/*
 * Decompiled with CFR 0.152.
 */
package com.griefcraft.modules.admin;

import com.griefcraft.io.BackupManager;
import com.griefcraft.lwc.LWC;
import com.griefcraft.scripting.JavaModule;
import com.griefcraft.scripting.event.LWCCommandEvent;
import com.griefcraft.util.StringUtil;
import org.bukkit.command.CommandSender;
import org.bukkit.plugin.Plugin;

public class AdminBackup
extends JavaModule {
    @Override
    public void onCommand(LWCCommandEvent event) {
        if (event.isCancelled()) {
            return;
        }
        if (!event.hasFlag("a", "admin")) {
            return;
        }
        final LWC lwc = event.getLWC();
        final CommandSender sender = event.getSender();
        String[] args = event.getArgs();
        if (!args[0].equals("backup")) {
            return;
        }
        event.setCancelled(true);
        if (args.length == 1) {
            lwc.sendSimpleUsage(sender, "/lwc admin backup <action>");
            return;
        }
        String action = args[1].toLowerCase();
        if (action.equals("create")) {
            lwc.getBackupManager().createBackup();
            sender.sendMessage("Backup is being created now.");
        } else if (action.equals("restore")) {
            if (args.length < 3) {
                lwc.sendSimpleUsage(sender, "/lwc admin backup restore <BackupName>");
                return;
            }
            final String backupName = StringUtil.join(args, 2);
            sender.sendMessage("Restoring backup " + backupName);
            lwc.getPlugin().getServer().getScheduler().scheduleAsyncDelayedTask((Plugin)lwc.getPlugin(), new Runnable(){

                @Override
                public void run() {
                    BackupManager.Result result = lwc.getBackupManager().restoreBackup(backupName);
                    sender.sendMessage("Result: " + (Object)((Object)result));
                }
            });
        }
    }
}

