/*
 * Decompiled with CFR 0.152.
 */
package com.griefcraft.lwc;

import com.griefcraft.cache.BlockCache;
import com.griefcraft.listeners.LWC114Listener;
import com.griefcraft.listeners.LWCBlockListener;
import com.griefcraft.listeners.LWCEntityListener;
import com.griefcraft.listeners.LWCPlayerListener;
import com.griefcraft.listeners.LWCServerListener;
import com.griefcraft.lwc.LWC;
import com.griefcraft.lwc.LWCInfo;
import com.griefcraft.lwc.MessageParser;
import com.griefcraft.lwc.SimpleMessageParser;
import com.griefcraft.scripting.event.LWCCommandEvent;
import com.griefcraft.sql.Database;
import com.griefcraft.util.Metrics;
import com.griefcraft.util.StringUtil;
import com.griefcraft.util.Updater;
import com.griefcraft.util.VersionUtil;
import com.griefcraft.util.locale.LWCResourceBundle;
import com.griefcraft.util.locale.LocaleClassLoader;
import com.griefcraft.util.locale.UTF8Control;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import java.util.concurrent.Callable;
import java.util.jar.JarFile;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;
import org.bukkit.plugin.java.JavaPlugin;

public class LWCPlugin
extends JavaPlugin {
    private LWC lwc;
    private MessageParser messageParser;
    private Updater updater;

    public boolean onCommand(CommandSender sender, Command command, String commandLabel, String[] args) {
        String commandName = command.getName().toLowerCase();
        String argString = StringUtil.join(args, 0);
        boolean isPlayer = sender instanceof Player;
        if (isPlayer) {
            String aliasCommand = null;
            String[] aliasArgs = new String[]{};
            if (commandName.equals("cpublic")) {
                aliasCommand = "create";
                aliasArgs = new String[]{"public"};
            } else if (commandName.equals("cpassword")) {
                aliasCommand = "create";
                aliasArgs = ("password " + argString).split(" ");
            } else if (commandName.equals("cprivate") || commandName.equals("lock")) {
                aliasCommand = "create";
                aliasArgs = ("private " + argString).split(" ");
            } else if (commandName.equals("cdonation")) {
                aliasCommand = "create";
                aliasArgs = ("donation " + argString).split(" ");
            } else if (commandName.equals("cmodify")) {
                aliasCommand = "modify";
                aliasArgs = argString.isEmpty() ? new String[]{} : argString.split(" ");
            } else if (commandName.equals("cinfo")) {
                aliasCommand = "info";
            } else if (commandName.equals("cunlock")) {
                aliasCommand = "unlock";
                aliasArgs = argString.isEmpty() ? new String[]{} : argString.split(" ");
            } else if (commandName.equals("cremove") || commandName.equals("unlock")) {
                aliasCommand = "remove";
                aliasArgs = new String[]{"protection"};
            } else if (commandName.equals("climits")) {
                aliasCommand = "limits";
                aliasArgs = argString.isEmpty() ? new String[]{} : argString.split(" ");
            } else if (commandName.equals("cadmin")) {
                aliasCommand = "admin";
                aliasArgs = argString.isEmpty() ? new String[]{} : argString.split(" ");
            } else if (commandName.equals("cremoveall")) {
                aliasCommand = "remove";
                aliasArgs = new String[]{"allprotections"};
            }
            if (commandName.equals("credstone")) {
                aliasCommand = "flag";
                aliasArgs = ("redstone " + argString).split(" ");
            } else if (commandName.equals("cmagnet")) {
                aliasCommand = "flag";
                aliasArgs = ("magnet " + argString).split(" ");
            } else if (commandName.equals("cexempt")) {
                aliasCommand = "flag";
                aliasArgs = ("exemption " + argString).split(" ");
            } else if (commandName.equals("cautoclose")) {
                aliasCommand = "flag";
                aliasArgs = ("autoclose " + argString).split(" ");
            } else if (commandName.equals("callowexplosions") || commandName.equals("ctnt")) {
                aliasCommand = "flag";
                aliasArgs = ("allowexplosions " + argString).split(" ");
            } else if (commandName.equals("chopper")) {
                aliasCommand = "flag";
                aliasArgs = ("hopper " + argString).split(" ");
            }
            if (commandName.equals("cdroptransfer")) {
                aliasCommand = "mode";
                aliasArgs = ("droptransfer " + argString).split(" ");
            } else if (commandName.equals("cpersist")) {
                aliasCommand = "mode";
                aliasArgs = ("persist " + argString).split(" ");
            } else if (commandName.equals("cnospam")) {
                aliasCommand = "mode";
                aliasArgs = ("nospam " + argString).split(" ");
            }
            if (aliasCommand != null) {
                this.lwc.getModuleLoader().dispatchEvent(new LWCCommandEvent(sender, aliasCommand, aliasArgs));
                return true;
            }
        }
        if (args.length == 0) {
            this.lwc.sendFullHelp(sender);
            return true;
        }
        LWCCommandEvent evt = new LWCCommandEvent(sender, args[0].toLowerCase(), args.length > 1 ? StringUtil.join(args, 1).split(" ") : new String[]{});
        this.lwc.getModuleLoader().dispatchEvent(evt);
        if (evt.isCancelled()) {
            return true;
        }
        if (!isPlayer) {
            this.lwc.sendLocale(sender, "lwc.commandnotsupported", new Object[0]);
            return true;
        }
        this.lwc.sendLocale(sender, "lwc.invalidcommand", new Object[0]);
        return true;
    }

    public void onDisable() {
        LWC.ENABLED = false;
        if (this.lwc != null) {
            this.lwc.destruct();
            BlockCache.destruct();
        }
        this.getServer().getScheduler().cancelTasks((Plugin)this);
    }

    public void onEnable() {
        this.lwc = new LWC(this);
        this.preload();
        HashSet<String> unsupportedVersions = new HashSet<String>(Arrays.asList("1.8", "1.9", "1.10", "1.11", "1.12"));
        Matcher matcher = Pattern.compile("\\d[.]\\d+").matcher(Bukkit.getVersion());
        if (matcher.find() && unsupportedVersions.contains(matcher.group())) {
            this.log("  _       __          __   _____ ");
            this.log(" | |      \\ \\        / /  / ____|");
            this.log(" | |       \\ \\  /\\  / /  | |     ");
            this.log(" | |        \\ \\/  \\/ /   | |     ");
            this.log(" | |____     \\  /\\  /    | |____ ");
            this.log(" |______|     \\/  \\/      \\_____|");
            this.log("");
            this.log("This version of ModernLWC is not compatible with MineCraft " + matcher.group());
            this.log("ModernLWC 2.0.0 and above can only be used on servers running MineCraft 1.13+");
            this.log("Please download an older version of the plugin at " + this.getDescription().getWebsite());
            this.getServer().getPluginManager().disablePlugin((Plugin)this);
            return;
        }
        Metrics m = new Metrics(this);
        m.addCustomChart(new Metrics.AdvancedPie("protected_blocks", new Callable<Map<String, Integer>>(){

            @Override
            public Map<String, Integer> call() throws Exception {
                HashMap<String, Integer> map = new HashMap<String, Integer>();
                if (LWCPlugin.this.lwc.getPhysicalDatabase().getProtectionCount() >= 50000) {
                    map.put("Over 50k", 1);
                } else if (LWCPlugin.this.lwc.getPhysicalDatabase().getProtectionCount() >= 25000) {
                    map.put("Over 25k", 1);
                } else if (LWCPlugin.this.lwc.getPhysicalDatabase().getProtectionCount() >= 10000) {
                    map.put("Over 10k", 1);
                } else if (LWCPlugin.this.lwc.getPhysicalDatabase().getProtectionCount() >= 5000) {
                    map.put("Over 5k", 1);
                } else if (LWCPlugin.this.lwc.getPhysicalDatabase().getProtectionCount() >= 1000) {
                    map.put("Over 1k", 1);
                } else {
                    map.put("Under 1k", 1);
                }
                return map;
            }
        }));
        m.addCustomChart(new Metrics.SimplePie("used_language", new Callable<String>(){

            @Override
            public String call() throws Exception {
                return LWCPlugin.this.getCurrentLocale();
            }
        }));
        m.addCustomChart(new Metrics.SimplePie("database_used", new Callable<String>(){

            @Override
            public String call() throws Exception {
                String database = LWCPlugin.this.lwc.getConfiguration().getString("database.adapter");
                if (database.equalsIgnoreCase("mysql")) {
                    return "MySQL";
                }
                return "SQLite";
            }
        }));
        LWCInfo.setVersion(this.getDescription().getVersion());
        LWC.ENABLED = true;
        this.loadLocales();
        this.loadDatabase();
        this.lwc.load();
        this.registerEvents();
    }

    public void loadDatabase() {
        String database = this.lwc.getConfiguration().getString("database.adapter");
        Database.DefaultType = database.equalsIgnoreCase("mysql") ? Database.Type.MySQL : Database.Type.SQLite;
    }

    public void loadLocales() {
        LWCResourceBundle locale;
        String localization = this.getCurrentLocale();
        File localeDir = new File("plugins/LWC/locale/");
        if (!localeDir.exists()) {
            localeDir.mkdir();
        }
        ResourceBundle optionalBundle = null;
        try (JarFile file = new JarFile(this.getFile());){
            PropertyResourceBundle defaultBundle = new PropertyResourceBundle(new InputStreamReader(file.getInputStream(file.getJarEntry("lang/lwc_en.properties")), "UTF-8"));
            locale = new LWCResourceBundle(defaultBundle);
            try {
                optionalBundle = ResourceBundle.getBundle("lwc", new Locale(localization), new LocaleClassLoader(), new UTF8Control());
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
            if (optionalBundle != null) {
                locale.addExtensionBundle(optionalBundle);
            }
            try {
                optionalBundle = new PropertyResourceBundle(new InputStreamReader(file.getInputStream(file.getJarEntry("lang/lwc_" + localization + ".properties")), "UTF-8"));
            }
            catch (MissingResourceException missingResourceException) {
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
            if (defaultBundle == optionalBundle) {
                optionalBundle = null;
            }
            if (optionalBundle != null) {
                locale.addExtensionBundle(optionalBundle);
            }
        }
        catch (MissingResourceException e) {
            this.log("We are missing the default locale in LWC.jar.. What happened to it? :-(");
            throw e;
        }
        catch (IOException e) {
            this.log("Uh-oh: " + e.getMessage());
            return;
        }
        this.messageParser = new SimpleMessageParser(locale);
    }

    private void preload() {
        this.updater = new Updater();
        this.updater.init();
    }

    private void log(String str) {
        this.getLogger().info(str);
    }

    private void registerEvents() {
        PluginManager pluginManager = Bukkit.getServer().getPluginManager();
        pluginManager.registerEvents((Listener)new LWCPlayerListener(this), (Plugin)this);
        pluginManager.registerEvents((Listener)new LWCEntityListener(this), (Plugin)this);
        pluginManager.registerEvents((Listener)new LWCBlockListener(this), (Plugin)this);
        pluginManager.registerEvents((Listener)new LWCServerListener(this), (Plugin)this);
        if (VersionUtil.getMinorVersion() > 13) {
            pluginManager.registerEvents((Listener)new LWC114Listener(), (Plugin)this);
        }
    }

    public String getCurrentLocale() {
        return this.lwc.getConfiguration().getString("core.locale", "en");
    }

    public LWC getLWC() {
        return this.lwc;
    }

    public MessageParser getMessageParser() {
        return this.messageParser;
    }

    public Updater getUpdater() {
        return this.updater;
    }

    public File getFile() {
        return super.getFile();
    }
}

