/*
 * Decompiled with CFR 0.152.
 */
package com.griefcraft.lwc;

import com.griefcraft.bukkit.EntityBlock;
import com.griefcraft.cache.BlockCache;
import com.griefcraft.cache.ProtectionCache;
import com.griefcraft.integration.ICurrency;
import com.griefcraft.integration.IPermissions;
import com.griefcraft.integration.currency.NoCurrency;
import com.griefcraft.integration.currency.VaultCurrency;
import com.griefcraft.integration.permissions.SuperPermsPermissions;
import com.griefcraft.integration.permissions.VaultPermissions;
import com.griefcraft.io.BackupManager;
import com.griefcraft.listeners.LWCMCPCSupport;
import com.griefcraft.lwc.LWCPlugin;
import com.griefcraft.lwc.MessageParser;
import com.griefcraft.migration.ConfigPost300;
import com.griefcraft.migration.MySQLPost200;
import com.griefcraft.model.Flag;
import com.griefcraft.model.History;
import com.griefcraft.model.LWCPlayer;
import com.griefcraft.model.Permission;
import com.griefcraft.model.Protection;
import com.griefcraft.modules.admin.AdminBackup;
import com.griefcraft.modules.admin.AdminCache;
import com.griefcraft.modules.admin.AdminCleanup;
import com.griefcraft.modules.admin.AdminClear;
import com.griefcraft.modules.admin.AdminDump;
import com.griefcraft.modules.admin.AdminExpire;
import com.griefcraft.modules.admin.AdminFind;
import com.griefcraft.modules.admin.AdminFlush;
import com.griefcraft.modules.admin.AdminForceOwner;
import com.griefcraft.modules.admin.AdminLocale;
import com.griefcraft.modules.admin.AdminOwnerAll;
import com.griefcraft.modules.admin.AdminPurge;
import com.griefcraft.modules.admin.AdminPurgeBanned;
import com.griefcraft.modules.admin.AdminQuery;
import com.griefcraft.modules.admin.AdminRebuild;
import com.griefcraft.modules.admin.AdminReload;
import com.griefcraft.modules.admin.AdminRemove;
import com.griefcraft.modules.admin.AdminReport;
import com.griefcraft.modules.admin.AdminVersion;
import com.griefcraft.modules.admin.AdminView;
import com.griefcraft.modules.admin.BaseAdminModule;
import com.griefcraft.modules.confirm.ConfirmModule;
import com.griefcraft.modules.create.CreateModule;
import com.griefcraft.modules.credits.CreditsModule;
import com.griefcraft.modules.debug.DebugModule;
import com.griefcraft.modules.destroy.DestroyModule;
import com.griefcraft.modules.doors.DoorsModule;
import com.griefcraft.modules.economy.EconomyModule;
import com.griefcraft.modules.fix.FixModule;
import com.griefcraft.modules.flag.BaseFlagModule;
import com.griefcraft.modules.flag.MagnetModule;
import com.griefcraft.modules.free.FreeModule;
import com.griefcraft.modules.history.HistoryModule;
import com.griefcraft.modules.info.InfoModule;
import com.griefcraft.modules.limits.LimitsModule;
import com.griefcraft.modules.limits.LimitsV2;
import com.griefcraft.modules.modes.BaseModeModule;
import com.griefcraft.modules.modes.DropTransferModule;
import com.griefcraft.modules.modes.NoSpamModule;
import com.griefcraft.modules.modes.PersistModule;
import com.griefcraft.modules.modify.ModifyModule;
import com.griefcraft.modules.owners.OwnersModule;
import com.griefcraft.modules.pluginsupport.Factions;
import com.griefcraft.modules.pluginsupport.Towny;
import com.griefcraft.modules.pluginsupport.WorldGuard;
import com.griefcraft.modules.redstone.RedstoneModule;
import com.griefcraft.modules.setup.BaseSetupModule;
import com.griefcraft.modules.setup.DatabaseSetupModule;
import com.griefcraft.modules.setup.LimitsSetup;
import com.griefcraft.modules.unlock.UnlockModule;
import com.griefcraft.scripting.Module;
import com.griefcraft.scripting.ModuleLoader;
import com.griefcraft.scripting.event.LWCAccessEvent;
import com.griefcraft.scripting.event.LWCReloadEvent;
import com.griefcraft.scripting.event.LWCSendLocaleEvent;
import com.griefcraft.sql.Database;
import com.griefcraft.sql.PhysDB;
import com.griefcraft.util.DatabaseThread;
import com.griefcraft.util.ProtectionFinder;
import com.griefcraft.util.Statistics;
import com.griefcraft.util.StringUtil;
import com.griefcraft.util.UUIDRegistry;
import com.griefcraft.util.config.Configuration;
import com.griefcraft.util.matchers.DoubleChestMatcher;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.md_5.bungee.api.ChatMessageType;
import net.md_5.bungee.api.chat.TextComponent;
import org.apache.commons.lang.StringUtils;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.BlockState;
import org.bukkit.block.data.type.Chest;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class LWC {
    public static boolean ENABLED = false;
    private static LWC instance;
    private Configuration configuration;
    private final ModuleLoader moduleLoader;
    private final BackupManager backupManager;
    private final ProtectionCache protectionCache;
    private PhysDB physicalDatabase;
    private LWCPlugin plugin;
    private DatabaseThread databaseThread;
    private IPermissions permissions;
    private ICurrency currency;
    private final Map<String, String> protectionConfigurationCache = new HashMap<String, String>();

    public LWC(LWCPlugin plugin) {
        this.plugin = plugin;
        instance = this;
        this.configuration = Configuration.load("core.yml");
        this.protectionCache = new ProtectionCache(this);
        this.backupManager = new BackupManager();
        this.moduleLoader = new ModuleLoader(this);
    }

    public static LWC getInstance() {
        return instance;
    }

    public static String materialToString(Material material) {
        if (material != null) {
            String materialName = LWC.normalizeMaterialName(material);
            String locale = LWC.getInstance().getPlugin().getMessageParser().parseMessage(materialName.toLowerCase(), new Object[0]);
            if (locale == null) {
                locale = materialName;
            }
            locale = locale.replace('_', ' ');
            return StringUtil.capitalizeFirstLetter(locale);
        }
        return "";
    }

    public static String normalizeMaterialName(Material material) {
        String name = StringUtils.replace((String)material.toString().toLowerCase(), (String)"block", (String)"");
        if (name.contains("sign")) {
            name = "Sign";
        }
        if (name.contains("furnace")) {
            name = "furnace";
        }
        if (name.endsWith("_")) {
            name = name.substring(0, name.length() - 1);
        }
        return name.toLowerCase();
    }

    public void adjustChestDirection(Block block, BlockFace face) {
        if (block.getType() != Material.CHEST) {
            return;
        }
        Block doubleChest = this.findAdjacentDoubleChest(block);
        int data = 0;
        switch (face) {
            case NORTH: {
                data = 4;
                break;
            }
            case SOUTH: {
                data = 5;
                break;
            }
            case EAST: {
                data = 2;
                break;
            }
            case WEST: {
                data = 3;
                break;
            }
        }
    }

    public Block findAdjacentDoubleChest(Block block) {
        if (!DoubleChestMatcher.PROTECTABLES_CHESTS.contains(block.getType())) {
            throw new UnsupportedOperationException("findAdjacentDoubleChest() cannot be called on a: " + block.getType());
        }
        BlockState baseBlockState = block.getState();
        Chest baseBlockData = null;
        try {
            baseBlockData = (Chest)baseBlockState.getBlockData();
        }
        catch (ClassCastException e) {
            return null;
        }
        BlockFace neighboringBlockFace = DoubleChestMatcher.getNeighboringChestBlockFace(baseBlockData);
        if (neighboringBlockFace == null) {
            return null;
        }
        Block neighboringBlock = baseBlockState.getBlock().getRelative(neighboringBlockFace);
        if (baseBlockState.getType() == neighboringBlock.getType()) {
            return block;
        }
        return null;
    }

    public boolean canAccessProtection(Player player, Block block) {
        Protection protection = this.findProtection(block.getLocation());
        return protection != null && this.canAccessProtection(player, protection);
    }

    public boolean canAccessProtection(Player player, int x, int y, int z) {
        return this.canAccessProtection(player, this.physicalDatabase.loadProtection(player.getWorld().getName(), x, y, z));
    }

    public boolean canAdminProtection(Player player, Block block) {
        Protection protection = this.findProtection(block.getLocation());
        return protection != null && this.canAdminProtection(player, protection);
    }

    public boolean canAdminProtection(Player player, Protection protection) {
        if (protection == null || player == null) {
            return true;
        }
        if (this.isAdmin(player)) {
            return true;
        }
        Permission.Access access = Permission.Access.NONE;
        switch (protection.getType()) {
            case PUBLIC: {
                if (!protection.isOwner(player)) break;
                return true;
            }
            case PASSWORD: {
                if (!protection.isOwner(player) || !this.wrapPlayer((CommandSender)player).getAccessibleProtections().contains(protection)) break;
                return true;
            }
            case PRIVATE: 
            case DONATION: {
                if (protection.isOwner(player)) {
                    return true;
                }
                if (protection.getAccess(player.getUniqueId().toString(), Permission.Type.PLAYER) == Permission.Access.ADMIN) {
                    return true;
                }
                if (protection.getAccess(player.getName(), Permission.Type.PLAYER) == Permission.Access.ADMIN) {
                    return true;
                }
                for (String groupName : this.permissions.getGroups(player)) {
                    if (protection.getAccess(groupName, Permission.Type.GROUP) != Permission.Access.ADMIN) continue;
                    return true;
                }
                break;
            }
        }
        LWCAccessEvent event = new LWCAccessEvent(player, protection, access);
        this.moduleLoader.dispatchEvent(event);
        return event.getAccess() == Permission.Access.ADMIN;
    }

    public Map<Integer, ItemStack> depositItems(Block block, ItemStack itemStack) {
        BlockState blockState = block.getState();
        if (blockState != null && blockState instanceof InventoryHolder) {
            Inventory inventory;
            Block doubleChestBlock = null;
            InventoryHolder holder = (InventoryHolder)blockState;
            if (DoubleChestMatcher.PROTECTABLES_CHESTS.contains(block.getType())) {
                doubleChestBlock = this.findAdjacentDoubleChest(block);
            } else if (!(block.getType() != Material.FURNACE || (inventory = holder.getInventory()).getItem(0) == null || inventory.getItem(1) == null || inventory.getItem(0).getType() == itemStack.getType() && inventory.getItem(0).getData().getData() == itemStack.getData().getData() && inventory.getItem(0).getMaxStackSize() >= inventory.getItem(0).getAmount() + itemStack.getAmount() || inventory.getItem(1).getType() == itemStack.getType() && inventory.getItem(1).getData().getData() == itemStack.getData().getData() && inventory.getItem(1).getMaxStackSize() >= inventory.getItem(1).getAmount() + itemStack.getAmount())) {
                return null;
            }
            if (itemStack.getAmount() <= 0) {
                return new HashMap<Integer, ItemStack>();
            }
            HashMap remaining = holder.getInventory().addItem(new ItemStack[]{itemStack});
            if (remaining.size() > 0) {
                int key = (Integer)remaining.keySet().iterator().next();
                ItemStack remainingItemStack = (ItemStack)remaining.get(key);
                if (doubleChestBlock != null) {
                    InventoryHolder holder2 = (InventoryHolder)doubleChestBlock.getState();
                    remaining = holder2.getInventory().addItem(new ItemStack[]{remainingItemStack});
                }
                if (remaining.size() > 0) {
                    return remaining;
                }
            }
        }
        return new HashMap<Integer, ItemStack>();
    }

    public Block findAdjacentBlock(Block block, Material material, Block ... ignore) {
        BlockFace[] faces = new BlockFace[]{BlockFace.NORTH, BlockFace.SOUTH, BlockFace.EAST, BlockFace.WEST};
        List<Block> ignoreList = Arrays.asList(ignore);
        for (BlockFace face : faces) {
            Block adjacentBlock = block.getRelative(face);
            if (adjacentBlock.getType() != material || ignoreList.contains(adjacentBlock)) continue;
            return adjacentBlock;
        }
        return null;
    }

    public Block findAdjacentBlockOnAllSides(Block block, Material material, Block ... ignore) {
        BlockFace[] faces = new BlockFace[]{BlockFace.NORTH, BlockFace.SOUTH, BlockFace.EAST, BlockFace.WEST, BlockFace.UP, BlockFace.DOWN};
        List<Block> ignoreList = Arrays.asList(ignore);
        for (BlockFace face : faces) {
            Block adjacentBlock = block.getRelative(face);
            if (adjacentBlock.getType() != material || ignoreList.contains(adjacentBlock)) continue;
            return adjacentBlock;
        }
        return null;
    }

    public List<Protection> findAdjacentProtectionsOnAllSides(Block block, Block ... ignore) {
        BlockFace[] faces = new BlockFace[]{BlockFace.NORTH, BlockFace.SOUTH, BlockFace.EAST, BlockFace.WEST, BlockFace.UP, BlockFace.DOWN};
        List<Block> ignoreList = Arrays.asList(ignore);
        ArrayList<Protection> found = new ArrayList<Protection>();
        for (BlockFace face : faces) {
            Protection protection;
            Block adjacentBlock = block.getRelative(face);
            if (ignoreList.contains(adjacentBlock.getLocation()) || (protection = this.findProtection(adjacentBlock.getLocation())) == null) continue;
            found.add(protection);
        }
        return found;
    }

    public void destruct() {
        if (this.moduleLoader != null) {
            this.moduleLoader.shutdown();
        }
        if (this.databaseThread != null) {
            this.log("Flushing protection updates (" + this.databaseThread.size() + ")");
            this.databaseThread.stop();
            this.databaseThread = null;
        }
        if (this.physicalDatabase != null) {
            this.physicalDatabase.dispose();
        }
        this.physicalDatabase = null;
        instance = null;
    }

    public void log(String str) {
        this.plugin.getLogger().info(str);
    }

    public String encrypt(String text) {
        return StringUtil.encrypt(text);
    }

    public boolean enforceAccess(Player player, Protection protection, Block block, boolean hasAccess) {
        boolean permShowNotices;
        MessageParser parser = this.plugin.getMessageParser();
        if (block == null || protection == null) {
            return true;
        }
        BlockCache blockCache = BlockCache.getInstance();
        if (block != null && protection.getBlockId() <= 0 && blockCache.getBlockId(block) != protection.getBlockId()) {
            protection.setBlockId(blockCache.getBlockId(block));
            protection.save();
        }
        if (!(block == null || protection.getWorld() != null && block.getWorld().getName().equals(protection.getWorld()))) {
            protection.setWorld(block.getWorld().getName());
            protection.save();
        }
        if (hasAccess) {
            long timestamp = System.currentTimeMillis() / 1000L;
            if (protection.isOwner(player) || protection.getAccess(player.getName(), Permission.Type.PLAYER) != Permission.Access.NONE) {
                protection.setLastAccessed(timestamp);
                protection.save();
            }
        }
        if ((permShowNotices = this.hasPermission(player, "lwc.shownotices")) && this.configuration.getBoolean("core.showNotices", true) && !Boolean.parseBoolean(this.resolveProtectionConfiguration(block, "quiet"))) {
            boolean isOwner = protection.isOwner(player);
            boolean showMyNotices = this.configuration.getBoolean("core.showMyNotices", true);
            if (!isOwner || isOwner && (showMyNotices || permShowNotices)) {
                String owner = protection.isRealOwner(player) ? parser.parseMessage("you", new Object[0]) : UUIDRegistry.formatPlayerName(protection.getOwner(), false);
                String blockName = LWC.materialToString(block);
                String protectionTypeToString = parser.parseMessage(protection.typeToString().toLowerCase(), new Object[0]);
                if (protectionTypeToString == null) {
                    protectionTypeToString = "Unknown";
                }
                if (parser.parseMessage("protection." + blockName.toLowerCase() + ".notice.protected", new Object[0]) != null) {
                    this.sendLocaleToActionBar((CommandSender)player, "protection." + blockName.toLowerCase() + ".notice.protected", "type", protectionTypeToString, "block", blockName, "owner", owner);
                } else {
                    this.sendLocaleToActionBar((CommandSender)player, "protection.general.notice.protected", "type", protectionTypeToString, "block", blockName, "owner", owner);
                }
            }
        }
        if (!hasAccess) {
            Protection.Type type = protection.getType();
            if (type == Protection.Type.PASSWORD) {
                this.sendLocaleToActionBar((CommandSender)player, "protection.general.locked.password", "block", LWC.materialToString(block), "owner", protection.getOwner());
            } else if (type == Protection.Type.PRIVATE || type == Protection.Type.DONATION) {
                this.sendLocaleToActionBar((CommandSender)player, "protection.general.locked.private", "block", LWC.materialToString(block), "owner", protection.getOwner());
            }
        }
        return hasAccess;
    }

    public boolean canAccessProtection(Player player, Protection protection) {
        if (protection == null || player == null) {
            return true;
        }
        if (this.isAdmin(player)) {
            return true;
        }
        if (this.isMod(player)) {
            Player protectionOwner = protection.getBukkitOwner();
            if (protectionOwner == null) {
                return true;
            }
            if (!this.isAdmin(protectionOwner)) {
                return true;
            }
        }
        Permission.Access access = Permission.Access.NONE;
        switch (protection.getType()) {
            case PUBLIC: 
            case DONATION: {
                return true;
            }
            case PASSWORD: {
                if (!this.wrapPlayer((CommandSender)player).getAccessibleProtections().contains(protection)) break;
                return true;
            }
            case PRIVATE: {
                if (protection.isOwner(player)) {
                    return true;
                }
                if (protection.getAccess(player.getUniqueId().toString(), Permission.Type.PLAYER).ordinal() >= Permission.Access.PLAYER.ordinal()) {
                    return true;
                }
                if (protection.getAccess(player.getName(), Permission.Type.PLAYER).ordinal() >= Permission.Access.PLAYER.ordinal()) {
                    return true;
                }
                for (Permission permission : protection.getPermissions()) {
                    if (permission.getType() != Permission.Type.ITEM) continue;
                    int item = Integer.parseInt(permission.getName());
                    BlockCache blockCache = BlockCache.getInstance();
                    if (blockCache.getBlockId(player.getItemInHand().getType()) != item) continue;
                    return true;
                }
                for (String groupName : this.permissions.getGroups(player)) {
                    if (protection.getAccess(groupName, Permission.Type.GROUP).ordinal() < Permission.Access.PLAYER.ordinal()) continue;
                    return true;
                }
                break;
            }
        }
        LWCAccessEvent event = new LWCAccessEvent(player, protection, access);
        this.moduleLoader.dispatchEvent(event);
        return event.getAccess() == Permission.Access.PLAYER || event.getAccess() == Permission.Access.ADMIN;
    }

    public boolean isMod(Player player) {
        return this.hasPermission(player, "lwc.mod");
    }

    public boolean isAdmin(Player player) {
        if (player.isOp() && this.configuration.getBoolean("core.opIsLWCAdmin", true)) {
            return true;
        }
        return this.hasPermission(player, "lwc.admin");
    }

    public boolean hasPermission(Player player, String node) {
        try {
            return player.hasPermission(node);
        }
        catch (NoSuchMethodError e) {
            return !node.contains("admin") && !node.contains("mod");
        }
    }

    public LWCPlayer wrapPlayer(CommandSender sender) {
        if (sender instanceof LWCPlayer) {
            return (LWCPlayer)sender;
        }
        if (!(sender instanceof Player)) {
            return null;
        }
        return LWCPlayer.getPlayer((Player)sender);
    }

    public Player findPlayer(int minX, int maxX, int minY, int maxY, int minZ, int maxZ) {
        for (Player player : this.plugin.getServer().getOnlinePlayers()) {
            Location location = player.getLocation();
            int plrX = location.getBlockX();
            int plrY = location.getBlockY();
            int plrZ = location.getBlockZ();
            if (plrX < minX || plrX > maxX || plrY < minY || plrY > maxY || plrZ < minZ || plrZ > maxZ) continue;
            return player;
        }
        return null;
    }

    public void sendLocale(CommandSender sender, String key, Object ... args) {
        MessageParser parser = this.plugin.getMessageParser();
        String parsed = parser.parseMessage(key, args);
        if (parsed == null) {
            return;
        }
        String[] message = StringUtils.split((String)parsed, (char)'\n');
        if (sender instanceof Player) {
            LWCSendLocaleEvent evt = new LWCSendLocaleEvent((Player)sender, key);
            this.moduleLoader.dispatchEvent(evt);
            if (evt.isCancelled()) {
                return;
            }
        }
        if (message == null) {
            sender.sendMessage("\u00a74LWC: \u00a7fUndefined locale: \"\u00a78" + key + "\u00a7f" + "\"");
            return;
        }
        if (message.length > 0 && message[0].equalsIgnoreCase("null")) {
            return;
        }
        for (String line : message) {
            sender.sendMessage(line);
        }
    }

    public void sendLocaleToActionBar(CommandSender sender, String key, Object ... args) {
        MessageParser parser = this.plugin.getMessageParser();
        String parsed = parser.parseMessage(key, args);
        if (parsed == null) {
            return;
        }
        String[] message = StringUtils.split((String)parsed, (char)'\n');
        if (sender instanceof Player) {
            LWCSendLocaleEvent evt = new LWCSendLocaleEvent((Player)sender, key);
            this.moduleLoader.dispatchEvent(evt);
            if (evt.isCancelled()) {
                return;
            }
        }
        if (message == null) {
            sender.sendMessage("\u00a74LWC: \u00a7fUndefined locale: \"\u00a78" + key + "\u00a7f" + "\"");
            return;
        }
        if (message.length > 0 && message[0].equalsIgnoreCase("null")) {
            return;
        }
        for (String line : message) {
            if (this.configuration.getBoolean("optional.useActionBar", false) && sender instanceof Player) {
                try {
                    ((Player)sender).spigot().sendMessage(ChatMessageType.ACTION_BAR, TextComponent.fromLegacyText((String)line));
                }
                catch (NoSuchMethodError e) {
                    sender.sendMessage(line);
                }
                continue;
            }
            sender.sendMessage(line);
        }
    }

    public static String materialToString(Block block) {
        if (block instanceof EntityBlock) {
            return StringUtils.capitalize((String)EntityBlock.getEntity().getType().name().replace("_", " "));
        }
        return LWC.materialToString(block.getType());
    }

    public int fastRemoveProtectionsByPlayer(CommandSender sender, String player, boolean shouldRemoveBlocks) {
        UUID uuid = UUIDRegistry.getUUID(player);
        int ret = this.fastRemoveProtections(sender, "Lower(owner) = Lower('" + (uuid != null ? uuid.toString() : player) + "')", shouldRemoveBlocks);
        this.physicalDatabase.invalidateHistory(player);
        return ret;
    }

    public static UUID convert(String uuid) {
        if (Bukkit.getOfflinePlayer((String)uuid).isOnline()) {
            return Bukkit.getPlayer((String)uuid).getUniqueId();
        }
        return Bukkit.getOfflinePlayer((String)uuid).getUniqueId();
    }

    public int fastRemoveProtections(CommandSender sender, String where, boolean shouldRemoveBlocks) {
        List<Integer> exemptedBlocks = this.configuration.getIntList("optional.exemptBlocks", new ArrayList<Integer>());
        LinkedList<Integer> toRemove = new LinkedList<Integer>();
        LinkedList<Block> removeBlocks = null;
        int totalProtections = this.physicalDatabase.getProtectionCount();
        int completed = 0;
        int count = 0;
        this.databaseThread.flush();
        if (shouldRemoveBlocks) {
            removeBlocks = new LinkedList<Block>();
        }
        if (where != null && !where.trim().isEmpty()) {
            where = " WHERE " + where.trim();
        }
        sender.sendMessage("Loading protections via STREAM mode");
        try {
            Statement resultStatement = this.physicalDatabase.getConnection().createStatement(1003, 1007);
            if (this.physicalDatabase.getType() == Database.Type.MySQL) {
                resultStatement.setFetchSize(Integer.MIN_VALUE);
            }
            String prefix = this.physicalDatabase.getPrefix();
            ResultSet result = resultStatement.executeQuery("SELECT id, owner, type, x, y, z, data, blockId, world, password, date, last_accessed FROM " + prefix + "protections" + where);
            while (result.next()) {
                Protection cached;
                Protection protection = this.physicalDatabase.resolveProtection(result);
                World world = protection.getBukkitWorld();
                if (protection.hasFlag(Flag.Type.EXEMPTION) || exemptedBlocks.contains(protection.getBlockId())) continue;
                if (++count % 100000 == 0 || count == totalProtections || count == 1) {
                    sender.sendMessage("\u00a74" + count + " / " + totalProtections);
                }
                if (world == null) continue;
                toRemove.add(protection.getId());
                if (shouldRemoveBlocks) {
                    removeBlocks.add(protection.getBlock());
                }
                if ((cached = this.protectionCache.getProtection(protection.getCacheKey())) != null) {
                    cached.removeCache();
                }
                ++completed;
            }
            result.close();
            resultStatement.close();
            this.fullRemoveProtections(sender, toRemove);
            if (shouldRemoveBlocks) {
                this.removeBlocks(sender, removeBlocks);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return completed;
    }

    private void fullRemoveProtections(CommandSender sender, List<Integer> toRemove) throws SQLException {
        StringBuilder deleteProtectionsQuery = new StringBuilder();
        StringBuilder deleteHistoryQuery = new StringBuilder();
        int total = toRemove.size();
        int count = 0;
        Iterator<Integer> iter = toRemove.iterator();
        String prefix = this.getPhysicalDatabase().getPrefix();
        Statement statement = this.getPhysicalDatabase().getConnection().createStatement();
        while (iter.hasNext()) {
            int protectionId = iter.next();
            if (count % 10000 == 0) {
                deleteProtectionsQuery.append("DELETE FROM ").append(prefix).append("protections WHERE id IN (").append(protectionId);
                deleteHistoryQuery.append("UPDATE ").append(prefix).append("history SET status = " + History.Status.INACTIVE.ordinal() + " WHERE protectionId IN(").append(protectionId);
            } else {
                deleteProtectionsQuery.append(",").append(protectionId);
                deleteHistoryQuery.append(",").append(protectionId);
            }
            if (count % 10000 == 9999 || count == total - 1) {
                deleteProtectionsQuery.append(")");
                deleteHistoryQuery.append(")");
                statement.executeUpdate(deleteProtectionsQuery.toString());
                statement.executeUpdate(deleteHistoryQuery.toString());
                deleteProtectionsQuery.setLength(0);
                deleteHistoryQuery.setLength(0);
                sender.sendMessage("\u00a72REMOVED " + (count + 1) + " / " + total);
            }
            ++count;
            this.physicalDatabase.decrementProtectionCount();
        }
        statement.close();
    }

    private void removeBlocks(CommandSender sender, List<Block> blocks) {
        int count = 0;
        for (Block block : blocks) {
            Block doubleChest;
            if (block == null || !this.isProtectable(block)) continue;
            if (DoubleChestMatcher.PROTECTABLES_CHESTS.contains(block.getType()) && (doubleChest = this.findAdjacentDoubleChest(block)) != null) {
                this.removeInventory(doubleChest);
                doubleChest.setType(Material.AIR);
            }
            this.removeInventory(block);
            block.setType(Material.AIR);
            ++count;
        }
        sender.sendMessage("Removed " + count + " blocks from the world");
    }

    private void removeInventory(Block block) {
        if (block == null) {
            return;
        }
        if (!(block.getState() instanceof InventoryHolder)) {
            return;
        }
        InventoryHolder holder = (InventoryHolder)block.getState();
        holder.getInventory().clear();
    }

    public boolean blockEquals(Block block, Block block2) {
        return block.getType() == block2.getType() && block.getX() == block2.getX() && block.getY() == block2.getY() && block.getZ() == block2.getZ() && block.getData() == block2.getData();
    }

    public Protection findProtection(Location location) {
        String cacheKey = this.protectionCache.cacheKey(location);
        if (this.protectionCache.isKnownNull(cacheKey)) {
            return null;
        }
        Protection protection = this.protectionCache.getProtection(cacheKey);
        return protection != null ? protection : this.findProtection(location.getBlock());
    }

    public Protection findProtection(Block block) {
        return this.findProtection(block.getState());
    }

    public Protection findProtection(BlockState block) {
        if (block != null) {
            if (block.getType() == Material.AIR || block instanceof EntityBlock) {
                return this.physicalDatabase.loadProtection(block.getWorld().getName(), block.getX(), block.getY(), block.getZ());
            }
            Protection found = null;
            try {
                ProtectionFinder finder = new ProtectionFinder(this);
                boolean result = finder.matchBlocks(block);
                if (result) {
                    found = finder.loadProtection();
                }
                if (found == null) {
                    this.protectionCache.addKnownNull(this.protectionCache.cacheKey(block.getLocation()));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return found;
        }
        this.log("Block is null");
        return null;
    }

    public boolean blockEquals(BlockState block, BlockState block2) {
        return block.getType() == block2.getType() && block.getX() == block2.getX() && block.getY() == block2.getY() && block.getZ() == block2.getZ() && block.getRawData() == block2.getRawData();
    }

    public Protection findProtection(World world, int x, int y, int z) {
        if (world == null) {
            return null;
        }
        return this.findProtection(new Location(world, (double)x, (double)y, (double)z));
    }

    public boolean isProtectable(BlockState state) {
        Material material = state.getType();
        if (material == null) {
            return false;
        }
        return Boolean.parseBoolean(this.resolveProtectionConfiguration(state, "enabled"));
    }

    public boolean isProtectable(EntityType state) {
        return Boolean.parseBoolean(this.resolveProtectionConfiguration(state, "enabled"));
    }

    public String resolveProtectionConfiguration(BlockState state, String node) {
        Material material = state.getType();
        String cacheKey = state.getRawData() + "-" + material.toString() + "-" + node;
        if (this.protectionConfigurationCache.containsKey(cacheKey)) {
            return this.protectionConfigurationCache.get(cacheKey);
        }
        ArrayList<String> names = new ArrayList<String>();
        String materialName = LWC.normalizeMaterialName(material);
        names.add(materialName);
        names.add(materialName + ":" + state.getRawData());
        names.add(material.toString());
        names.add(material.toString().toLowerCase());
        names.add("*");
        if (materialName.contains("_")) {
            names.add("*_" + materialName.substring(materialName.indexOf("_") + 1));
        }
        String value = this.configuration.getString("protections." + node);
        for (String name : names) {
            String temp = this.configuration.getString("protections.blocks." + name + "." + node);
            if (temp == null || temp.isEmpty()) continue;
            value = temp;
        }
        this.protectionConfigurationCache.put(cacheKey, value);
        return value;
    }

    public String resolveProtectionConfiguration(EntityType state, String node) {
        String cacheKey = state + "-" + state + "-" + node;
        if (this.protectionConfigurationCache.containsKey(cacheKey)) {
            return this.protectionConfigurationCache.get(cacheKey);
        }
        String value = this.configuration.getString("protections." + node);
        String temp = this.configuration.getString("protections.blocks." + state.name().toUpperCase() + "." + node);
        if (temp != null && !temp.isEmpty()) {
            value = temp;
        }
        this.protectionConfigurationCache.put(cacheKey, value);
        return value;
    }

    public boolean hasAdminPermission(CommandSender sender, String node) {
        return this.isAdmin(sender) || this.hasPermission(sender, node, "lwc.admin");
    }

    public boolean isAdmin(CommandSender sender) {
        return !(sender instanceof Player) || this.isAdmin((Player)sender);
    }

    public boolean hasPermission(CommandSender sender, String node, String ... fallback) {
        if (!(sender instanceof Player)) {
            return true;
        }
        Player player = (Player)sender;
        boolean hasNode = this.hasPermission(player, node);
        if (!hasNode) {
            for (String temp : fallback) {
                if (!this.hasPermission(player, temp)) continue;
                return true;
            }
        }
        return hasNode;
    }

    public boolean hasPlayerPermission(CommandSender sender, String node) {
        return this.hasPermission(sender, node, "lwc.protect");
    }

    public boolean isModeEnabled(String mode) {
        return this.configuration.getBoolean("modes." + mode + ".enabled", true);
    }

    public boolean isModeWhitelisted(Player player, String mode) {
        return this.hasPermission((CommandSender)player, "lwc.mode." + mode, "lwc.allmodes");
    }

    public boolean isProtectable(Block block) {
        Material material = block.getType();
        if (block instanceof EntityBlock) {
            return Boolean.parseBoolean(this.resolveProtectionConfiguration(EntityBlock.getEntity().getType(), "enabled"));
        }
        if (material == null) {
            return false;
        }
        return Boolean.parseBoolean(this.resolveProtectionConfiguration(block, "enabled"));
    }

    public String resolveProtectionConfiguration(Block block, String node) {
        Material material = block.getType();
        if (material == null) {
            return null;
        }
        String cacheKey = block.getData() + "-" + material.toString() + "-" + node;
        if (this.protectionConfigurationCache.containsKey(cacheKey)) {
            return this.protectionConfigurationCache.get(cacheKey);
        }
        ArrayList<String> names = new ArrayList<String>();
        String materialName = LWC.normalizeMaterialName(material);
        names.add(materialName);
        names.add(materialName + ":" + block.getData());
        names.add(material.toString());
        names.add(material.toString().toLowerCase());
        names.add("*");
        if (materialName.contains("_")) {
            names.add("*_" + materialName.substring(materialName.indexOf("_") + 1));
        }
        String value = this.configuration.getString("protections." + node);
        for (String name : names) {
            String temp = this.configuration.getString("protections.blocks." + name + "." + node);
            if (temp == null || temp.isEmpty()) continue;
            value = temp;
        }
        this.protectionConfigurationCache.put(cacheKey, value);
        return value;
    }

    public String resolveProtectionConfiguration(Material material, String node) {
        if (material == null) {
            return null;
        }
        String cacheKey = "00-" + material.toString() + "-" + node;
        if (this.protectionConfigurationCache.containsKey(cacheKey)) {
            return this.protectionConfigurationCache.get(cacheKey);
        }
        ArrayList<String> names = new ArrayList<String>();
        String materialName = LWC.normalizeMaterialName(material);
        names.add(materialName);
        names.add(material.toString());
        names.add(material.toString().toLowerCase());
        names.add("*");
        String value = this.configuration.getString("protections." + node);
        for (String name : names) {
            String temp = this.configuration.getString("protections.blocks." + name + "." + node);
            if (temp == null || temp.isEmpty()) continue;
            value = temp;
        }
        this.protectionConfigurationCache.put(cacheKey, value);
        return value;
    }

    public void load() {
        this.configuration = Configuration.load("core.yml");
        this.registerCoreModules();
        new ConfigPost300().run();
        this.plugin.loadDatabase();
        Statistics.init();
        this.physicalDatabase = new PhysDB();
        this.databaseThread = new DatabaseThread(this);
        this.permissions = new SuperPermsPermissions();
        if (this.resolvePlugin("Vault") != null) {
            this.permissions = new VaultPermissions();
        }
        this.currency = new NoCurrency();
        if (this.resolvePlugin("Vault") != null) {
            this.currency = new VaultCurrency();
        }
        this.plugin.getUpdater().init();
        this.log("Connecting to " + (Object)((Object)Database.DefaultType));
        try {
            if (!this.physicalDatabase.connect()) {
                Bukkit.getPluginManager().disablePlugin((Plugin)this.plugin);
                return;
            }
            this.physicalDatabase.load();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        new MySQLPost200().run();
        this.physicalDatabase.precache();
        this.moduleLoader.loadAll();
    }

    private void registerCoreModules() {
        this.registerModule(new LWCMCPCSupport(this));
        this.registerModule(new LimitsV2());
        this.registerModule(new LimitsModule());
        this.registerModule(new CreateModule());
        this.registerModule(new ModifyModule());
        this.registerModule(new DestroyModule());
        this.registerModule(new FreeModule());
        this.registerModule(new InfoModule());
        this.registerModule(new UnlockModule());
        this.registerModule(new OwnersModule());
        this.registerModule(new DoorsModule());
        this.registerModule(new DebugModule());
        this.registerModule(new CreditsModule());
        this.registerModule(new FixModule());
        this.registerModule(new HistoryModule());
        this.registerModule(new ConfirmModule());
        this.registerModule(new BaseAdminModule());
        this.registerModule(new AdminCache());
        this.registerModule(new AdminCleanup());
        this.registerModule(new AdminClear());
        this.registerModule(new AdminFind());
        this.registerModule(new AdminFlush());
        this.registerModule(new AdminForceOwner());
        this.registerModule(new AdminOwnerAll());
        this.registerModule(new AdminLocale());
        this.registerModule(new AdminPurge());
        this.registerModule(new AdminReload());
        this.registerModule(new AdminRemove());
        this.registerModule(new AdminReport());
        this.registerModule(new AdminVersion());
        this.registerModule(new AdminQuery());
        this.registerModule(new AdminPurgeBanned());
        this.registerModule(new AdminExpire());
        this.registerModule(new AdminDump());
        this.registerModule(new AdminRebuild());
        this.registerModule(new AdminBackup());
        this.registerModule(new AdminView());
        this.registerModule(new BaseSetupModule());
        this.registerModule(new DatabaseSetupModule());
        this.registerModule(new LimitsSetup());
        this.registerModule(new BaseFlagModule());
        this.registerModule(new RedstoneModule());
        this.registerModule(new MagnetModule());
        this.registerModule(new BaseModeModule());
        this.registerModule(new PersistModule());
        this.registerModule(new DropTransferModule());
        this.registerModule(new NoSpamModule());
        if (this.resolvePlugin("WorldGuard") != null) {
            this.registerModule(new WorldGuard());
        }
        if (this.resolvePlugin("Towny") != null) {
            this.registerModule(new Towny());
        }
        if (this.resolvePlugin("Vault") != null) {
            this.registerModule(new EconomyModule());
        }
        if (this.resolvePlugin("Factions") != null) {
            this.registerModule(new Factions());
        }
    }

    private void registerModule(Module module) {
        this.moduleLoader.registerModule((Plugin)this.plugin, module);
    }

    private Plugin resolvePlugin(String name) {
        Plugin temp = this.plugin.getServer().getPluginManager().getPlugin(name);
        if (temp == null) {
            return null;
        }
        return temp;
    }

    public ItemStack[] mergeInventories(List<Block> blocks) {
        ItemStack[] stacks = new ItemStack[54];
        int index = 0;
        try {
            for (Block block : blocks) {
                if (!(block.getState() instanceof InventoryHolder)) continue;
                InventoryHolder holder = (InventoryHolder)block.getState();
                Inventory inventory = holder.getInventory();
                ItemStack[] itemStackArray = inventory.getContents();
                int n = itemStackArray.length;
                for (int i = 0; i < n; ++i) {
                    ItemStack stack;
                    stacks[index] = stack = itemStackArray[i];
                    ++index;
                }
            }
        }
        catch (Exception e) {
            return this.mergeInventories(blocks);
        }
        return stacks;
    }

    public void processRightsModifications(CommandSender sender, Protection protection, String ... arguments) {
        try {
            Protection.Type protectionType = Protection.Type.matchType(arguments[0]);
            if (protectionType != null) {
                if (!(sender.hasPermission("lwc.create." + arguments[0]) && sender.hasPermission("lwc.create") && sender.hasPermission("lwc.protect"))) {
                    return;
                }
                protection.setType(protectionType);
                protection.save();
                if (protectionType == Protection.Type.PASSWORD) {
                    String password = StringUtil.join(arguments, 1);
                    protection.setPassword(this.encrypt(password));
                }
                this.sendLocale(sender, "protection.typechanged", "type", this.plugin.getMessageParser().parseMessage(protectionType.toString().toLowerCase(), new Object[0]));
                return;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        for (String value : arguments) {
            UUID uuid;
            boolean remove = false;
            boolean isAdmin = false;
            Permission.Type type = Permission.Type.PLAYER;
            if (value.startsWith("id:")) continue;
            if (value.startsWith("-")) {
                remove = true;
                value = value.substring(1);
            }
            if (value.startsWith("@")) {
                isAdmin = true;
                value = value.substring(1);
            }
            if (value.toLowerCase().startsWith("p:")) {
                type = Permission.Type.PLAYER;
                value = value.substring(2);
            }
            if (value.toLowerCase().startsWith("g:")) {
                type = Permission.Type.GROUP;
                value = value.substring(2);
            }
            if (value.toLowerCase().startsWith("t:")) {
                type = Permission.Type.TOWN;
                value = value.substring(2);
            }
            if (value.toLowerCase().startsWith("town:")) {
                type = Permission.Type.TOWN;
                value = value.substring(5);
            }
            if (value.toLowerCase().startsWith("item:")) {
                type = Permission.Type.ITEM;
                value = value.substring(5);
            }
            if (value.toLowerCase().startsWith("r:")) {
                type = Permission.Type.REGION;
                value = value.substring(2);
            }
            if (value.toLowerCase().startsWith("region:")) {
                type = Permission.Type.REGION;
                value = value.substring(7);
            }
            if (value.trim().isEmpty()) continue;
            String localeChild = type.toString().toLowerCase();
            if (type == Permission.Type.PLAYER && (uuid = UUIDRegistry.getUUID(value)) != null) {
                value = uuid.toString();
            }
            if (!remove) {
                Permission permission = new Permission(value, type);
                permission.setAccess(isAdmin ? Permission.Access.ADMIN : Permission.Access.PLAYER);
                protection.addPermission(permission);
                protection.save();
                if (type == Permission.Type.PLAYER) {
                    this.sendLocale(sender, "protection.interact.rights.register." + localeChild, "name", UUIDRegistry.formatPlayerName(value, false), "isadmin", isAdmin ? "[\u00a74ADMIN\u00a76]" : "");
                    continue;
                }
                this.sendLocale(sender, "protection.interact.rights.register." + localeChild, "name", value, "isadmin", isAdmin ? "[\u00a74ADMIN\u00a76]" : "");
                continue;
            }
            protection.removePermissions(value, type);
            protection.save();
            if (type == Permission.Type.PLAYER) {
                this.sendLocale(sender, "protection.interact.rights.remove." + localeChild, "name", UUIDRegistry.formatPlayerName(value, false), "isadmin", isAdmin ? "[\u00a74ADMIN\u00a76]" : "");
                continue;
            }
            this.sendLocale(sender, "protection.interact.rights.remove." + localeChild, "name", value, "isadmin", isAdmin ? "[\u00a74ADMIN\u00a76]" : "");
        }
    }

    public void reload() {
        this.plugin.loadLocales();
        this.protectionConfigurationCache.clear();
        Configuration.reload();
        this.moduleLoader.dispatchEvent(new LWCReloadEvent());
    }

    public void reloadDatabase() {
        try {
            this.databaseThread.flush();
            this.databaseThread.stop();
            this.physicalDatabase = new PhysDB();
            this.physicalDatabase.connect();
            this.physicalDatabase.load();
            this.databaseThread = new DatabaseThread(this);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void removeModes(CommandSender sender) {
        if (sender instanceof Player) {
            Player bPlayer = (Player)sender;
            if (this.notInPersistentMode(bPlayer.getName())) {
                this.wrapPlayer((CommandSender)bPlayer).removeAllActions();
            }
        } else if (sender instanceof LWCPlayer) {
            this.removeModes((CommandSender)((LWCPlayer)sender).getBukkitPlayer());
        }
    }

    public boolean notInPersistentMode(String player) {
        return !this.wrapPlayer((CommandSender)Bukkit.getServer().getPlayer(player)).hasMode("persist");
    }

    public void sendFullHelp(CommandSender sender) {
        this.sendLocale(sender, "help.basic", new Object[0]);
        if (this.isAdmin(sender)) {
            sender.sendMessage("");
            sender.sendMessage("\u00a74/lwc admin - Administration");
        }
    }

    public void sendSimpleUsage(CommandSender player, String command) {
        this.sendLocale(player, "help.simpleusage", "command", command);
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public ICurrency getCurrency() {
        return this.currency;
    }

    public BackupManager getBackupManager() {
        return this.backupManager;
    }

    public ModuleLoader getModuleLoader() {
        return this.moduleLoader;
    }

    public IPermissions getPermissions() {
        return this.permissions;
    }

    public PhysDB getPhysicalDatabase() {
        return this.physicalDatabase;
    }

    public LWCPlugin getPlugin() {
        return this.plugin;
    }

    public ProtectionCache getProtectionCache() {
        return this.protectionCache;
    }

    public DatabaseThread getDatabaseThread() {
        return this.databaseThread;
    }

    public double getVersion() {
        return Double.parseDouble(this.plugin.getDescription().getVersion());
    }

    public boolean isHistoryEnabled() {
        return !this.configuration.getBoolean("core.disableHistory", false);
    }

    public boolean enforceAccess(Player player, Protection protection, Entity entity, boolean hasAccess) {
        boolean permShowNotices;
        MessageParser parser = this.plugin.getMessageParser();
        if (entity == null || protection == null) {
            return true;
        }
        BlockCache blockCache = BlockCache.getInstance();
        if (entity != null && protection.getBlockId() <= 0 && blockCache.getBlockId(EntityBlock.ENTITY_BLOCK_NAME) != protection.getBlockId()) {
            protection.setBlockId(blockCache.getBlockId(EntityBlock.ENTITY_BLOCK_NAME));
            protection.save();
        }
        if (!(entity == null || protection.getWorld() != null && entity.getWorld().getName().equals(protection.getWorld()))) {
            protection.setWorld(entity.getWorld().getName());
            protection.save();
        }
        if (hasAccess) {
            long timestamp = System.currentTimeMillis() / 1000L;
            if (protection.isOwner(player) || protection.getAccess(player.getName(), Permission.Type.PLAYER) != Permission.Access.NONE) {
                protection.setLastAccessed(timestamp);
                protection.save();
            }
        }
        if ((permShowNotices = this.hasPermission(player, "lwc.shownotices")) && this.configuration.getBoolean("core.showNotices", true) && !Boolean.parseBoolean(this.resolveProtectionConfiguration(entity.getType(), "quiet"))) {
            boolean isOwner = protection.isOwner(player);
            boolean showMyNotices = this.configuration.getBoolean("core.showMyNotices", true);
            if (!isOwner || isOwner && (showMyNotices || permShowNotices)) {
                String owner = protection.isRealOwner(player) ? parser.parseMessage("you", new Object[0]) : UUIDRegistry.formatPlayerName(protection.getOwner(), false);
                String blockName = entity.getType().name();
                String protectionTypeToString = parser.parseMessage(protection.typeToString().toLowerCase(), new Object[0]);
                if (protectionTypeToString == null) {
                    protectionTypeToString = "Unknown";
                }
                if (parser.parseMessage("protection." + blockName.toLowerCase() + ".notice.protected", new Object[0]) != null) {
                    this.sendLocaleToActionBar((CommandSender)player, "protection." + blockName.toLowerCase() + ".notice.protected", "type", protectionTypeToString, "block", blockName, "owner", owner);
                } else {
                    this.sendLocaleToActionBar((CommandSender)player, "protection.general.notice.protected", "type", protectionTypeToString, "block", blockName, "owner", owner);
                }
            }
        }
        if (!hasAccess) {
            String blockName = entity.getType().name();
            Protection.Type type = protection.getType();
            if (type == Protection.Type.PASSWORD) {
                this.sendLocaleToActionBar((CommandSender)player, "protection.general.locked.password", "block", blockName, "owner", protection.getOwner());
            } else if (type == Protection.Type.PRIVATE || type == Protection.Type.DONATION) {
                this.sendLocaleToActionBar((CommandSender)player, "protection.general.locked.private", "block", blockName, "owner", protection.getOwner());
            }
        }
        return hasAccess;
    }
}

