/*
 * Decompiled with CFR 0.152.
 */
package com.griefcraft.listeners;

import com.griefcraft.bukkit.EntityBlock;
import com.griefcraft.cache.BlockCache;
import com.griefcraft.lwc.LWC;
import com.griefcraft.lwc.LWCPlugin;
import com.griefcraft.model.Action;
import com.griefcraft.model.Flag;
import com.griefcraft.model.LWCPlayer;
import com.griefcraft.model.Protection;
import com.griefcraft.scripting.Module;
import com.griefcraft.scripting.event.LWCBlockInteractEvent;
import com.griefcraft.scripting.event.LWCDropItemEvent;
import com.griefcraft.scripting.event.LWCEntityInteractEvent;
import com.griefcraft.scripting.event.LWCPlayerEvent;
import com.griefcraft.scripting.event.LWCProtectionDestroyEvent;
import com.griefcraft.scripting.event.LWCProtectionInteractEntityEvent;
import com.griefcraft.scripting.event.LWCProtectionInteractEvent;
import com.griefcraft.util.UUIDRegistry;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.block.Container;
import org.bukkit.block.DoubleChest;
import org.bukkit.block.Hopper;
import org.bukkit.command.CommandSender;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Hanging;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.entity.Vehicle;
import org.bukkit.entity.minecart.HopperMinecart;
import org.bukkit.entity.minecart.StorageMinecart;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.event.hanging.HangingBreakByEntityEvent;
import org.bukkit.event.hanging.HangingBreakEvent;
import org.bukkit.event.inventory.InventoryAction;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryMoveItemEvent;
import org.bukkit.event.inventory.InventoryOpenEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.event.player.PlayerArmorStandManipulateEvent;
import org.bukkit.event.player.PlayerDropItemEvent;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.vehicle.VehicleDestroyEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;

public class LWCPlayerListener
implements Listener {
    private static LWCPlugin plugin;

    public LWCPlayerListener(LWCPlugin plugin) {
        LWCPlayerListener.plugin = plugin;
    }

    @EventHandler
    public void hangingBreakByEvent(HangingBreakByEntityEvent event) {
        Hanging entity = event.getEntity();
        if (plugin.getLWC().isProtectable(event.getEntity().getType())) {
            int A = 50000 + entity.getUniqueId().hashCode();
            LWC lwc = LWC.getInstance();
            Protection protection = lwc.getPhysicalDatabase().loadProtection(entity.getWorld().getName(), A, A, A);
            if (event.getRemover() instanceof Projectile && protection != null) {
                event.setCancelled(true);
            }
            if (event.getRemover() instanceof Player) {
                Player p = (Player)event.getRemover();
                if ((p.hasPermission("lwc.lockentity." + entity.getType()) || p.hasPermission("lwc.lockentity.all")) && this.onPlayerEntityInteract(p, (Entity)entity, event.isCancelled())) {
                    event.setCancelled(true);
                }
                if (!event.isCancelled() && protection != null) {
                    boolean canAccess = lwc.canAccessProtection(p, protection);
                    if (canAccess) {
                        protection.remove();
                        protection.removeAllPermissions();
                        protection.removeCache();
                        return;
                    }
                    event.setCancelled(true);
                }
            }
        }
    }

    @EventHandler
    public void minecartBreak(VehicleDestroyEvent e) {
        Vehicle entity = e.getVehicle();
        if (plugin.getLWC().isProtectable(e.getVehicle().getType())) {
            int A = 50000 + entity.getUniqueId().hashCode();
            LWC lwc = LWC.getInstance();
            Protection protection = lwc.getPhysicalDatabase().loadProtection(entity.getWorld().getName(), A, A, A);
            if ((entity instanceof StorageMinecart || entity instanceof HopperMinecart) && protection != null) {
                Player p;
                boolean canAccess;
                if (e.getAttacker() instanceof Projectile) {
                    e.setCancelled(true);
                }
                if (canAccess = lwc.canAccessProtection(p = (Player)e.getAttacker(), protection)) {
                    protection.remove();
                    protection.removeAllPermissions();
                    protection.removeCache();
                    return;
                }
                e.setCancelled(true);
            }
        }
    }

    @EventHandler
    public void hangingBreak(HangingBreakEvent event) {
        Hanging entity = event.getEntity();
        if (plugin.getLWC().isProtectable(event.getEntity().getType())) {
            int A = 50000 + entity.getUniqueId().hashCode();
            LWC lwc = LWC.getInstance();
            Protection protection = lwc.getPhysicalDatabase().loadProtection(entity.getWorld().getName(), A, A, A);
            if (protection != null && (event.getCause() == HangingBreakEvent.RemoveCause.PHYSICS || event.getCause() == HangingBreakEvent.RemoveCause.EXPLOSION || event.getCause() == HangingBreakEvent.RemoveCause.OBSTRUCTION)) {
                event.setCancelled(true);
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onPlayerArmorStandManipulate(PlayerArmorStandManipulateEvent e) {
        ArmorStand entity = e.getRightClicked();
        if (plugin.getLWC().isProtectable(e.getRightClicked().getType())) {
            int A = 50000 + entity.getUniqueId().hashCode();
            LWC lwc = LWC.getInstance();
            Protection protection = lwc.getPhysicalDatabase().loadProtection(entity.getWorld().getName(), A, A, A);
            Player p = e.getPlayer();
            boolean canAccess = lwc.canAccessProtection(p, protection);
            if (this.onPlayerEntityInteract(p, (Entity)entity, e.isCancelled())) {
                e.setCancelled(true);
            }
            if (protection != null) {
                if (canAccess) {
                    return;
                }
                e.setCancelled(true);
            }
        }
    }

    @EventHandler
    public void onEntityDamage(EntityDamageEvent e) {
        if (e instanceof EntityDamageByEntityEvent && e.getCause() != EntityDamageEvent.DamageCause.BLOCK_EXPLOSION && e.getCause() != EntityDamageEvent.DamageCause.ENTITY_EXPLOSION) {
            return;
        }
        Entity entity = e.getEntity();
        if (plugin.getLWC().isProtectable(e.getEntity().getType())) {
            int A = 50000 + entity.getUniqueId().hashCode();
            LWC lwc = LWC.getInstance();
            Protection protection = lwc.getPhysicalDatabase().loadProtection(entity.getWorld().getName(), A, A, A);
            if (protection != null && e.getCause() != EntityDamageEvent.DamageCause.CONTACT) {
                e.setCancelled(true);
            }
        }
    }

    @EventHandler
    public void itemFrameItemRemoval(EntityDamageByEntityEvent e) {
        if (e.isCancelled()) {
            return;
        }
        Entity entity = e.getEntity();
        if (plugin.getLWC().isProtectable(e.getEntity().getType())) {
            int A = 50000 + entity.getUniqueId().hashCode();
            LWC lwc = LWC.getInstance();
            Protection protection = lwc.getPhysicalDatabase().loadProtection(entity.getWorld().getName(), A, A, A);
            if (!(entity instanceof Player)) {
                if (e.getDamager() instanceof Projectile) {
                    if (protection != null) {
                        e.setCancelled(true);
                    }
                    if ((entity instanceof StorageMinecart || entity instanceof HopperMinecart) && protection != null) {
                        e.setCancelled(true);
                    }
                }
                if (e.getDamager() instanceof Player) {
                    Player p = (Player)e.getDamager();
                    if (protection != null && !lwc.canAccessProtection(p, protection)) {
                        e.setCancelled(true);
                    }
                    if ((p.hasPermission("lwc.lockentity." + e.getEntityType()) || p.hasPermission("lwc.lockentity.all")) && this.onPlayerEntityInteract(p, entity, e.isCancelled())) {
                        e.setCancelled(true);
                    }
                    if ((entity instanceof StorageMinecart || entity instanceof HopperMinecart) && protection != null) {
                        e.setCancelled(true);
                    }
                }
            }
        }
    }

    @EventHandler
    public void onDeath(EntityDeathEvent e) {
        LivingEntity entity = e.getEntity();
        if (plugin.getLWC().isProtectable(e.getEntity().getType())) {
            int A = 50000 + entity.getUniqueId().hashCode();
            Player player = e.getEntity().getKiller();
            LWC lwc = LWC.getInstance();
            Protection protection = lwc.getPhysicalDatabase().loadProtection(entity.getWorld().getName(), A, A, A);
            if (protection != null) {
                boolean canAccess = lwc.canAccessProtection(player, protection);
                boolean canAdmin = lwc.canAdminProtection(player, protection);
                try {
                    if (player != null) {
                        LWCProtectionDestroyEvent evt = new LWCProtectionDestroyEvent(player, protection, LWCProtectionDestroyEvent.Method.ENTITY_DESTRUCTION, canAccess, canAdmin);
                        lwc.getModuleLoader().dispatchEvent(evt);
                    } else {
                        protection.remove();
                        protection.removeAllPermissions();
                        protection.removeCache();
                    }
                }
                catch (Exception ex) {
                    if (player != null) {
                        lwc.sendLocale((CommandSender)player, "protection.internalerror", "id", "ENTITY_DEATH");
                    }
                    lwc.sendLocale((CommandSender)Bukkit.getServer().getConsoleSender(), "protection.internalerror", "id", "ENTITY_DEATH");
                    ex.printStackTrace();
                }
            }
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onEntityInteract(PlayerInteractEntityEvent e) {
        Entity entity = e.getRightClicked();
        if (plugin.getLWC().isProtectable(entity.getType())) {
            Module.Result result;
            int A = 50000 + entity.getUniqueId().hashCode();
            LWC lwc = LWC.getInstance();
            Protection protection = lwc.getPhysicalDatabase().loadProtection(entity.getWorld().getName(), A, A, A);
            Player p = e.getPlayer();
            boolean canAccess = lwc.canAccessProtection(p, protection);
            if (entity instanceof Player) {
                return;
            }
            boolean canAdmin = lwc.canAdminProtection(p, protection);
            Set<String> actions = lwc.wrapPlayer((CommandSender)p).getActionNames();
            if (protection != null) {
                LWCProtectionInteractEntityEvent evt = new LWCProtectionInteractEntityEvent(e, protection, actions, canAccess, canAdmin);
                lwc.getModuleLoader().dispatchEvent(evt);
                result = evt.getResult();
            } else {
                LWCEntityInteractEvent evt = new LWCEntityInteractEvent(e, entity, actions);
                lwc.getModuleLoader().dispatchEvent(evt);
                result = evt.getResult();
            }
            if (result == Module.Result.ALLOW) {
                return;
            }
            if ((p.hasPermission("lwc.lockentity." + entity.getType()) || p.hasPermission("lwc.lockentity.all")) && this.onPlayerEntityInteract(p, entity, e.isCancelled())) {
                e.setCancelled(true);
            }
            if (protection != null) {
                if (canAccess) {
                    return;
                }
                e.setCancelled(true);
            }
        }
    }

    @EventHandler
    public void storageMinecraftInventoryOpen(InventoryOpenEvent event) {
        InventoryHolder holder = event.getInventory().getHolder();
        Player player = (Player)event.getPlayer();
        if (!(holder instanceof StorageMinecart) && !(holder instanceof HopperMinecart)) {
            return;
        }
        Entity entity = (Entity)holder;
        if (plugin.getLWC().isProtectable(entity.getType())) {
            if (!plugin.getLWC().hasPermission(player, "lwc.protect") && plugin.getLWC().hasPermission(player, "lwc.deny") && !plugin.getLWC().isAdmin(player) && !plugin.getLWC().isMod(player)) {
                plugin.getLWC().sendLocale((CommandSender)player, "protection.interact.error.blocked", new Object[0]);
                event.setCancelled(true);
                return;
            }
            if (this.onPlayerEntityInteract((Player)event.getPlayer(), entity, event.isCancelled())) {
                event.setCancelled(true);
            }
        }
    }

    private boolean onPlayerEntityInteract(Player player, Entity entity, boolean cancelled) {
        int A = 50000 + entity.getUniqueId().hashCode();
        LWC lwc = LWC.getInstance();
        Protection protection = lwc.getPhysicalDatabase().loadProtection(entity.getWorld().getName(), A, A, A);
        LWCPlayer lwcPlayer = lwc.wrapPlayer((CommandSender)player);
        try {
            Player owner;
            Module.Result result;
            LWCPlayerEvent evt;
            boolean hasPendingAction;
            Set<String> actions = lwcPlayer.getActionNames();
            boolean canAccess = lwc.canAccessProtection(player, protection);
            int actionCount = actions.size();
            boolean hasInteracted = actions.contains("interacted");
            boolean bl = hasPendingAction = hasInteracted && actionCount > 1 || !hasInteracted && actionCount > 0;
            if (cancelled) {
                if (hasPendingAction) {
                    lwc.sendLocale((CommandSender)player, "lwc.pendingaction", new Object[0]);
                }
                return false;
            }
            if (protection != null) {
                Action action = new Action();
                action.setName("interacted");
                action.setPlayer(lwcPlayer);
                action.setProtection(protection);
                lwcPlayer.addAction(action);
            }
            boolean canAdmin = lwc.canAdminProtection(player, protection);
            Block fakeBlock = EntityBlock.getEntityBlock(entity);
            PlayerInteractEvent fakeEvent = new PlayerInteractEvent(player, org.bukkit.event.block.Action.RIGHT_CLICK_BLOCK, null, fakeBlock, null);
            if (protection != null) {
                evt = new LWCProtectionInteractEvent(fakeEvent, protection, actions, canAccess, canAdmin);
                lwc.getModuleLoader().dispatchEvent(evt);
                result = ((LWCProtectionInteractEvent)evt).getResult();
            } else {
                evt = new LWCBlockInteractEvent(fakeEvent, fakeBlock, actions);
                lwc.getModuleLoader().dispatchEvent(evt);
                result = ((LWCBlockInteractEvent)evt).getResult();
            }
            if (result == Module.Result.ALLOW) {
                return false;
            }
            if (!(protection == null || canAccess || !lwc.getConfiguration().getBoolean("optional.onlyProtectWhenOwnerIsOnline", false) || (owner = protection.getBukkitOwner()) != null && owner.isOnline())) {
                return false;
            }
            if (protection != null && !canAccess && lwc.getConfiguration().getBoolean("optional.onlyProtectWhenOwnerIsOffline", false) && (owner = protection.getBukkitOwner()) != null && owner.isOnline()) {
                return false;
            }
            if (result == Module.Result.DEFAULT) {
                canAccess = lwc.enforceAccess(player, protection, entity, canAccess);
            }
            if (!canAccess || result == Module.Result.CANCEL) {
                return true;
            }
        }
        catch (Exception e) {
            lwc.sendLocale((CommandSender)player, "protection.internalerror", "id", "PLAYER_INTERACT");
            e.printStackTrace();
            return true;
        }
        return false;
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onPlayerJoin(PlayerJoinEvent event) {
        Player player = event.getPlayer();
        UUIDRegistry.updateCache(player.getUniqueId(), player.getName());
    }

    @EventHandler(ignoreCancelled=true)
    public void onMoveItem(InventoryMoveItemEvent event) {
        boolean result = event.getInitiator() == event.getSource() ? this.handleMoveItemEvent(event.getInitiator(), event.getDestination()) : this.handleMoveItemEvent(event.getInitiator(), event.getSource());
        if (result) {
            event.setCancelled(true);
        }
    }

    private boolean handleMoveItemEvent(Inventory initiator, Inventory inventory) {
        Protection hopperProtection;
        Location location;
        InventoryHolder hopperHolder;
        InventoryHolder holder;
        LWC lwc = LWC.getInstance();
        if (inventory == null) {
            return false;
        }
        Location hopperLocation = null;
        try {
            holder = inventory.getHolder();
            hopperHolder = initiator.getHolder();
        }
        catch (AbstractMethodError e) {
            return false;
        }
        try {
            if (holder instanceof BlockState) {
                location = ((BlockState)holder).getLocation();
            } else if (holder instanceof DoubleChest) {
                location = ((DoubleChest)holder).getLocation();
            } else {
                return false;
            }
            if (hopperHolder instanceof Hopper) {
                hopperLocation = ((Hopper)hopperHolder).getLocation();
            } else if (hopperHolder instanceof HopperMinecart) {
                hopperLocation = ((HopperMinecart)hopperHolder).getLocation();
            }
        }
        catch (Exception e) {
            return false;
        }
        lwc.getProtectionCache().increaseIfNecessary();
        Protection protection = lwc.findProtection(location);
        if (protection == null) {
            return false;
        }
        if (hopperLocation != null && Boolean.parseBoolean(lwc.resolveProtectionConfiguration(Material.HOPPER, "enabled")) && (hopperProtection = lwc.findProtection(hopperLocation)) != null && protection.getOwner().equals(hopperProtection.getOwner())) {
            return false;
        }
        BlockCache blockCache = BlockCache.getInstance();
        boolean denyHoppers = Boolean.parseBoolean(lwc.resolveProtectionConfiguration(blockCache.getBlockType(protection.getBlockId()), "denyHoppers"));
        return denyHoppers ^ protection.hasFlag(Flag.Type.HOPPER);
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onPlayerDropItem(PlayerDropItemEvent event) {
        if (event.isCancelled() || !LWC.ENABLED) {
            return;
        }
        Player player = event.getPlayer();
        LWCDropItemEvent evt = new LWCDropItemEvent(player, event);
        plugin.getLWC().getModuleLoader().dispatchEvent(evt);
        if (evt.isCancelled()) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onPlayerInteract(PlayerInteractEvent event) {
        BlockState state;
        LWC lwc = plugin.getLWC();
        Player player = event.getPlayer();
        LWCPlayer lwcPlayer = lwc.wrapPlayer((CommandSender)player);
        if (event.getAction() != org.bukkit.event.block.Action.LEFT_CLICK_BLOCK && event.getAction() != org.bukkit.event.block.Action.RIGHT_CLICK_BLOCK) {
            return;
        }
        if (event.getHand() == EquipmentSlot.OFF_HAND && !(event.getClickedBlock() instanceof Container)) {
            return;
        }
        Block block = event.getClickedBlock();
        try {
            state = block.getState();
        }
        catch (NullPointerException e) {
            return;
        }
        if (state instanceof InventoryHolder && lwc.isProtectable(block) && !lwc.hasPermission(player, "lwc.protect") && lwc.hasPermission(player, "lwc.deny") && !lwc.isAdmin(player) && !lwc.isMod(player)) {
            lwc.sendLocale((CommandSender)player, "protection.interact.error.blocked", new Object[0]);
            event.setCancelled(true);
            return;
        }
        try {
            Player owner;
            Module.Result result;
            LWCPlayerEvent evt;
            boolean ignoreRightClick;
            boolean ignoreLeftClick;
            boolean hasPendingAction;
            Set<String> actions = lwcPlayer.getActionNames();
            Protection protection = lwc.findProtection(block.getLocation());
            boolean canAccess = lwc.canAccessProtection(player, protection);
            int actionCount = actions.size();
            boolean hasInteracted = actions.contains("interacted");
            boolean bl = hasPendingAction = hasInteracted && actionCount > 1 || !hasInteracted && actionCount > 0;
            if (event.getAction() == org.bukkit.event.block.Action.LEFT_CLICK_BLOCK ? (ignoreLeftClick = Boolean.parseBoolean(lwc.resolveProtectionConfiguration(block, "ignoreLeftClick"))) : event.getAction() == org.bukkit.event.block.Action.RIGHT_CLICK_BLOCK && (ignoreRightClick = Boolean.parseBoolean(lwc.resolveProtectionConfiguration(block, "ignoreRightClick")))) {
                return;
            }
            if (event.isCancelled()) {
                if (hasPendingAction) {
                    lwc.sendLocale((CommandSender)player, "lwc.pendingaction", new Object[0]);
                }
                return;
            }
            if (protection != null) {
                Action action = new Action();
                action.setName("interacted");
                action.setPlayer(lwcPlayer);
                action.setProtection(protection);
                lwcPlayer.addAction(action);
            }
            boolean canAdmin = lwc.canAdminProtection(player, protection);
            if (protection != null) {
                evt = new LWCProtectionInteractEvent(event, protection, actions, canAccess, canAdmin);
                lwc.getModuleLoader().dispatchEvent(evt);
                result = ((LWCProtectionInteractEvent)evt).getResult();
            } else {
                evt = new LWCBlockInteractEvent(event, block, actions);
                lwc.getModuleLoader().dispatchEvent(evt);
                result = ((LWCBlockInteractEvent)evt).getResult();
            }
            if (result == Module.Result.ALLOW) {
                return;
            }
            if (!(protection == null || canAccess || !lwc.getConfiguration().getBoolean("optional.onlyProtectWhenOwnerIsOnline", false) || (owner = protection.getBukkitOwner()) != null && owner.isOnline())) {
                return;
            }
            if (protection != null && !canAccess && lwc.getConfiguration().getBoolean("optional.onlyProtectWhenOwnerIsOffline", false) && (owner = protection.getBukkitOwner()) != null && owner.isOnline()) {
                return;
            }
            if (result == Module.Result.DEFAULT) {
                canAccess = lwc.enforceAccess(player, protection, block, canAccess);
            }
            if (!canAccess || result == Module.Result.CANCEL) {
                event.setCancelled(true);
                event.setUseInteractedBlock(Event.Result.DENY);
            }
        }
        catch (Exception e) {
            event.setCancelled(true);
            event.setUseInteractedBlock(Event.Result.DENY);
            lwc.sendLocale((CommandSender)player, "protection.internalerror", "id", "PLAYER_INTERACT");
            e.printStackTrace();
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onPlayerQuit(PlayerQuitEvent event) {
        if (!LWC.ENABLED) {
            return;
        }
        LWCPlayer.removePlayer(event.getPlayer());
    }

    @EventHandler(ignoreCancelled=true)
    public void onInventoryClick(InventoryClickEvent event) {
        Protection protection;
        Location location;
        Player player;
        LWC lwc;
        block18: {
            lwc = LWC.getInstance();
            if (!(event.getWhoClicked() instanceof Player)) {
                return;
            }
            player = (Player)event.getWhoClicked();
            Inventory inventory = event.getInventory();
            if (inventory == null || event.getSlot() < 0) {
                return;
            }
            InventoryHolder holder = null;
            try {
                holder = event.getInventory().getHolder();
            }
            catch (AbstractMethodError e) {
                e.printStackTrace();
                return;
            }
            try {
                if (holder instanceof BlockState) {
                    location = ((BlockState)holder).getLocation();
                    break block18;
                }
                if (holder instanceof DoubleChest) {
                    location = ((DoubleChest)holder).getLocation();
                    break block18;
                }
                return;
            }
            catch (Exception e) {
                Location ploc = player.getLocation();
                String holderName = holder.getClass().getSimpleName();
                e.printStackTrace();
                return;
            }
        }
        if (event.getAction() != InventoryAction.COLLECT_TO_CURSOR) {
            ItemStack item;
            if (event.getSlotType() != InventoryType.SlotType.CONTAINER) {
                return;
            }
            if (event.getSlot() != event.getRawSlot()) {
                return;
            }
            try {
                item = event.getCurrentItem();
            }
            catch (ArrayIndexOutOfBoundsException e) {
                return;
            }
            ItemStack cursor = event.getCursor();
            if (item == null || item.getType() == null || item.getType() == Material.AIR) {
                return;
            }
            if (player.getInventory().getItemInMainHand() == null && !event.isRightClick() && !event.isShiftClick()) {
                return;
            }
        }
        if ((protection = lwc.findProtection(location)) == null) {
            return;
        }
        if (protection.getType() != Protection.Type.DONATION) {
            return;
        }
        boolean canAdmin = lwc.canAdminProtection(player, protection);
        if (!canAdmin) {
            event.setCancelled(true);
        }
    }

    private boolean areEnchantmentsEqual(ItemStack stack1, ItemStack stack2) {
        if (stack1 == null || stack2 == null) {
            return false;
        }
        Map enchantments1 = stack1.getEnchantments();
        Map enchantments2 = stack2.getEnchantments();
        if (enchantments1.size() != enchantments2.size()) {
            return false;
        }
        if (stack1.getItemMeta() != null && stack2.getItemMeta() != null && !stack1.getItemMeta().equals(stack2.getItemMeta())) {
            return false;
        }
        for (Enchantment enchantment : enchantments1.keySet()) {
            int level2;
            if (!enchantments2.containsKey(enchantment)) {
                return false;
            }
            int level1 = (Integer)enchantments1.get(enchantment);
            if (level1 == (level2 = ((Integer)enchantments2.get(enchantment)).intValue())) continue;
            return false;
        }
        return true;
    }

    public static String getMinecraftVersion() {
        Matcher matcher = Pattern.compile("(\\(MC: )([\\d\\.]+)(\\))").matcher(Bukkit.getVersion());
        if (matcher.find()) {
            return matcher.group(2);
        }
        return null;
    }
}

