/*
 * Decompiled with CFR 0.152.
 */
package com.griefcraft.listeners;

import com.griefcraft.lwc.LWC;
import com.griefcraft.scripting.JavaModule;
import com.griefcraft.scripting.event.LWCProtectionDestroyEvent;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class LWCMCPCSupport
extends JavaModule {
    private LWC lwc;
    private final Set<String> blacklistedPlayers = new HashSet<String>();

    public LWCMCPCSupport(LWC lwc) {
        this.lwc = lwc;
        this.loadAndProcessConfig();
    }

    public void loadAndProcessConfig() {
        this.blacklistedPlayers.clear();
        for (String player : this.lwc.getConfiguration().getStringList("optional.blacklistedPlayers", new ArrayList<String>())) {
            this.blacklistedPlayers.add(player.toLowerCase());
        }
    }

    @Override
    public void onDestroyProtection(LWCProtectionDestroyEvent event) {
        if (event.isCancelled()) {
            return;
        }
        Player player = event.getPlayer();
        String lowerPlayerName = player.getName().toLowerCase();
        if (this.blacklistedPlayers.contains(lowerPlayerName)) {
            event.setCancelled(true);
            this.lwc.sendLocale((CommandSender)player, "protection.accessdenied", new Object[0]);
        }
    }
}

