/*
 * Decompiled with CFR 0.152.
 */
package com.griefcraft.listeners;

import com.griefcraft.bukkit.EntityBlock;
import com.griefcraft.cache.ProtectionCache;
import com.griefcraft.lwc.LWC;
import com.griefcraft.lwc.LWCPlugin;
import com.griefcraft.model.Flag;
import com.griefcraft.model.Protection;
import com.griefcraft.scripting.event.LWCProtectionDestroyEvent;
import com.griefcraft.scripting.event.LWCProtectionRegisterEvent;
import com.griefcraft.scripting.event.LWCProtectionRegistrationPostEvent;
import java.util.UUID;
import org.bukkit.GameMode;
import org.bukkit.block.Block;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Hanging;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntityBreakDoorEvent;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityExplodeEvent;
import org.bukkit.event.entity.EntityInteractEvent;
import org.bukkit.event.hanging.HangingPlaceEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.ItemStack;

public class LWCEntityListener
implements Listener {
    private LWCPlugin plugin;
    private UUID placedArmorStandPlayer;

    public LWCEntityListener(LWCPlugin plugin) {
        this.plugin = plugin;
    }

    @EventHandler(ignoreCancelled=true)
    public void onHangingPlace(HangingPlaceEvent event) {
        Player player = event.getPlayer();
        Hanging block = event.getEntity();
        this.entityCreatedByPlayer((Entity)block, player);
    }

    @EventHandler(ignoreCancelled=true)
    public void onPlayerInteract(PlayerInteractEvent e) {
        ItemStack inHand = e.getItem();
        if (inHand != null) {
            this.placedArmorStandPlayer = e.getPlayer().getUniqueId();
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onEntityDamageByEntity(EntityDamageByEntityEvent event) {
        if (!LWC.ENABLED || event.isCancelled()) {
            return;
        }
        LWC lwc = this.plugin.getLWC();
        if (event.getDamager() instanceof Player) {
            Player player = (Player)event.getDamager();
            Entity entity = event.getEntity();
            EntityBlock entityBlock = new EntityBlock(entity);
            boolean ignoreBlockDestruction = Boolean.parseBoolean(lwc.resolveProtectionConfiguration(entityBlock, "ignoreBlockDestruction"));
            if (ignoreBlockDestruction) {
                return;
            }
            if (event.getEntityType().equals((Object)EntityType.ARMOR_STAND) && (event.getDamage() < 1.0 || ((Player)event.getDamager()).getGameMode().equals((Object)GameMode.CREATIVE))) {
                Protection protection;
                String cacheKey;
                ProtectionCache cache = lwc.getProtectionCache();
                if (cache.isKnownNull(cacheKey = cache.cacheKey(entityBlock.getLocation()))) {
                    cache.remove(cacheKey);
                }
                if ((protection = lwc.findProtection(entityBlock)) == null) {
                    return;
                }
                boolean canAccess = lwc.canAccessProtection(player, protection);
                boolean canAdmin = lwc.canAdminProtection(player, protection);
                try {
                    LWCProtectionDestroyEvent evt = new LWCProtectionDestroyEvent(player, protection, LWCProtectionDestroyEvent.Method.ENTITY_DESTRUCTION, canAccess, canAdmin);
                    lwc.getModuleLoader().dispatchEvent(evt);
                    protection.remove();
                    protection.removeAllPermissions();
                    protection.removeCache();
                    if (evt.isCancelled() || !canAccess) {
                        event.setCancelled(true);
                    }
                }
                catch (Exception e) {
                    event.setCancelled(true);
                    lwc.sendLocale((CommandSender)player, "protection.internalerror", "id", "BLOCK_BREAK");
                    e.printStackTrace();
                }
            }
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onCreateSpawn(CreatureSpawnEvent e) {
        if (this.placedArmorStandPlayer != null) {
            Player player = this.plugin.getServer().getPlayer(this.placedArmorStandPlayer);
            LivingEntity block = e.getEntity();
            this.placedArmorStandPlayer = null;
            if (player != null && player.getWorld().equals(block.getWorld()) && player.getLocation().distance(block.getLocation()) <= 5.0) {
                this.entityCreatedByPlayer((Entity)block, player);
            }
        }
    }

    private void entityCreatedByPlayer(Entity entity, Player player) {
        Protection.Type type;
        int A;
        LWC lwc;
        block16: {
            if (!LWC.ENABLED) {
                return;
            }
            lwc = this.plugin.getLWC();
            A = 50000 + entity.getUniqueId().hashCode();
            try {
                Protection current = lwc.findProtection(EntityBlock.getEntityBlock(entity));
                if (current == null) break block16;
                if (!current.isBlockInWorld()) {
                    current.remove();
                    break block16;
                }
                if (current.getProtectionFinder() != null) {
                    current.getProtectionFinder().fullMatchBlocks();
                    lwc.getProtectionCache().addProtection(current);
                }
                return;
            }
            catch (ClassCastException ex) {
                ex.printStackTrace();
            }
        }
        if (!lwc.isProtectable(entity.getType())) {
            return;
        }
        String autoRegisterType = lwc.resolveProtectionConfiguration(entity.getType(), "autoRegister");
        if (!(autoRegisterType.equalsIgnoreCase("private") || autoRegisterType.equalsIgnoreCase("public") || autoRegisterType.equalsIgnoreCase("donation"))) {
            return;
        }
        if (!lwc.hasPermission((CommandSender)player, "lwc.create." + autoRegisterType, "lwc.create", "lwc.protect")) {
            return;
        }
        try {
            type = Protection.Type.valueOf(autoRegisterType.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            return;
        }
        if (type == null) {
            player.sendMessage("\u00a74LWC_INVALID_CONFIG_autoRegister");
            return;
        }
        try {
            LWCProtectionRegisterEvent evt = new LWCProtectionRegisterEvent(player, EntityBlock.getEntityBlock(entity));
            lwc.getModuleLoader().dispatchEvent(evt);
            if (evt.isCancelled()) {
                return;
            }
            Protection protection = lwc.getPhysicalDatabase().registerProtection(5000, type, entity.getWorld().getName(), player.getUniqueId().toString(), "", A, A, A);
            if (!Boolean.parseBoolean(lwc.resolveProtectionConfiguration(EntityBlock.getEntityBlock(entity), "quiet"))) {
                lwc.sendLocaleToActionBar((CommandSender)player, "protection.onplace.create.finalize", "type", lwc.getPlugin().getMessageParser().parseMessage(autoRegisterType.toLowerCase(), new Object[0]), "block", LWC.materialToString(EntityBlock.getEntityBlock(entity)));
            }
            if (protection != null) {
                lwc.getModuleLoader().dispatchEvent(new LWCProtectionRegistrationPostEvent(protection));
            }
        }
        catch (Exception e) {
            lwc.sendLocale((CommandSender)player, "protection.internalerror", "id", "PLAYER_INTERACT");
            e.printStackTrace();
        }
    }

    @EventHandler
    public void entityInteract(EntityInteractEvent event) {
        boolean allowEntityInteract;
        Block block = event.getBlock();
        Protection protection = this.plugin.getLWC().findProtection(block.getLocation());
        if (protection != null && !(allowEntityInteract = Boolean.parseBoolean(this.plugin.getLWC().resolveProtectionConfiguration(block, "allowEntityInteract")))) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void entityBreakDoor(EntityBreakDoorEvent event) {
        boolean allowEntityBreakDoor;
        Block block = event.getBlock();
        Protection protection = this.plugin.getLWC().findProtection(block.getLocation());
        if (protection != null && !(allowEntityBreakDoor = Boolean.parseBoolean(this.plugin.getLWC().resolveProtectionConfiguration(block, "allowEntityBreakDoor")))) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onEntityExplode(EntityExplodeEvent event) {
        if (!LWC.ENABLED || event.isCancelled()) {
            return;
        }
        LWC lwc = LWC.getInstance();
        for (Block block : event.blockList()) {
            boolean ignoreExplosions;
            Protection protection = this.plugin.getLWC().findProtection(block.getLocation());
            if (protection == null || (ignoreExplosions = Boolean.parseBoolean(lwc.resolveProtectionConfiguration(protection.getBlock(), "ignoreExplosions"))) || protection.hasFlag(Flag.Type.ALLOWEXPLOSIONS)) continue;
            event.setCancelled(true);
        }
    }
}

