/*
 * Decompiled with CFR 0.152.
 */
package com.griefcraft.listeners;

import com.griefcraft.cache.BlockCache;
import com.griefcraft.cache.ProtectionCache;
import com.griefcraft.lwc.LWC;
import com.griefcraft.lwc.LWCPlugin;
import com.griefcraft.model.Flag;
import com.griefcraft.model.Protection;
import com.griefcraft.scripting.event.LWCProtectionDestroyEvent;
import com.griefcraft.scripting.event.LWCProtectionRegisterEvent;
import com.griefcraft.scripting.event.LWCProtectionRegistrationPostEvent;
import com.griefcraft.scripting.event.LWCRedstoneEvent;
import com.griefcraft.util.MaterialUtil;
import com.griefcraft.util.matchers.DoubleChestMatcher;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.BlockState;
import org.bukkit.block.data.type.Chest;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockExplodeEvent;
import org.bukkit.event.block.BlockFromToEvent;
import org.bukkit.event.block.BlockMultiPlaceEvent;
import org.bukkit.event.block.BlockPistonExtendEvent;
import org.bukkit.event.block.BlockPistonRetractEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.block.BlockRedstoneEvent;
import org.bukkit.event.block.SignChangeEvent;
import org.bukkit.event.entity.EntityChangeBlockEvent;
import org.bukkit.event.world.StructureGrowEvent;

public class LWCBlockListener
implements Listener {
    private LWCPlugin plugin;
    private final Set<Material> blacklistedBlocks = new HashSet<Material>();
    public static final BlockFace[] POSSIBLE_FACES = new BlockFace[]{BlockFace.NORTH, BlockFace.SOUTH, BlockFace.EAST, BlockFace.WEST, BlockFace.UP, BlockFace.DOWN};

    public LWCBlockListener(LWCPlugin plugin) {
        this.plugin = plugin;
        this.loadAndProcessConfig();
    }

    @EventHandler
    public void onBlockRedstoneChange(BlockRedstoneEvent event) {
        if (!LWC.ENABLED) {
            return;
        }
        LWC lwc = this.plugin.getLWC();
        Block block = event.getBlock();
        if (block == null) {
            return;
        }
        Protection protection = lwc.findProtection(block.getLocation());
        if (protection == null) {
            return;
        }
        LWCRedstoneEvent evt = new LWCRedstoneEvent(event, protection);
        lwc.getModuleLoader().dispatchEvent(evt);
        if (evt.isCancelled()) {
            event.setNewCurrent(event.getOldCurrent());
        }
    }

    @EventHandler
    public void onStructureGrow(StructureGrowEvent event) {
        if (!LWC.ENABLED) {
            return;
        }
        LWC lwc = LWC.getInstance();
        List blocks = event.getBlocks();
        for (BlockState block : blocks) {
            Protection protection;
            if (!lwc.isProtectable(block.getBlock()) || (protection = lwc.getPhysicalDatabase().loadProtection(block.getWorld().getName(), block.getX(), block.getY(), block.getZ())) == null) continue;
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onEntityChangeBlock(EntityChangeBlockEvent event) {
        Block block;
        if (!LWC.ENABLED) {
            return;
        }
        LWC lwc = LWC.getInstance();
        if (!lwc.isProtectable(block = event.getBlock())) {
            return;
        }
        Protection protection = lwc.findProtection(block);
        if (protection != null) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onSignChange(SignChangeEvent event) {
        if (!LWC.ENABLED || event.isCancelled()) {
            return;
        }
        LWC lwc = this.plugin.getLWC();
        Block block = event.getBlock();
        Player player = event.getPlayer();
        if (block == null) {
            return;
        }
        Protection protection = lwc.findProtection(block.getLocation());
        if (protection == null) {
            return;
        }
        boolean canAccess = lwc.canAccessProtection(player, protection);
        if (!canAccess) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onBlockBreak(BlockBreakEvent event) {
        Block doubleChest;
        Protection protection;
        String cacheKey;
        if (!LWC.ENABLED || event.isCancelled()) {
            return;
        }
        LWC lwc = this.plugin.getLWC();
        Player player = event.getPlayer();
        Block block = event.getBlock();
        boolean ignoreBlockDestruction = Boolean.parseBoolean(lwc.resolveProtectionConfiguration(block, "ignoreBlockDestruction"));
        if (ignoreBlockDestruction) {
            return;
        }
        ProtectionCache cache = lwc.getProtectionCache();
        if (cache.isKnownNull(cacheKey = cache.cacheKey(block.getLocation()))) {
            cache.remove(cacheKey);
        }
        if ((protection = lwc.findProtection(block.getLocation())) == null) {
            return;
        }
        boolean canAccess = lwc.canAccessProtection(player, protection);
        boolean canAdmin = lwc.canAdminProtection(player, protection);
        if (protection.isOwner(player) && DoubleChestMatcher.PROTECTABLES_CHESTS.contains(block.getType()) && (doubleChest = lwc.findAdjacentDoubleChest(block)) != null) {
            if (lwc.blockEquals(protection.getBlock(), block)) {
                BlockCache blockCache = BlockCache.getInstance();
                protection.setBlockId(blockCache.getBlockId(doubleChest));
                protection.setX(doubleChest.getX());
                protection.setY(doubleChest.getY());
                protection.setZ(doubleChest.getZ());
                protection.saveNow();
            }
            protection.radiusRemoveCache();
            if (protection.getProtectionFinder() != null) {
                protection.getProtectionFinder().removeBlock(block.getState());
            }
            lwc.getProtectionCache().addProtection(protection);
            return;
        }
        try {
            LWCProtectionDestroyEvent evt = new LWCProtectionDestroyEvent(player, protection, LWCProtectionDestroyEvent.Method.BLOCK_DESTRUCTION, canAccess, canAdmin);
            lwc.getModuleLoader().dispatchEvent(evt);
            if (evt.isCancelled() || !canAccess) {
                event.setCancelled(true);
            }
        }
        catch (Exception e) {
            event.setCancelled(true);
            lwc.sendLocale((CommandSender)player, "protection.internalerror", "id", "BLOCK_BREAK");
            e.printStackTrace();
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onBlockMultiPlace(BlockMultiPlaceEvent event) {
        LWC lwc = this.plugin.getLWC();
        Block block = event.getBlock();
        if (block.getType().name().contains("_BED")) {
            for (BlockState state : event.getReplacedBlockStates()) {
                Protection protection = lwc.findProtection(state);
                if (protection == null) continue;
                event.setCancelled(true);
                return;
            }
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onBlockFromTo(BlockFromToEvent event) {
        Block block = event.getBlock();
        LWC lwc = this.plugin.getLWC();
        if (block.getType() == Material.WATER && lwc.isProtectable(event.getToBlock()) && lwc.findProtection(event.getToBlock().getLocation()) != null) {
            event.setCancelled(true);
            return;
        }
    }

    @EventHandler
    public void onBlockPistonRetract(BlockPistonRetractEvent event) {
        if (!LWC.ENABLED || event.isCancelled()) {
            return;
        }
        LWC lwc = this.plugin.getLWC();
        for (Block block : event.getBlocks()) {
            Protection protection = lwc.findProtection(block);
            if (protection == null) continue;
            event.setCancelled(true);
            return;
        }
    }

    @EventHandler
    public void onBlockPistonExtend(BlockPistonExtendEvent event) {
        if (!LWC.ENABLED || event.isCancelled()) {
            return;
        }
        LWC lwc = this.plugin.getLWC();
        for (Block block : event.getBlocks()) {
            Protection protection = lwc.findProtection(block);
            if (protection == null) continue;
            event.setCancelled(true);
            return;
        }
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onBlockExplode(BlockExplodeEvent event) {
        if (!LWC.ENABLED || event.isCancelled()) {
            return;
        }
        LWC lwc = this.plugin.getLWC();
        for (Block block : event.blockList()) {
            boolean ignoreExplosions;
            Protection protection = this.plugin.getLWC().findProtection(block.getLocation());
            if (protection == null || (ignoreExplosions = Boolean.parseBoolean(lwc.resolveProtectionConfiguration(protection.getBlock(), "ignoreExplosions"))) || protection.hasFlag(Flag.Type.ALLOWEXPLOSIONS)) continue;
            event.setCancelled(true);
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onBlockPlace(BlockPlaceEvent event) {
        String cacheKey;
        if (!LWC.ENABLED) {
            return;
        }
        LWC lwc = this.plugin.getLWC();
        Player player = event.getPlayer();
        Block block = event.getBlockPlaced();
        ProtectionCache cache = lwc.getProtectionCache();
        if (cache.isKnownNull(cacheKey = cache.cacheKey(block.getLocation()))) {
            cache.remove(cacheKey);
        }
        if (this.blacklistedBlocks.contains(block.getType())) {
            for (Protection protection : lwc.findAdjacentProtectionsOnAllSides(block, new Block[0])) {
                if (protection == null || lwc.canAccessProtection(player, protection) && (protection.getType() != Protection.Type.DONATION || lwc.canAdminProtection(player, protection))) continue;
                event.setCancelled(true);
                return;
            }
        }
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.HIGHEST)
    public void onBlockPlaceMonitor(BlockPlaceEvent event) {
        BlockFace neighboringChestBlockFace;
        Protection.Type type;
        if (!LWC.ENABLED) {
            return;
        }
        LWC lwc = this.plugin.getLWC();
        Player player = event.getPlayer();
        Block block = event.getBlockPlaced();
        Protection current = lwc.findProtection(block.getLocation());
        if (current != null) {
            if (!current.isBlockInWorld()) {
                current.remove();
            } else {
                if (current.getProtectionFinder() != null) {
                    current.getProtectionFinder().fullMatchBlocks();
                    lwc.getProtectionCache().addProtection(current);
                }
                return;
            }
        }
        if (!lwc.isProtectable(block)) {
            return;
        }
        String autoRegisterType = lwc.resolveProtectionConfiguration(block, "autoRegister");
        if (!lwc.hasPermission(player, "lwc.autoprotect") && !autoRegisterType.equalsIgnoreCase("private") && !autoRegisterType.equalsIgnoreCase("public") && !autoRegisterType.equalsIgnoreCase("donation") || autoRegisterType.equalsIgnoreCase("false")) {
            return;
        }
        if (!lwc.hasPermission((CommandSender)player, "lwc.create." + autoRegisterType, "lwc.create", "lwc.protect")) {
            return;
        }
        if (lwc.hasPermission(player, "lwc.autoprotect")) {
            autoRegisterType = "private";
        }
        try {
            type = Protection.Type.valueOf(autoRegisterType.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            return;
        }
        if (type == null) {
            player.sendMessage("\u00a74LWC_INVALID_CONFIG_autoRegister");
            return;
        }
        BlockState blockState = block.getState();
        Chest chestData = null;
        try {
            chestData = (Chest)blockState.getBlockData();
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        if (chestData != null && (neighboringChestBlockFace = DoubleChestMatcher.getNeighboringChestBlockFace(chestData)) != null) {
            Block neighboringBlock = block.getRelative(neighboringChestBlockFace);
            lwc.getProtectionCache().addProtection(current);
            if (neighboringBlock.getType() == blockState.getBlock().getType() && lwc.findProtection(neighboringBlock.getLocation()) != null) {
                return;
            }
        }
        try {
            LWCProtectionRegisterEvent evt = new LWCProtectionRegisterEvent(player, block);
            lwc.getModuleLoader().dispatchEvent(evt);
            if (evt.isCancelled()) {
                return;
            }
            BlockCache blockCache = BlockCache.getInstance();
            int blockId = blockCache.getBlockId(block);
            if (blockId < 0) {
                return;
            }
            Protection protection = lwc.getPhysicalDatabase().registerProtection(blockId, type, block.getWorld().getName(), player.getUniqueId().toString(), "", block.getX(), block.getY(), block.getZ());
            if (!Boolean.parseBoolean(lwc.resolveProtectionConfiguration(block, "quiet"))) {
                lwc.sendLocaleToActionBar((CommandSender)player, "protection.onplace.create.finalize", "type", lwc.getPlugin().getMessageParser().parseMessage(autoRegisterType.toLowerCase(), new Object[0]), "block", LWC.materialToString(block));
            }
            if (protection != null) {
                lwc.getModuleLoader().dispatchEvent(new LWCProtectionRegistrationPostEvent(protection));
            }
            protection.saveNow();
        }
        catch (Exception e) {
            lwc.sendLocale((CommandSender)player, "protection.internalerror", "id", "PLAYER_INTERACT");
            e.printStackTrace();
        }
    }

    public void loadAndProcessConfig() {
        List<String> blocks = LWC.getInstance().getConfiguration().getStringList("optional.blacklistedBlocks", new ArrayList<String>());
        for (String block : blocks) {
            int legacyId;
            try {
                legacyId = Integer.parseInt(block.trim().split(":")[0]);
            }
            catch (Exception e) {
                legacyId = -1;
            }
            Material material = MaterialUtil.getMaterialById(legacyId);
            if (material != null) {
                this.blacklistedBlocks.add(material);
                continue;
            }
            material = Material.matchMaterial((String)block.trim().toUpperCase());
            if (material == null) continue;
            this.blacklistedBlocks.add(material);
        }
    }

    private int hashCode(int int1, int int2) {
        int hash = int1 * 17;
        return hash *= 37 + int2;
    }
}

