/*
 * Decompiled with CFR 0.152.
 */
package com.griefcraft.io;

import com.griefcraft.io.Restorable;
import com.griefcraft.lwc.LWC;
import com.griefcraft.model.Protection;
import java.text.ParseException;
import java.text.SimpleDateFormat;

public class RestorableProtection
implements Restorable {
    private int id;
    private int protectionType;
    private int blockId;
    private String owner;
    private String world;
    private int x;
    private int y;
    private int z;
    private String data;
    private long created;
    private long updated;

    @Override
    public int getType() {
        return 0;
    }

    @Override
    public void restore() {
        LWC lwc = LWC.getInstance();
        Protection protection = lwc.getPhysicalDatabase().registerProtection(this.blockId, Protection.Type.values()[this.protectionType], this.world, this.owner, this.data, this.x, this.y, this.z);
    }

    public static RestorableProtection wrapProtection(Protection protection) {
        if (protection == null) {
            return null;
        }
        try {
            RestorableProtection rprotection = new RestorableProtection();
            rprotection.id = protection.getId();
            rprotection.protectionType = protection.getType().ordinal();
            rprotection.blockId = protection.getBlockId();
            rprotection.owner = protection.getOwner();
            rprotection.world = protection.getWorld();
            rprotection.x = protection.getX();
            rprotection.y = protection.getY();
            rprotection.z = protection.getZ();
            rprotection.data = protection.getData().toJSONString();
            rprotection.created = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(protection.getCreation()).getTime() / 1000L;
            rprotection.updated = protection.getLastAccessed();
            return rprotection;
        }
        catch (ParseException e) {
            System.out.println("Failed to wrap protection: " + protection + " " + e.getMessage());
            return null;
        }
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public int getProtectionType() {
        return this.protectionType;
    }

    public void setProtectionType(int protectionType) {
        this.protectionType = protectionType;
    }

    public int getBlockId() {
        return this.blockId;
    }

    public void setBlockId(int blockId) {
        this.blockId = blockId;
    }

    public String getOwner() {
        return this.owner;
    }

    public void setOwner(String owner) {
        this.owner = owner;
    }

    public String getWorld() {
        return this.world;
    }

    public void setWorld(String world) {
        this.world = world;
    }

    public int getX() {
        return this.x;
    }

    public void setX(int x) {
        this.x = x;
    }

    public int getY() {
        return this.y;
    }

    public void setY(int y) {
        this.y = y;
    }

    public int getZ() {
        return this.z;
    }

    public void setZ(int z) {
        this.z = z;
    }

    public String getData() {
        return this.data;
    }

    public void setData(String data) {
        this.data = data;
    }

    public long getCreated() {
        return this.created;
    }

    public void setCreated(long created) {
        this.created = created;
    }

    public long getUpdated() {
        return this.updated;
    }

    public void setUpdated(long updated) {
        this.updated = updated;
    }
}

