/*
 * Decompiled with CFR 0.152.
 */
package com.griefcraft.io;

import com.griefcraft.cache.BlockCache;
import com.griefcraft.io.Restorable;
import com.griefcraft.lwc.LWC;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.Server;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class RestorableBlock
implements Restorable {
    private int id;
    private String world;
    private int x;
    private int y;
    private int z;
    private int data;
    private final Map<Integer, ItemStack> items = new HashMap<Integer, ItemStack>();

    @Override
    public int getType() {
        return 1;
    }

    @Override
    public void restore() {
        final LWC lwc = LWC.getInstance();
        lwc.getPlugin().getServer().getScheduler().scheduleSyncDelayedTask((Plugin)lwc.getPlugin(), new Runnable(){

            @Override
            public void run() {
                Server server = Bukkit.getServer();
                World bworld = server.getWorld(RestorableBlock.this.world);
                if (RestorableBlock.this.world == null) {
                    return;
                }
                Block block = bworld.getBlockAt(RestorableBlock.this.x, RestorableBlock.this.y, RestorableBlock.this.z);
                BlockCache blockCache = BlockCache.getInstance();
                block.setType(blockCache.getBlockType(RestorableBlock.this.id));
                if (RestorableBlock.this.items.size() > 0) {
                    if (!(block.getState() instanceof InventoryHolder)) {
                        lwc.log(String.format("The block at [%d, %d, %d] has backed up items but no longer supports them. Why? %s", RestorableBlock.this.x, RestorableBlock.this.y, RestorableBlock.this.z, block.toString()));
                    }
                    Inventory inventory = ((InventoryHolder)block.getState()).getInventory();
                    for (Map.Entry entry : RestorableBlock.this.items.entrySet()) {
                        int slot = (Integer)entry.getKey();
                        ItemStack stack = (ItemStack)entry.getValue();
                        if (stack == null) continue;
                        inventory.setItem(slot, stack);
                    }
                }
            }
        });
    }

    public static RestorableBlock wrapBlock(Block block) {
        if (block == null) {
            return null;
        }
        BlockCache blockCache = BlockCache.getInstance();
        RestorableBlock rblock = new RestorableBlock();
        rblock.id = blockCache.getBlockId(block);
        rblock.world = block.getWorld().getName();
        rblock.x = block.getX();
        rblock.y = block.getY();
        rblock.z = block.getZ();
        rblock.data = block.getData();
        BlockState state = block.getState();
        if (state instanceof InventoryHolder) {
            Inventory inventory = ((InventoryHolder)state).getInventory();
            ItemStack[] stacks = inventory.getContents();
            for (int slot = 0; slot < stacks.length; ++slot) {
                ItemStack stack = stacks[slot];
                if (stack == null) continue;
                rblock.setSlot(slot, stack);
            }
        }
        return rblock;
    }

    public void setSlot(int slot, ItemStack stack) {
        this.items.put(slot, stack);
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public String getWorld() {
        return this.world;
    }

    public void setWorld(String world) {
        this.world = world;
    }

    public int getX() {
        return this.x;
    }

    public void setX(int x) {
        this.x = x;
    }

    public int getY() {
        return this.y;
    }

    public void setY(int y) {
        this.y = y;
    }

    public int getZ() {
        return this.z;
    }

    public void setZ(int z) {
        this.z = z;
    }

    public int getData() {
        return this.data;
    }

    public void setData(int data) {
        this.data = data;
    }

    public Map<Integer, ItemStack> getItems() {
        return this.items;
    }
}

