/*
 * Decompiled with CFR 0.152.
 */
package com.griefcraft.io;

import com.griefcraft.io.Backup;
import com.griefcraft.io.Restorable;
import com.griefcraft.io.RestorableBlock;
import com.griefcraft.io.RestorableProtection;
import com.griefcraft.lwc.LWC;
import com.griefcraft.lwc.LWCPlugin;
import com.griefcraft.model.Protection;
import com.griefcraft.sql.Database;
import com.griefcraft.sql.PhysDB;
import java.io.File;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.EnumSet;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import org.bukkit.Bukkit;
import org.bukkit.Server;
import org.bukkit.block.Block;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitScheduler;

public class BackupManager {
    public static String BACKUP_FOLDER = "plugins/LWC/backups/";
    private static String DATE_FORMAT = "MM-dd-yyyy-HHmm";
    private static String FILE_EXTENSION_COMPRESSED = ".lwc.gz";
    private static String FILE_EXTENSION_UNCOMPRESSED = ".lwc";
    private static int BATCH_SIZE = 250;
    private final File backupFolder = new File(BACKUP_FOLDER);

    public BackupManager() {
        if (!this.backupFolder.exists()) {
            this.backupFolder.mkdir();
        }
    }

    public Result restoreBackup(String name) {
        try {
            Backup backup = this.loadBackup(name);
            if (backup == null) {
                return Result.FAILURE;
            }
            return this.restoreBackup(backup);
        }
        catch (IOException e) {
            System.out.println("[BackupManager] Caught: " + e.getMessage());
            return Result.FAILURE;
        }
    }

    public Result restoreBackup(Backup backup) {
        try {
            Restorable restorable;
            backup.readHeader();
            int count = 0;
            int protectionCount = 0;
            int blockCount = 0;
            while ((restorable = backup.readRestorable()) != null) {
                restorable.restore();
                if (count % 2000 == 0) {
                    System.out.println("[Backup] Restored restorables: " + count);
                }
                ++count;
                if (restorable.getType() == 0) {
                    ++protectionCount;
                    continue;
                }
                if (restorable.getType() != 1) continue;
                ++blockCount;
            }
            System.out.println(String.format("[BackupManager] Restored %d restorables. %d were protections, %d blocks.", count, protectionCount, blockCount));
            return Result.OK;
        }
        catch (IOException e) {
            e.printStackTrace();
            return Result.FAILURE;
        }
    }

    public Backup loadBackup(String name) throws IOException {
        File file = new File(BACKUP_FOLDER, name + FILE_EXTENSION_COMPRESSED);
        if (file.exists()) {
            return new Backup(file, Backup.OperationMode.READ, EnumSet.of(Flag.COMPRESSION));
        }
        file = new File(BACKUP_FOLDER, name + FILE_EXTENSION_UNCOMPRESSED);
        if (file.exists()) {
            return new Backup(file, Backup.OperationMode.READ, EnumSet.noneOf(Flag.class));
        }
        return null;
    }

    public Backup createBackup(String name, EnumSet<Flag> flags) {
        final LWC lwc = LWC.getInstance();
        LWCPlugin plugin = lwc.getPlugin();
        Server server = Bukkit.getServer();
        final BukkitScheduler scheduler = server.getScheduler();
        String extension = flags.contains((Object)Flag.COMPRESSION) ? FILE_EXTENSION_COMPRESSED : FILE_EXTENSION_UNCOMPRESSED;
        File backupFile = new File(this.backupFolder, name + extension);
        try {
            final Backup backup = new Backup(backupFile, Backup.OperationMode.WRITE, flags);
            scheduler.scheduleAsyncDelayedTask((Plugin)plugin, new Runnable((Plugin)plugin, flags){
                final /* synthetic */ Plugin val$plugin;
                final /* synthetic */ EnumSet val$flags;
                {
                    this.val$plugin = plugin;
                    this.val$flags = enumSet;
                }

                @Override
                public void run() {
                    try {
                        lwc.log("Processing backup request now in a separate thread");
                        final ArrayList<Protection> protections = new ArrayList<Protection>(BATCH_SIZE);
                        int totalProtections = lwc.getPhysicalDatabase().getProtectionCount();
                        backup.writeHeader();
                        PhysDB database = new PhysDB();
                        database.connect();
                        database.load();
                        Statement resultStatement = database.getConnection().createStatement(1003, 1007);
                        if (lwc.getPhysicalDatabase().getType() == Database.Type.MySQL) {
                            resultStatement.setFetchSize(Integer.MIN_VALUE);
                        }
                        String prefix = lwc.getPhysicalDatabase().getPrefix();
                        ResultSet result = resultStatement.executeQuery("SELECT id, owner, type, x, y, z, data, blockId, world, password, date, last_accessed FROM " + prefix + "protections");
                        int count = 0;
                        while (result.next()) {
                            Protection tprotection = database.resolveProtection(result);
                            if (count % 2000 == 0) {
                                lwc.log("[Backup] Parsed protections: " + count + "/" + totalProtections);
                            }
                            ++count;
                            if (protections.size() != BATCH_SIZE) {
                                protections.add(tprotection);
                                if (protections.size() != totalProtections) continue;
                            }
                            Future getBlocks = scheduler.callSyncMethod(this.val$plugin, (Callable)new Callable<Void>(){

                                @Override
                                public Void call() throws Exception {
                                    for (Protection protection : protections) {
                                        protection.getBlock();
                                    }
                                    return null;
                                }
                            });
                            getBlocks.get();
                            for (Protection protection : protections) {
                                try {
                                    if (this.val$flags.contains((Object)Flag.BACKUP_BLOCKS)) {
                                        Block block = protection.getBlock();
                                        RestorableBlock rblock = RestorableBlock.wrapBlock(block);
                                        backup.writeRestorable(rblock);
                                    }
                                    if (!this.val$flags.contains((Object)Flag.BACKUP_PROTECTIONS)) continue;
                                    RestorableProtection rprotection = RestorableProtection.wrapProtection(protection);
                                    backup.writeRestorable(rprotection);
                                }
                                catch (Exception e) {
                                    lwc.log("Caught: " + e.getMessage() + ". Carrying on...");
                                }
                            }
                            protections.clear();
                        }
                        result.close();
                        resultStatement.close();
                        backup.close();
                        lwc.log("Backup completed!");
                    }
                    catch (Exception e) {
                        lwc.log("Backup exception caught: " + e.getMessage());
                    }
                }
            });
            return backup;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public Backup createBackup(EnumSet<Flag> flags) {
        return this.createBackup(new SimpleDateFormat(DATE_FORMAT).format(new Date()), flags);
    }

    public Backup createBackup() {
        return this.createBackup(EnumSet.of(Flag.COMPRESSION, Flag.BACKUP_BLOCKS, Flag.BACKUP_PROTECTIONS));
    }

    public static enum Flag {
        BACKUP_PROTECTIONS,
        BACKUP_BLOCKS,
        COMPRESSION;

    }

    public static enum Result {
        OK,
        FAILURE;

    }
}

