/*
 * Decompiled with CFR 0.152.
 */
package com.griefcraft.io;

import com.griefcraft.cache.BlockCache;
import com.griefcraft.io.BackupManager;
import com.griefcraft.io.Restorable;
import com.griefcraft.io.RestorableBlock;
import com.griefcraft.io.RestorableProtection;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.EnumSet;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.bukkit.inventory.ItemStack;

public class Backup {
    public static final int CURRENT_REVISION = 1;
    private final OperationMode operationMode;
    private int revision;
    private long created;
    private DataInputStream inputStream;
    private DataOutputStream outputStream;

    public Backup(File file, OperationMode operationMode, EnumSet<BackupManager.Flag> flags) throws IOException {
        this.operationMode = operationMode;
        if (!file.exists()) {
            if (operationMode == OperationMode.READ) {
                throw new UnsupportedOperationException("The backup could not be read");
            }
            file.createNewFile();
        }
        if (operationMode == OperationMode.WRITE) {
            this.revision = 1;
            this.created = System.currentTimeMillis() / 1000L;
        }
        boolean compression = flags.contains((Object)BackupManager.Flag.COMPRESSION);
        if (operationMode == OperationMode.READ) {
            FileInputStream fis = new FileInputStream(file);
            this.inputStream = new DataInputStream(compression ? new GZIPInputStream(fis) : fis);
        } else if (operationMode == OperationMode.WRITE) {
            FileOutputStream fos = new FileOutputStream(file);
            this.outputStream = new DataOutputStream(compression ? new GZIPOutputStream(fos) : fos);
        }
    }

    protected Restorable readRestorable() throws IOException {
        if (this.operationMode != OperationMode.READ) {
            throw new UnsupportedOperationException("READ is not allowed on this backup.");
        }
        byte type = (byte)this.inputStream.read();
        if (type == -1) {
            return null;
        }
        if (type == 0) {
            RestorableProtection rprotection = new RestorableProtection();
            rprotection.setId(this.inputStream.readInt());
            rprotection.setProtectionType(this.inputStream.readByte());
            rprotection.setBlockId(this.inputStream.readShort());
            rprotection.setOwner(this.inputStream.readUTF());
            rprotection.setWorld(this.inputStream.readUTF());
            rprotection.setX(this.inputStream.readInt());
            rprotection.setY(this.inputStream.readShort());
            rprotection.setZ(this.inputStream.readInt());
            rprotection.setData(this.inputStream.readUTF());
            rprotection.setCreated(this.inputStream.readLong());
            rprotection.setUpdated(this.inputStream.readLong());
            return rprotection;
        }
        if (type == 1) {
            RestorableBlock rblock = new RestorableBlock();
            rblock.setId(this.inputStream.readShort());
            rblock.setWorld(this.inputStream.readUTF());
            rblock.setX(this.inputStream.readInt());
            rblock.setY(this.inputStream.readShort());
            rblock.setZ(this.inputStream.readInt());
            rblock.setData(this.inputStream.read() & 0xFF);
            int itemCount = this.inputStream.readShort();
            for (int i = 0; i < itemCount; ++i) {
                short slot = this.inputStream.readShort();
                short itemId = this.inputStream.readShort();
                short amount = this.inputStream.readShort();
                short damage = this.inputStream.readShort();
                BlockCache blockCache = BlockCache.getInstance();
                ItemStack itemStack = new ItemStack(blockCache.getBlockType(itemId), (int)amount, damage);
                rblock.setSlot(slot, itemStack);
            }
            return rblock;
        }
        throw new UnsupportedOperationException("Read unknown type: " + type);
    }

    protected void writeRestorable(Restorable restorable) throws IOException {
        if (this.operationMode != OperationMode.WRITE) {
            throw new UnsupportedOperationException("WRITE is not allowed on this backup.");
        }
        this.outputStream.write((byte)restorable.getType());
        if (restorable.getType() == 0) {
            RestorableProtection rprotection = (RestorableProtection)restorable;
            this.outputStream.writeInt(rprotection.getId());
            this.outputStream.writeByte(rprotection.getType());
            this.outputStream.writeShort(rprotection.getBlockId());
            this.outputStream.writeUTF(rprotection.getOwner());
            this.outputStream.writeUTF(rprotection.getWorld());
            this.outputStream.writeInt(rprotection.getX());
            this.outputStream.writeShort(rprotection.getY());
            this.outputStream.writeInt(rprotection.getZ());
            this.outputStream.writeUTF(rprotection.getData());
            this.outputStream.writeLong(rprotection.getCreated());
            this.outputStream.writeLong(rprotection.getUpdated());
        } else if (restorable.getType() == 1) {
            RestorableBlock rblock = (RestorableBlock)restorable;
            this.outputStream.writeShort(rblock.getId());
            this.outputStream.writeUTF(rblock.getWorld());
            this.outputStream.writeInt(rblock.getX());
            this.outputStream.writeShort(rblock.getY());
            this.outputStream.writeInt(rblock.getZ());
            this.outputStream.write((byte)rblock.getData());
            this.outputStream.writeShort(rblock.getItems().size());
            for (Map.Entry<Integer, ItemStack> entry : rblock.getItems().entrySet()) {
                int slot = entry.getKey();
                ItemStack stack = entry.getValue();
                BlockCache blockCache = BlockCache.getInstance();
                this.outputStream.writeShort(slot);
                this.outputStream.writeShort(blockCache.getBlockId(stack.getType()));
                this.outputStream.writeShort(stack.getAmount());
                this.outputStream.writeShort(stack.getDurability());
            }
        }
        this.outputStream.flush();
    }

    protected void readHeader() throws IOException {
        this.revision = this.inputStream.readShort();
        this.created = this.inputStream.readLong();
        this.inputStream.read(new byte[10]);
    }

    protected void writeHeader() throws IOException {
        this.outputStream.writeShort(this.revision);
        this.outputStream.writeLong(this.created);
        this.outputStream.write(new byte[10]);
        this.outputStream.flush();
    }

    protected void close() throws IOException {
        if (this.operationMode == OperationMode.READ) {
            this.inputStream.close();
        } else if (this.operationMode == OperationMode.WRITE) {
            this.outputStream.close();
        }
    }

    public static enum OperationMode {
        READ,
        WRITE;

    }
}

