/*
 * Decompiled with CFR 0.152.
 */
package com.griefcraft.cache;

import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;

public class MethodCounter {
    private final Map<String, Integer> counts = new HashMap<String, Integer>();

    public void increment(String method) {
        this.deltaMethod(method, 1);
    }

    public void decrement(String method) {
        this.deltaMethod(method, -1);
    }

    public int get(String method) {
        return this.counts.containsKey(method) ? this.counts.get(method) : 0;
    }

    public Map<String, Integer> sortByValue() {
        return Collections.unmodifiableMap(MethodCounter.sortByComparator(this.counts, false));
    }

    private void deltaMethod(String method, int delta) {
        if (!this.counts.containsKey(method)) {
            this.counts.put(method, delta);
            return;
        }
        this.counts.put(method, this.counts.get(method) + delta);
    }

    private static Map<String, Integer> sortByComparator(Map<String, Integer> unsortMap, final boolean order) {
        LinkedList<Map.Entry<String, Integer>> list = new LinkedList<Map.Entry<String, Integer>>(unsortMap.entrySet());
        Collections.sort(list, new Comparator<Map.Entry<String, Integer>>(){

            @Override
            public int compare(Map.Entry<String, Integer> o1, Map.Entry<String, Integer> o2) {
                if (order) {
                    return o1.getValue().compareTo(o2.getValue());
                }
                return o2.getValue().compareTo(o1.getValue());
            }
        });
        LinkedHashMap<String, Integer> sortedMap = new LinkedHashMap<String, Integer>();
        for (Map.Entry entry : list) {
            sortedMap.put((String)entry.getKey(), (Integer)entry.getValue());
        }
        return sortedMap;
    }
}

