/*
 * Decompiled with CFR 0.152.
 */
package com.griefcraft.cache;

import com.griefcraft.lwc.LWC;
import com.griefcraft.sql.PhysDB;
import com.griefcraft.util.MaterialUtil;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.Material;
import org.bukkit.block.Block;

public class BlockCache {
    private static BlockCache blockCache = new BlockCache();
    private LWC lwc = LWC.getInstance();
    private Map<Integer, Material> intBlockCache = new HashMap<Integer, Material>();
    private Map<Material, Integer> materialBlockCache = new HashMap<Material, Integer>();
    private int nextId = 1;

    private BlockCache() {
    }

    public static BlockCache getInstance() {
        return blockCache;
    }

    public static void destruct() {
        blockCache = null;
    }

    private void addMapping(Integer integer, Material material) {
        this.intBlockCache.put(integer, material);
        this.materialBlockCache.put(material, integer);
    }

    private void removeMapping(Integer integer, Material material) {
        this.intBlockCache.remove(integer);
        this.materialBlockCache.remove(material);
    }

    public void loadBlocks() {
        PhysDB database = this.lwc.getPhysicalDatabase();
        String prefix = database.getPrefix();
        try {
            PreparedStatement statement = database.prepare("SELECT id, name FROM " + prefix + "blocks");
            ResultSet set = statement.executeQuery();
            while (set.next()) {
                Integer materialId = set.getInt("id");
                String materialName = set.getString("name");
                Material material = Material.matchMaterial((String)materialName);
                if (material != null) {
                    this.addMapping(materialId, material);
                    if (materialId < this.nextId) continue;
                    this.nextId = materialId + 1;
                    continue;
                }
                this.lwc.log("Unable to load " + materialName + "from " + prefix + "blocks!");
            }
        }
        catch (SQLException e) {
            this.lwc.log("Unable to load " + prefix + "blocks!");
            e.printStackTrace();
        }
    }

    public int addBlock(Material blockMaterial) {
        if (this.materialBlockCache.containsKey(blockMaterial)) {
            return this.materialBlockCache.get(blockMaterial);
        }
        PhysDB database = this.lwc.getPhysicalDatabase();
        String prefix = database.getPrefix();
        try {
            PreparedStatement statement = database.prepare("INSERT INTO " + prefix + "blocks (id, name) VALUES(?, ?)");
            statement.setInt(1, this.nextId);
            statement.setString(2, blockMaterial.name());
            statement.executeUpdate();
            int newId = this.nextId++;
            this.addMapping(newId, blockMaterial);
            return newId;
        }
        catch (SQLException e) {
            this.lwc.log("Unable to add new block to " + prefix + "blocks!");
            e.printStackTrace();
            return -1;
        }
    }

    public int addBlock(String block) {
        Material material = Material.matchMaterial((String)block);
        if (material != null) {
            return this.addBlock(material);
        }
        return -1;
    }

    public int addBlock(Block block) {
        return this.addBlock(block.getType());
    }

    public int addBlock(int blockId) {
        return this.addBlock(MaterialUtil.getMaterialById(blockId));
    }

    public void removeBlock(Material blockMaterial) {
        if (this.materialBlockCache.containsKey(blockMaterial)) {
            this.removeBlock(this.materialBlockCache.get(blockMaterial));
        }
    }

    public void removeBlock(String block) {
        Material material = Material.matchMaterial((String)block);
        if (material != null) {
            this.removeBlock(material);
        }
    }

    public void removeBlock(Block block) {
        this.removeBlock(block.getType());
    }

    public void removeBlock(int blockId) {
        if (!this.intBlockCache.containsKey(blockId)) {
            return;
        }
        PhysDB database = this.lwc.getPhysicalDatabase();
        String prefix = database.getPrefix();
        try {
            PreparedStatement statement = database.prepare("DELETE FROM " + prefix + "blocks WHERE id = ?");
            statement.setInt(1, blockId);
            statement.executeUpdate();
            this.removeMapping(blockId, this.intBlockCache.get(blockId));
        }
        catch (SQLException e) {
            this.lwc.log("Unable to remove block from " + prefix + "blocks!");
            e.printStackTrace();
        }
    }

    public int getBlockId(Material blockMaterial) {
        Integer id = this.materialBlockCache.get(blockMaterial);
        if (id != null) {
            return id;
        }
        return this.addBlock(blockMaterial);
    }

    public int getBlockId(String blockName) {
        Material material = Material.matchMaterial((String)blockName);
        if (material != null) {
            return this.getBlockId(material);
        }
        return this.addBlock(blockName);
    }

    public int getBlockId(Block block) {
        return this.getBlockId(block.getType());
    }

    public int getBlockId(int blockId) {
        if (this.intBlockCache.containsKey(blockId)) {
            return blockId;
        }
        return this.addBlock(blockId);
    }

    public Material getBlockType(Material blockMaterial) {
        if (this.materialBlockCache.containsKey(blockMaterial)) {
            return blockMaterial;
        }
        int id = this.addBlock(blockMaterial);
        if (this.intBlockCache.containsKey(id)) {
            return this.intBlockCache.get(id);
        }
        return null;
    }

    public Material getBlockType(String blockName) {
        Material material = Material.matchMaterial((String)blockName);
        if (material != null) {
            return this.getBlockType(material);
        }
        return null;
    }

    public Material getBlockType(Block block) {
        return this.getBlockType(block.getType());
    }

    public Material getBlockType(int blockId) {
        int id;
        if (this.intBlockCache.containsKey(blockId)) {
            return this.intBlockCache.get(blockId);
        }
        Material material = MaterialUtil.getMaterialById(blockId);
        if (material != null && this.intBlockCache.containsKey(id = this.addBlock(material))) {
            return this.intBlockCache.get(id);
        }
        return null;
    }

    public static enum Constants {
        AIR(0),
        ENTITY(1);

        private int id;

        private Constants(int id) {
            this.id = id;
        }

        public int getValue() {
            return this.id;
        }
    }
}

