/*
 * Decompiled with CFR 0.152.
 */
package me.zombie_striker.pluginconstructor;

import com.google.gson.Gson;
import com.google.gson.JsonParseException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.EnumSet;
import java.util.Enumeration;
import java.util.List;
import java.util.logging.Level;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import org.bukkit.Bukkit;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class Updater {
    private static final Gson GSON = new Gson();
    private static final String HOST = "https://api.curseforge.com";
    private static final String QUERY = "/servermods/files?projectIds=";
    private static final String AGENT = "Mozilla/5.0 Updater by ArsenArsen";
    private static final File WORKING_DIR = new File("plugins" + File.separator + "AUpdater" + File.separator);
    private static final File BACKUP_DIR = new File(WORKING_DIR, "backups" + File.separator);
    private static final File LOG_FILE = new File(WORKING_DIR, "updater.log");
    private static final File CONFIG_FILE = new File(WORKING_DIR, "global.yml");
    private static final char[] HEX_CHAR_ARRAY = "0123456789abcdef".toCharArray();
    private static final Pattern NAME_MATCH = Pattern.compile(".+\\sv?[0-9.]+");
    private static final String VERSION_SPLIT = "\\sv?";
    private int id = -1;
    private Plugin p;
    private boolean debug = false;
    private UpdateAvailability lastCheck = null;
    private UpdateResult lastUpdate = UpdateResult.NOT_UPDATED;
    private File pluginFile = null;
    private String downloadURL = null;
    private String futuremd5;
    private String downloadName;
    private EnumSet<Channel> allowedChannels = EnumSet.allOf(Channel.class);
    private List<UpdateCallback> callbacks = new ArrayList<UpdateCallback>();
    private SyncCallbackCaller caller = new SyncCallbackCaller();
    private List<String> skipTags = new ArrayList<String>();
    private String latest;
    private FileConfiguration global;

    public Updater(Plugin p) {
        this.p = p;
        try {
            this.pluginFile = new File(URLDecoder.decode(p.getClass().getProtectionDomain().getCodeSource().getLocation().getPath(), "UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("You don't have a good text codec on your system", e);
        }
        this.latest = p.getDescription().getVersion();
        if (!CONFIG_FILE.exists()) {
            try {
                CONFIG_FILE.getParentFile().mkdirs();
                CONFIG_FILE.createNewFile();
                this.log("Created config file!");
            }
            catch (IOException e) {
                p.getLogger().log(Level.SEVERE, "Could not create " + CONFIG_FILE.getName() + "!", e);
            }
        }
        this.global = YamlConfiguration.loadConfiguration((File)CONFIG_FILE);
        this.global.options().header("Updater by ArsenArsen\nGlobal config\nSets should updates be downloaded globally");
        if (!this.global.isSet("update")) {
            this.global.set("update", (Object)true);
            try {
                this.global.save(CONFIG_FILE);
            }
            catch (IOException e) {
                p.getLogger().log(Level.SEVERE, "Could not save default config file!", e);
            }
        }
        if (!LOG_FILE.exists()) {
            try {
                LOG_FILE.getParentFile().mkdirs();
                LOG_FILE.createNewFile();
                this.log("Created log file!");
            }
            catch (IOException e) {
                p.getLogger().log(Level.SEVERE, "Could not create " + LOG_FILE.getName() + "!", e);
            }
        }
    }

    public Updater(Plugin p, int id) {
        this(p);
        this.setID(id);
    }

    public Updater(Plugin p, int id, boolean download, String ... skipTags) {
        this(p);
        this.setID(id);
        String[] stringArray = skipTags;
        int n = skipTags.length;
        int n2 = 0;
        while (n2 < n) {
            String tag = stringArray[n2];
            if (tag.startsWith("-")) {
                this.skipTags.add(tag);
            }
            ++n2;
        }
        if (download && this.checkForUpdates() == UpdateAvailability.UPDATE_AVAILABLE) {
            this.update();
        }
    }

    public Updater(Plugin p, int id, boolean download, String[] skipTags, UpdateCallback ... callbacks) {
        this(p);
        this.setID(id);
        this.callbacks.addAll(Arrays.asList(callbacks));
        if (skipTags != null) {
            String[] stringArray = skipTags;
            int n = skipTags.length;
            int n2 = 0;
            while (n2 < n) {
                String tag = stringArray[n2];
                if (tag.startsWith("-")) {
                    this.skipTags.add(tag);
                }
                ++n2;
            }
        }
        if (this.global.getBoolean("update", true) && download && this.checkForUpdates() == UpdateAvailability.UPDATE_AVAILABLE) {
            this.update();
        }
    }

    public int getID() {
        return this.id;
    }

    public void setID(int id) {
        this.id = id;
    }

    public void registerCallback(UpdateCallback callback) {
        this.callbacks.add(callback);
    }

    public void update() {
        this.debug(WORKING_DIR.getAbsolutePath());
        this.debug("Update!");
        if (this.id == -1) {
            throw new IllegalStateException("Plugin ID is not set!");
        }
        if (this.lastCheck == null) {
            this.checkForUpdates();
        }
        if (!BACKUP_DIR.exists() || !BACKUP_DIR.isDirectory()) {
            BACKUP_DIR.mkdir();
        }
        Updater updater = this;
        if (!this.global.getBoolean("update", true)) {
            this.lastUpdate = UpdateResult.DISABLED;
            this.debug("Disabled!");
            this.caller.call(this.callbacks, UpdateResult.DISABLED, updater);
            return;
        }
        if (this.lastCheck == UpdateAvailability.UPDATE_AVAILABLE) {
            new BukkitRunnable(){

                public void run() {
                    Updater.this.debug("Update STARTED!");
                    Updater.this.p.getLogger().info("Starting update of " + Updater.this.p.getName());
                    Updater.this.log("Updating " + Updater.this.p.getName() + "!");
                    Updater.this.lastUpdate = Updater.this.download();
                    Updater.this.p.getLogger().log(Level.INFO, "Update done! Result: " + (Object)((Object)Updater.this.lastUpdate));
                    Updater.this.caller.call(Updater.this.callbacks, Updater.this.lastUpdate, updater);
                }
            }.runTaskAsynchronously(this.p);
        } else if (this.lastCheck == UpdateAvailability.SM_UNREACHABLE) {
            this.lastUpdate = UpdateResult.IOERROR;
            this.debug("Fail!");
            this.caller.call(this.callbacks, UpdateResult.IOERROR, updater);
        } else {
            this.lastUpdate = UpdateResult.GENERAL_ERROR;
            this.debug("Fail!");
            this.caller.call(this.callbacks, UpdateResult.IOERROR, updater);
        }
    }

    private UpdateResult download() {
        try {
            Files.copy(this.pluginFile.toPath(), new File(BACKUP_DIR, "backup-" + System.currentTimeMillis() + "-" + this.p.getName() + ".jar").toPath(), StandardCopyOption.REPLACE_EXISTING);
            File downloadTo = new File(String.valueOf(this.pluginFile.getParentFile().getAbsolutePath()) + File.separator + "AUpdater" + File.separator, this.downloadName);
            downloadTo.getParentFile().mkdirs();
            downloadTo.delete();
            this.debug("Started download!");
            this.downloadIsSeperateBecauseGotoGotRemoved(downloadTo);
            this.debug("Ended download!");
            if (!this.fileHash(downloadTo).equalsIgnoreCase(this.futuremd5)) {
                return UpdateResult.BAD_HASH;
            }
            if (downloadTo.getName().endsWith(".jar")) {
                this.pluginFile.setWritable(true, false);
                this.pluginFile.delete();
                this.debug("Started copy!");
                FileInputStream in = new FileInputStream(downloadTo);
                File file = new File(this.pluginFile.getParentFile().getAbsoluteFile() + File.separator + "update" + File.separator, this.pluginFile.getName());
                file.getParentFile().mkdirs();
                file.createNewFile();
                FileOutputStream out = new FileOutputStream(file);
                long bytes = this.copy(in, out);
                this.p.getLogger().info("Update done! Downloaded " + bytes + " bytes!");
                this.log("Updated plugin " + this.p.getName() + " with " + bytes + "bytes!");
                return UpdateResult.UPDATE_SUCCEEDED;
            }
            return this.unzip(downloadTo);
        }
        catch (IOException e) {
            this.p.getLogger().log(Level.SEVERE, "Couldn't download update for " + this.p.getName(), e);
            this.log("Failed to update " + this.p.getName() + "!", e);
            return UpdateResult.IOERROR;
        }
    }

    private void downloadIsSeperateBecauseGotoGotRemoved(File downloadTo) throws IOException {
        URL url = new URL(this.downloadURL);
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.addRequestProperty("User-Agent", AGENT);
        connection.connect();
        if (connection.getResponseCode() >= 300 && connection.getResponseCode() < 400) {
            this.downloadURL = connection.getHeaderField("Location");
            this.downloadIsSeperateBecauseGotoGotRemoved(downloadTo);
        } else {
            this.debug(String.valueOf(connection.getResponseCode()) + " " + connection.getResponseMessage() + " when requesting " + this.downloadURL);
            this.copy(connection.getInputStream(), new FileOutputStream(downloadTo));
        }
    }

    private long copy(InputStream in, OutputStream out) throws IOException {
        int r;
        long bytes = 0L;
        byte[] buf = new byte[4096];
        while ((r = in.read(buf)) != -1) {
            out.write(buf, 0, r);
            bytes += (long)r;
            this.debug("Another 4K, current: " + r);
        }
        out.flush();
        out.close();
        in.close();
        return bytes;
    }

    private UpdateResult unzip(File download) {
        ZipFile zipFile = null;
        try {
            ZipEntry entry;
            zipFile = new ZipFile(download);
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            File updateFile = new File(this.pluginFile.getParentFile().getAbsoluteFile() + File.separator + "update" + File.separator, this.pluginFile.getName());
            while ((entry = entries.nextElement()) != null) {
                File target = new File(updateFile, entry.getName());
                File inPlugins = new File(this.pluginFile.getParentFile(), entry.getName());
                if (!inPlugins.exists()) {
                    target = inPlugins;
                }
                if (entry.isDirectory()) continue;
                target.getParentFile().mkdirs();
                InputStream zipStream = zipFile.getInputStream(entry);
                FileOutputStream fileStream = new FileOutputStream(target);
                this.copy(zipStream, fileStream);
            }
            UpdateResult updateResult = UpdateResult.UPDATE_SUCCEEDED;
            return updateResult;
        }
        catch (IOException e) {
            if (e instanceof ZipException) {
                this.p.getLogger().log(Level.SEVERE, "Could not unzip downloaded file!", e);
                this.log("Update for " + this.p.getName() + "was an unknown filetype! ", e);
                UpdateResult updateResult = UpdateResult.UNKNOWN_FILE_TYPE;
                return updateResult;
            }
            this.p.getLogger().log(Level.SEVERE, "An IOException occured while trying to update %s!".replace("%s", this.p.getName()), e);
            this.log("Update for " + this.p.getName() + "was an unknown filetype! ", e);
            UpdateResult updateResult = UpdateResult.IOERROR;
            return updateResult;
        }
        finally {
            if (zipFile != null) {
                try {
                    zipFile.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public UpdateAvailability checkForUpdates(boolean force) {
        if (this.id == -1) {
            throw new IllegalStateException("Plugin ID is not set!");
        }
        if (force || this.lastCheck == null) {
            String target = "https://api.curseforge.com/servermods/files?projectIds=" + this.id;
            this.debug(target);
            try {
                URL url = new URL(target);
                HttpURLConnection connection = (HttpURLConnection)url.openConnection();
                connection.addRequestProperty("User-Agent", AGENT);
                connection.connect();
                this.debug("Connecting!");
                int counter = 1;
                if (connection.getResponseCode() == 200) {
                    try {
                        this.debug("RESCODE 200");
                        this.debug("Counter: " + counter);
                        UpdateStructure[] json = (UpdateStructure[])GSON.fromJson((Reader)new InputStreamReader(connection.getInputStream()), UpdateStructure[].class);
                        while (true) {
                            if (json.length - counter < 0) {
                                this.lastCheck = UpdateAvailability.NO_UPDATE;
                                this.debug("No update!");
                                break;
                            }
                            UpdateStructure latest = json[json.length - counter];
                            this.futuremd5 = latest.md5;
                            String channel = latest.releaseType;
                            String name = latest.name;
                            if (this.allowedChannels.contains((Object)Channel.matchChannel(channel)) && !this.hasTag(name)) {
                                String noTagName = name;
                                StringBuilder oldVersion = new StringBuilder(this.p.getDescription().getVersion().replaceAll("-.*", ""));
                                for (String tag : this.skipTags) {
                                    noTagName = noTagName.replace(tag, "");
                                    oldVersion = new StringBuilder(oldVersion.toString().replace(tag, ""));
                                }
                                if (!NAME_MATCH.matcher(noTagName).matches()) {
                                    this.lastCheck = UpdateAvailability.CANT_PARSE_NAME;
                                    return this.lastCheck;
                                }
                                String[] splitName = noTagName.split(VERSION_SPLIT);
                                StringBuilder version = new StringBuilder(splitName[splitName.length - 1]);
                                while (oldVersion.length() != version.length()) {
                                    if (oldVersion.length() > version.length()) {
                                        version.append(version.length() % 2 == 0 ? ".0" : ".00");
                                        continue;
                                    }
                                    if (oldVersion.length() >= version.length()) continue;
                                    oldVersion.append(oldVersion.length() % 2 == 0 ? ".0" : ".00");
                                }
                                this.debug("Versions are same length");
                                String[] splitOldVersion = oldVersion.toString().split("\\.");
                                String[] splitVersion = version.toString().split("\\.");
                                int[] parsedOldVersion = new int[splitOldVersion.length];
                                int[] parsedVersion = new int[splitVersion.length];
                                int i = 0;
                                while (i < parsedOldVersion.length) {
                                    parsedOldVersion[i] = Integer.parseInt(splitOldVersion[i]);
                                    ++i;
                                }
                                i = 0;
                                while (i < parsedVersion.length) {
                                    parsedVersion[i] = Integer.parseInt(splitVersion[i]);
                                    ++i;
                                }
                                boolean update = false;
                                int i2 = 0;
                                while (i2 < parsedOldVersion.length) {
                                    if (parsedOldVersion[i2] < parsedVersion[i2]) {
                                        update = true;
                                        break;
                                    }
                                    ++i2;
                                }
                                if (!update) {
                                    ++counter;
                                    continue;
                                }
                                this.lastCheck = UpdateAvailability.UPDATE_AVAILABLE;
                                this.downloadURL = latest.downloadUrl.replace(" ", "%20");
                                this.downloadName = latest.fileName;
                                break;
                            }
                            ++counter;
                        }
                        this.debug("While loop over!");
                    }
                    catch (JsonParseException e) {
                        this.p.getLogger().log(Level.SEVERE, "Could not parse API Response for " + target, e);
                        this.log("Could not parse API Response for " + target + " while updating " + this.p.getName(), (Exception)((Object)e));
                        this.lastCheck = UpdateAvailability.CANT_UNDERSTAND;
                    }
                } else {
                    this.log("Could not reach API for " + target + " while updating " + this.p.getName());
                    this.lastCheck = UpdateAvailability.SM_UNREACHABLE;
                }
                connection.disconnect();
            }
            catch (IOException e) {
                this.p.getLogger().log(Level.SEVERE, "Could not check for updates for plugin " + this.p.getName(), e);
                this.log("Could not reach API for " + target + " while updating " + this.p.getName(), e);
                this.lastCheck = UpdateAvailability.SM_UNREACHABLE;
            }
        }
        this.log("Update check ran for " + this.p.getName() + "! Check resulted in " + (Object)((Object)this.lastCheck));
        return this.lastCheck;
    }

    private void debug(String message) {
        if (this.debug) {
            this.p.getLogger().info(String.valueOf(message) + ' ' + new Throwable().getStackTrace()[1]);
        }
    }

    private void log(String message) {
        try {
            Files.write(LOG_FILE.toPath(), Collections.singletonList("[" + new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()) + "] " + message), StandardCharsets.UTF_8, StandardOpenOption.APPEND);
        }
        catch (IOException e) {
            this.p.getLogger().log(Level.SEVERE, "Could not log to " + LOG_FILE.getAbsolutePath() + "!", e);
        }
    }

    private void log(String message, Exception exception) {
        StringWriter string = new StringWriter();
        PrintWriter print = new PrintWriter(string);
        exception.printStackTrace(print);
        this.log(String.valueOf(message) + " " + string.toString());
        try {
            string.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        print.close();
    }

    private boolean hasTag(String name) {
        for (String tag : this.skipTags) {
            if (!name.toLowerCase().endsWith(tag.toLowerCase())) continue;
            return true;
        }
        return false;
    }

    public UpdateAvailability checkForUpdates() {
        return this.checkForUpdates(false);
    }

    public UpdateResult isUpdated() {
        return this.lastUpdate;
    }

    public void setChannels(Channel ... channels) {
        this.allowedChannels.clear();
        this.allowedChannels.addAll(Arrays.asList(channels));
    }

    public String getLatest() {
        return this.latest;
    }

    public String fileHash(File file) {
        try {
            int numBytes;
            FileInputStream is = new FileInputStream(file);
            MessageDigest md = MessageDigest.getInstance("MD5");
            byte[] bytes = new byte[2048];
            while ((numBytes = is.read(bytes)) != -1) {
                md.update(bytes, 0, numBytes);
            }
            byte[] digest = md.digest();
            char[] hexChars = new char[digest.length * 2];
            int j = 0;
            while (j < digest.length) {
                int v = digest[j] & 0xFF;
                hexChars[j * 2] = HEX_CHAR_ARRAY[v >>> 4];
                hexChars[j * 2 + 1] = HEX_CHAR_ARRAY[v & 0xF];
                ++j;
            }
            is.close();
            return new String(hexChars);
        }
        catch (IOException | NoSuchAlgorithmException e) {
            this.p.getLogger().log(Level.SEVERE, "Could not digest " + file.getPath(), e);
            return null;
        }
    }

    public static enum Channel {
        RELEASE("release"),
        BETA("beta"),
        ALPHA("alpha");

        private String channel;

        private Channel(String channel) {
            this.channel = channel;
        }

        public String getChannel() {
            return this.channel;
        }

        public static Channel matchChannel(String channel) {
            Channel[] channelArray = Channel.values();
            int n = channelArray.length;
            int n2 = 0;
            while (n2 < n) {
                Channel c = channelArray[n2];
                if (c.channel.equalsIgnoreCase(channel)) {
                    return c;
                }
                ++n2;
            }
            return null;
        }
    }

    private class SyncCallbackCaller
    extends BukkitRunnable {
        private List<UpdateCallback> callbacks;
        private UpdateResult updateResult;
        private Updater updater;

        private SyncCallbackCaller() {
        }

        public void run() {
            for (UpdateCallback callback : this.callbacks) {
                callback.updated(this.updateResult, this.updater);
            }
        }

        void call(List<UpdateCallback> callbacks, UpdateResult updateResult, Updater updater) {
            this.callbacks = callbacks;
            this.updateResult = updateResult;
            this.updater = updater;
            if (!Bukkit.getServer().isPrimaryThread()) {
                this.runTask(updater.p);
            } else {
                this.run();
            }
        }
    }

    public static enum UpdateAvailability {
        UPDATE_AVAILABLE,
        NO_UPDATE,
        SM_UNREACHABLE,
        CANT_PARSE_NAME,
        CANT_UNDERSTAND;

    }

    public static interface UpdateCallback {
        public void updated(UpdateResult var1, Updater var2);
    }

    public static enum UpdateResult {
        UPDATE_SUCCEEDED,
        NOT_UPDATED,
        UNKNOWN_FILE_TYPE,
        GENERAL_ERROR,
        DISABLED,
        BAD_HASH,
        IOERROR;

    }

    private class UpdateStructure {
        public String downloadUrl;
        public String fileName;
        public String md5;
        public String name;
        public String releaseType;

        private UpdateStructure() {
        }
    }
}

