/*
 * Decompiled with CFR 0.152.
 */
package me.zombie_striker.pluginconstructor;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import me.zombie_striker.pluginconstructor.MojangAPIUtil;
import me.zombie_striker.pluginconstructor.PlayerList;
import me.zombie_striker.pluginconstructor.SkinCallBack;
import org.apache.commons.lang.Validate;
import org.bukkit.configuration.serialization.ConfigurationSerializable;
import org.bukkit.scheduler.BukkitRunnable;

class Skin
implements ConfigurationSerializable {
    public static Object SKIN_CACHE;
    static Map<UUID, String> callbacksUUID;
    static Map<String, List<SkinCallBack>> callbacks;
    public static final Skin EMPTY_SKIN;
    private UUID uuid;
    private String base64;
    private String signedBase64;

    static {
        try {
            SKIN_CACHE = CacheBuilder.newBuilder().expireAfterWrite(5L, TimeUnit.MINUTES).build((CacheLoader)new CacheLoader<UUID, Skin>(){

                public Skin load(UUID uuid) throws Exception {
                    MojangAPIUtil.Result<MojangAPIUtil.SkinData> result = MojangAPIUtil.getSkinData(uuid);
                    if (result.wasSuccessful()) {
                        if (result.getValue() != null) {
                            MojangAPIUtil.SkinData data = result.getValue();
                            if (data.getSkinURL() == null && data.getCapeURL() == null) {
                                return EMPTY_SKIN;
                            }
                            return new Skin(data.getUUID(), data.getBase64(), data.getSignedBase64());
                        }
                    } else {
                        throw result.getException();
                    }
                    return EMPTY_SKIN;
                }
            });
        }
        catch (Error | Exception throwable) {
            // empty catch block
        }
        callbacksUUID = new HashMap<UUID, String>();
        callbacks = new HashMap<String, List<SkinCallBack>>();
        EMPTY_SKIN = new Skin();
    }

    public static void getSkin(String username, SkinCallBack callBack) {
        boolean newcall = false;
        if (!callbacks.containsKey(username)) {
            callbacks.put(username, new ArrayList());
            newcall = true;
        }
        callbacks.get(username).add(callBack);
        if (newcall) {
            new BukkitRunnable(){
                String u;
                {
                    this.u = string;
                }

                public void run() {
                    final MojangAPIUtil.Result<Map<String, MojangAPIUtil.Profile>> result = MojangAPIUtil.getUUID(Collections.singletonList(username));
                    if (result.wasSuccessful()) {
                        if (result.getValue() == null || result.getValue().isEmpty()) {
                            new BukkitRunnable(){

                                public void run() {
                                    List<SkinCallBack> calls = callbacks.get(u);
                                    callbacks.remove(u);
                                    for (SkinCallBack s : calls) {
                                        s.callBack(EMPTY_SKIN, true, null);
                                    }
                                }
                            }.runTask(PlayerList.plugin);
                            return;
                        }
                        for (Map.Entry<String, MojangAPIUtil.Profile> entry : result.getValue().entrySet()) {
                            if (!entry.getKey().equalsIgnoreCase(username)) continue;
                            callbacksUUID.put(entry.getValue().getUUID(), this.u);
                            Skin.getSkin(entry.getValue().getUUID(), callBack);
                            return;
                        }
                    } else {
                        new BukkitRunnable(){

                            public void run() {
                                List<SkinCallBack> calls = callbacks.get(u);
                                callbacks.remove(u);
                                for (SkinCallBack s : calls) {
                                    s.callBack(null, false, result.getException());
                                }
                            }
                        }.runTask(PlayerList.plugin);
                    }
                }
            }.runTaskAsynchronously(PlayerList.plugin);
        }
    }

    public static void getSkin(UUID uuid, SkinCallBack callBack) {
        ConcurrentMap asMap = null;
        try {
            asMap = ((Cache)SKIN_CACHE).asMap();
        }
        catch (Error | Exception e4) {
            callBack.callBack(EMPTY_SKIN, true, null);
            return;
        }
        if (asMap.containsKey(uuid)) {
            for (SkinCallBack s : callbacks.get(callbacksUUID.get(uuid))) {
                s.callBack((Skin)asMap.get(uuid), true, null);
            }
        } else {
            new BukkitRunnable(){

                public void run() {
                    try {
                        final Skin skin = (Skin)((LoadingCache)SKIN_CACHE).get((Object)uuid);
                        new BukkitRunnable(){

                            public void run() {
                                for (SkinCallBack s : callbacks.get(callbacksUUID.get(uuid))) {
                                    s.callBack(skin, true, null);
                                }
                            }
                        }.runTask(PlayerList.plugin);
                    }
                    catch (Exception e) {
                        new BukkitRunnable(){

                            public void run() {
                                for (SkinCallBack s : callbacks.get(callbacksUUID.get(uuid))) {
                                    s.callBack(null, false, e);
                                }
                            }
                        }.runTask(PlayerList.plugin);
                    }
                }
            }.runTaskAsynchronously(PlayerList.plugin);
        }
    }

    public Skin(UUID uuid, String base64, String signedBase64) {
        Validate.notNull((Object)uuid, (String)"uuid cannot be null");
        Validate.notNull((Object)base64, (String)"base64 cannot be null");
        this.uuid = uuid;
        this.base64 = base64;
        this.signedBase64 = signedBase64;
    }

    private Skin() {
    }

    public boolean hasSignedBase64() {
        return this.signedBase64 != null;
    }

    public String getSignedBase64() {
        return this.signedBase64;
    }

    public String getBase64() {
        return this.base64;
    }

    public UUID getUUID() {
        return this.uuid;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Skin)) {
            return false;
        }
        Skin skin = (Skin)obj;
        if (skin == EMPTY_SKIN) {
            return this == EMPTY_SKIN;
        }
        return skin.base64.equals(this.base64) && skin.uuid.equals(this.uuid) && skin.signedBase64.equals(this.signedBase64);
    }

    public int hashCode() {
        return Objects.hash(this.base64, this.uuid, this.signedBase64);
    }

    public String toString() {
        return "Skin{uuid=" + this.uuid + ",base64=" + this.base64 + ",signedBase64=" + this.signedBase64 + "}";
    }

    public Map<String, Object> serialize() {
        HashMap map = Maps.newHashMap();
        if (this == EMPTY_SKIN) {
            map.put("empty", "true");
        } else {
            map.put("uuid", this.uuid);
            map.put("base64", this.base64);
            if (this.hasSignedBase64()) {
                map.put("signedBase64", this.signedBase64);
            }
        }
        return map;
    }

    public static Skin deserialize(Map<String, Object> map) {
        if (map.containsKey("empty")) {
            return EMPTY_SKIN;
        }
        return new Skin(UUID.fromString((String)map.get("uuid")), (String)map.get("base64"), map.containsKey("signedBase64") ? (String)map.get("signedBase64") : null);
    }
}

