/*
 * Decompiled with CFR 0.152.
 */
package me.zombie_striker.pluginconstructor;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Optional;
import me.zombie_striker.pluginconstructor.PlayerList;
import org.bukkit.Bukkit;

class ReflectionUtil {
    protected static final String SERVER_VERSION;

    static {
        String name = Bukkit.getServer().getClass().getName();
        name = name.substring(name.indexOf("craftbukkit.") + "craftbukkit.".length());
        SERVER_VERSION = name = name.substring(0, name.indexOf("."));
    }

    ReflectionUtil() {
    }

    protected static boolean isVersionHigherThan(int mainVersion, int secondVersion) {
        int sInt;
        String firstChar = SERVER_VERSION.substring(1, 2);
        int fInt = Integer.parseInt(firstChar);
        if (fInt < mainVersion) {
            return false;
        }
        StringBuilder secondChar = new StringBuilder();
        int i = 3;
        while (i < 10) {
            if (SERVER_VERSION.charAt(i) == '_' || SERVER_VERSION.charAt(i) == '.') break;
            secondChar.append(SERVER_VERSION.charAt(i));
            ++i;
        }
        return (sInt = Integer.parseInt(secondChar.toString())) >= secondVersion;
    }

    protected static Class<?> getNMSClass(String name) {
        try {
            return Class.forName("net.minecraft.server." + SERVER_VERSION + "." + name);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    protected static Class<?> getOLDAuthlibClass(String name) {
        try {
            return Class.forName("net.minecraft.util.com.mojang.authlib." + name);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    protected static Class<?> getCraftbukkitClass(String name, String packageName) {
        try {
            return Class.forName("org.bukkit.craftbukkit." + SERVER_VERSION + "." + packageName + "." + name);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    protected static Class<?> getMojangAuthClass(String name) {
        try {
            if (PlayerList.a(new Integer[0])) {
                return Class.forName("com.mojang.authlib." + name);
            }
            return Class.forName("net.minecraft.util.com.mojang.authlib." + name);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    protected static Object invokeMethod(Object handle, String methodName, Class[] parameterClasses, Object ... args) {
        return ReflectionUtil.invokeMethod(handle.getClass(), handle, methodName, parameterClasses, args);
    }

    protected static Object invokeMethod(Class<?> clazz, Object handle, String methodName, Class[] parameterClasses, Object ... args) {
        Optional<Method> methodOptional = ReflectionUtil.getMethod(clazz, methodName, parameterClasses);
        if (!methodOptional.isPresent()) {
            return null;
        }
        Method method = methodOptional.get();
        try {
            return method.invoke(handle, args);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            e.printStackTrace();
            return null;
        }
    }

    protected static void setInstanceField(Object handle, String name, Object value) {
        Class<?> clazz = handle.getClass();
        Optional<Field> fieldOptional = ReflectionUtil.getField(clazz, name);
        if (!fieldOptional.isPresent()) {
            return;
        }
        Field field = fieldOptional.get();
        if (!field.isAccessible()) {
            field.setAccessible(true);
        }
        try {
            field.set(handle, value);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
    }

    protected static Object getInstanceField(Object handle, String name) {
        Class<?> clazz = handle.getClass();
        Optional<Field> fieldOptional = ReflectionUtil.getField(clazz, name);
        if (!fieldOptional.isPresent()) {
            return handle;
        }
        Field field = fieldOptional.get();
        if (!field.isAccessible()) {
            field.setAccessible(true);
        }
        try {
            return field.get(handle);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            return null;
        }
    }

    protected static Object getEnumConstant(Class<?> enumClass, String name) {
        if (!enumClass.isEnum()) {
            return null;
        }
        ?[] objArray = enumClass.getEnumConstants();
        int n = objArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object o = objArray[n2];
            if (name.equals(ReflectionUtil.invokeMethod(o, "name", new Class[0], new Object[0]))) {
                return o;
            }
            ++n2;
        }
        return null;
    }

    protected static Optional<?> getConstructor(Class<?> clazz, Class<?> ... params) {
        try {
            return Optional.of(clazz.getConstructor(params));
        }
        catch (NoSuchMethodException e) {
            try {
                return Optional.of(clazz.getDeclaredConstructor(params));
            }
            catch (NoSuchMethodException e2) {
                e2.printStackTrace();
                return Optional.empty();
            }
        }
    }

    protected static Object instantiate(Constructor<?> constructor, Object ... arguments) {
        try {
            return constructor.newInstance(arguments);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    protected static Optional<Method> getMethod(Class<?> clazz, String name, Class<?> ... params) {
        try {
            return Optional.of(clazz.getMethod(name, params));
        }
        catch (NoSuchMethodException e) {
            try {
                return Optional.of(clazz.getDeclaredMethod(name, params));
            }
            catch (NoSuchMethodException e2) {
                e2.printStackTrace();
                return Optional.empty();
            }
        }
    }

    protected static Optional<Field> getField(Class<?> clazz, String name) {
        try {
            return Optional.of(clazz.getField(name));
        }
        catch (NoSuchFieldException e) {
            try {
                return Optional.of(clazz.getDeclaredField(name));
            }
            catch (NoSuchFieldException noSuchFieldException) {
                return Optional.empty();
            }
        }
    }
}

