/*
 * Decompiled with CFR 0.152.
 */
package me.zombie_striker.pluginconstructor;

import com.google.common.base.Strings;
import com.google.common.collect.Maps;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.commons.lang.Validate;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitTask;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;

class MojangAPIUtil {
    private static URL API_STATUS_URL = null;
    private static URL GET_UUID_URL = null;
    private static final JSONParser PARSER = new JSONParser();
    private static Plugin plugin;

    static {
        Plugin[] pluginArray = Bukkit.getPluginManager().getPlugins();
        int n = pluginArray.length;
        int n2 = 0;
        while (n2 < n) {
            Plugin plugin = pluginArray[n2];
            if (plugin.getClass().getProtectionDomain().getCodeSource().equals(MojangAPIUtil.class.getProtectionDomain().getCodeSource())) {
                MojangAPIUtil.plugin = plugin;
            }
            ++n2;
        }
        try {
            API_STATUS_URL = new URL("https://status.mojang.com/check");
            GET_UUID_URL = new URL("https://api.mojang.com/profiles/minecraft");
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
    }

    MojangAPIUtil() {
    }

    public static void setPlugin(Plugin plugin) {
        MojangAPIUtil.plugin = plugin;
    }

    public static void getAPIStatusWithCallBack(ResultCallBack<Map<String, APIStatus>> callBack) {
        MojangAPIUtil.getAPIStatusAsyncWithCallBack((successful, result, exception) -> {
            BukkitTask bukkitTask = new BukkitRunnable((Map)result, exception){
                private final /* synthetic */ Map val$result;
                private final /* synthetic */ Exception val$exception;
                {
                    this.val$result = map;
                    this.val$exception = exception;
                }

                public void run() {
                    callBack.callBack(successful, this.val$result, this.val$exception);
                }
            }.runTask(plugin);
        });
    }

    public static void getAPIStatusAsyncWithCallBack(ResultCallBack<Map<String, APIStatus>> callBack) {
        if (plugin == null) {
            return;
        }
        MojangAPIUtil.makeAsyncGetRequest(API_STATUS_URL, (successful, response, exception, responseCode) -> {
            if (callBack == null) {
                return;
            }
            if (successful && responseCode == 200) {
                try {
                    HashMap map = Maps.newHashMap();
                    JSONArray jsonArray = (JSONArray)PARSER.parse(response);
                    for (JSONObject jsonObject : jsonArray) {
                        for (Map.Entry entry : jsonObject.entrySet()) {
                            map.put((String)entry.getKey(), APIStatus.fromString((String)entry.getValue()));
                        }
                    }
                    callBack.callBack(true, map, null);
                }
                catch (Exception e) {
                    callBack.callBack(false, null, e);
                }
            } else if (exception != null) {
                callBack.callBack(false, null, exception);
            } else {
                callBack.callBack(false, null, new IOException("Failed to obtain Mojang data! Response code: " + responseCode));
            }
        });
    }

    public static void getUUIDAtTimeWithCallBack(String username, long timeStamp, ResultCallBack<UUIDAtTime> callBack) {
        MojangAPIUtil.getUUIDAtTimeAsyncWithCallBack(username, timeStamp, (successful, result, exception) -> {
            BukkitTask bukkitTask = new BukkitRunnable((UUIDAtTime)result, exception){
                private final /* synthetic */ UUIDAtTime val$result;
                private final /* synthetic */ Exception val$exception;
                {
                    this.val$result = uUIDAtTime;
                    this.val$exception = exception;
                }

                public void run() {
                    callBack.callBack(successful, this.val$result, this.val$exception);
                }
            }.runTask(plugin);
        });
    }

    public static void getUUIDAtTimeAsyncWithCallBack(String username, long timeStamp, ResultCallBack<UUIDAtTime> callBack) {
        if (plugin == null) {
            return;
        }
        Validate.notNull((Object)username);
        Validate.isTrue((!username.isEmpty() ? 1 : 0) != 0, (String)"username cannot be empty");
        try {
            URL url = new URL("https://api.mojang.com/users/profiles/minecraft/" + username + (timeStamp != -1L ? "?at=" + timeStamp : ""));
            MojangAPIUtil.makeAsyncGetRequest(url, (successful, response, exception, responseCode) -> {
                if (callBack == null) {
                    return;
                }
                if (successful && (responseCode == 200 || responseCode == 204)) {
                    try {
                        UUIDAtTime[] uuidAtTime = new UUIDAtTime[1];
                        if (responseCode == 200) {
                            JSONObject object = (JSONObject)PARSER.parse(response);
                            String uuidString = (String)object.get((Object)"id");
                            uuidAtTime[0] = new UUIDAtTime((String)object.get((Object)"name"), MojangAPIUtil.getUUIDFromString(uuidString));
                        }
                        callBack.callBack(true, uuidAtTime[0], null);
                    }
                    catch (Exception e) {
                        callBack.callBack(false, null, e);
                    }
                } else if (exception != null) {
                    callBack.callBack(false, null, exception);
                } else {
                    callBack.callBack(false, null, new IOException("Failed to obtain Mojang data! Response code: " + responseCode));
                }
            });
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
    }

    public static void getNameHistoryWithCallBack(UUID uuid, ResultCallBack<Map<String, Long>> callBack) {
        MojangAPIUtil.getNameHistoryAsyncWithCallBack(uuid, (successful, result, exception) -> {
            BukkitTask bukkitTask = new BukkitRunnable((Map)result, exception){
                private final /* synthetic */ Map val$result;
                private final /* synthetic */ Exception val$exception;
                {
                    this.val$result = map;
                    this.val$exception = exception;
                }

                public void run() {
                    callBack.callBack(successful, this.val$result, this.val$exception);
                }
            }.runTask(plugin);
        });
    }

    public static void getNameHistoryAsyncWithCallBack(UUID uuid, ResultCallBack<Map<String, Long>> callBack) {
        if (plugin == null) {
            return;
        }
        Validate.notNull((Object)uuid, (String)"uuid cannot be null!");
        try {
            URL url = new URL("https://api.mojang.com/user/profiles/" + uuid.toString().replace("-", "") + "/names");
            MojangAPIUtil.makeAsyncGetRequest(url, (successful, response, exception, responseCode) -> {
                if (callBack == null) {
                    return;
                }
                if (successful && (responseCode == 200 || responseCode == 204)) {
                    try {
                        HashMap map = Maps.newHashMap();
                        if (responseCode == 200) {
                            JSONArray jsonArray = (JSONArray)PARSER.parse(response);
                            for (JSONObject jsonObject : jsonArray) {
                                String name = (String)jsonObject.get((Object)"name");
                                if (jsonObject.containsKey((Object)"changedToAt")) {
                                    map.put(name, (Long)jsonObject.get((Object)"changedToAt"));
                                    continue;
                                }
                                map.put(name, -1L);
                            }
                        }
                        callBack.callBack(true, map, null);
                    }
                    catch (Exception e) {
                        callBack.callBack(false, null, e);
                    }
                } else if (exception != null) {
                    callBack.callBack(false, null, exception);
                } else {
                    callBack.callBack(false, null, new IOException("Failed to obtain Mojang data! Response code: " + responseCode));
                }
            });
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
    }

    public static void getUUIDWithCallBack(ResultCallBack<Map<String, Profile>> callBack, String ... usernames) {
        MojangAPIUtil.getUUIDWithCallBack(Arrays.asList(usernames), callBack);
    }

    public static void getUUIDWithCallBack(List<String> usernames, ResultCallBack<Map<String, Profile>> callBack) {
        MojangAPIUtil.getUUIDAsyncWithCallBack(usernames, (boolean successful, Map<String, Profile> result, Exception exception) -> {
            BukkitTask bukkitTask = new BukkitRunnable((Map)result, exception){
                private final /* synthetic */ Map val$result;
                private final /* synthetic */ Exception val$exception;
                {
                    this.val$result = map;
                    this.val$exception = exception;
                }

                public void run() {
                    callBack.callBack(successful, this.val$result, this.val$exception);
                }
            }.runTask(plugin);
        });
    }

    public static void getUUIDAsyncWithCallBack(ResultCallBack<Map<String, Profile>> callBack, String ... usernames) {
        MojangAPIUtil.getUUIDAsyncWithCallBack(Arrays.asList(usernames), callBack);
    }

    public static Result<Map<String, Profile>> getUUID(List<String> usernames) {
        if (plugin == null) {
            return new Result<Object>(null, false, new RuntimeException("No plugin instance found!"));
        }
        Validate.notNull(usernames, (String)"usernames cannot be null");
        Validate.isTrue((usernames.size() <= 100 ? 1 : 0) != 0, (String)"cannot request more than 100 usernames at once");
        JSONArray usernameJson = new JSONArray();
        usernameJson.addAll((Collection)usernames.stream().filter(s -> !Strings.isNullOrEmpty((String)s)).collect(Collectors.toList()));
        RequestResult result = MojangAPIUtil.makeSyncPostRequest(GET_UUID_URL, usernameJson.toJSONString());
        if (result == null) {
            return new Result<Object>(null, false, new RuntimeException("No plugin instance found!"));
        }
        try {
            if (result.successful && result.responseCode == 200) {
                HashMap map = Maps.newHashMap();
                JSONArray jsonArray = (JSONArray)PARSER.parse(result.response);
                for (JSONObject jsonObject : jsonArray) {
                    String uuidString = (String)jsonObject.get((Object)"id");
                    String name = (String)jsonObject.get((Object)"name");
                    boolean legacy = false;
                    if (jsonObject.containsKey((Object)"legacy")) {
                        legacy = (Boolean)jsonObject.get((Object)"legacy");
                    }
                    boolean unpaid = false;
                    if (jsonObject.containsKey((Object)"demo")) {
                        unpaid = (Boolean)jsonObject.get((Object)"demo");
                    }
                    map.put(name, new Profile(MojangAPIUtil.getUUIDFromString(uuidString), name, legacy, unpaid));
                }
                return new Result<Map<String, Profile>>(map, true, null);
            }
            if (result.exception != null) {
                return new Result<Object>(null, false, result.exception);
            }
            return new Result<Object>(null, false, new IOException("Failed to obtain Mojang data! Response code: " + result.responseCode));
        }
        catch (Exception e) {
            return new Result<Object>(null, false, e);
        }
    }

    public static void getUUIDAsyncWithCallBack(List<String> usernames, ResultCallBack<Map<String, Profile>> callBack) {
        if (plugin == null) {
            return;
        }
        Validate.notNull(usernames, (String)"usernames cannot be null");
        Validate.isTrue((usernames.size() <= 100 ? 1 : 0) != 0, (String)"cannot request more than 100 usernames at once");
        JSONArray usernameJson = new JSONArray();
        usernameJson.addAll((Collection)usernames.stream().filter(s -> !Strings.isNullOrEmpty((String)s)).collect(Collectors.toList()));
        MojangAPIUtil.makeAsyncPostRequest(GET_UUID_URL, usernameJson.toJSONString(), (successful, response, exception, responseCode) -> {
            if (callBack == null) {
                return;
            }
            try {
                if (successful && responseCode == 200) {
                    HashMap map = Maps.newHashMap();
                    JSONArray jsonArray = (JSONArray)PARSER.parse(response);
                    for (JSONObject jsonObject : jsonArray) {
                        String uuidString = (String)jsonObject.get((Object)"id");
                        String name = (String)jsonObject.get((Object)"name");
                        boolean legacy = false;
                        if (jsonObject.containsKey((Object)"legacy")) {
                            legacy = (Boolean)jsonObject.get((Object)"legacy");
                        }
                        boolean unpaid = false;
                        if (jsonObject.containsKey((Object)"demo")) {
                            unpaid = (Boolean)jsonObject.get((Object)"demo");
                        }
                        map.put(name, new Profile(MojangAPIUtil.getUUIDFromString(uuidString), name, legacy, unpaid));
                    }
                    callBack.callBack(true, map, null);
                } else if (exception != null) {
                    callBack.callBack(false, null, exception);
                } else {
                    callBack.callBack(false, null, new IOException("Failed to obtain Mojang data! Response code: " + responseCode));
                }
            }
            catch (Exception e) {
                callBack.callBack(false, null, e);
            }
        });
    }

    public static Result<SkinData> getSkinData(UUID uuid) {
        URL url;
        if (plugin == null) {
            return new Result<Object>(null, false, new RuntimeException("No plugin instance found!"));
        }
        try {
            url = new URL("https://sessionserver.mojang.com/session/minecraft/profile/" + uuid.toString().replace("-", "") + "?unsigned=false");
        }
        catch (MalformedURLException e) {
            return new Result<Object>(null, false, e);
        }
        RequestResult result = MojangAPIUtil.makeSyncGetRequest(url);
        if (result == null) {
            return new Result<Object>(null, false, new RuntimeException("No plugin instance found!"));
        }
        try {
            if (result.successful && (result.responseCode == 200 || result.responseCode == 204)) {
                if (result.responseCode == 204) {
                    return new Result<Object>(null, true, null);
                }
                JSONObject object = (JSONObject)PARSER.parse(result.response);
                JSONArray propertiesArray = (JSONArray)object.get((Object)"properties");
                String base64 = null;
                String signedBase64 = null;
                for (JSONObject property : propertiesArray) {
                    String name = (String)property.get((Object)"name");
                    if (!name.equals("textures")) continue;
                    base64 = (String)property.get((Object)"value");
                    signedBase64 = (String)property.get((Object)"signature");
                }
                if (base64 == null) {
                    return new Result<Object>(null, true, null);
                }
                String decodedBase64 = new String(Base64.getDecoder().decode(base64), "UTF-8");
                JSONObject base64json = (JSONObject)PARSER.parse(decodedBase64);
                long timeStamp = (Long)base64json.get((Object)"timestamp");
                String profileName = (String)base64json.get((Object)"profileName");
                UUID profileId = MojangAPIUtil.getUUIDFromString((String)base64json.get((Object)"profileId"));
                JSONObject textures = (JSONObject)base64json.get((Object)"textures");
                String skinURL = null;
                String capeURL = null;
                if (textures.containsKey((Object)"SKIN")) {
                    JSONObject skinObject = (JSONObject)textures.get((Object)"SKIN");
                    skinURL = (String)skinObject.get((Object)"url");
                }
                if (textures.containsKey((Object)"CAPE")) {
                    JSONObject capeObject = (JSONObject)textures.get((Object)"CAPE");
                    capeURL = (String)capeObject.get((Object)"url");
                }
                return new Result<SkinData>(new SkinData(profileId, profileName, skinURL, capeURL, timeStamp, base64, signedBase64), true, null);
            }
            if (result.exception != null) {
                return new Result<Object>(null, false, result.exception);
            }
            return new Result<Object>(null, false, new IOException("Failed to obtain Mojang data! Response code: " + result.responseCode));
        }
        catch (Exception e) {
            return new Result<Object>(null, false, e);
        }
    }

    public static void getSkinData(UUID uuid, ResultCallBack<SkinData> callBack) {
        MojangAPIUtil.getSkinDataAsync(uuid, (successful, result, exception) -> {
            BukkitTask bukkitTask = new BukkitRunnable((SkinData)result, exception){
                private final /* synthetic */ SkinData val$result;
                private final /* synthetic */ Exception val$exception;
                {
                    this.val$result = skinData;
                    this.val$exception = exception;
                }

                public void run() {
                    callBack.callBack(successful, this.val$result, this.val$exception);
                }
            }.runTask(plugin);
        });
    }

    public static void getSkinDataAsync(UUID uuid, ResultCallBack<SkinData> callBack) {
        URL url;
        if (plugin == null) {
            return;
        }
        try {
            url = new URL("https://sessionserver.mojang.com/session/minecraft/profile/" + uuid.toString().replace("-", "") + "?unsigned=false");
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
            return;
        }
        MojangAPIUtil.makeAsyncGetRequest(url, (successful, response, exception, responseCode) -> {
            try {
                if (successful && (responseCode == 200 || responseCode == 204)) {
                    if (responseCode == 204) {
                        callBack.callBack(true, null, null);
                        return;
                    }
                    JSONObject object = (JSONObject)PARSER.parse(response);
                    JSONArray propertiesArray = (JSONArray)object.get((Object)"properties");
                    String base64 = null;
                    String signedBase64 = null;
                    for (JSONObject property : propertiesArray) {
                        String name = (String)property.get((Object)"name");
                        if (!name.equals("textures")) continue;
                        base64 = (String)property.get((Object)"value");
                        signedBase64 = (String)property.get((Object)"signature");
                    }
                    if (base64 == null) {
                        callBack.callBack(true, null, null);
                        return;
                    }
                    String decodedBase64 = new String(Base64.getDecoder().decode(base64), "UTF-8");
                    JSONObject base64json = (JSONObject)PARSER.parse(decodedBase64);
                    long timeStamp = (Long)base64json.get((Object)"timestamp");
                    String profileName = (String)base64json.get((Object)"profileName");
                    UUID profileId = MojangAPIUtil.getUUIDFromString((String)base64json.get((Object)"profileId"));
                    JSONObject textures = (JSONObject)base64json.get((Object)"textures");
                    String skinURL = null;
                    String capeURL = null;
                    if (textures.containsKey((Object)"SKIN")) {
                        JSONObject skinObject = (JSONObject)textures.get((Object)"SKIN");
                        skinURL = (String)skinObject.get((Object)"url");
                    }
                    if (textures.containsKey((Object)"CAPE")) {
                        JSONObject capeObject = (JSONObject)textures.get((Object)"CAPE");
                        capeURL = (String)capeObject.get((Object)"url");
                    }
                    callBack.callBack(true, new SkinData(profileId, profileName, skinURL, capeURL, timeStamp, base64, signedBase64), null);
                } else if (exception != null) {
                    callBack.callBack(false, null, exception);
                } else {
                    callBack.callBack(false, null, new IOException("Failed to obtain Mojang data! Response code: " + responseCode));
                }
            }
            catch (Exception e) {
                callBack.callBack(false, null, e);
            }
        });
    }

    private static RequestResult makeSyncGetRequest(URL url) {
        if (plugin == null) {
            return null;
        }
        StringBuilder response = new StringBuilder();
        try {
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.connect();
            Throwable throwable = null;
            Object var4_7 = null;
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getInputStream()));){
                String line = reader.readLine();
                while (line != null) {
                    response.append(line);
                    line = reader.readLine();
                }
                RequestResult result = new RequestResult();
                result.successful = true;
                result.responseCode = connection.getResponseCode();
                result.response = response.toString();
                return result;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            RequestResult result = new RequestResult();
            result.exception = e;
            result.successful = false;
            return result;
        }
    }

    private static void makeAsyncGetRequest(URL url, RequestCallBack asyncCallBack) {
        if (plugin == null) {
            return;
        }
        new BukkitRunnable(){

            public void run() {
                StringBuilder response = new StringBuilder();
                try {
                    HttpURLConnection connection = (HttpURLConnection)url.openConnection();
                    connection.connect();
                    Throwable throwable = null;
                    Object var4_6 = null;
                    try (BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getInputStream()));){
                        String line = reader.readLine();
                        while (line != null) {
                            response.append(line);
                            line = reader.readLine();
                        }
                        asyncCallBack.callBack(true, response.toString(), null, connection.getResponseCode());
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (Exception e) {
                    asyncCallBack.callBack(false, response.toString(), e, -1);
                }
            }
        }.runTaskAsynchronously(plugin);
    }

    private static RequestResult makeSyncPostRequest(URL url, String payload) {
        if (plugin == null) {
            return null;
        }
        StringBuilder response = new StringBuilder();
        try {
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setDoOutput(true);
            connection.setRequestMethod("POST");
            connection.setRequestProperty("Content-Type", "application/json");
            connection.connect();
            Throwable throwable = null;
            Object var5_9 = null;
            try (PrintWriter writer = new PrintWriter(connection.getOutputStream());){
                writer.write(payload);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            throwable = null;
            var5_9 = null;
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getInputStream()));){
                String line = reader.readLine();
                while (line != null) {
                    response.append(line);
                    line = reader.readLine();
                }
                RequestResult result = new RequestResult();
                result.successful = true;
                result.responseCode = connection.getResponseCode();
                result.response = response.toString();
                return result;
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                } else if (throwable != throwable3) {
                    throwable.addSuppressed(throwable3);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            RequestResult result = new RequestResult();
            result.successful = false;
            result.exception = e;
            return result;
        }
    }

    private static void makeAsyncPostRequest(URL url, String payload, RequestCallBack asyncCallBack) {
        if (plugin == null) {
            return;
        }
        new BukkitRunnable(){

            public void run() {
                StringBuilder response = new StringBuilder();
                try {
                    HttpURLConnection connection = (HttpURLConnection)url.openConnection();
                    connection.setDoOutput(true);
                    connection.setRequestMethod("POST");
                    connection.setRequestProperty("Content-Type", "application/json");
                    connection.connect();
                    Throwable throwable = null;
                    Object var4_7 = null;
                    try (PrintWriter writer = new PrintWriter(connection.getOutputStream());){
                        writer.write(payload);
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                    throwable = null;
                    var4_7 = null;
                    try (BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getInputStream()));){
                        String line = reader.readLine();
                        while (line != null) {
                            response.append(line);
                            line = reader.readLine();
                        }
                        asyncCallBack.callBack(true, response.toString(), null, connection.getResponseCode());
                    }
                    catch (Throwable throwable3) {
                        if (throwable == null) {
                            throwable = throwable3;
                        } else if (throwable != throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        throw throwable;
                    }
                }
                catch (Exception e) {
                    asyncCallBack.callBack(false, response.toString(), e, -1);
                }
            }
        }.runTaskAsynchronously(plugin);
    }

    public static UUID getUUIDFromString(String string) {
        String uuidString = String.valueOf(string.substring(0, 8)) + "-" + string.substring(8, 12) + "-" + string.substring(12, 16) + "-" + string.substring(16, 20) + "-" + string.substring(20);
        return UUID.fromString(uuidString);
    }

    public static enum APIStatus {
        RED,
        YELLOW,
        GREEN;


        public static APIStatus fromString(String string) {
            switch (string) {
                case "red": {
                    return RED;
                }
                case "yellow": {
                    return YELLOW;
                }
                case "green": {
                    return GREEN;
                }
            }
            throw new IllegalArgumentException("Unknown status: " + string);
        }
    }

    public static class Profile {
        private UUID uuid;
        private String name;
        private boolean legacy;
        private boolean unpaid;

        Profile(UUID uuid, String name, boolean legacy, boolean unpaid) {
            this.uuid = uuid;
            this.name = name;
            this.legacy = legacy;
            this.unpaid = unpaid;
        }

        public UUID getUUID() {
            return this.uuid;
        }

        public String getName() {
            return this.name;
        }

        public boolean isLegacy() {
            return this.legacy;
        }

        public boolean isUnpaid() {
            return this.unpaid;
        }

        public String toString() {
            return "Profile{uuid=" + this.uuid + ", name=" + this.name + ", legacy=" + this.legacy + ", unpaid=" + this.unpaid + "}";
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof Profile)) {
                return false;
            }
            Profile otherProfile = (Profile)obj;
            return this.uuid.equals(otherProfile.uuid) && this.name.equals(otherProfile.name) && this.legacy == otherProfile.legacy && this.unpaid == otherProfile.unpaid;
        }

        public int hashCode() {
            return Objects.hash(this.uuid, this.name, this.legacy, this.unpaid);
        }
    }

    @FunctionalInterface
    private static interface RequestCallBack {
        public void callBack(boolean var1, String var2, Exception var3, int var4);
    }

    private static class RequestResult {
        boolean successful;
        String response;
        Exception exception;
        int responseCode;

        private RequestResult() {
        }
    }

    public static class Result<T> {
        private T value;
        private boolean successful;
        private Exception exception;

        public Result(T value, boolean successful, Exception exception) {
            this.value = value;
            this.successful = successful;
            this.exception = exception;
        }

        public T getValue() {
            return this.value;
        }

        public boolean wasSuccessful() {
            return this.successful;
        }

        public Exception getException() {
            return this.exception;
        }
    }

    @FunctionalInterface
    public static interface ResultCallBack<T> {
        public void callBack(boolean var1, T var2, Exception var3);
    }

    public static class SkinData {
        private UUID uuid;
        private String name;
        private String skinURL;
        private String capeURL;
        private long timeStamp;
        private String base64;
        private String signedBase64;

        public SkinData(UUID uuid, String name, String skinURL, String capeURL, long timeStamp, String base64, String signedBase64) {
            this.uuid = uuid;
            this.name = name;
            this.skinURL = skinURL;
            this.capeURL = capeURL;
            this.timeStamp = timeStamp;
            this.base64 = base64;
            this.signedBase64 = signedBase64;
        }

        public UUID getUUID() {
            return this.uuid;
        }

        public String getName() {
            return this.name;
        }

        public boolean hasSkinURL() {
            return this.skinURL != null;
        }

        public String getSkinURL() {
            return this.skinURL;
        }

        public boolean hasCapeURL() {
            return this.capeURL != null;
        }

        public String getCapeURL() {
            return this.capeURL;
        }

        public long getTimeStamp() {
            return this.timeStamp;
        }

        public String getBase64() {
            return this.base64;
        }

        public boolean hasSignedBase64() {
            return this.signedBase64 != null;
        }

        public String getSignedBase64() {
            return this.signedBase64;
        }

        public String toString() {
            return "SkinData{uuid=" + this.uuid + ",name=" + this.name + ",skinURL=" + this.skinURL + ",capeURL=" + this.capeURL + ",timeStamp=" + this.timeStamp + ",base64=" + this.base64 + ",signedBase64=" + this.signedBase64 + "}";
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof SkinData)) {
                return false;
            }
            SkinData skinData = (SkinData)obj;
            return this.uuid.equals(skinData.uuid) && this.name.equals(skinData.name) && (this.skinURL == null ? skinData.skinURL == null : this.skinURL.equals(skinData.skinURL)) && (this.capeURL == null ? skinData.capeURL == null : this.capeURL.equals(skinData.skinURL)) && this.timeStamp == skinData.timeStamp && this.base64.equals(skinData.base64) && (this.signedBase64 == null ? skinData.signedBase64 == null : this.signedBase64.equals(skinData.signedBase64));
        }

        public int hashCode() {
            return Objects.hash(this.uuid, this.name, this.skinURL, this.capeURL, this.timeStamp, this.base64, this.signedBase64);
        }
    }

    public static class UUIDAtTime {
        private String name;
        private UUID uuid;

        public UUIDAtTime(String name, UUID uuid) {
            this.name = name;
            this.uuid = uuid;
        }

        public String getName() {
            return this.name;
        }

        public UUID getUUID() {
            return this.uuid;
        }

        public String toString() {
            return "UUIDAtTime{name=" + this.name + ",uuid=" + this.uuid + "}";
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof UUIDAtTime)) {
                return false;
            }
            UUIDAtTime uuidAtTime = (UUIDAtTime)obj;
            return this.name.equals(uuidAtTime.name) && this.uuid.equals(uuidAtTime.uuid);
        }

        public int hashCode() {
            return Objects.hash(this.name, this.uuid);
        }
    }
}

