/*
 * Decompiled with CFR 0.152.
 */
package me.zombie_striker.pluginconstructor;

import java.util.HashMap;
import java.util.Map;
import me.zombie_striker.pluginconstructor.RGBBlockColor;
import org.bukkit.Material;
import org.bukkit.block.BlockFace;
import org.bukkit.configuration.serialization.ConfigurationSerializable;
import org.bukkit.configuration.serialization.ConfigurationSerialization;

public class MaterialData
implements ConfigurationSerializable {
    private Material m;
    private byte data;
    private BlockFace direction = null;

    public boolean hasDirection() {
        return this.direction != null;
    }

    public BlockFace getDirection() {
        return this.direction;
    }

    public MaterialData(Material m, byte data, BlockFace direction) {
        ConfigurationSerialization.registerClass(MaterialData.class);
        this.setMaterial(m);
        this.data = data;
        this.direction = direction;
    }

    public MaterialData(Material m, byte data) {
        this(m, data, null);
    }

    public MaterialData(Material m) {
        this(m, 0, null);
    }

    public static MaterialData getMatDataByTypes(Material mat, byte data) {
        for (MaterialData key : RGBBlockColor.materialValue.keySet()) {
            if (key.getData() != data || key.getMaterial() != mat) continue;
            return key;
        }
        return null;
    }

    public byte getData() {
        return this.data;
    }

    public Material getMaterial() {
        return this.m;
    }

    public MaterialData(Map<String, Object> data) {
        this.setMaterial(Material.valueOf((String)((String)data.get("m"))));
        this.data = Byte.parseByte((String)data.get("data"));
    }

    public Map<String, Object> serialize() {
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("m", this.getMaterial().toString());
        data.put("data", String.valueOf(this.data));
        return data;
    }

    public void setMaterial(Material m) {
        this.m = m;
    }
}

