/*
 * Decompiled with CFR 0.152.
 */
package me.zombie_striker.pluginconstructor;

import java.awt.image.BufferedImage;
import me.zombie_striker.pluginconstructor.CustomImageRenderer;
import me.zombie_striker.pluginconstructor.Direction;
import me.zombie_striker.pluginconstructor.PluginConstructorAPI;
import me.zombie_striker.pluginconstructor.ReflectionUtil;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.ItemFrame;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.MapMeta;
import org.bukkit.map.MapRenderer;
import org.bukkit.map.MapView;

public class MapWallUtil {
    public static ItemStack getMap(BufferedImage BUFFEREDIMAGE) {
        MapView mv = Bukkit.createMap((World)((World)Bukkit.getWorlds().get(0)));
        int mapIds = mv.getId();
        Material map = Material.MAP;
        if (ReflectionUtil.isVersionHigherThan(1, 13)) {
            map = Material.FILLED_MAP;
        }
        ItemStack is = new ItemStack(map, 1, (short)mapIds);
        for (MapRenderer mr : mv.getRenderers()) {
            mv.removeRenderer(mr);
        }
        mv.addRenderer((MapRenderer)new CustomImageRenderer(BUFFEREDIMAGE, CustomImageRenderer.TICK_FOR_STILLS));
        return is;
    }

    public static ItemStack[][] getMaps(BufferedImage[] whole) {
        int frames = whole.length;
        int width = 0;
        int height = 0;
        int i = 0;
        while (i < whole.length) {
            if (width < whole[i].getWidth()) {
                width = whole[i].getWidth();
            }
            if (height < whole[i].getHeight()) {
                height = whole[i].getHeight();
            }
            ++i;
        }
        int wd1 = (int)(0.999999999 + (double)width / 128.0);
        int hd1 = (int)(0.999999999 + (double)height / 128.0);
        ItemStack[][] stacks = new ItemStack[wd1][hd1];
        if (wd1 == 0 || hd1 == 0) {
            Bukkit.broadcast((String)("Image is invalid. Width=" + wd1 + " Height=" + hd1 + "."), (String)"pluginconstructorapi.detectImage");
        }
        int x = 0;
        while (x < wd1) {
            int y = 0;
            while (y < hd1) {
                ItemStack is;
                Material map;
                MapView mv = Bukkit.createMap((World)((World)Bukkit.getWorlds().get(0)));
                if (ReflectionUtil.isVersionHigherThan(1, 13)) {
                    map = Material.FILLED_MAP;
                    is = new ItemStack(map, 1);
                    MapMeta mapmeta = (MapMeta)is.getItemMeta();
                    mapmeta.setMapId(mv.getId());
                    is.setItemMeta((ItemMeta)mapmeta);
                } else {
                    map = Material.MAP;
                    is = new ItemStack(map, 1, (short)mv.getId());
                }
                BufferedImage[] bip = new BufferedImage[frames];
                int frame = 0;
                while (frame < frames) {
                    if (x * 128 < whole[frame].getWidth()) {
                        int cW = 128;
                        int cH = 128;
                        if (x * 128 + cW > whole[frame].getWidth()) {
                            cW = whole[frame].getWidth() - x * 128;
                        }
                        if (y * 128 + cH > whole[frame].getHeight()) {
                            cH = whole[frame].getHeight() - y * 128;
                        }
                        if (cH > 0 && cW > 0) {
                            bip[frame] = whole[frame].getSubimage(x * 128, y * 128, cW, cH);
                        }
                    }
                    ++frame;
                }
                CustomImageRenderer cir = new CustomImageRenderer(bip, frames > 1 ? 0 : CustomImageRenderer.TICK_FOR_STILLS);
                for (MapRenderer mr : mv.getRenderers()) {
                    mv.removeRenderer(mr);
                }
                mv.addRenderer((MapRenderer)cir);
                stacks[x][y] = is;
                ++y;
            }
            ++x;
        }
        return stacks;
    }

    public static void setBlockAt(Direction dir, Player p, int height, int width, ItemStack is) {
        BlockFace bf;
        Location frame_loc;
        Location loc = new Location(p.getWorld(), (double)p.getLocation().getBlockX(), (double)p.getLocation().getBlockY(), (double)p.getLocation().getBlockZ());
        Material type = Material.GLASS;
        switch (dir) {
            case UP_EAST: {
                loc.add((double)width, (double)height, 0.0);
                loc.getBlock().setType(type);
                frame_loc = loc.clone();
                frame_loc.setZ(loc.getZ() + 1.0);
                bf = BlockFace.EAST;
                break;
            }
            case UP_WEST: {
                loc.add((double)(-width), (double)height, 0.0);
                loc.getBlock().setType(type);
                frame_loc = loc.clone();
                frame_loc.setZ(loc.getZ() - 1.0);
                bf = BlockFace.WEST;
                break;
            }
            case UP_NORTH: {
                loc.add(0.0, (double)height, (double)(-width));
                loc.getBlock().setType(type);
                frame_loc = loc.clone();
                frame_loc.setX(loc.getX() + 1.0);
                bf = BlockFace.NORTH;
                break;
            }
            default: {
                loc.add(0.0, (double)height, (double)width);
                loc.getBlock().setType(type);
                frame_loc = loc.clone();
                frame_loc.setX(loc.getX() - 1.0);
                bf = BlockFace.SOUTH;
            }
        }
        if (frame_loc.getBlock().getType() != Material.AIR) {
            frame_loc.getBlock().setType(Material.AIR);
        }
        if (is != null) {
            Bukkit.getScheduler().scheduleSyncDelayedTask(PluginConstructorAPI.getInstance(), new Runnable(){

                @Override
                public void run() {
                    ItemFrame i = (ItemFrame)p.getWorld().spawnEntity(frame_loc, EntityType.ITEM_FRAME);
                    i.setFacingDirection(bf);
                    i.setItem(is);
                }
            }, 20L);
        }
    }
}

