/*
 * Decompiled with CFR 0.152.
 */
package me.zombie_striker.pluginconstructor;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import java.util.logging.Level;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

public class DependencyDownloader {
    private static final String HOST = "https://api.curseforge.com";
    private static final String QUERY = "/servermods/files?projectIds=";
    private static final String AGENT = "Mozilla/5.0 Dependency Downloader by Zombie_Striker";
    private static final File WORKING_DIR = new File("plugins" + File.separator + "DependencyDownloader" + File.separator);
    private static final File CONFIG_FILE = new File(WORKING_DIR, "global.yml");
    private static final char[] HEX_CHAR_ARRAY = "0123456789abcdef".toCharArray();
    private int id = -1;
    private Plugin p;
    private boolean debug = false;
    private String downloadURL = null;
    private String futuremd5;
    private String downloadName;
    private List<Channel> allowedChannels = Arrays.asList(Channel.ALPHA, Channel.BETA, Channel.RELEASE);
    private FileConfiguration global;
    public boolean downloaderActive = false;

    public DependencyDownloader(Plugin p, int id) {
        this.setID(id);
        this.p = p;
        if (!CONFIG_FILE.exists()) {
            try {
                CONFIG_FILE.getParentFile().mkdirs();
                CONFIG_FILE.createNewFile();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        this.global = YamlConfiguration.loadConfiguration((File)CONFIG_FILE);
        this.global.options().header("DependencyDownloader by Zombie_Striker\nGlobal config");
        if (!this.global.isSet("download")) {
            this.global.set("download", (Object)true);
            try {
                this.global.save(CONFIG_FILE);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        this.downloaderActive = this.global.getBoolean("download");
        this.downloadDependency();
    }

    public DependencyDownloader(Plugin p, ProjectID id) {
        this(p, id.getID());
    }

    public int getID() {
        return this.id;
    }

    public void setID(int id) {
        this.id = id;
    }

    public void downloadDependency() {
        if (!this.downloaderActive) {
            this.debug("Disabled!");
            return;
        }
        new BukkitRunnable(){

            public void run() {
                DependencyDownloader.this.debug("Downloading STARTED!");
                DependencyDownloader.this.download();
            }
        }.runTaskAsynchronously(this.p);
    }

    private void download() {
        block14: {
            String target = "https://api.curseforge.com/servermods/files?projectIds=" + this.id;
            this.debug(target);
            try {
                String line;
                URL url = new URL(target);
                HttpURLConnection connection = (HttpURLConnection)url.openConnection();
                connection.addRequestProperty("User-Agent", AGENT);
                connection.connect();
                this.debug("Connecting!");
                BufferedReader responseReader = new BufferedReader(new InputStreamReader(connection.getInputStream()));
                StringBuilder responseBuffer = new StringBuilder();
                while ((line = responseReader.readLine()) != null) {
                    responseBuffer.append(line);
                }
                responseReader.close();
                String response = responseBuffer.toString();
                int counter = 1;
                if (connection.getResponseCode() != 200) break block14;
                try {
                    this.debug("RESCODE 200");
                    while (true) {
                        this.debug("Counter: " + counter);
                        JSONParser parser = new JSONParser();
                        JSONArray json = (JSONArray)parser.parse(response);
                        if (json.size() - counter < 0) {
                            this.debug("No version available!");
                            break;
                        }
                        JSONObject latest = (JSONObject)json.get(json.size() - counter);
                        this.futuremd5 = (String)latest.get((Object)"md5");
                        String channel = (String)latest.get((Object)"releaseType");
                        if (this.allowedChannels.contains((Object)Channel.matchChannel(channel.toUpperCase()))) {
                            this.downloadURL = ((String)latest.get((Object)"downloadUrl")).replace(" ", "%20");
                            this.downloadName = (String)latest.get((Object)"fileName");
                            break;
                        }
                        ++counter;
                    }
                }
                catch (ParseException e) {
                    this.p.getLogger().log(Level.SEVERE, "Could not parse API Response for " + target, e);
                }
            }
            catch (IOException e) {
                this.p.getLogger().log(Level.SEVERE, "Could not check for the dependencies for the plugin " + this.p.getName(), e);
            }
        }
        try {
            File downloadTo = null;
            try {
                downloadTo = new File(this.p.getDataFolder().getParentFile().getAbsolutePath(), this.downloadName);
            }
            catch (Exception e) {
                downloadTo = new File(this.p.getDataFolder().getParentFile().getAbsolutePath(), "PluginConstructorAPI v1.0.0.jar");
            }
            downloadTo.getParentFile().mkdirs();
            downloadTo.delete();
            this.debug("Started download!");
            this.downloadIsSeperateBecauseGotoGotRemoved(downloadTo);
            this.debug("Ended download!");
            if (!this.fileHash(downloadTo).equalsIgnoreCase(this.futuremd5)) {
                return;
            }
            if (downloadTo.getName().endsWith(".jar")) {
                return;
            }
            this.unzip(downloadTo);
        }
        catch (IOException e) {
            this.p.getLogger().log(Level.SEVERE, "Couldn't download " + this.downloadName, e);
            return;
        }
    }

    private void downloadIsSeperateBecauseGotoGotRemoved(File downloadTo) throws IOException {
        URL url = null;
        try {
            url = new URL(this.downloadURL);
        }
        catch (Exception e) {
            url = new URL("https://dev.bukkit.org/projects/pluginconstructorapi/files/2473165/download");
        }
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.addRequestProperty("User-Agent", AGENT);
        connection.connect();
        if (connection.getResponseCode() >= 300 && connection.getResponseCode() < 400) {
            this.downloadURL = connection.getHeaderField("Location");
            this.downloadIsSeperateBecauseGotoGotRemoved(downloadTo);
        } else {
            this.debug(String.valueOf(connection.getResponseCode()) + " " + connection.getResponseMessage() + " when requesting " + this.downloadURL);
            this.copy(connection.getInputStream(), new FileOutputStream(downloadTo));
        }
    }

    private long copy(InputStream in, OutputStream out) throws IOException {
        int r;
        long bytes = 0L;
        byte[] buf = new byte[4096];
        while ((r = in.read(buf)) != -1) {
            out.write(buf, 0, r);
            bytes += (long)r;
            this.debug("Another 4K, current: " + r);
        }
        out.flush();
        out.close();
        in.close();
        return bytes;
    }

    private void unzip(File download) {
        ZipFile zipFile = null;
        try {
            ZipEntry entry;
            zipFile = new ZipFile(download);
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            File downloadedFile = new File(this.p.getDataFolder().getParentFile().getAbsoluteFile(), this.downloadName);
            while ((entry = entries.nextElement()) != null) {
                File target = new File(downloadedFile, entry.getName());
                File inPlugins = new File(this.p.getDataFolder().getParentFile(), this.downloadName);
                if (!inPlugins.exists()) {
                    target = inPlugins;
                }
                if (entry.isDirectory()) continue;
                target.getParentFile().mkdirs();
                InputStream zipStream = zipFile.getInputStream(entry);
                FileOutputStream fileStream = new FileOutputStream(target);
                this.copy(zipStream, fileStream);
            }
            return;
        }
        catch (IOException e) {
            if (e instanceof ZipException) {
                this.p.getLogger().log(Level.SEVERE, "Could not unzip downloaded file!", e);
                return;
            }
            this.p.getLogger().log(Level.SEVERE, "An IOException occured while trying to unzip %s!".replace("%s", this.p.getName()), e);
            return;
        }
        finally {
            if (zipFile != null) {
                try {
                    zipFile.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private void debug(String message) {
        if (this.debug) {
            this.p.getLogger().info(String.valueOf(message) + ' ' + new Throwable().getStackTrace()[1]);
        }
    }

    public void setChannels(Channel ... channels) {
        this.allowedChannels.clear();
        this.allowedChannels.addAll(Arrays.asList(channels));
    }

    public String fileHash(File file) {
        try {
            int numBytes;
            FileInputStream is = new FileInputStream(file);
            MessageDigest md = MessageDigest.getInstance("MD5");
            byte[] bytes = new byte[2048];
            while ((numBytes = is.read(bytes)) != -1) {
                md.update(bytes, 0, numBytes);
            }
            byte[] digest = md.digest();
            char[] hexChars = new char[digest.length * 2];
            int j = 0;
            while (j < digest.length) {
                int v = digest[j] & 0xFF;
                hexChars[j * 2] = HEX_CHAR_ARRAY[v >>> 4];
                hexChars[j * 2 + 1] = HEX_CHAR_ARRAY[v & 0xF];
                ++j;
            }
            is.close();
            return new String(hexChars);
        }
        catch (IOException | NoSuchAlgorithmException e) {
            this.p.getLogger().log(Level.SEVERE, "Could not digest " + file.getPath(), e);
            return null;
        }
    }

    public static enum Channel {
        RELEASE("release"),
        BETA("beta"),
        ALPHA("alpha");

        private String channel;

        private Channel(String channel) {
            this.channel = channel;
        }

        public String getChannel() {
            return this.channel;
        }

        public static Channel matchChannel(String channel) {
            Channel[] channelArray = Channel.values();
            int n = channelArray.length;
            int n2 = 0;
            while (n2 < n) {
                Channel c = channelArray[n2];
                if (c.channel.equalsIgnoreCase(channel)) {
                    return c;
                }
                ++n2;
            }
            return null;
        }
    }

    public static enum ProjectID {
        PROTOCOLLIB(45564),
        WORLDGUARD(31054),
        WORLDEDIT(31043),
        VAULT(33184),
        HOLOGRAPHICDISPLAYS(75097),
        CITIZENS(31073),
        FACTIONS(31292),
        DYNMAP(31620);

        private int id;

        private ProjectID(int i) {
            this.id = i;
        }

        public int getID() {
            return this.id;
        }
    }
}

