/*
 * Decompiled with CFR 0.152.
 */
package me.zombie_striker.pluginconstructor;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.command.BlockCommandSender;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Damageable;
import org.bukkit.entity.Entity;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.minecart.CommandMinecart;
import org.bukkit.scoreboard.Objective;
import org.bukkit.scoreboard.Team;

public class CommandUtils {
    public static Entity[] getTargets(CommandSender sender, String arg) {
        Entity[] ents = null;
        Location loc = null;
        if (sender instanceof Player) {
            loc = ((Player)sender).getLocation();
        } else if (sender instanceof BlockCommandSender) {
            loc = ((BlockCommandSender)sender).getBlock().getLocation();
        } else if (sender instanceof CommandMinecart) {
            loc = ((CommandMinecart)sender).getLocation();
        }
        if (arg.startsWith("@a")) {
            if (loc != null) {
                int maxEnts = 0;
                for (World w : CommandUtils.getAcceptedWorlds(loc, arg)) {
                    maxEnts += w.getEntities().size();
                }
                ents = new Entity[maxEnts];
                int id = 0;
                int C = CommandUtils.getC(arg);
                World world3 = null;
                block1: for (World w : CommandUtils.getAcceptedWorlds(loc, arg)) {
                    List ea = w.getEntities();
                    int i = 0;
                    while (i < w.getEntities().size()) {
                        if (world3 == null || !world3.equals(w)) {
                            world3 = w;
                        }
                        if (id >= C) continue block1;
                        Entity e = (Entity)ea.get(i);
                        boolean good = true;
                        int b = 0;
                        while (b < CommandUtils.getTags(arg).length) {
                            if (!CommandUtils.canBeAccepted(CommandUtils.getTags(arg)[b], e, loc)) {
                                good = false;
                                break;
                            }
                            ++b;
                        }
                        if (good) {
                            ents[id] = e;
                            ++id;
                        }
                        ++i;
                    }
                }
            }
        } else if (arg.startsWith("@p")) {
            ents = new Entity[1];
            double closestInt = -1.0;
            Player closest = null;
            for (World w : CommandUtils.getAcceptedWorlds(loc, arg)) {
                for (Player e : w.getPlayers()) {
                    if (e.getLocation().equals((Object)loc) || closestInt != -1.0 && !(closestInt > e.getLocation().distance(loc))) continue;
                    boolean good = true;
                    int b = 0;
                    while (b < CommandUtils.getTags(arg).length) {
                        if (!CommandUtils.canBeAccepted(arg, (Entity)e, loc)) {
                            good = false;
                            break;
                        }
                        ++b;
                    }
                    if (!good) continue;
                    closestInt = e.getLocation().distance(loc);
                    closest = e;
                }
            }
            ents[0] = closest;
        } else if (arg.startsWith("@e")) {
            ents = new Entity[1];
            double closestInt = -1.0;
            Entity closest = null;
            for (World w : CommandUtils.getAcceptedWorlds(loc, arg)) {
                for (Entity e : w.getEntities()) {
                    if (e.getLocation().equals((Object)loc)) continue;
                    boolean good = true;
                    if (closestInt != -1.0 && !(closestInt > e.getLocation().distance(loc))) continue;
                    int b = 0;
                    while (b < CommandUtils.getTags(arg).length) {
                        if (!CommandUtils.canBeAccepted(arg, e, loc)) {
                            good = false;
                            break;
                        }
                        ++b;
                    }
                    if (!good) continue;
                    closestInt = e.getLocation().distance(loc);
                    closest = e;
                }
            }
            ents[0] = closest;
        } else if (arg.startsWith("@r")) {
            ThreadLocalRandom r = ThreadLocalRandom.current();
            ents = new Entity[1];
            Entity entity = null;
            int tries = 0;
            while (entity == null && tries < 100) {
                ++tries;
                if (CommandUtils.hasType(arg)) {
                    Entity e = (Entity)loc.getWorld().getEntities().get(((Random)r).nextInt(loc.getWorld().getEntities().size()));
                    boolean good = true;
                    int b = 0;
                    while (b < CommandUtils.getTags(arg).length) {
                        if (!CommandUtils.canBeAccepted(arg, e, loc)) {
                            good = false;
                            break;
                        }
                        ++b;
                    }
                    if (!good) continue;
                    entity = e;
                    continue;
                }
                ArrayList onl = new ArrayList(Bukkit.getOnlinePlayers());
                Entity e = (Entity)onl.get(((Random)r).nextInt(onl.size()));
                boolean good = true;
                int b = 0;
                while (b < CommandUtils.getTags(arg).length) {
                    if (!CommandUtils.canBeAccepted(arg, e, loc)) {
                        good = false;
                        break;
                    }
                    ++b;
                }
                if (!good) continue;
                entity = e;
            }
            ents[0] = entity;
        } else {
            ents = new Entity[]{Bukkit.getPlayer((String)arg)};
        }
        return ents;
    }

    public static Entity getTarget(CommandSender sender, String arg) {
        return CommandUtils.getTargets(sender, arg)[0];
    }

    public static int getIntRelative(String arg, String rel, Entity e) {
        int relInt = 0;
        switch (rel.toLowerCase()) {
            case "x": {
                relInt = e.getLocation().getBlockX();
                break;
            }
            case "y": {
                relInt = e.getLocation().getBlockY();
                break;
            }
            case "z": {
                relInt = e.getLocation().getBlockZ();
            }
        }
        return CommandUtils.mathIt(arg, relInt);
    }

    private static boolean canBeAccepted(String arg, Entity e, Location loc) {
        if (CommandUtils.isType(arg, e)) {
            return true;
        }
        if (CommandUtils.isR(arg, loc, e)) {
            return true;
        }
        if (CommandUtils.isName(arg, e)) {
            return true;
        }
        if (CommandUtils.isRM(arg, loc, e)) {
            return true;
        }
        if (CommandUtils.isH(arg, e)) {
            return true;
        }
        if (CommandUtils.isHM(arg, e)) {
            return true;
        }
        if (CommandUtils.isM(arg, e)) {
            return true;
        }
        if (CommandUtils.isL(arg, e)) {
            return true;
        }
        if (CommandUtils.isLM(arg, e)) {
            return true;
        }
        if (CommandUtils.isW(arg, loc, e)) {
            return true;
        }
        if (CommandUtils.isRX(arg, e)) {
            return true;
        }
        if (CommandUtils.isRXM(arg, e)) {
            return true;
        }
        if (CommandUtils.isRY(arg, e)) {
            return true;
        }
        if (CommandUtils.isTeam(arg, e)) {
            return true;
        }
        if (CommandUtils.isScore(arg, e)) {
            return true;
        }
        if (CommandUtils.isScoreMin(arg, e)) {
            return true;
        }
        return CommandUtils.isRYM(arg, e);
    }

    private static String[] getTags(String arg) {
        if (!arg.contains("[")) {
            return new String[0];
        }
        String tags = arg.split("\\[")[1].split("\\]")[0];
        return tags.split(",");
    }

    private static int mathIt(String args, int relInt) {
        int total = 0;
        int mode = 0;
        String arg = args.replace("~", String.valueOf(relInt));
        String intString = "";
        int i = 0;
        while (i < arg.length()) {
            if (arg.charAt(i) == '+' || arg.charAt(i) == '-' || arg.charAt(i) == '*' || arg.charAt(i) == '/') {
                try {
                    switch (mode) {
                        case 0: {
                            total += Integer.parseInt(intString);
                            break;
                        }
                        case 1: {
                            total -= Integer.parseInt(intString);
                            break;
                        }
                        case 2: {
                            total *= Integer.parseInt(intString);
                            break;
                        }
                        case 3: {
                            total /= Integer.parseInt(intString);
                        }
                    }
                    mode = (short)(arg.charAt(i) == '+' ? 0 : (arg.charAt(i) == '-' ? 1 : (arg.charAt(i) == '*' ? 2 : (arg.charAt(i) == '/' ? 3 : -1))));
                }
                catch (Exception e) {
                    Bukkit.getLogger().severe("There has been an issue with a plugin using the CommandUtils class!");
                }
            } else {
                if (args.length() == i || arg.charAt(i) == ' ' || arg.charAt(i) == ',' || arg.charAt(i) == ']') {
                    try {
                        switch (mode) {
                            case 0: {
                                total += Integer.parseInt(intString);
                                break;
                            }
                            case 1: {
                                total -= Integer.parseInt(intString);
                                break;
                            }
                            case 2: {
                                total *= Integer.parseInt(intString);
                                break;
                            }
                            case 3: {
                                total /= Integer.parseInt(intString);
                            }
                        }
                    }
                    catch (Exception e) {
                        Bukkit.getLogger().severe("There has been an issue with a plugin using the CommandUtils class!");
                    }
                    break;
                }
                intString = String.valueOf(intString) + arg.charAt(i);
            }
            ++i;
        }
        return total;
    }

    private static String getType(String arg) {
        if (CommandUtils.hasType(arg)) {
            return arg.toLowerCase().split("=")[1].replace("!", "");
        }
        return "Player";
    }

    private static int getC(String arg) {
        if (!CommandUtils.hasC(arg)) {
            return Integer.MAX_VALUE;
        }
        return Integer.parseInt(arg.toLowerCase().replace("!", "").split("=")[1]);
    }

    private static int getR(String arg) {
        if (!CommandUtils.hasR(arg)) {
            return Integer.MAX_VALUE;
        }
        return Integer.parseInt(arg.toLowerCase().replace("!", "").split("=")[1]);
    }

    private static int getRM(String arg) {
        if (!CommandUtils.hasRM(arg)) {
            return 1;
        }
        return Integer.parseInt(arg.toLowerCase().replace("!", "").split("=")[1]);
    }

    private static int getRX(String arg) {
        if (!CommandUtils.hasRX(arg)) {
            return -2147483647;
        }
        return Integer.parseInt(arg.toLowerCase().replace("!", "").split("=")[1]);
    }

    private static int getRXM(String arg) {
        if (!CommandUtils.hasRXM(arg)) {
            return -8;
        }
        return Integer.parseInt(arg.toLowerCase().replace("!", "").split("=")[1]);
    }

    private static int getRY(String arg) {
        if (!CommandUtils.hasRY(arg)) {
            return -2147483647;
        }
        return Integer.parseInt(arg.toLowerCase().replace("!", "").split("=")[1]);
    }

    private static int getRYM(String arg) {
        if (!CommandUtils.hasRYM(arg)) {
            return -8;
        }
        return Integer.parseInt(arg.toLowerCase().replace("!", "").split("=")[1]);
    }

    private static int getH(String arg) {
        if (!CommandUtils.hasH(arg)) {
            return -1;
        }
        return Integer.parseInt(arg.toLowerCase().replace("!", "").split("=")[1]);
    }

    private static int getHM(String arg) {
        if (!CommandUtils.hasHM(arg)) {
            return Integer.MAX_VALUE;
        }
        return Integer.parseInt(arg.toLowerCase().replace("!", "").split("=")[1]);
    }

    private static int getL(String arg) {
        if (!CommandUtils.hasL(arg)) {
            return -1;
        }
        return Integer.parseInt(arg.toLowerCase().replace("!", "").split("=")[1]);
    }

    private static int getLM(String arg) {
        if (!CommandUtils.hasLM(arg)) {
            return Integer.MAX_VALUE;
        }
        return Integer.parseInt(arg.toLowerCase().replace("!", "").split("=")[1]);
    }

    private static String getName(String arg) {
        String reparg = arg.replace(" ", "_");
        if (!CommandUtils.hasName(reparg)) {
            return null;
        }
        return reparg.replace("!", "").split("=")[1];
    }

    private static World getW(String arg) {
        if (!CommandUtils.hasW(arg)) {
            return null;
        }
        return Bukkit.getWorld((String)arg.replace("!", "").split("=")[1]);
    }

    private static String getScoreMinName(String arg) {
        if (!CommandUtils.hasScoreMin(arg)) {
            return null;
        }
        return arg.split("=")[0].substring(0, arg.split("=")[0].length() - 1 - 4).replace("score_", "");
    }

    private static String getScoreName(String arg) {
        if (!CommandUtils.hasScore(arg)) {
            return null;
        }
        return arg.split("=")[0].replace("score_", "");
    }

    private static String getTeam(String arg) {
        if (!CommandUtils.hasTeam(arg)) {
            return null;
        }
        return arg.toLowerCase().replace("!", "").split("=")[1];
    }

    private static int getScoreMin(String arg) {
        if (!CommandUtils.hasScoreMin(arg)) {
            return -8;
        }
        return Integer.parseInt(arg.replace("!", "").split("=")[1]);
    }

    private static int getScore(String arg) {
        if (!CommandUtils.hasScore(arg)) {
            return Integer.MAX_VALUE;
        }
        return Integer.parseInt(arg.replace("!", "").split("=")[1]);
    }

    private static GameMode getM(String arg) {
        if (!CommandUtils.hasM(arg)) {
            return null;
        }
        String[] split = arg.replace("!", "").toLowerCase().split("=");
        String returnType = split[1];
        if (returnType.equalsIgnoreCase("0") || returnType.equalsIgnoreCase("s") || returnType.equalsIgnoreCase("survival")) {
            return GameMode.SURVIVAL;
        }
        if (returnType.equalsIgnoreCase("1") || returnType.equalsIgnoreCase("c") || returnType.equalsIgnoreCase("creative")) {
            return GameMode.CREATIVE;
        }
        if (returnType.equalsIgnoreCase("2") || returnType.equalsIgnoreCase("a") || returnType.equalsIgnoreCase("adventure")) {
            return GameMode.ADVENTURE;
        }
        if (returnType.equalsIgnoreCase("3") || returnType.equalsIgnoreCase("sp") || returnType.equalsIgnoreCase("spectator")) {
            return GameMode.SPECTATOR;
        }
        return null;
    }

    private static List<World> getAcceptedWorlds(Location loc, String string) {
        ArrayList<World> worlds = new ArrayList<World>(Bukkit.getWorlds());
        if (CommandUtils.getW(string) != null) {
            if (CommandUtils.isInverted(string)) {
                worlds.remove(CommandUtils.getW(string));
            } else {
                worlds.clear();
                worlds.add(CommandUtils.getW(string));
            }
        }
        return worlds;
    }

    private static boolean isTeam(String arg, Entity e) {
        if (!CommandUtils.hasTeam(arg)) {
            return true;
        }
        if (!(e instanceof Player)) {
            return false;
        }
        for (Team t : Bukkit.getScoreboardManager().getMainScoreboard().getTeams()) {
            if (t.getName().equalsIgnoreCase(CommandUtils.getTeam(arg)) == CommandUtils.isInverted(arg) || t.getEntries().contains(((Player)e).getName()) == CommandUtils.isInverted(arg)) continue;
            return true;
        }
        return false;
    }

    private static boolean isScore(String arg, Entity e) {
        if (!CommandUtils.hasScore(arg)) {
            return true;
        }
        if (!(e instanceof Player)) {
            return false;
        }
        for (Objective o : Bukkit.getScoreboardManager().getMainScoreboard().getObjectives()) {
            if (!o.getName().equalsIgnoreCase(CommandUtils.getScoreName(arg)) || o.getScore(((Player)e).getName()).getScore() <= CommandUtils.getScore(arg) == CommandUtils.isInverted(arg)) continue;
            return true;
        }
        return false;
    }

    private static boolean isScoreMin(String arg, Entity e) {
        if (!CommandUtils.hasScoreMin(arg)) {
            return true;
        }
        if (!(e instanceof Player)) {
            return false;
        }
        for (Objective o : Bukkit.getScoreboardManager().getMainScoreboard().getObjectives()) {
            if (!o.getName().equalsIgnoreCase(CommandUtils.getScoreMinName(arg)) || o.getScore(((Player)e).getName()).getScore() >= CommandUtils.getScoreMin(arg) == CommandUtils.isInverted(arg)) continue;
            return true;
        }
        return false;
    }

    private static boolean isRM(String arg, Location loc, Entity e) {
        if (!CommandUtils.hasRM(arg)) {
            return true;
        }
        return CommandUtils.isInverted(arg) != (double)CommandUtils.getRM(arg) < loc.distance(e.getLocation());
    }

    private static boolean isR(String arg, Location loc, Entity e) {
        if (!CommandUtils.hasR(arg)) {
            return true;
        }
        return CommandUtils.isInverted(arg) != (double)CommandUtils.getR(arg) > loc.distance(e.getLocation());
    }

    private static boolean isRXM(String arg, Entity e) {
        return CommandUtils.isInverted(arg) != (float)CommandUtils.getRXM(arg) < e.getLocation().getYaw();
    }

    private static boolean isRX(String arg, Entity e) {
        return CommandUtils.isInverted(arg) != (float)CommandUtils.getRX(arg) > e.getLocation().getYaw();
    }

    private static boolean isRYM(String arg, Entity e) {
        return CommandUtils.isInverted(arg) != (float)CommandUtils.getRYM(arg) < e.getLocation().getPitch();
    }

    private static boolean isRY(String arg, Entity e) {
        return CommandUtils.isInverted(arg) != (float)CommandUtils.getRY(arg) > e.getLocation().getPitch();
    }

    private static boolean isL(String arg, Entity e) {
        if (!CommandUtils.hasL(arg)) {
            return true;
        }
        return e instanceof Player && CommandUtils.isInverted(arg) != CommandUtils.getL(arg) < ((Player)e).getTotalExperience();
    }

    private static boolean isLM(String arg, Entity e) {
        if (!CommandUtils.hasLM(arg)) {
            return true;
        }
        return e instanceof Player && CommandUtils.isInverted(arg) != CommandUtils.getLM(arg) > ((Player)e).getTotalExperience();
    }

    private static boolean isH(String arg, Entity e) {
        if (!CommandUtils.hasH(arg)) {
            return true;
        }
        return e instanceof Damageable && CommandUtils.isInverted(arg) != (double)CommandUtils.getH(arg) > ((Damageable)e).getHealth();
    }

    private static boolean isHM(String arg, Entity e) {
        if (!CommandUtils.hasHM(arg)) {
            return true;
        }
        return e instanceof Damageable && CommandUtils.isInverted(arg) != (double)CommandUtils.getHM(arg) < ((Damageable)e).getHealth();
    }

    private static boolean isM(String arg, Entity e) {
        if (CommandUtils.getM(arg) == null) {
            return true;
        }
        return e instanceof HumanEntity && CommandUtils.isInverted(arg) != (CommandUtils.getM(arg) == ((HumanEntity)e).getGameMode());
    }

    private static boolean isW(String arg, Location loc, Entity e) {
        if (CommandUtils.getW(arg) == null) {
            return true;
        }
        return CommandUtils.isInverted(arg) != CommandUtils.getAcceptedWorlds(loc, arg).contains(CommandUtils.getW(arg));
    }

    private static boolean isName(String arg, Entity e) {
        if (CommandUtils.getName(arg) == null) {
            return true;
        }
        return CommandUtils.isInverted(arg) != (e.getCustomName() != null) && CommandUtils.isInverted(arg) != (CommandUtils.getName(arg).equals(e.getCustomName().replace(" ", "_")) || e instanceof Player && ((Player)e).getName().replace(" ", "_").equalsIgnoreCase(CommandUtils.getName(arg)));
    }

    private static boolean isType(String arg, Entity e) {
        if (!CommandUtils.hasType(arg)) {
            return true;
        }
        boolean invert = CommandUtils.isInverted(arg);
        String type = CommandUtils.getType(arg);
        return invert != e.getType().name().equalsIgnoreCase(type);
    }

    private static boolean isInverted(String arg) {
        return arg.toLowerCase().split("!").length != 1;
    }

    private static boolean hasR(String arg) {
        return arg.toLowerCase().startsWith("r=");
    }

    private static boolean hasScoreMin(String arg) {
        boolean startW = arg.startsWith("score_");
        if (!startW) {
            return false;
        }
        String[] split = arg.split("=");
        return split[0].endsWith("_min");
    }

    private static boolean hasScore(String arg) {
        boolean startW = arg.startsWith("score_");
        if (!startW) {
            return false;
        }
        String[] split = arg.split("=");
        return !split[0].endsWith("_min");
    }

    private static boolean hasRX(String arg) {
        return arg.toLowerCase().startsWith("rx=");
    }

    private static boolean hasRXM(String arg) {
        return arg.toLowerCase().startsWith("rxm=");
    }

    private static boolean hasRY(String arg) {
        return arg.toLowerCase().startsWith("ry=");
    }

    private static boolean hasRYM(String arg) {
        return arg.toLowerCase().startsWith("rym=");
    }

    private static boolean hasRM(String arg) {
        return arg.toLowerCase().startsWith("rm=");
    }

    private static boolean hasH(String arg) {
        return arg.toLowerCase().startsWith("h=");
    }

    private static boolean hasHM(String arg) {
        return arg.toLowerCase().startsWith("hm=");
    }

    private static boolean hasC(String arg) {
        return arg.toLowerCase().startsWith("c=");
    }

    private static boolean hasM(String arg) {
        return arg.toLowerCase().startsWith("m=");
    }

    private static boolean hasW(String arg) {
        return arg.toLowerCase().startsWith("w=");
    }

    private static boolean hasL(String arg) {
        return arg.toLowerCase().startsWith("l=");
    }

    private static boolean hasLM(String arg) {
        return arg.toLowerCase().startsWith("lm=");
    }

    private static boolean hasName(String arg) {
        return arg.toLowerCase().startsWith("name=");
    }

    private static boolean hasTeam(String arg) {
        return arg.toLowerCase().startsWith("team=");
    }

    private static boolean hasType(String arg) {
        return arg.toLowerCase().startsWith("type=");
    }
}

