/*
 * Decompiled with CFR 0.152.
 */
package xyz.nkomarn.Harbor.util;

import java.util.List;
import java.util.Random;
import net.md_5.bungee.api.ChatMessageType;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.ChatColor;
import org.bukkit.World;
import org.bukkit.entity.Player;
import xyz.nkomarn.Harbor.task.Checker;
import xyz.nkomarn.Harbor.util.Config;

public class Messages {
    public static void sendRandomChatMessage(World world, String messageList) {
        List<String> messages = Config.getList(messageList);
        if (messages.size() < 1) {
            return;
        }
        int index = new Random().nextInt(Math.max(0, messages.size()));
        Messages.sendWorldChatMessage(world, messages.get(index));
    }

    private static void sendWorldChatMessage(World world, String message) {
        if (!Config.getBoolean("messages.chat.chat") || message.length() < 1) {
            return;
        }
        world.getPlayers().forEach(player -> player.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)Messages.prepareMessage(world, message))));
    }

    public static void sendActionBarMessage(Player player, String message) {
        World world = player.getWorld();
        if (!Config.getBoolean("messages.actionbar.actionbar") || message.length() < 1) {
            return;
        }
        player.spigot().sendMessage(ChatMessageType.ACTION_BAR, TextComponent.fromLegacyText((String)Messages.prepareMessage(world, message)));
    }

    private static String prepareMessage(World world, String message) {
        return ChatColor.translateAlternateColorCodes((char)'&', (String)message.replace("[sleeping]", String.valueOf(Checker.getSleeping(world).size())).replace("[players]", String.valueOf(Checker.getPlayers(world))).replace("[needed]", String.valueOf(Checker.getSkipAmount(world))).replace("[more]", String.valueOf(Checker.getNeeded(world))));
    }
}

