/*
 * Decompiled with CFR 0.152.
 */
package xyz.nkomarn.Harbor.task;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.World;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import xyz.nkomarn.Harbor.Harbor;
import xyz.nkomarn.Harbor.task.AccelerateNightTask;
import xyz.nkomarn.Harbor.util.Config;
import xyz.nkomarn.Harbor.util.Messages;

public class Checker
implements Runnable {
    public static final List<World> skippingWorlds = new ArrayList<World>();

    @Override
    public void run() {
        Bukkit.getOnlinePlayers().stream().map(Entity::getWorld).distinct().filter(this::validateWorld).forEach(this::checkWorld);
    }

    private void checkWorld(World world) {
        int sleeping = Checker.getSleeping(world).size();
        int needed = Checker.getNeeded(world);
        if (sleeping > 0 && needed > 0) {
            world.getPlayers().forEach(player -> Messages.sendActionBarMessage(player, Config.getString("messages.actionbar.sleeping")));
        } else if (needed == 0 && sleeping > 0) {
            world.getPlayers().forEach(player -> Messages.sendActionBarMessage(player, Config.getString("messages.actionbar.everyone")));
            skippingWorlds.add(world);
            if (!Config.getBoolean("features.skip")) {
                return;
            }
            new AccelerateNightTask(world).runTaskTimer((Plugin)Harbor.instance, 0L, 1L);
            Messages.sendRandomChatMessage(world, "messages.chat.accelerateNight");
        }
    }

    private boolean validateWorld(World world) {
        return !this.isBlacklisted(world) && !skippingWorlds.contains(world) && this.isNight(world);
    }

    private boolean isBlacklisted(World world) {
        return Config.getList("blacklist").contains(world.getName());
    }

    private boolean isNight(World world) {
        return world.getTime() > 12950L || world.getTime() < 23950L;
    }

    public static List<Player> getSleeping(World world) {
        return world.getPlayers().stream().filter(LivingEntity::isSleeping).collect(Collectors.toList());
    }

    public static int getSkipAmount(World world) {
        return (int)Math.ceil((double)Checker.getPlayers(world) * (Config.getDouble("values.percent") / 100.0));
    }

    public static int getPlayers(World world) {
        return Math.max(0, world.getPlayers().size() - Checker.getExcluded(world).size());
    }

    public static int getNeeded(World world) {
        return Math.max(0, (int)Math.ceil((double)Checker.getPlayers(world) * (Config.getDouble("values.percent") / 100.0) - (double)Checker.getSleeping(world).size()));
    }

    private static List<Player> getExcluded(World world) {
        return world.getPlayers().stream().filter(Checker::isExcluded).collect(Collectors.toList());
    }

    private static boolean isExcluded(Player p) {
        boolean excludedByAfk;
        boolean excludedByGameMode = Config.getBoolean("features.ignore") && p.getGameMode() != GameMode.SURVIVAL;
        boolean excludedByPermission = Config.getBoolean("features.bypass") && p.hasPermission("harbor.bypass");
        boolean bl = excludedByAfk = Harbor.essentials != null && Harbor.essentials.getUser(p).isAfk();
        return excludedByGameMode || excludedByPermission || excludedByAfk;
    }
}

