/*
 * Decompiled with CFR 0.152.
 */
package xyz.nkomarn.Harbor.command;

import java.util.concurrent.ExecutionException;
import net.md_5.bungee.api.ChatMessageType;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.ChatColor;
import org.bukkit.Sound;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import xyz.nkomarn.Harbor.Harbor;
import xyz.nkomarn.Harbor.util.Config;
import xyz.nkomarn.Harbor.util.Updater;

public class HarborCommand
implements CommandExecutor {
    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        String prefix = Config.getString("messages.miscellaneous.prefix");
        if (args.length < 1) {
            sender.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)(String.valueOf(prefix) + "&7Harbor version " + Harbor.version + " by TechToolbox (@nkomarn).")));
            return true;
        }
        if (!sender.hasPermission("harbor.admin")) {
            sender.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)(String.valueOf(prefix) + Config.getString("messages.miscellaneous.permission"))));
            return true;
        }
        if (args[0].equalsIgnoreCase("reload")) {
            Harbor.instance.reloadConfig();
            sender.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)(String.valueOf(prefix) + "&7Reloaded configuration.")));
            return true;
        }
        if (args[0].equalsIgnoreCase("update")) {
            boolean updateAvailable;
            if (sender instanceof Player) {
                Player player = (Player)sender;
                player.playSound(player.getLocation(), Sound.BLOCK_NOTE_BLOCK_PLING, 1.0f, 1.0f);
                player.spigot().sendMessage(ChatMessageType.ACTION_BAR, TextComponent.fromLegacyText((String)ChatColor.translateAlternateColorCodes((char)'&', (String)(String.valueOf(prefix) + "&fChecking for updates."))));
            }
            try {
                updateAvailable = Updater.check().get();
            }
            catch (InterruptedException | ExecutionException e) {
                sender.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)(String.valueOf(prefix) + "&7Failed to check for a " + "new update. Check console for full log.")));
                e.printStackTrace();
                return true;
            }
            if (updateAvailable) {
                try {
                    if (sender instanceof Player) {
                        Player player = (Player)sender;
                        player.playSound(player.getLocation(), Sound.ENTITY_PLAYER_LEVELUP, 1.0f, 1.0f);
                        player.spigot().sendMessage(ChatMessageType.ACTION_BAR, TextComponent.fromLegacyText((String)ChatColor.translateAlternateColorCodes((char)'&', (String)(String.valueOf(prefix) + "&fUpdate found, upgrading."))));
                    }
                    sender.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)(String.valueOf(prefix) + "&7" + Updater.upgrade().get())));
                }
                catch (InterruptedException | ExecutionException e) {
                    e.printStackTrace();
                }
                return true;
            }
            sender.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)(String.valueOf(prefix) + "&7You're already running " + "the latest version of Harbor. Great work!")));
            return true;
        }
        sender.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)(String.valueOf(prefix) + Config.getString("messages.miscellaneous.unrecognized"))));
        return true;
    }
}

