/*
 * Decompiled with CFR 0.152.
 */
package timber.core;

import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.logging.Level;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.java.JavaPlugin;

public class Plugin
extends JavaPlugin
implements Listener {
    public static HashSet<String> validLogMaterials = new HashSet<String>(Arrays.asList("LOG", "LOG_2", "LEGACY_LOG", "LEGACY_LOG_2", "ACACIA_LOG", "BIRCH_LOG", "DARK_OAK_LOG", "JUNGLE_LOG", "OAK_LOG", "SPRUCE_LOG"));
    public static HashSet<String> validAxeMaterials = new HashSet<String>(Arrays.asList("DIAMOND_AXE", "GOLDEN_AXE", "IRON_AXE", "STONE_AXE", "WOODEN_AXE", "GOLD_AXE", "WOOD_AXE"));
    public static HashSet<Material> logMaterials = new HashSet();
    public static HashSet<Material> axeMaterials = new HashSet();
    public static boolean reverseSneakFunction = false;

    public void initializeHashSets() {
        Material[] materialArray = Material.values();
        int n = materialArray.length;
        int n2 = 0;
        while (n2 < n) {
            Material material = materialArray[n2];
            if (validLogMaterials.contains(material.name())) {
                logMaterials.add(material);
            }
            if (validAxeMaterials.contains(material.name())) {
                axeMaterials.add(material);
            }
            ++n2;
        }
        Bukkit.getLogger().log(Level.INFO, "Timber Log Materials: " + logMaterials.toString());
        Bukkit.getLogger().log(Level.INFO, "Timber Axe Materials: " + axeMaterials.toString());
    }

    public void onEnable() {
        this.saveDefaultConfig();
        reverseSneakFunction = this.getConfig().getBoolean("reverseSneakFunction");
        this.initializeHashSets();
        this.getServer().getPluginManager().registerEvents((Listener)this, (org.bukkit.plugin.Plugin)this);
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onBlockBreak(BlockBreakEvent e) {
        Block block;
        ItemStack handStack;
        boolean check;
        Player player = e.getPlayer();
        boolean bl = reverseSneakFunction ? player.isSneaking() : (check = !player.isSneaking());
        if (check && (!player.hasPermission("timber.disallow") || player.isOp()) && axeMaterials.contains((handStack = player.getItemInHand()).getType()) && logMaterials.contains((block = e.getBlock()).getType())) {
            this.cutDownTree(block.getLocation(), player.getGameMode() == GameMode.CREATIVE ? handStack.clone() : handStack);
        }
    }

    private void cutDownTree(Location location, ItemStack handStack) {
        LinkedList<Block> blocks = new LinkedList<Block>();
        int i = location.getBlockY();
        while (i < location.getWorld().getHighestBlockYAt(location.getBlockX(), location.getBlockZ())) {
            Location l = location.add(0.0, 1.0, 0.0);
            Block block = l.getBlock();
            if (!logMaterials.contains(block.getType())) break;
            blocks.add(l.getBlock());
            l = null;
            ++i;
        }
        for (Block block : blocks) {
            if (!block.breakNaturally(handStack)) continue;
            handStack.setDurability((short)(handStack.getDurability() + 1));
            if (handStack.getType().getMaxDurability() != handStack.getDurability()) continue;
            handStack.setType(Material.AIR);
            return;
        }
        blocks = null;
    }
}

