/*
 * Decompiled with CFR 0.152.
 */
package com.onarandombox.buscript;

import com.onarandombox.buscript.Buscript;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.bukkit.plugin.Plugin;

class ScriptTask
implements Runnable {
    private Buscript buscript;
    private Plugin plugin;
    private int id = -1;

    ScriptTask(Buscript buscript) {
        this.plugin = buscript.getPlugin();
        this.buscript = buscript;
    }

    void start() {
        this.id = this.plugin.getServer().getScheduler().scheduleSyncRepeatingTask(this.plugin, (Runnable)this, 20L, 20L);
    }

    void kill() {
        this.plugin.getServer().getScheduler().cancelTask(this.id);
    }

    @Override
    public void run() {
        if (!this.buscript.runTasks) {
            this.kill();
            return;
        }
        long time = System.currentTimeMillis();
        for (Map.Entry<String, List<Map<String, Object>>> entry : this.buscript.delayedScripts.entrySet()) {
            boolean removed = false;
            Iterator<Map<String, Object>> scriptsIt = entry.getValue().iterator();
            while (scriptsIt.hasNext()) {
                Map<String, Object> script = scriptsIt.next();
                if (script.get("time") != null) {
                    try {
                        long scriptTime = (Long)script.get("time");
                        if (time < scriptTime) continue;
                        if (script.get("file") != null) {
                            Map metaData;
                            List replacements;
                            final File scriptFile = new File(script.get("file").toString());
                            if (scriptFile.exists()) {
                                try {
                                    replacements = (List)script.get("replacements");
                                    metaData = (Map)script.get("metaData");
                                    this.buscript.getPlugin().getServer().getScheduler().scheduleSyncDelayedTask(this.plugin, new Runnable(){

                                        @Override
                                        public void run() {
                                            ScriptTask.this.buscript.executeDelayedScript(scriptFile, replacements, metaData);
                                        }
                                    });
                                    scriptsIt.remove();
                                    removed = true;
                                }
                                catch (ClassCastException e) {
                                    this.plugin.getLogger().warning("Invalid delayed script entry");
                                    scriptsIt.remove();
                                    removed = true;
                                }
                                continue;
                            }
                            try {
                                scriptFile.createNewFile();
                            }
                            catch (IOException e) {
                                // empty catch block
                            }
                            if (scriptFile.exists()) {
                                try {
                                    replacements = (List)script.get("replacements");
                                    metaData = (Map)script.get("metaData");
                                    this.buscript.getPlugin().getServer().getScheduler().scheduleSyncDelayedTask(this.plugin, new Runnable(){

                                        @Override
                                        public void run() {
                                            ScriptTask.this.buscript.executeDelayedScript(scriptFile, replacements, metaData);
                                        }
                                    });
                                    scriptsIt.remove();
                                    removed = true;
                                }
                                catch (ClassCastException e) {
                                    scriptsIt.remove();
                                    removed = true;
                                    System.out.println("could not cast");
                                }
                                continue;
                            }
                            this.plugin.getLogger().warning("Missing script file: " + scriptFile);
                            scriptsIt.remove();
                            removed = true;
                            continue;
                        }
                        this.plugin.getLogger().warning("Invalid delayed script entry");
                        scriptsIt.remove();
                        removed = true;
                    }
                    catch (NumberFormatException ignore) {
                        this.plugin.getLogger().warning("Invalid delayed script entry");
                        scriptsIt.remove();
                        removed = true;
                    }
                    continue;
                }
                this.plugin.getLogger().warning("Invalid delayed script entry");
                scriptsIt.remove();
                removed = true;
            }
            if (!removed) continue;
            this.buscript.saveData();
        }
    }
}

