/*
 * Decompiled with CFR 0.152.
 */
package com.onarandombox.buscript;

import com.onarandombox.buscript.BukkitScriptExecutor;
import com.onarandombox.buscript.Buscript;
import com.onarandombox.buscript.ScriptExecutor;
import java.io.File;
import java.io.IOException;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class BuscriptPlugin
extends JavaPlugin {
    private Buscript buscript;

    public void onEnable() {
        this.buscript = new Buscript((Plugin)this);
        this.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this, new Runnable(){

            @Override
            public void run() {
                BuscriptPlugin.this.getAPI().executeScript(BuscriptPlugin.this.getStartupScript());
            }
        });
    }

    public Buscript getAPI() {
        return this.buscript;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (label.equalsIgnoreCase("run")) {
            if (args.length < 1) {
                return false;
            }
            File scriptFile = new File(this.getAPI().getScriptFolder(), args[0]);
            if (!scriptFile.exists()) {
                sender.sendMessage("Script '" + scriptFile + "' does not exist!");
                return true;
            }
            Player player = null;
            if (sender instanceof Player) {
                player = (Player)sender;
            }
            if (args.length == 1) {
                this.getAPI().executeScript(scriptFile, new BukkitScriptExecutor(player));
                return true;
            }
            if (args.length == 2) {
                this.getAPI().executeScript(scriptFile, args[1], (ScriptExecutor)new BukkitScriptExecutor(player));
                return true;
            }
        } else if (label.equalsIgnoreCase("breload")) {
            this.buscript.clearScriptCache();
            sender.sendMessage("Script cache cleared!");
        }
        return false;
    }

    private File getStartupScript() {
        File scriptFile = new File(this.getDataFolder(), "startup-script.txt");
        if (!scriptFile.exists()) {
            try {
                this.saveResource("startup-script.txt", false);
                if (!scriptFile.exists()) {
                    scriptFile.createNewFile();
                }
            }
            catch (IOException e) {
                this.getLogger().severe("Error creating startup script file: " + e.getMessage());
                this.getServer().getPluginManager().disablePlugin((Plugin)this);
                return null;
            }
            catch (IllegalArgumentException e) {
                this.getLogger().info("Start up script not found in jar.");
            }
        }
        return scriptFile;
    }
}

