/*
 * Decompiled with CFR 0.152.
 */
package com.onarandombox.buscript;

import com.onarandombox.buscript.BukkitScriptExecutor;
import com.onarandombox.buscript.BuscriptListener;
import com.onarandombox.buscript.DefaultEventExecutor;
import com.onarandombox.buscript.DefaultFunctions;
import com.onarandombox.buscript.DefaultListener;
import com.onarandombox.buscript.ScriptExecutor;
import com.onarandombox.buscript.ScriptManager;
import com.onarandombox.buscript.ScriptTask;
import com.onarandombox.buscript.StringReplacer;
import com.onarandombox.buscript.VaultListener;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.milkbowl.vault.chat.Chat;
import net.milkbowl.vault.economy.Economy;
import net.milkbowl.vault.permission.Permission;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventPriority;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.plugin.EventExecutor;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.RegisteredListener;
import org.bukkit.plugin.RegisteredServiceProvider;

public class Buscript
extends ScriptManager {
    private Plugin plugin;
    private Permission permissions;
    private Economy economy;
    private Chat chat;
    private File scriptFile;
    private FileConfiguration scriptConfig;
    boolean runTasks = true;
    Map<String, List<Map<String, Object>>> delayedScripts = new HashMap<String, List<Map<String, Object>>>();

    public Buscript(Plugin plugin) {
        this(plugin, "plugin");
    }

    public Buscript(Plugin plugin, String pluginScriptName) {
        super(new File(plugin.getDataFolder(), "scripts"), plugin.getLogger());
        this.plugin = plugin;
        this.setScriptVariable("server", plugin.getServer());
        this.setScriptVariable(pluginScriptName, plugin);
        this.addScriptMethods(new DefaultFunctions(this));
        this.setupVault();
        plugin.getServer().getPluginManager().registerEvents((Listener)new VaultListener(this), plugin);
        this.initData();
        ScriptTask scriptTask = new ScriptTask(this);
        scriptTask.start();
        plugin.getServer().getPluginManager().registerEvents((Listener)new BuscriptListener(this), plugin);
    }

    private void initData() {
        this.scriptFile = new File(this.getScriptFolder(), "scripts.bin");
        this.scriptConfig = YamlConfiguration.loadConfiguration((File)this.scriptFile);
        ConfigurationSection scripts = this.scriptConfig.getConfigurationSection("scripts");
        if (scripts != null) {
            for (String player : scripts.getKeys(false)) {
                ArrayList playerScripts = new ArrayList();
                this.delayedScripts.put(player, playerScripts);
                for (Object scriptObj : scripts.getList(player)) {
                    if (!(scriptObj instanceof Map)) continue;
                    Map scriptMap = (Map)scriptObj;
                    HashMap<String, Number> script = new HashMap<String, Number>(2);
                    for (Object keyObj : scriptMap.keySet()) {
                        if (keyObj.toString().equals("time")) {
                            try {
                                script.put(keyObj.toString(), Long.valueOf(scriptMap.get(keyObj).toString()));
                            }
                            catch (NumberFormatException e) {
                                this.getPlugin().getLogger().warning("Script data error, time reset");
                                script.put(keyObj.toString(), 0);
                            }
                            continue;
                        }
                        script.put(keyObj.toString(), (Number)scriptMap.get(keyObj));
                    }
                    playerScripts.add(script);
                }
            }
        }
    }

    void setupVault() {
        RegisteredServiceProvider chatProvider;
        RegisteredServiceProvider economyProvider;
        if (this.getPlugin().getServer().getPluginManager().getPlugin("Vault") == null) {
            return;
        }
        RegisteredServiceProvider permissionProvider = this.getPlugin().getServer().getServicesManager().getRegistration(Permission.class);
        if (permissionProvider != null) {
            this.permissions = (Permission)permissionProvider.getProvider();
        }
        if ((economyProvider = this.getPlugin().getServer().getServicesManager().getRegistration(Economy.class)) != null) {
            this.economy = (Economy)economyProvider.getProvider();
        }
        if ((chatProvider = this.getPlugin().getServer().getServicesManager().getRegistration(Chat.class)) != null) {
            this.chat = (Chat)chatProvider.getProvider();
        }
        this.updateVaultInGlobalScope();
    }

    void disableVault() {
        this.permissions = null;
        this.economy = null;
        this.chat = null;
        this.updateVaultInGlobalScope();
    }

    private void updateVaultInGlobalScope() {
        this.setScriptVariable("permissions", this.permissions);
        this.setScriptVariable("chat", this.chat);
        this.setScriptVariable("economy", this.economy);
    }

    void saveData() {
        this.scriptConfig.set("scripts", this.delayedScripts);
        try {
            this.scriptConfig.save(this.scriptFile);
        }
        catch (IOException e) {
            this.plugin.getLogger().warning("Could not save script data: " + e.getMessage());
        }
    }

    public Plugin getPlugin() {
        return this.plugin;
    }

    public Permission getPermissions() {
        return this.permissions;
    }

    public Economy getEconomy() {
        return this.economy;
    }

    public Chat getChat() {
        return this.chat;
    }

    public Object executeScript(File scriptFile, Player executor) {
        return super.executeScript(scriptFile, new BukkitScriptExecutor(executor));
    }

    public Object executeScript(File scriptFile, String target, Player executor) {
        return super.executeScript(scriptFile, target, (ScriptExecutor)new BukkitScriptExecutor(executor));
    }

    public Object executeScript(String script, String source, Player executor) {
        return super.executeScript(script, source, (ScriptExecutor)new BukkitScriptExecutor(executor));
    }

    public Object executeScript(String script, String source, String target, Player executor) {
        return super.executeScript(script, source, target, new BukkitScriptExecutor(executor));
    }

    public void scheduleScript(File scriptFile, long delay) {
        this.scheduleScript(scriptFile, null, delay);
    }

    public void scheduleScript(File scriptFile, String target, long delay) {
        List<Map<String, Object>> playerScripts;
        if (target == null) {
            target = "!!NULL";
        }
        if ((playerScripts = this.delayedScripts.get(target)) == null) {
            playerScripts = new ArrayList<Map<String, Object>>();
            this.delayedScripts.put(target, playerScripts);
        }
        HashMap<String, Object> script = new HashMap<String, Object>(2);
        script.put("time", System.currentTimeMillis() + delay);
        script.put("file", scriptFile.toString());
        ArrayList replacements = new ArrayList(this.stringReplacers.size());
        for (StringReplacer r : this.stringReplacers) {
            String var;
            String replace;
            HashMap<String, String> replacement = new HashMap<String, String>(2);
            String regex = r.getRegexString();
            if (regex != null) {
                replacement.put("regex", regex);
            }
            if ((replace = r.getReplacement()) != null) {
                replacement.put("replace", replace);
            }
            if ((var = r.getGlobalVarName()) != null) {
                replacement.put("var", var);
            }
            replacements.add(replacement);
        }
        script.put("replacements", replacements);
        script.put("metaData", new HashMap(this.metaData));
        playerScripts.add(script);
        this.saveData();
    }

    public void clearScheduledScripts(String target) {
        this.delayedScripts.remove(target);
        this.saveData();
    }

    public void registerEventScript(String eventClassName, String priorityString, File scriptFile) {
        Method method;
        Class<?> eventClass;
        EventPriority priority = EventPriority.valueOf((String)priorityString.toUpperCase());
        if (priority == null) {
            this.getPlugin().getLogger().warning(priorityString + " is not a valid EventPriority!");
            return;
        }
        try {
            eventClass = Class.forName(eventClassName);
        }
        catch (ClassNotFoundException e) {
            this.getPlugin().getLogger().warning(e.getMessage());
            return;
        }
        if (!Event.class.isAssignableFrom(eventClass)) {
            this.getPlugin().getLogger().warning("Class must extend " + Event.class);
            return;
        }
        try {
            method = eventClass.getDeclaredMethod("getHandlerList", new Class[0]);
        }
        catch (NoSuchMethodException ignore) {
            this.getPlugin().getLogger().warning(eventClass.getName() + " cannot be listened for!");
            return;
        }
        if (method == null) {
            this.getPlugin().getLogger().warning(eventClass.getName() + " cannot be listened for!");
            return;
        }
        HandlerList handlerList = null;
        try {
            method.setAccessible(true);
            Object handlerListObj = method.invoke(null, new Object[0]);
            if (handlerListObj == null || !(handlerListObj instanceof HandlerList)) {
                this.getPlugin().getLogger().warning(eventClass.getName() + " cannot be listened for!");
                return;
            }
            handlerList = (HandlerList)handlerListObj;
        }
        catch (IllegalAccessException ignore) {
            this.getPlugin().getLogger().warning(eventClass.getName() + " cannot be listened for!");
            return;
        }
        catch (InvocationTargetException ignore) {
            this.getPlugin().getLogger().warning(eventClass.getName() + " cannot be listened for!");
            return;
        }
        DefaultListener listener = new DefaultListener();
        DefaultEventExecutor eventExecutor = new DefaultEventExecutor(this, scriptFile.toString());
        RegisteredListener registeredListener = new RegisteredListener((Listener)listener, (EventExecutor)eventExecutor, priority, this.getPlugin(), false);
        handlerList.register(registeredListener);
    }
}

