/*
 * Decompiled with CFR 0.152.
 */
package com.onarandombox.MultiverseCore.utils.webpaste;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import com.onarandombox.MultiverseCore.utils.webpaste.PasteFailedException;
import com.onarandombox.MultiverseCore.utils.webpaste.PasteService;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.HashMap;
import java.util.Map;

public class GithubPasteService
implements PasteService {
    private final boolean isPrivate;

    public GithubPasteService(boolean isPrivate) {
        this.isPrivate = isPrivate;
    }

    @Override
    public String encodeData(String data) {
        HashMap<String, String> mapData = new HashMap<String, String>();
        mapData.put("multiverse.txt", data);
        return this.encodeData(mapData);
    }

    @Override
    public String encodeData(Map<String, String> files) {
        JsonObject root = new JsonObject();
        root.add("description", (JsonElement)new JsonPrimitive("Multiverse-Core Debug Info"));
        root.add("public", (JsonElement)new JsonPrimitive(Boolean.valueOf(!this.isPrivate)));
        JsonObject fileList = new JsonObject();
        for (Map.Entry<String, String> entry : files.entrySet()) {
            JsonObject fileObject = new JsonObject();
            fileObject.add("content", (JsonElement)new JsonPrimitive(entry.getValue()));
            fileList.add(entry.getKey(), (JsonElement)fileObject);
        }
        root.add("files", (JsonElement)fileList);
        return root.toString();
    }

    @Override
    public URL getPostURL() {
        try {
            return new URL("https://api.github.com/gists");
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    @Override
    public String postData(String encodedData, URL url) throws PasteFailedException {
        OutputStreamWriter wr = null;
        BufferedReader rd = null;
        try {
            String line;
            URLConnection conn = url.openConnection();
            conn.setDoOutput(true);
            wr = new OutputStreamWriter(conn.getOutputStream());
            wr.write(encodedData);
            wr.flush();
            rd = new BufferedReader(new InputStreamReader(conn.getInputStream()));
            String pastieUrl = "";
            StringBuilder responseString = new StringBuilder();
            while ((line = rd.readLine()) != null) {
                responseString.append(line);
            }
            String string = new JsonParser().parse(responseString.toString()).getAsJsonObject().get("html_url").getAsString();
            return string;
        }
        catch (Exception e) {
            throw new PasteFailedException(e);
        }
        finally {
            if (wr != null) {
                try {
                    wr.close();
                }
                catch (IOException iOException) {}
            }
            if (rd != null) {
                try {
                    rd.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    @Override
    public boolean supportsMultiFile() {
        return true;
    }
}

