/*
 * Decompiled with CFR 0.152.
 */
package com.onarandombox.MultiverseCore.utils;

import com.onarandombox.MultiverseCore.MVWorld;
import com.onarandombox.MultiverseCore.MultiverseCore;
import com.onarandombox.MultiverseCore.MultiverseCoreConfiguration;
import com.onarandombox.MultiverseCore.WorldProperties;
import com.onarandombox.MultiverseCore.api.MVWorldManager;
import com.onarandombox.MultiverseCore.api.MultiverseWorld;
import com.onarandombox.MultiverseCore.api.SafeTTeleporter;
import com.onarandombox.MultiverseCore.api.WorldPurger;
import com.onarandombox.MultiverseCore.event.MVWorldDeleteEvent;
import com.onarandombox.MultiverseCore.utils.CoreLogging;
import com.onarandombox.MultiverseCore.utils.FileUtils;
import com.onarandombox.MultiverseCore.utils.PurgeWorlds;
import com.onarandombox.MultiverseCore.utils.SimpleWorldPurger;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.Stack;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.WorldCreator;
import org.bukkit.WorldType;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.generator.ChunkGenerator;
import org.bukkit.permissions.Permission;
import org.bukkit.permissions.PermissionDefault;
import org.bukkit.plugin.Plugin;

public class WorldManager
implements MVWorldManager {
    private final MultiverseCore plugin;
    private final WorldPurger worldPurger;
    private final Map<String, MultiverseWorld> worlds;
    private Map<String, WorldProperties> worldsFromTheConfig;
    private FileConfiguration configWorlds = null;
    private Map<String, String> defaultGens;
    private String firstSpawn;
    private static final char SEPARATOR = '\uf8ff';

    public WorldManager(MultiverseCore core) {
        this.plugin = core;
        this.worldsFromTheConfig = new HashMap<String, WorldProperties>();
        this.worlds = new ConcurrentHashMap<String, MultiverseWorld>();
        this.worldPurger = new SimpleWorldPurger(this.plugin);
    }

    @Override
    public void getDefaultWorldGenerators() {
        this.defaultGens = new HashMap<String, String>();
        File[] files = this.plugin.getServerFolder().listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File file, String s) {
                return s.equalsIgnoreCase("bukkit.yml");
            }
        });
        if (files != null && files.length == 1) {
            YamlConfiguration bukkitConfig = YamlConfiguration.loadConfiguration((File)files[0]);
            if (bukkitConfig.isConfigurationSection("worlds")) {
                Set keys = bukkitConfig.getConfigurationSection("worlds").getKeys(false);
                for (String key : keys) {
                    this.defaultGens.put(key, bukkitConfig.getString("worlds." + key + ".generator", ""));
                }
            }
        } else {
            this.plugin.log(Level.WARNING, "Could not read 'bukkit.yml'. Any Default worldgenerators will not be loaded!");
        }
    }

    @Override
    @Deprecated
    public boolean cloneWorld(String oldName, String newName, String generator) {
        return this.cloneWorld(oldName, newName);
    }

    @Override
    public boolean cloneWorld(String oldName, String newName) {
        File uidFile;
        if (!this.worldsFromTheConfig.containsKey(oldName)) {
            for (Map.Entry<String, WorldProperties> entry : this.worldsFromTheConfig.entrySet()) {
                if (!oldName.equals(entry.getValue().getAlias())) continue;
                oldName = entry.getKey();
                break;
            }
            if (!this.worldsFromTheConfig.containsKey(oldName)) {
                CoreLogging.warning("Old world '%s' does not exist", oldName);
                return false;
            }
        }
        if (this.isMVWorld(newName)) {
            CoreLogging.warning("New world '%s' already exists", newName);
            return false;
        }
        File oldWorldFile = new File(this.plugin.getServer().getWorldContainer(), oldName);
        File newWorldFile = new File(this.plugin.getServer().getWorldContainer(), newName);
        if (newWorldFile.exists()) {
            CoreLogging.warning("File for new world '%s' already exists", newName);
            return false;
        }
        boolean wasJustLoaded = false;
        boolean wasLoadSpawn = false;
        if (this.plugin.getServer().getWorld(oldName) == null) {
            wasJustLoaded = true;
            WorldProperties props = this.worldsFromTheConfig.get(oldName);
            wasLoadSpawn = props.isKeepingSpawnInMemory();
            if (wasLoadSpawn) {
                props.setKeepSpawnInMemory(false);
            }
            if (!this.loadWorld(oldName)) {
                return false;
            }
            this.plugin.getServer().getWorld(oldName).setAutoSave(false);
        }
        MVWorld oldWorld = (MVWorld)this.getMVWorld(oldName);
        World.Environment environment = oldWorld.getEnvironment();
        String seedString = oldWorld.getSeed() + "";
        WorldType worldType = oldWorld.getWorldType();
        Boolean generateStructures = oldWorld.getCBWorld().canGenerateStructures();
        String generator = oldWorld.getGenerator();
        boolean useSpawnAdjust = oldWorld.getAdjustSpawn();
        if (wasJustLoaded) {
            this.unloadWorld(oldName, true);
            oldWorld = null;
            if (wasLoadSpawn) {
                this.worldsFromTheConfig.get(oldName).setKeepSpawnInMemory(true);
            }
        }
        boolean wasAutoSave = false;
        if (oldWorld != null && oldWorld.getCBWorld().isAutoSave()) {
            wasAutoSave = true;
            CoreLogging.config("Saving world '%s'", oldName);
            oldWorld.getCBWorld().setAutoSave(false);
            oldWorld.getCBWorld().save();
        }
        CoreLogging.config("Copying files for world '%s'", oldName);
        if (!FileUtils.copyFolder(oldWorldFile, newWorldFile, CoreLogging.getLogger())) {
            CoreLogging.warning("Failed to copy files for world '%s', see the log info", newName);
            return false;
        }
        if (oldWorld != null && wasAutoSave) {
            oldWorld.getCBWorld().setAutoSave(true);
        }
        if ((uidFile = new File(newWorldFile, "uid.dat")).exists() && !uidFile.delete()) {
            CoreLogging.warning("Failed to delete unique ID file for world '%s'", newName);
            return false;
        }
        if (newWorldFile.exists()) {
            CoreLogging.fine("Succeeded at copying files", new Object[0]);
            if (this.addWorld(newName, environment, seedString, worldType, generateStructures, generator, useSpawnAdjust)) {
                CoreLogging.fine("Succeeded at importing world", new Object[0]);
                MVWorld newWorld = (MVWorld)this.getMVWorld(newName);
                newWorld.copyValues(this.worldsFromTheConfig.get(oldName));
                newWorld.setAlias(null);
                return true;
            }
        }
        CoreLogging.warning("Failed to copy files for world '%s', see the log info", newName);
        return false;
    }

    @Override
    public boolean addWorld(String name, World.Environment env, String seedString, WorldType type, Boolean generateStructures, String generator) {
        return this.addWorld(name, env, seedString, type, generateStructures, generator, true);
    }

    @Override
    public boolean addWorld(String name, World.Environment env, String seedString, WorldType type, Boolean generateStructures, String generator, boolean useSpawnAdjust) {
        if (name.equalsIgnoreCase("plugins") || name.equalsIgnoreCase("logs")) {
            return false;
        }
        Long seed = null;
        WorldCreator c = new WorldCreator(name);
        if (seedString != null && seedString.length() > 0) {
            try {
                seed = Long.parseLong(seedString);
            }
            catch (NumberFormatException numberformatexception) {
                seed = seedString.hashCode();
            }
            c.seed(seed.longValue());
        }
        if (generator != null && generator.length() != 0) {
            c.generator(generator);
        }
        c.environment(env);
        if (type != null) {
            c.type(type);
        }
        if (generateStructures != null) {
            c.generateStructures(generateStructures.booleanValue());
        }
        if (!this.worldsFromTheConfig.containsKey(name)) {
            WorldProperties props = new WorldProperties(useSpawnAdjust, env);
            this.worldsFromTheConfig.put(name, props);
        }
        StringBuilder builder = new StringBuilder();
        builder.append("Loading World & Settings - '").append(name).append("'");
        builder.append(" - Env: ").append(env);
        builder.append(" - Type: ").append(type);
        if (seed != null) {
            builder.append(" & seed: ").append(seed);
        }
        if (generator != null) {
            builder.append(" & generator: ").append(generator);
        }
        CoreLogging.info(builder.toString(), new Object[0]);
        if (!this.doLoad(c, true)) {
            this.plugin.log(Level.SEVERE, "Failed to Create/Load the world '" + name + "'");
            return false;
        }
        this.worlds.get(name).setGenerator(generator);
        this.saveWorldsConfig();
        return true;
    }

    @Override
    public ChunkGenerator getChunkGenerator(String generator, final String generatorID, final String worldName) {
        if (generator == null) {
            return null;
        }
        final Plugin myPlugin = this.plugin.getServer().getPluginManager().getPlugin(generator);
        if (myPlugin == null) {
            return null;
        }
        return this.plugin.getUnsafeCallWrapper().wrap(new Callable<ChunkGenerator>(){

            @Override
            public ChunkGenerator call() throws Exception {
                return myPlugin.getDefaultWorldGenerator(worldName, generatorID);
            }
        }, myPlugin.getName(), "Failed to get the default chunk generator: %s", new Object[0]);
    }

    @Override
    public boolean removeWorldFromConfig(String name) {
        if (!this.unloadWorld(name)) {
            return false;
        }
        if (this.worldsFromTheConfig.containsKey(name)) {
            this.worldsFromTheConfig.remove(name);
            CoreLogging.info("World '%s' was removed from config.yml", name);
            this.saveWorldsConfig();
            return true;
        }
        CoreLogging.info("World '%s' was already removed from config.yml", name);
        return false;
    }

    @Override
    public void setFirstSpawnWorld(String world) {
        this.firstSpawn = world == null && this.plugin.getServer().getWorlds().size() > 0 ? ((World)this.plugin.getServer().getWorlds().get(0)).getName() : world;
    }

    @Override
    public MultiverseWorld getFirstSpawnWorld() {
        MultiverseWorld world = this.getMVWorld(this.firstSpawn);
        if (world == null) {
            this.plugin.log(Level.WARNING, "The world specified as the spawn world (" + this.firstSpawn + ") did not exist!!");
            try {
                return this.getMVWorld((World)this.plugin.getServer().getWorlds().get(0));
            }
            catch (IndexOutOfBoundsException e) {
                return null;
            }
        }
        return world;
    }

    @Override
    public boolean unloadWorld(String name) {
        return this.unloadWorld(name, true);
    }

    @Override
    public boolean unloadWorld(String name, boolean unloadBukkit) {
        if (this.worlds.containsKey(name)) {
            this.worldsFromTheConfig.get(name).cacheVirtualProperties();
            if (unloadBukkit && this.unloadWorldFromBukkit(name, true)) {
                this.worlds.remove(name);
                CoreLogging.info("World '%s' was unloaded from memory.", name);
                return true;
            }
            if (!unloadBukkit) {
                this.worlds.remove(name);
                CoreLogging.info("World '%s' was unloaded from memory.", name);
                return true;
            }
            CoreLogging.warning("World '%s' could not be unloaded. Is it a default world?", name);
        } else if (this.plugin.getServer().getWorld(name) != null) {
            CoreLogging.warning("Hmm Multiverse does not know about this world but it's loaded in memory.", new Object[0]);
            CoreLogging.warning("To let Multiverse know about it, use:", new Object[0]);
            CoreLogging.warning("/mv import %s %s", name, this.plugin.getServer().getWorld(name).getEnvironment().toString());
        } else {
            if (this.worldsFromTheConfig.containsKey(name)) {
                return true;
            }
            CoreLogging.info("Multiverse does not know about '%s' and it's not loaded by Bukkit.", name);
        }
        return false;
    }

    @Override
    public boolean loadWorld(String name) {
        if (this.worlds.containsKey(name)) {
            return true;
        }
        if (this.worldsFromTheConfig.containsKey(name)) {
            return this.doLoad(name);
        }
        return false;
    }

    private void brokenWorld(String name) {
        this.plugin.log(Level.SEVERE, "The world '" + name + "' could NOT be loaded because it contains errors and is probably corrupt!");
        this.plugin.log(Level.SEVERE, "Try using Minecraft Region Fixer to repair your world! '" + name + "'");
        this.plugin.log(Level.SEVERE, "https://github.com/Fenixin/Minecraft-Region-Fixer");
    }

    private void nullWorld(String name) {
        this.plugin.log(Level.SEVERE, "The world '" + name + "' could NOT be loaded because the server didn't like it!");
        this.plugin.log(Level.SEVERE, "We don't really know why this is. Contact the developer of your server software!");
        this.plugin.log(Level.SEVERE, "Server version info: " + Bukkit.getServer().getVersion());
    }

    private boolean doLoad(String name) {
        return this.doLoad(name, false, null);
    }

    private boolean doLoad(String name, boolean ignoreExists, WorldType type) {
        if (!this.worldsFromTheConfig.containsKey(name)) {
            throw new IllegalArgumentException("That world doesn't exist!");
        }
        final WorldProperties world = this.worldsFromTheConfig.get(name);
        final WorldCreator creator = WorldCreator.name((String)name);
        creator.environment(world.getEnvironment()).seed(world.getSeed());
        if (type != null) {
            creator.type(type);
        }
        boolean generatorSuccess = true;
        if (world.getGenerator() != null && !world.getGenerator().equals("null")) {
            generatorSuccess = null != this.plugin.getUnsafeCallWrapper().wrap(new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    creator.generator(world.getGenerator());
                    return new Object();
                }
            }, "the generator plugin", "Failed to set the generator for world '%s' to '%s': %s", name, world.getGenerator());
        }
        return generatorSuccess && this.doLoad(creator, ignoreExists);
    }

    private boolean doLoad(WorldCreator creator, boolean ignoreExists) {
        World cbworld;
        String worldName = creator.name();
        if (!this.worldsFromTheConfig.containsKey(worldName)) {
            throw new IllegalArgumentException("That world doesn't exist!");
        }
        if (this.worlds.containsKey(worldName)) {
            throw new IllegalArgumentException("That world is already loaded!");
        }
        if (!(ignoreExists || new File(this.plugin.getServer().getWorldContainer(), worldName).exists() || new File(this.plugin.getServer().getWorldContainer().getParent(), worldName).exists())) {
            this.plugin.log(Level.WARNING, "WorldManager: Can't load this world because the folder was deleted/moved: " + worldName);
            this.plugin.log(Level.WARNING, "Use '/mv remove' to remove it from the config!");
            return false;
        }
        WorldProperties mvworld = this.worldsFromTheConfig.get(worldName);
        try {
            cbworld = creator.createWorld();
        }
        catch (Exception e) {
            e.printStackTrace();
            this.brokenWorld(worldName);
            return false;
        }
        if (cbworld == null) {
            this.nullWorld(worldName);
            return false;
        }
        MVWorld world = new MVWorld(this.plugin, cbworld, mvworld);
        if (MultiverseCoreConfiguration.getInstance().isAutoPurgeEnabled()) {
            this.worldPurger.purgeWorld(world);
        }
        this.worlds.put(worldName, world);
        return true;
    }

    @Override
    public boolean deleteWorld(String name, boolean removeFromConfig, boolean deleteWorldFolder) {
        World world = this.plugin.getServer().getWorld(name);
        if (world == null) {
            return false;
        }
        MVWorldDeleteEvent mvwde = new MVWorldDeleteEvent(this.getMVWorld(name), removeFromConfig);
        this.plugin.getServer().getPluginManager().callEvent((Event)mvwde);
        if (mvwde.isCancelled()) {
            this.plugin.log(Level.FINE, "Tried to delete a world, but the event was cancelled!");
            return false;
        }
        if (removeFromConfig ? !this.removeWorldFromConfig(name) : !this.unloadWorld(name)) {
            return false;
        }
        try {
            File worldFile = world.getWorldFolder();
            this.plugin.log(Level.FINER, "deleteWorld(): worldFile: " + worldFile.getAbsolutePath());
            if (deleteWorldFolder ? FileUtils.deleteFolder(worldFile) : FileUtils.deleteFolderContents(worldFile)) {
                CoreLogging.info("World '%s' was DELETED.", name);
                return true;
            }
            CoreLogging.severe("World '%s' was NOT deleted.", name);
            CoreLogging.severe("Are you sure the folder %s exists?", name);
            CoreLogging.severe("Please check your file permissions on '%s'", name);
            return false;
        }
        catch (Throwable e) {
            CoreLogging.severe("Hrm, something didn't go as planned. Here's an exception for ya.", new Object[0]);
            CoreLogging.severe("You can go politely explain your situation in #multiverse on esper.net", new Object[0]);
            CoreLogging.severe("But from here, it looks like your folder is oddly named.", new Object[0]);
            CoreLogging.severe("This world has been removed from Multiverse-Core so your best bet is to go delete the folder by hand. Sorry.", new Object[0]);
            CoreLogging.severe(e.getMessage(), new Object[0]);
            return false;
        }
    }

    @Override
    public boolean deleteWorld(String name, boolean removeFromConfig) {
        return this.deleteWorld(name, removeFromConfig, true);
    }

    @Override
    public boolean deleteWorld(String name) {
        return this.deleteWorld(name, true);
    }

    private boolean unloadWorldFromBukkit(String name, boolean safely) {
        this.removePlayersFromWorld(name);
        return this.plugin.getServer().unloadWorld(name, safely);
    }

    @Override
    public void removePlayersFromWorld(String name) {
        World w = this.plugin.getServer().getWorld(name);
        if (w != null) {
            World safeWorld = (World)this.plugin.getServer().getWorlds().get(0);
            List ps = w.getPlayers();
            SafeTTeleporter teleporter = this.plugin.getSafeTTeleporter();
            for (Player p : ps) {
                teleporter.safelyTeleport(null, (Entity)p, safeWorld.getSpawnLocation(), true);
            }
        }
    }

    @Override
    public Collection<MultiverseWorld> getMVWorlds() {
        return this.worlds.values();
    }

    @Override
    public MultiverseWorld getMVWorld(String name) {
        if (name == null) {
            return null;
        }
        MultiverseWorld world = this.worlds.get(name);
        if (world != null) {
            return world;
        }
        return this.getMVWorldByAlias(name);
    }

    @Override
    public MultiverseWorld getMVWorld(World world) {
        if (world != null) {
            return this.getMVWorld(world.getName());
        }
        return null;
    }

    private MultiverseWorld getMVWorldByAlias(String alias) {
        for (MultiverseWorld w : this.worlds.values()) {
            if (!w.getAlias().equalsIgnoreCase(alias)) continue;
            return w;
        }
        return null;
    }

    @Override
    public boolean isMVWorld(String name) {
        return this.worlds.containsKey(name) || this.isMVWorldAlias(name);
    }

    @Override
    public boolean isMVWorld(World world) {
        return world != null && this.isMVWorld(world.getName());
    }

    private boolean isMVWorldAlias(String alias) {
        for (MultiverseWorld w : this.worlds.values()) {
            if (!w.getAlias().equalsIgnoreCase(alias)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void loadDefaultWorlds() {
        this.ensureConfigIsPrepared();
        List myWorlds = this.plugin.getServer().getWorlds();
        for (World w : myWorlds) {
            String name = w.getName();
            if (this.worldsFromTheConfig.containsKey(name)) continue;
            String generator = null;
            if (this.defaultGens.containsKey(name)) {
                generator = this.defaultGens.get(name);
            }
            this.addWorld(name, w.getEnvironment(), String.valueOf(w.getSeed()), w.getWorldType(), w.canGenerateStructures(), generator);
        }
    }

    private void ensureConfigIsPrepared() {
        this.configWorlds.options().pathSeparator('\uf8ff');
        if (this.configWorlds.getConfigurationSection("worlds") == null) {
            this.configWorlds.createSection("worlds");
        }
    }

    @Override
    public void loadWorlds(boolean forceLoad) {
        int count = 0;
        this.ensureConfigIsPrepared();
        this.ensureSecondNamespaceIsPrepared();
        if (forceLoad) {
            Permission allAccess = this.plugin.getServer().getPluginManager().getPermission("multiverse.access.*");
            Permission allExempt = this.plugin.getServer().getPluginManager().getPermission("multiverse.exempt.*");
            for (MultiverseWorld w : this.worlds.values()) {
                if (allAccess != null) {
                    allAccess.getChildren().remove(w.getAccessPermission().getName());
                }
                if (allExempt != null) {
                    allExempt.getChildren().remove(w.getAccessPermission().getName());
                }
                this.plugin.getServer().getPluginManager().removePermission(w.getAccessPermission().getName());
                this.plugin.getServer().getPluginManager().removePermission(w.getExemptPermission().getName());
                this.plugin.getServer().getPluginManager().removePermission("mv.bypass.gamemode." + w.getName());
            }
            this.plugin.getServer().getPluginManager().recalculatePermissionDefaults(allAccess);
            this.plugin.getServer().getPluginManager().recalculatePermissionDefaults(allExempt);
            this.worlds.clear();
        }
        for (Map.Entry<String, WorldProperties> entry : this.worldsFromTheConfig.entrySet()) {
            if (this.worlds.containsKey(entry.getKey()) || !entry.getValue().getAutoLoad() || !this.doLoad(entry.getKey())) continue;
            ++count;
        }
        CoreLogging.config("%s - World(s) loaded.", count);
        this.saveWorldsConfig();
    }

    private void ensureSecondNamespaceIsPrepared() {
        Permission special = this.plugin.getServer().getPluginManager().getPermission("mv.bypass.gamemode.*");
        if (special == null) {
            special = new Permission("mv.bypass.gamemode.*", PermissionDefault.FALSE);
            this.plugin.getServer().getPluginManager().addPermission(special);
        }
    }

    @Override
    @Deprecated
    public PurgeWorlds getWorldPurger() {
        return new PurgeWorlds(this.plugin);
    }

    @Override
    public WorldPurger getTheWorldPurger() {
        return this.worldPurger;
    }

    @Override
    public boolean isKeepingSpawnInMemory(World world) {
        WorldProperties properties = this.worldsFromTheConfig.get(world.getName());
        return properties == null || properties.isKeepingSpawnInMemory();
    }

    @Override
    public FileConfiguration loadWorldConfig(File file) {
        this.configWorlds = YamlConfiguration.loadConfiguration((File)file);
        this.ensureConfigIsPrepared();
        try {
            this.configWorlds.save(new File(this.plugin.getDataFolder(), "worlds.yml"));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        Stack<String> worldKeys = new Stack<String>();
        worldKeys.addAll(this.configWorlds.getConfigurationSection("worlds").getKeys(false));
        HashMap<String, WorldProperties> newWorldsFromTheConfig = new HashMap<String, WorldProperties>();
        while (!worldKeys.isEmpty()) {
            String key = (String)worldKeys.pop();
            String path = "worlds\uf8ff" + key;
            Object obj = this.configWorlds.get(path);
            if (obj != null && obj instanceof WorldProperties) {
                MVWorld mvWorld;
                String worldName = key.replaceAll(String.valueOf('\uf8ff'), ".");
                WorldProperties props = (WorldProperties)obj;
                if (this.worldsFromTheConfig.containsKey(worldName) && (mvWorld = (MVWorld)this.worlds.get(worldName)) != null) {
                    mvWorld.copyValues((WorldProperties)obj);
                }
                newWorldsFromTheConfig.put(worldName, props);
                continue;
            }
            if (!this.configWorlds.isConfigurationSection(path)) continue;
            ConfigurationSection section = this.configWorlds.getConfigurationSection(path);
            Set subkeys = section.getKeys(false);
            for (String subkey : subkeys) {
                worldKeys.push(key + '\uf8ff' + subkey);
            }
        }
        this.worldsFromTheConfig = newWorldsFromTheConfig;
        this.worlds.keySet().retainAll(this.worldsFromTheConfig.keySet());
        return this.configWorlds;
    }

    @Override
    public boolean saveWorldsConfig() {
        try {
            this.configWorlds.options().pathSeparator('\uf8ff');
            this.configWorlds.set("worlds", null);
            for (Map.Entry<String, WorldProperties> entry : this.worldsFromTheConfig.entrySet()) {
                this.configWorlds.set("worlds\uf8ff" + entry.getKey(), (Object)entry.getValue());
            }
            this.configWorlds.save(new File(this.plugin.getDataFolder(), "worlds.yml"));
            return true;
        }
        catch (IOException e) {
            this.plugin.log(Level.SEVERE, "Could not save worlds.yml. Please check your settings.");
            return false;
        }
    }

    @Override
    public MultiverseWorld getSpawnWorld() {
        return this.getMVWorld((World)this.plugin.getServer().getWorlds().get(0));
    }

    @Override
    public List<String> getUnloadedWorlds() {
        ArrayList<String> allNames = new ArrayList<String>(this.worldsFromTheConfig.keySet());
        allNames.removeAll(this.worlds.keySet());
        return allNames;
    }

    @Override
    public boolean regenWorld(String name, boolean useNewSeed, boolean randomSeed, String seed) {
        MultiverseWorld world = this.getMVWorld(name);
        if (world == null) {
            return false;
        }
        List ps = world.getCBWorld().getPlayers();
        if (useNewSeed) {
            long theSeed;
            if (randomSeed) {
                theSeed = new Random().nextLong();
            } else {
                try {
                    theSeed = Long.parseLong(seed);
                }
                catch (NumberFormatException e) {
                    theSeed = seed.hashCode();
                }
            }
            world.setSeed(theSeed);
        }
        WorldType type = world.getWorldType();
        if (this.deleteWorld(name, false, false)) {
            this.doLoad(name, true, type);
            SafeTTeleporter teleporter = this.plugin.getSafeTTeleporter();
            Location newSpawn = world.getSpawnLocation();
            for (Player p : ps) {
                teleporter.safelyTeleport(null, (Entity)p, newSpawn, true);
            }
            return true;
        }
        return false;
    }

    public FileConfiguration getConfigWorlds() {
        return this.configWorlds;
    }

    @Override
    public boolean hasUnloadedWorld(String name, boolean includeLoaded) {
        if (this.getMVWorld(name) != null) {
            return includeLoaded;
        }
        for (Map.Entry<String, WorldProperties> entry : this.worldsFromTheConfig.entrySet()) {
            if (!name.equals(entry.getKey()) && !name.equals(entry.getValue().getAlias())) continue;
            return true;
        }
        return false;
    }
}

