/*
 * Decompiled with CFR 0.152.
 */
package com.onarandombox.MultiverseCore.utils;

import com.onarandombox.MultiverseCore.utils.CoreLogging;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.Comparator;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Stream;

public class FileUtils {
    protected FileUtils() {
        throw new UnsupportedOperationException();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean deleteFolder(File file) {
        try (Stream<Path> files = Files.walk(file.toPath(), new FileVisitOption[0]);){
            files.sorted(Comparator.reverseOrder()).map(Path::toFile).forEach(File::delete);
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            CoreLogging.warning(e.getMessage(), new Object[0]);
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean deleteFolderContents(File file) {
        try (Stream<Path> files = Files.walk(file.toPath(), new FileVisitOption[0]);){
            files.sorted(Comparator.reverseOrder()).map(Path::toFile).filter(f -> !f.equals(file)).forEach(File::delete);
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            CoreLogging.warning(e.getMessage(), new Object[0]);
            return false;
        }
    }

    public static boolean copyFolder(File source, File target, Logger log) {
        Path sourceDir = source.toPath();
        Path targetDir = target.toPath();
        try {
            Files.walkFileTree(sourceDir, new CopyDirFileVisitor(sourceDir, targetDir));
            return true;
        }
        catch (IOException e) {
            log.log(Level.WARNING, "Unable to copy directory", e);
            return false;
        }
    }

    private static class CopyDirFileVisitor
    extends SimpleFileVisitor<Path> {
        private final Path sourceDir;
        private final Path targetDir;

        private CopyDirFileVisitor(Path sourceDir, Path targetDir) {
            this.sourceDir = sourceDir;
            this.targetDir = targetDir;
        }

        @Override
        public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
            Path newDir = this.targetDir.resolve(this.sourceDir.relativize(dir));
            if (!Files.isDirectory(newDir, new LinkOption[0])) {
                Files.createDirectory(newDir, new FileAttribute[0]);
            }
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
            Path targetFile = this.targetDir.resolve(this.sourceDir.relativize(file));
            Files.copy(file, targetFile, StandardCopyOption.COPY_ATTRIBUTES);
            return FileVisitResult.CONTINUE;
        }
    }
}

