/*
 * Decompiled with CFR 0.152.
 */
package com.onarandombox.MultiverseCore.commands;

import com.onarandombox.MultiverseCore.MultiverseCore;
import com.onarandombox.MultiverseCore.commands.MultiverseCommand;
import com.onarandombox.MultiverseCore.event.MVVersionEvent;
import com.onarandombox.MultiverseCore.utils.CoreLogging;
import com.onarandombox.MultiverseCore.utils.webpaste.BitlyURLShortener;
import com.onarandombox.MultiverseCore.utils.webpaste.PasteFailedException;
import com.onarandombox.MultiverseCore.utils.webpaste.PasteService;
import com.onarandombox.MultiverseCore.utils.webpaste.PasteServiceFactory;
import com.onarandombox.MultiverseCore.utils.webpaste.PasteServiceType;
import com.onarandombox.MultiverseCore.utils.webpaste.URLShortener;
import com.onarandombox.commandhandler.CommandHandler;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.permissions.PermissionDefault;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class VersionCommand
extends MultiverseCommand {
    private static final URLShortener SHORTENER = new BitlyURLShortener();

    public VersionCommand(MultiverseCore plugin) {
        super(plugin);
        this.setName("Multiverse Version");
        this.setCommandUsage("/mv version " + ChatColor.GOLD + "-[bh] [--include-plugin-list]");
        this.setArgRange(0, 2);
        this.addKey("mv version");
        this.addKey("mvv");
        this.addKey("mvversion");
        this.setPermission("multiverse.core.version", "Dumps version info to the console, optionally to pastie.org with -p or pastebin.com with a -b.", PermissionDefault.TRUE);
    }

    private String getLegacyString() {
        StringBuilder legacyFile = new StringBuilder();
        legacyFile.append("[Multiverse-Core] Multiverse-Core Version: ").append(this.plugin.getDescription().getVersion()).append('\n');
        legacyFile.append("[Multiverse-Core] Bukkit Version: ").append(this.plugin.getServer().getVersion()).append('\n');
        legacyFile.append("[Multiverse-Core] Loaded Worlds: ").append(this.plugin.getMVWorldManager().getMVWorlds()).append('\n');
        legacyFile.append("[Multiverse-Core] Multiverse Plugins Loaded: ").append(this.plugin.getPluginCount()).append('\n');
        legacyFile.append("[Multiverse-Core] Economy being used: ").append(this.plugin.getEconomist().getEconomyName()).append('\n');
        legacyFile.append("[Multiverse-Core] Permissions Plugin: ").append(this.plugin.getMVPerms().getType()).append('\n');
        legacyFile.append("[Multiverse-Core] Dumping Config Values: (version ").append(this.plugin.getMVConfig().getVersion()).append(")").append('\n');
        legacyFile.append("[Multiverse-Core]  messagecooldown: ").append(this.plugin.getMessaging().getCooldown()).append('\n');
        legacyFile.append("[Multiverse-Core]  teleportcooldown: ").append(this.plugin.getMVConfig().getTeleportCooldown()).append('\n');
        legacyFile.append("[Multiverse-Core]  worldnameprefix: ").append(this.plugin.getMVConfig().getPrefixChat()).append('\n');
        legacyFile.append("[Multiverse-Core]  worldnameprefixFormat: ").append(this.plugin.getMVConfig().getPrefixChatFormat()).append('\n');
        legacyFile.append("[Multiverse-Core]  enforceaccess: ").append(this.plugin.getMVConfig().getEnforceAccess()).append('\n');
        legacyFile.append("[Multiverse-Core]  displaypermerrors: ").append(this.plugin.getMVConfig().getDisplayPermErrors()).append('\n');
        legacyFile.append("[Multiverse-Core]  teleportintercept: ").append(this.plugin.getMVConfig().getTeleportIntercept()).append('\n');
        legacyFile.append("[Multiverse-Core]  firstspawnoverride: ").append(this.plugin.getMVConfig().getFirstSpawnOverride()).append('\n');
        legacyFile.append("[Multiverse-Core]  firstspawnworld: ").append(this.plugin.getMVConfig().getFirstSpawnWorld()).append('\n');
        legacyFile.append("[Multiverse-Core]  debug: ").append(this.plugin.getMVConfig().getGlobalDebug()).append('\n');
        legacyFile.append("[Multiverse-Core] Special Code: FRN002").append('\n');
        return legacyFile.toString();
    }

    private String getMarkdownString() {
        StringBuilder markdownString = new StringBuilder();
        markdownString.append("# Multiverse-Core\n");
        markdownString.append("## Overview\n");
        markdownString.append("| Name | Value |\n");
        markdownString.append("| --- | --- |\n");
        markdownString.append("| Multiverse-Core Version | `").append(this.plugin.getDescription().getVersion()).append("` |\n");
        markdownString.append("| Bukkit Version | `").append(this.plugin.getServer().getVersion()).append("` |\n");
        markdownString.append("| Multiverse Plugins Loaded | `").append(this.plugin.getPluginCount()).append("` |\n");
        markdownString.append("| Economy being used | `").append(this.plugin.getEconomist().getEconomyName()).append("` |\n");
        markdownString.append("| Permissions Plugin | `").append(this.plugin.getMVPerms().getType()).append("` |\n");
        markdownString.append("## Parsed Config\n");
        markdownString.append("These are what Multiverse thought the in-memory values of the config were.\n\n");
        markdownString.append("| Config Key  | Value |\n");
        markdownString.append("| --- | --- |\n");
        markdownString.append("| version | `").append(this.plugin.getMVConfig().getVersion()).append("` |\n");
        markdownString.append("| messagecooldown | `").append(this.plugin.getMessaging().getCooldown()).append("` |\n");
        markdownString.append("| teleportcooldown | `").append(this.plugin.getMVConfig().getTeleportCooldown()).append("` |\n");
        markdownString.append("| worldnameprefix | `").append(this.plugin.getMVConfig().getPrefixChat()).append("` |\n");
        markdownString.append("| worldnameprefixFormat | `").append(this.plugin.getMVConfig().getPrefixChatFormat()).append("` |\n");
        markdownString.append("| enforceaccess | `").append(this.plugin.getMVConfig().getEnforceAccess()).append("` |\n");
        markdownString.append("| displaypermerrors | `").append(this.plugin.getMVConfig().getDisplayPermErrors()).append("` |\n");
        markdownString.append("| teleportintercept | `").append(this.plugin.getMVConfig().getTeleportIntercept()).append("` |\n");
        markdownString.append("| firstspawnoverride | `").append(this.plugin.getMVConfig().getFirstSpawnOverride()).append("` |\n");
        markdownString.append("| firstspawnworld | `").append(this.plugin.getMVConfig().getFirstSpawnWorld()).append("` |\n");
        markdownString.append("| debug | `").append(this.plugin.getMVConfig().getGlobalDebug()).append("` |\n");
        return markdownString.toString();
    }

    private String readFile(String filename) {
        String result;
        try {
            String line;
            FileReader reader = new FileReader(filename);
            BufferedReader bufferedReader = new BufferedReader(reader);
            result = "";
            while ((line = bufferedReader.readLine()) != null) {
                result = result + line + '\n';
            }
        }
        catch (FileNotFoundException e) {
            CoreLogging.severe("Unable to find %s. Here's the traceback: %s", filename, e.getMessage());
            e.printStackTrace();
            result = String.format("ERROR: Could not load: %s", filename);
        }
        catch (IOException e) {
            CoreLogging.severe("Something bad happend when reading %s. Here's the traceback: %s", filename, e.getMessage());
            e.printStackTrace();
            result = String.format("ERROR: Could not load: %s", filename);
        }
        return result;
    }

    private Map<String, String> getVersionFiles() {
        HashMap<String, String> files = new HashMap<String, String>();
        files.put("version.md", this.getMarkdownString());
        File configFile = new File(this.plugin.getDataFolder(), "config.yml");
        files.put(configFile.getName(), this.readFile(configFile.getAbsolutePath()));
        File worldConfig = new File(this.plugin.getDataFolder(), "worlds.yml");
        files.put(worldConfig.getName(), this.readFile(worldConfig.getAbsolutePath()));
        return files;
    }

    @Override
    public void runCommand(final CommandSender sender, final List<String> args) {
        String[] lines;
        if (sender instanceof Player) {
            sender.sendMessage("Version info dumped to console. Please check your server logs.");
        }
        MVVersionEvent versionEvent = new MVVersionEvent(this.getLegacyString(), this.getVersionFiles());
        final Map<String, String> files = this.getVersionFiles();
        this.plugin.getServer().getPluginManager().callEvent((Event)versionEvent);
        String versionInfo = versionEvent.getVersionInfo();
        if (CommandHandler.hasFlag("--include-plugin-list", args)) {
            versionInfo = versionInfo + "\nPlugins: " + this.getPluginList();
        }
        final String data = versionInfo;
        for (String line : lines = data.split("\n")) {
            if (line.isEmpty()) continue;
            CoreLogging.info(line, new Object[0]);
        }
        BukkitRunnable logPoster = new BukkitRunnable(){

            public void run() {
                if (args.size() > 0) {
                    String pasteUrl;
                    if (CommandHandler.hasFlag("-b", args)) {
                        pasteUrl = VersionCommand.postToService(PasteServiceType.PASTEBIN, true, data, files);
                    } else if (CommandHandler.hasFlag("-h", args)) {
                        pasteUrl = VersionCommand.postToService(PasteServiceType.HASTEBIN, true, data, files);
                    } else {
                        return;
                    }
                    if (!(sender instanceof ConsoleCommandSender)) {
                        sender.sendMessage("Version info dumped here: " + ChatColor.GREEN + pasteUrl);
                    }
                    CoreLogging.info("Version info dumped here: %s", pasteUrl);
                }
            }
        };
        logPoster.runTaskAsynchronously((Plugin)this.plugin);
    }

    private static String postToService(PasteServiceType type, boolean isPrivate, String pasteData, Map<String, String> pasteFiles) {
        PasteService ps = PasteServiceFactory.getService(type, isPrivate);
        try {
            String result = ps.supportsMultiFile() ? ps.postData(ps.encodeData(pasteFiles), ps.getPostURL()) : ps.postData(ps.encodeData(pasteData), ps.getPostURL());
            return SHORTENER.shorten(result);
        }
        catch (PasteFailedException e) {
            System.out.print(e);
            return "Error posting to service";
        }
    }

    private String getPluginList() {
        return StringUtils.join((Object[])this.plugin.getServer().getPluginManager().getPlugins(), (String)", ");
    }
}

