/*
 * Decompiled with CFR 0.152.
 */
package com.onarandombox.MultiverseCore;

import com.onarandombox.MultiverseCore.MultiverseCore;
import com.onarandombox.MultiverseCore.MultiverseCoreConfiguration;
import com.onarandombox.MultiverseCore.WorldProperties;
import com.onarandombox.MultiverseCore.api.BlockSafety;
import com.onarandombox.MultiverseCore.api.MultiverseWorld;
import com.onarandombox.MultiverseCore.api.SafeTTeleporter;
import com.onarandombox.MultiverseCore.configuration.SpawnLocation;
import com.onarandombox.MultiverseCore.configuration.SpawnSettings;
import com.onarandombox.MultiverseCore.configuration.WorldPropertyValidator;
import com.onarandombox.MultiverseCore.enums.AllowedPortalType;
import com.onarandombox.MultiverseCore.enums.EnglishChatColor;
import com.onarandombox.MultiverseCore.exceptions.PropertyDoesNotExistException;
import com.onarandombox.MultiverseCore.utils.CoreLogging;
import com.onarandombox.serializationconfig.SerializationConfig.ChangeDeniedException;
import com.onarandombox.serializationconfig.SerializationConfig.NoSuchPropertyException;
import com.onarandombox.serializationconfig.SerializationConfig.VirtualProperty;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.logging.Level;
import org.bukkit.ChatColor;
import org.bukkit.Difficulty;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.WorldType;
import org.bukkit.configuration.serialization.SerializableAs;
import org.bukkit.entity.Player;
import org.bukkit.permissions.Permission;
import org.bukkit.permissions.PermissionDefault;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.Nullable;
import org.json.simple.JSONObject;

public class MVWorld
implements MultiverseWorld {
    private static final int SPAWN_LOCATION_SEARCH_TOLERANCE = 16;
    private static final int SPAWN_LOCATION_SEARCH_RADIUS = 16;
    private final MultiverseCore plugin;
    private final String name;
    private final UUID worldUID;
    private final WorldProperties props;
    private Permission permission;
    private Permission exempt;
    private Permission ignoreperm;
    private Permission limitbypassperm;

    public MVWorld(MultiverseCore plugin, World world, WorldProperties properties) {
        this(plugin, world, properties, true);
    }

    public MVWorld(MultiverseCore plugin, World world, WorldProperties properties, boolean fixSpawn) {
        this.plugin = plugin;
        this.name = world.getName();
        this.worldUID = world.getUID();
        this.props = properties;
        this.setupProperties();
        if (!fixSpawn) {
            this.props.setAdjustSpawn(false);
        }
        SpawnLocationPropertyValidator spawnValidator = new SpawnLocationPropertyValidator();
        this.props.setValidator("spawn", spawnValidator);
        this.props.spawnLocation.setWorld(world);
        if (this.props.spawnLocation instanceof NullLocation) {
            SpawnLocation newLoc;
            this.props.spawnLocation = newLoc = new SpawnLocation(this.readSpawnFromWorld(world));
            world.setSpawnLocation(newLoc.getBlockX(), newLoc.getBlockY(), newLoc.getBlockZ());
        }
        this.props.environment = world.getEnvironment();
        this.props.seed = world.getSeed();
        this.initPerms();
        this.props.flushChanges();
        this.validateProperties();
    }

    private void setupProperties() {
        this.props.setMVWorld(this);
        this.props.pvp = new VirtualProperty<Boolean>(){

            @Override
            public void set(Boolean newValue) {
                World world = MVWorld.this.getCBWorld();
                if (world != null) {
                    world.setPVP(newValue.booleanValue());
                }
            }

            @Override
            public Boolean get() {
                World world = MVWorld.this.getCBWorld();
                return world != null ? Boolean.valueOf(world.getPVP()) : null;
            }
        };
        this.props.difficulty = new VirtualProperty<Difficulty>(){

            @Override
            public void set(Difficulty newValue) {
                World world = MVWorld.this.getCBWorld();
                if (world != null) {
                    world.setDifficulty(newValue);
                }
            }

            @Override
            public Difficulty get() {
                World world = MVWorld.this.getCBWorld();
                return world != null ? world.getDifficulty() : null;
            }
        };
        this.props.keepSpawnInMemory = new VirtualProperty<Boolean>(){

            @Override
            public void set(Boolean newValue) {
                World world = MVWorld.this.getCBWorld();
                if (world != null) {
                    world.setKeepSpawnInMemory(newValue.booleanValue());
                }
            }

            @Override
            public Boolean get() {
                World world = MVWorld.this.getCBWorld();
                return world != null ? Boolean.valueOf(world.getKeepSpawnInMemory()) : null;
            }
        };
        this.props.spawn = new VirtualProperty<Location>(){

            @Override
            public void set(Location newValue) {
                if (MVWorld.this.getCBWorld() != null) {
                    MVWorld.this.getCBWorld().setSpawnLocation(newValue.getBlockX(), newValue.getBlockY(), newValue.getBlockZ());
                }
                ((MVWorld)MVWorld.this).props.spawnLocation = new SpawnLocation(newValue);
            }

            @Override
            public Location get() {
                ((MVWorld)MVWorld.this).props.spawnLocation.setWorld(MVWorld.this.getCBWorld());
                return ((MVWorld)MVWorld.this).props.spawnLocation;
            }
        };
        this.props.time = new VirtualProperty<Long>(){

            @Override
            public void set(Long newValue) {
                World world = MVWorld.this.getCBWorld();
                if (world != null) {
                    world.setTime(newValue.longValue());
                }
            }

            @Override
            public Long get() {
                World world = MVWorld.this.getCBWorld();
                return world != null ? Long.valueOf(world.getTime()) : null;
            }
        };
        this.props.setValidator("scale", new ScalePropertyValidator());
        this.props.setValidator("respawnWorld", new RespawnWorldPropertyValidator());
        this.props.setValidator("allowWeather", new AllowWeatherPropertyValidator());
        this.props.setValidator("spawning", new SpawningPropertyValidator());
        this.props.setValidator("gameMode", new GameModePropertyValidator());
    }

    public void validateEntitySpawns() {
        this.setAllowAnimalSpawn(this.canAnimalsSpawn());
        this.setAllowMonsterSpawn(this.canMonstersSpawn());
    }

    private void validateProperties() {
        this.setPVPMode(this.isPVPEnabled());
        this.setDifficulty(this.getDifficulty());
        this.setKeepSpawnInMemory(this.isKeepingSpawnInMemory());
        this.setScaling(this.getScaling());
        this.setRespawnToWorld(this.props.getRespawnToWorld());
        this.validateEntitySpawns();
        this.setGameMode(this.getGameMode());
    }

    private void initPerms() {
        this.permission = new Permission("multiverse.access." + this.getName(), "Allows access to " + this.getName(), PermissionDefault.OP);
        this.ignoreperm = new Permission("mv.bypass.gamemode." + this.getName(), "Allows players with this permission to ignore gamemode changes.", PermissionDefault.FALSE);
        this.exempt = new Permission("multiverse.exempt." + this.getName(), "A player who has this does not pay to enter this world, or use any MV portals in it " + this.getName(), PermissionDefault.OP);
        this.limitbypassperm = new Permission("mv.bypass.playerlimit." + this.getName(), "A player who can enter this world regardless of wether its full", PermissionDefault.OP);
        try {
            this.plugin.getServer().getPluginManager().addPermission(this.permission);
            this.plugin.getServer().getPluginManager().addPermission(this.exempt);
            this.plugin.getServer().getPluginManager().addPermission(this.ignoreperm);
            this.plugin.getServer().getPluginManager().addPermission(this.limitbypassperm);
            this.addToUpperLists(this.permission);
            this.ignoreperm.addParent("mv.bypass.gamemode.*", true);
            this.limitbypassperm.addParent("mv.bypass.playerlimit.*", true);
        }
        catch (IllegalArgumentException e) {
            this.plugin.log(Level.FINER, "Permissions nodes were already added for " + this.name);
        }
    }

    private Location readSpawnFromWorld(World w) {
        Location location = w.getSpawnLocation();
        BlockSafety bs = this.plugin.getBlockSafety();
        if (!bs.playerCanSpawnHereSafely(location)) {
            if (!this.getAdjustSpawn()) {
                this.plugin.log(Level.FINE, "Spawn location from world.dat file was unsafe!!");
                this.plugin.log(Level.FINE, "NOT adjusting spawn for '" + this.getAlias() + "' because you told me not to.");
                this.plugin.log(Level.FINE, "To turn on spawn adjustment for this world simply type:");
                this.plugin.log(Level.FINE, "/mvm set adjustspawn true " + this.getAlias());
                return location;
            }
            SafeTTeleporter teleporter = this.plugin.getSafeTTeleporter();
            this.plugin.log(Level.WARNING, "Spawn location from world.dat file was unsafe. Adjusting...");
            this.plugin.log(Level.WARNING, "Original Location: " + this.plugin.getLocationManipulation().strCoordsRaw(location));
            Location newSpawn = teleporter.getSafeLocation(location, 16, 16);
            if (newSpawn != null) {
                CoreLogging.info("New Spawn for '%s' is located at: %s", this.getName(), this.plugin.getLocationManipulation().locationToString(newSpawn));
                return newSpawn;
            }
            Location newerSpawn = bs.getTopBlock(new Location(w, 0.0, 0.0, 0.0));
            if (newerSpawn != null) {
                CoreLogging.info("New Spawn for '%s' is located at: %s", this.getName(), this.plugin.getLocationManipulation().locationToString(newerSpawn));
                return newerSpawn;
            }
            this.plugin.log(Level.SEVERE, "Safe spawn NOT found!!!");
        }
        return location;
    }

    private void addToUpperLists(Permission perm) {
        Permission all = this.plugin.getServer().getPluginManager().getPermission("multiverse.*");
        Permission allWorlds = this.plugin.getServer().getPluginManager().getPermission("multiverse.access.*");
        Permission allExemption = this.plugin.getServer().getPluginManager().getPermission("multiverse.exempt.*");
        if (allWorlds == null) {
            allWorlds = new Permission("multiverse.access.*");
            this.plugin.getServer().getPluginManager().addPermission(allWorlds);
        }
        allWorlds.getChildren().put(perm.getName(), true);
        if (allExemption == null) {
            allExemption = new Permission("multiverse.exempt.*");
            this.plugin.getServer().getPluginManager().addPermission(allExemption);
        }
        allExemption.getChildren().put(this.exempt.getName(), true);
        if (all == null) {
            all = new Permission("multiverse.*");
            this.plugin.getServer().getPluginManager().addPermission(all);
        }
        all.getChildren().put("multiverse.access.*", true);
        all.getChildren().put("multiverse.exempt.*", true);
        this.plugin.getServer().getPluginManager().recalculatePermissionDefaults(all);
        this.plugin.getServer().getPluginManager().recalculatePermissionDefaults(allWorlds);
    }

    public void copyValues(MVWorld other) {
        this.props.copyValues(other.props);
    }

    public void copyValues(WorldProperties other) {
        this.props.copyValues(other);
    }

    @Override
    public World getCBWorld() {
        World world = this.plugin.getServer().getWorld(this.worldUID);
        if (world == null) {
            throw new IllegalStateException("Lost reference to bukkit world '" + this.name + "'");
        }
        return world;
    }

    @Override
    public String getColoredWorldString() {
        if (this.props.getAlias().length() == 0) {
            this.props.setAlias(this.getName());
        }
        if (this.props.getColor() == null || this.props.getColor().getColor() == null) {
            this.props.setColor(EnglishChatColor.WHITE);
        }
        StringBuilder nameBuilder = new StringBuilder().append(this.props.getColor().getColor());
        if (this.props.getStyle().getColor() != null) {
            nameBuilder.append(this.props.getStyle().getColor());
        }
        nameBuilder.append(this.props.getAlias()).append(ChatColor.WHITE).toString();
        return nameBuilder.toString();
    }

    @Override
    @Deprecated
    public boolean clearList(String property) {
        return this.clearVariable(property);
    }

    @Override
    @Deprecated
    public boolean clearVariable(String property) {
        List<String> list = this.getOldAndEvilList(property);
        if (list == null) {
            return false;
        }
        list.clear();
        this.validateEntitySpawns();
        return true;
    }

    @Override
    @Deprecated
    public boolean addToVariable(String property, String value) {
        List<String> list = this.getOldAndEvilList(property);
        if (list == null) {
            return false;
        }
        list.add(value);
        this.validateEntitySpawns();
        return true;
    }

    @Override
    @Deprecated
    public boolean removeFromVariable(String property, String value) {
        List<String> list = this.getOldAndEvilList(property);
        if (list == null) {
            return false;
        }
        list.remove(value);
        this.validateEntitySpawns();
        return true;
    }

    @Deprecated
    private List<String> getOldAndEvilList(String property) {
        if (property.equalsIgnoreCase("worldblacklist")) {
            return this.props.getWorldBlacklist();
        }
        if (property.equalsIgnoreCase("animals")) {
            return this.props.getAnimalList();
        }
        if (property.equalsIgnoreCase("monsters")) {
            return this.props.getMonsterList();
        }
        return null;
    }

    @Override
    public String getPropertyValue(String property) throws PropertyDoesNotExistException {
        try {
            return this.props.getProperty(property, true);
        }
        catch (NoSuchPropertyException e) {
            throw new PropertyDoesNotExistException(property, e);
        }
    }

    @Override
    public boolean setPropertyValue(String property, String value) throws PropertyDoesNotExistException {
        try {
            return this.props.setProperty(property, value, true);
        }
        catch (NoSuchPropertyException e) {
            throw new PropertyDoesNotExistException(property, e);
        }
    }

    @Override
    public String getPropertyHelp(String property) throws PropertyDoesNotExistException {
        try {
            return this.props.getPropertyDescription(property, true);
        }
        catch (NoSuchPropertyException e) {
            throw new PropertyDoesNotExistException(property, e);
        }
    }

    @Override
    public WorldType getWorldType() {
        World world = this.getCBWorld();
        return world != null ? world.getWorldType() : null;
    }

    @Override
    public World.Environment getEnvironment() {
        return this.props.getEnvironment();
    }

    @Override
    public void setEnvironment(World.Environment environment) {
        this.props.setEnvironment(environment);
    }

    @Override
    public long getSeed() {
        return this.props.getSeed();
    }

    @Override
    public void setSeed(long seed) {
        this.props.setSeed(seed);
    }

    @Override
    public String getGenerator() {
        return this.props.getGenerator();
    }

    @Override
    public void setGenerator(String generator) {
        this.props.setGenerator(generator);
    }

    @Override
    public int getPlayerLimit() {
        return this.props.getPlayerLimit();
    }

    @Override
    public void setPlayerLimit(int limit) {
        this.props.setPlayerLimit(limit);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getPermissibleName() {
        return this.name.toLowerCase();
    }

    @Override
    public String getAlias() {
        if (this.props.getAlias() == null || this.props.getAlias().length() == 0) {
            return this.name;
        }
        return this.props.getAlias();
    }

    @Override
    public void setAlias(String alias) {
        this.props.setAlias(alias);
    }

    @Override
    public boolean canAnimalsSpawn() {
        return this.props.canAnimalsSpawn();
    }

    @Override
    public void setAllowAnimalSpawn(boolean animals) {
        this.props.setAllowAnimalSpawn(animals);
    }

    @Override
    public List<String> getAnimalList() {
        return this.props.getAnimalList();
    }

    @Override
    public boolean canMonstersSpawn() {
        return this.props.canMonstersSpawn();
    }

    @Override
    public void setAllowMonsterSpawn(boolean monsters) {
        this.props.setAllowMonsterSpawn(monsters);
    }

    @Override
    public List<String> getMonsterList() {
        return this.props.getMonsterList();
    }

    @Override
    public boolean isPVPEnabled() {
        return this.props.isPVPEnabled();
    }

    @Override
    public void setPVPMode(boolean pvp) {
        this.props.setPVPMode(pvp);
    }

    @Override
    public boolean isHidden() {
        return this.props.isHidden();
    }

    @Override
    public void setHidden(boolean hidden) {
        this.props.setHidden(hidden);
    }

    @Override
    public List<String> getWorldBlacklist() {
        return this.props.getWorldBlacklist();
    }

    @Override
    public double getScaling() {
        return this.props.getScaling();
    }

    @Override
    public boolean setScaling(double scaling) {
        return this.props.setScaling(scaling);
    }

    @Override
    public boolean setColor(String aliasColor) {
        return this.props.setColor(aliasColor);
    }

    @Override
    @Deprecated
    public boolean isValidAliasColor(String aliasColor) {
        return EnglishChatColor.fromString(aliasColor) != null;
    }

    @Override
    public ChatColor getColor() {
        return this.props.getColor().getColor();
    }

    @Override
    @Deprecated
    public boolean getFakePVP() {
        return false;
    }

    @Override
    public World getRespawnToWorld() {
        return this.plugin.getServer().getWorld(this.props.getRespawnToWorld());
    }

    @Override
    public boolean setRespawnToWorld(String respawnToWorld) {
        if (!this.plugin.getMVWorldManager().isMVWorld(respawnToWorld)) {
            return false;
        }
        return this.props.setRespawnToWorld(respawnToWorld);
    }

    @Override
    public Permission getAccessPermission() {
        return this.permission;
    }

    @Override
    public Material getCurrency() {
        return this.props.getCurrency();
    }

    @Override
    public void setCurrency(@Nullable Material currency) {
        this.props.setCurrency(currency);
    }

    @Override
    public double getPrice() {
        return this.props.getPrice();
    }

    @Override
    public void setPrice(double price) {
        this.props.setPrice(price);
    }

    @Override
    public Permission getExemptPermission() {
        return this.exempt;
    }

    @Override
    public boolean setGameMode(String mode) {
        return this.props.setGameMode(mode);
    }

    @Override
    public boolean setGameMode(GameMode mode) {
        return this.props.setGameMode(mode);
    }

    @Override
    public GameMode getGameMode() {
        return this.props.getGameMode();
    }

    @Override
    public void setEnableWeather(boolean weather) {
        this.props.setEnableWeather(weather);
    }

    @Override
    public boolean isWeatherEnabled() {
        return this.props.isWeatherEnabled();
    }

    @Override
    public boolean isKeepingSpawnInMemory() {
        return this.props.isKeepingSpawnInMemory();
    }

    @Override
    public void setKeepSpawnInMemory(boolean value) {
        this.props.setKeepSpawnInMemory(value);
    }

    @Override
    public boolean getHunger() {
        return this.props.getHunger();
    }

    @Override
    public void setHunger(boolean hunger) {
        this.props.setHunger(hunger);
    }

    @Override
    public Location getSpawnLocation() {
        return this.props.getSpawnLocation();
    }

    @Override
    public void setSpawnLocation(Location l) {
        this.props.setSpawnLocation(l);
    }

    @Override
    public Difficulty getDifficulty() {
        return this.props.getDifficulty();
    }

    @Override
    @Deprecated
    public boolean setDifficulty(String difficulty) {
        return this.props.setDifficulty(difficulty);
    }

    @Override
    public boolean setDifficulty(Difficulty difficulty) {
        return this.props.setDifficulty(difficulty);
    }

    @Override
    public boolean getAutoHeal() {
        return this.props.getAutoHeal();
    }

    @Override
    public void setAutoHeal(boolean heal) {
        this.props.setAutoHeal(heal);
    }

    @Override
    public void setAdjustSpawn(boolean adjust) {
        this.props.setAdjustSpawn(adjust);
    }

    @Override
    public boolean getAdjustSpawn() {
        return this.props.getAdjustSpawn();
    }

    @Override
    public void setAutoLoad(boolean load) {
        this.props.setAutoLoad(load);
    }

    @Override
    public boolean getAutoLoad() {
        return this.props.getAutoLoad();
    }

    @Override
    public void setBedRespawn(boolean respawn) {
        this.props.setBedRespawn(respawn);
    }

    @Override
    public boolean getBedRespawn() {
        return this.props.getBedRespawn();
    }

    @Override
    public String getAllPropertyNames() {
        return this.props.getAllPropertyNames();
    }

    @Override
    public String getTime() {
        return this.props.getTime();
    }

    @Override
    public boolean setTime(String timeAsString) {
        return this.props.setTime(timeAsString);
    }

    @Override
    public AllowedPortalType getAllowedPortals() {
        return this.props.getAllowedPortals();
    }

    @Override
    public void allowPortalMaking(AllowedPortalType portalType) {
        this.props.allowPortalMaking(portalType);
    }

    @Override
    public ChatColor getStyle() {
        return this.props.getStyle().getColor();
    }

    @Override
    public boolean setStyle(String style) {
        return this.props.setStyle(style);
    }

    @Override
    public boolean getAllowFlight() {
        return this.props.getAllowFlight();
    }

    @Override
    public void setAllowFlight(boolean allowFlight) {
        this.props.setAllowFlight(allowFlight);
    }

    public String toString() {
        JSONObject jsonData = new JSONObject();
        jsonData.put((Object)"Name", (Object)this.getName());
        jsonData.put((Object)"Env", (Object)this.getEnvironment().toString());
        jsonData.put((Object)"Type", (Object)this.getWorldType().toString());
        jsonData.put((Object)"Gen", (Object)this.getGenerator());
        JSONObject topLevel = new JSONObject();
        topLevel.put((Object)(this.getClass().getSimpleName() + "@" + this.hashCode()), (Object)jsonData);
        return topLevel.toString();
    }

    @SerializableAs(value="MVNullLocation (It's a bug if you see this in your config file)")
    public static final class NullLocation
    extends SpawnLocation {
        public NullLocation() {
            super(0.0, -1.0, 0.0);
        }

        public Location clone() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Map<String, Object> serialize() {
            return Collections.EMPTY_MAP;
        }

        public static NullLocation deserialize(Map<String, Object> args) {
            return new NullLocation();
        }

        public Vector toVector() {
            throw new UnsupportedOperationException();
        }

        public int hashCode() {
            return -1;
        }

        public String toString() {
            return "NULL LOCATION";
        }
    }

    private final class SpawnLocationPropertyValidator
    extends WorldPropertyValidator<Location> {
        private SpawnLocationPropertyValidator() {
        }

        @Override
        public Location validateChange(String property, Location newValue, Location oldValue, MVWorld object) throws ChangeDeniedException {
            BlockSafety bs;
            if (newValue == null) {
                throw new ChangeDeniedException();
            }
            if (MVWorld.this.props.getAdjustSpawn() && !(bs = MVWorld.this.plugin.getBlockSafety()).playerCanSpawnHereSafely(newValue)) {
                MVWorld.this.plugin.log(Level.WARNING, String.format("Somebody tried to set the spawn location for '%s' to an unsafe value! Adjusting...", MVWorld.this.getAlias()));
                MVWorld.this.plugin.log(Level.WARNING, "Old Location: " + MVWorld.this.plugin.getLocationManipulation().strCoordsRaw(oldValue));
                MVWorld.this.plugin.log(Level.WARNING, "New (unsafe) Location: " + MVWorld.this.plugin.getLocationManipulation().strCoordsRaw(newValue));
                SafeTTeleporter teleporter = MVWorld.this.plugin.getSafeTTeleporter();
                newValue = teleporter.getSafeLocation(newValue, 16, 16);
                if (newValue == null) {
                    MVWorld.this.plugin.log(Level.WARNING, "Couldn't fix the location. I have to abort the spawn location-change :/");
                    throw new ChangeDeniedException();
                }
                MVWorld.this.plugin.log(Level.WARNING, "New (safe) Location: " + MVWorld.this.plugin.getLocationManipulation().strCoordsRaw(newValue));
            }
            return super.validateChange(property, newValue, oldValue, object);
        }
    }

    private final class GameModePropertyValidator
    extends WorldPropertyValidator<GameMode> {
        private GameModePropertyValidator() {
        }

        @Override
        public GameMode validateChange(String property, GameMode newValue, GameMode oldValue, MVWorld object) throws ChangeDeniedException {
            for (Player p : MVWorld.this.plugin.getServer().getWorld(MVWorld.this.getName()).getPlayers()) {
                MVWorld.this.plugin.log(Level.FINER, String.format("Setting %s's GameMode to %s", p.getName(), newValue.toString()));
                MVWorld.this.plugin.getPlayerListener().handleGameModeAndFlight(p, MVWorld.this);
            }
            return super.validateChange(property, newValue, oldValue, object);
        }
    }

    private final class SpawningPropertyValidator
    extends WorldPropertyValidator<SpawnSettings> {
        private SpawningPropertyValidator() {
        }

        @Override
        public SpawnSettings validateChange(String property, SpawnSettings newValue, SpawnSettings oldValue, MVWorld object) throws ChangeDeniedException {
            boolean allowAnimals = MVWorld.this.getAnimalList().isEmpty() ? MVWorld.this.canAnimalsSpawn() : true;
            boolean allowMonsters = MVWorld.this.getMonsterList().isEmpty() ? MVWorld.this.canMonstersSpawn() : true;
            World world = MVWorld.this.getCBWorld();
            if (world != null) {
                if (MVWorld.this.props.getAnimalSpawnRate() != -1) {
                    world.setTicksPerAnimalSpawns(MVWorld.this.props.getAnimalSpawnRate());
                }
                if (MVWorld.this.props.getMonsterSpawnRate() != -1) {
                    world.setTicksPerMonsterSpawns(MVWorld.this.props.getMonsterSpawnRate());
                }
                world.setSpawnFlags(allowMonsters, allowAnimals);
            }
            if (MultiverseCoreConfiguration.getInstance().isAutoPurgeEnabled()) {
                MVWorld.this.plugin.getMVWorldManager().getTheWorldPurger().purgeWorld(MVWorld.this);
            }
            return super.validateChange(property, newValue, oldValue, object);
        }
    }

    private final class AllowWeatherPropertyValidator
    extends WorldPropertyValidator<Boolean> {
        private AllowWeatherPropertyValidator() {
        }

        @Override
        public Boolean validateChange(String property, Boolean newValue, Boolean oldValue, MVWorld object) throws ChangeDeniedException {
            World world;
            if (!newValue.booleanValue() && (world = MVWorld.this.getCBWorld()) != null) {
                world.setStorm(false);
                world.setThundering(false);
            }
            return super.validateChange(property, newValue, oldValue, object);
        }
    }

    private final class RespawnWorldPropertyValidator
    extends WorldPropertyValidator<String> {
        private RespawnWorldPropertyValidator() {
        }

        @Override
        public String validateChange(String property, String newValue, String oldValue, MVWorld object) throws ChangeDeniedException {
            if (!newValue.isEmpty() && !MVWorld.this.plugin.getMVWorldManager().isMVWorld(newValue)) {
                throw new ChangeDeniedException();
            }
            return super.validateChange(property, newValue, oldValue, object);
        }
    }

    private final class ScalePropertyValidator
    extends WorldPropertyValidator<Double> {
        private ScalePropertyValidator() {
        }

        @Override
        public Double validateChange(String property, Double newValue, Double oldValue, MVWorld object) throws ChangeDeniedException {
            if (newValue <= 0.0) {
                MVWorld.this.plugin.log(Level.FINE, "Someone tried to set a scale <= 0, aborting!");
                throw new ChangeDeniedException();
            }
            return super.validateChange(property, newValue, oldValue, object);
        }
    }
}

