/*
 * Decompiled with CFR 0.152.
 */
package de.myzelyam.supervanish.visibility.hiders;

import de.myzelyam.supervanish.SuperVanish;
import de.myzelyam.supervanish.utils.BukkitPlayerHidingUtil;
import de.myzelyam.supervanish.visibility.hiders.PlayerHider;
import java.util.Set;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class PreventionHider
extends PlayerHider
implements Runnable {
    private int taskId;

    public PreventionHider(SuperVanish plugin) {
        super(plugin);
        this.taskId = plugin.getServer().getScheduler().runTaskTimer((Plugin)plugin, (Runnable)this, 1L, 1L).getTaskId();
    }

    @Override
    public boolean setHidden(Player player, Player viewer, boolean hidden) {
        if (super.setHidden(player, viewer, hidden)) {
            if (hidden) {
                BukkitPlayerHidingUtil.hidePlayer(player, viewer, this.plugin);
            } else {
                BukkitPlayerHidingUtil.showPlayer(player, viewer, this.plugin);
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean supportsShowInTab() {
        return false;
    }

    @Override
    public String getName() {
        return "Prevention";
    }

    @Override
    public void run() {
        for (Player hidden : this.playerHiddenFromPlayersMap.keySet()) {
            if (BukkitPlayerHidingUtil.isNewPlayerHidingAPISupported(hidden)) {
                this.plugin.getServer().getScheduler().cancelTask(this.taskId);
                return;
            }
            for (Player viewer : (Set)this.playerHiddenFromPlayersMap.get(hidden)) {
                BukkitPlayerHidingUtil.hidePlayer(hidden, viewer, this.plugin);
            }
        }
    }
}

