/*
 * Decompiled with CFR 0.152.
 */
package de.myzelyam.supervanish.net;

import de.myzelyam.supervanish.SuperVanish;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import java.util.logging.Level;
import javax.net.ssl.HttpsURLConnection;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitTask;

public class UpdateNotifier {
    private static final long CHECK_INTERVAL = 24000L;
    private final SuperVanish plugin;
    private final BukkitTask checkTask;
    private final String currentVersion;
    private final Set<UUID> notifiedPlayers = new HashSet<UUID>();
    private volatile String latestVersion;
    private boolean notifiedConsole = false;

    public UpdateNotifier(final SuperVanish plugin) {
        this.plugin = plugin;
        this.currentVersion = plugin.getDescription().getVersion();
        this.checkTask = this.start();
        Bukkit.getPluginManager().registerEvents(new Listener(){

            @EventHandler
            public void onJoin(final PlayerJoinEvent e) {
                new BukkitRunnable(){

                    public void run() {
                        if (!UpdateNotifier.this.isUpToDate()) {
                            UpdateNotifier.this.notifyPlayer(e.getPlayer());
                        }
                    }
                }.runTaskLater((Plugin)plugin, 2L);
            }
        }, (Plugin)plugin);
    }

    public boolean isUpToDate() {
        try {
            if (this.latestVersion == null) {
                throw new NumberFormatException();
            }
            int comparision = this.plugin.getVersionUtil().compareVersions(this.currentVersion, this.latestVersion);
            return comparision >= 0;
        }
        catch (NumberFormatException e) {
            return this.currentVersion.equals(this.latestVersion);
        }
    }

    private void notifyPlayer(Player p) {
        if (p.hasPermission("sv.notify") && this.latestVersion != null) {
            if (this.notifiedPlayers.contains(p.getUniqueId())) {
                return;
            }
            this.notifiedPlayers.add(p.getUniqueId());
            this.plugin.sendMessage((CommandSender)p, this.plugin.getMessage("PluginOutdated").replace("%new%", this.latestVersion).replace("%current%", this.currentVersion), p);
        }
    }

    private void notifyAdmins() {
        for (Player p : this.plugin.getServer().getOnlinePlayers()) {
            this.notifyPlayer(p);
        }
    }

    private void notifyConsole() {
        if (!this.notifiedConsole) {
            this.plugin.log(Level.INFO, "Your current version of SuperVanish is outdated - New version: '" + this.latestVersion + "'; Currently: '" + this.currentVersion + "'");
            this.notifiedConsole = true;
        }
    }

    private BukkitTask start() {
        if (this.checkTask != null) {
            throw new IllegalStateException("Task is already running");
        }
        return new BukkitRunnable(){

            public void run() {
                String latestVersion = UpdateNotifier.this.fetchLatestVersion();
                UpdateNotifier.this.latestVersion = latestVersion.equals("Error") ? (UpdateNotifier.this.latestVersion == null ? UpdateNotifier.this.currentVersion : UpdateNotifier.this.latestVersion) : latestVersion;
                if (!UpdateNotifier.this.isUpToDate()) {
                    new BukkitRunnable(){

                        public void run() {
                            UpdateNotifier.this.notifyConsole();
                            if (UpdateNotifier.this.plugin.getSettings().getBoolean("MiscellaneousOptions.UpdateChecker.NotifyAdmins")) {
                                UpdateNotifier.this.notifyAdmins();
                            }
                        }
                    }.runTask((Plugin)UpdateNotifier.this.plugin);
                }
            }
        }.runTaskTimerAsynchronously((Plugin)this.plugin, 0L, 24000L);
    }

    private String fetchLatestVersion() {
        try {
            String version;
            HttpsURLConnection con = (HttpsURLConnection)new URL("https://api.spigotmc.org/legacy/update.php?resource=1331").openConnection();
            con.setConnectTimeout(20000);
            con.setReadTimeout(20000);
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(con.getInputStream()));){
                version = reader.readLine();
            }
            con.disconnect();
            if (version.length() <= 7) {
                return version;
            }
            throw new RuntimeException("'" + version + "' is not a valid version");
        }
        catch (Exception e) {
            this.plugin.log(Level.WARNING, "Failed to check for an update: " + e.getMessage());
            return "Error";
        }
    }

    public String getCurrentVersion() {
        return this.currentVersion;
    }

    public String getLatestVersion() {
        return this.latestVersion;
    }
}

