/*
 * Decompiled with CFR 0.152.
 */
package de.myzelyam.supervanish.features;

import com.comphenix.protocol.PacketType;
import com.comphenix.protocol.ProtocolLibrary;
import com.comphenix.protocol.events.ListenerPriority;
import com.comphenix.protocol.events.PacketAdapter;
import com.comphenix.protocol.events.PacketEvent;
import com.comphenix.protocol.events.PacketListener;
import com.comphenix.protocol.wrappers.EnumWrappers;
import com.comphenix.protocol.wrappers.PlayerInfoData;
import com.google.common.collect.ImmutableList;
import de.myzelyam.api.vanish.PlayerShowEvent;
import de.myzelyam.supervanish.SuperVanish;
import de.myzelyam.supervanish.features.Feature;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.block.Action;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.event.player.PlayerGameModeChangeEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryView;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class SilentOpenChest
extends Feature {
    private final Map<Player, StateInfo> playerStateInfoMap = new HashMap<Player, StateInfo>();
    private final Collection<Material> shulkerBoxes = new ArrayList<Material>();

    public SilentOpenChest(SuperVanish plugin) {
        super(plugin);
        if (plugin.getVersionUtil().isOneDotXOrHigher(11)) {
            try {
                InventoryType testInvType = InventoryType.SHULKER_BOX;
                this.shulkerBoxes.addAll(Arrays.asList(Material.BLACK_SHULKER_BOX, Material.BLUE_SHULKER_BOX, Material.BROWN_SHULKER_BOX, Material.CYAN_SHULKER_BOX, Material.GRAY_SHULKER_BOX, Material.GREEN_SHULKER_BOX, Material.LIGHT_BLUE_SHULKER_BOX, Material.LIME_SHULKER_BOX, Material.MAGENTA_SHULKER_BOX, Material.ORANGE_SHULKER_BOX, Material.PINK_SHULKER_BOX, Material.PURPLE_SHULKER_BOX, Material.RED_SHULKER_BOX, Material.WHITE_SHULKER_BOX, Material.YELLOW_SHULKER_BOX));
                try {
                    this.shulkerBoxes.add(Material.LIGHT_GRAY_SHULKER_BOX);
                }
                catch (NoSuchFieldError e) {
                    this.shulkerBoxes.add(Material.valueOf((String)"SILVER_SHULKER_BOX"));
                }
                if (plugin.getVersionUtil().isOneDotXOrHigher(14)) {
                    this.shulkerBoxes.add(Material.valueOf((String)"BARREL"));
                }
            }
            catch (IllegalArgumentException | NoSuchFieldError throwable) {
                // empty catch block
            }
        }
    }

    @Override
    public void onDisable() {
        for (Player p : this.playerStateInfoMap.keySet()) {
            StateInfo stateInfo = this.playerStateInfoMap.remove(p);
            if (stateInfo == null) continue;
            this.restoreState(stateInfo, p);
        }
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onSpectatorClick(InventoryClickEvent e) {
        if (!(e.getWhoClicked() instanceof Player)) {
            return;
        }
        Player p = (Player)e.getWhoClicked();
        if (!this.plugin.getVanishStateMgr().isVanished(p.getUniqueId())) {
            return;
        }
        if (!this.playerStateInfoMap.containsKey(p)) {
            return;
        }
        if (p.getGameMode() != GameMode.SURVIVAL && p.getGameMode() != GameMode.ADVENTURE && p.getGameMode() != GameMode.CREATIVE) {
            e.setCancelled(false);
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onQuit(PlayerQuitEvent e) {
        Player p = e.getPlayer();
        StateInfo stateInfo = this.playerStateInfoMap.remove(p);
        if (stateInfo == null) {
            return;
        }
        this.restoreState(stateInfo, p);
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onTeleport(PlayerTeleportEvent e) {
        Player p = e.getPlayer();
        if (this.playerStateInfoMap.containsKey(p) && e.getCause() == PlayerTeleportEvent.TeleportCause.SPECTATE) {
            e.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onReappear(PlayerShowEvent e) {
        Player p = e.getPlayer();
        StateInfo stateInfo = this.playerStateInfoMap.remove(p);
        if (stateInfo == null) {
            return;
        }
        this.restoreState(stateInfo, p);
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onMove(PlayerMoveEvent e) {
        Player p = e.getPlayer();
        if (!(!this.playerStateInfoMap.containsKey(p) || p.getOpenInventory().getType() == InventoryType.CHEST || this.plugin.getVersionUtil().isOneDotXOrHigher(11) && this.isShulkerBox(p.getOpenInventory()))) {
            this.restoreState(this.playerStateInfoMap.get(p), p);
            this.playerStateInfoMap.remove(p);
        }
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onGameModeChange(PlayerGameModeChangeEvent e) {
        Player p = e.getPlayer();
        if (this.playerStateInfoMap.containsKey(p) && e.getNewGameMode() != GameMode.SPECTATOR && e.isCancelled()) {
            e.setCancelled(false);
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onChestInteract(PlayerInteractEvent e) {
        Player p = e.getPlayer();
        if (!this.plugin.getVanishStateMgr().isVanished(p.getUniqueId())) {
            return;
        }
        if (e.getAction() != Action.RIGHT_CLICK_BLOCK) {
            return;
        }
        if (p.getGameMode() == GameMode.SPECTATOR) {
            return;
        }
        if (p.isSneaking() && p.getItemInHand() != null && p.getItemInHand().getType().isBlock() && p.getItemInHand().getType() != Material.AIR) {
            return;
        }
        Block block = e.getClickedBlock();
        if (block == null) {
            return;
        }
        if (block.getType() == Material.ENDER_CHEST) {
            e.setCancelled(true);
            p.openInventory(p.getEnderChest());
            return;
        }
        if (!(block.getType() == Material.CHEST || block.getType() == Material.TRAPPED_CHEST || this.plugin.getVersionUtil().isOneDotXOrHigher(11) && this.shulkerBoxes.contains(block.getType()))) {
            return;
        }
        StateInfo stateInfo = StateInfo.extract(p);
        this.playerStateInfoMap.put(p, stateInfo);
        p.setGameMode(GameMode.SPECTATOR);
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onChestClose(InventoryCloseEvent e) {
        if (!(e.getPlayer() instanceof Player)) {
            return;
        }
        final Player p = (Player)e.getPlayer();
        if (!this.playerStateInfoMap.containsKey(p)) {
            return;
        }
        if (!(p.getInventory().getType() == InventoryType.CHEST || this.plugin.getVersionUtil().isOneDotXOrHigher(11) && this.isShulkerBox((Inventory)p.getInventory()))) {
            return;
        }
        new BukkitRunnable(){

            public void run() {
                StateInfo stateInfo = (StateInfo)SilentOpenChest.this.playerStateInfoMap.get(p);
                if (stateInfo == null) {
                    return;
                }
                SilentOpenChest.this.restoreState(stateInfo, p);
                SilentOpenChest.this.playerStateInfoMap.remove(p);
            }
        }.runTaskLater((Plugin)this.plugin, 1L);
    }

    private void restoreState(StateInfo stateInfo, Player p) {
        p.setGameMode(stateInfo.gameMode);
        p.setAllowFlight(stateInfo.canFly);
        p.setFlying(stateInfo.isFlying);
    }

    @Override
    public boolean isActive() {
        return this.plugin.getSettings().getBoolean("InvisibilityFeatures.OpenChestsSilently");
    }

    private boolean isShulkerBox(Inventory inv) {
        try {
            return inv.getType() == InventoryType.SHULKER_BOX;
        }
        catch (NoSuchFieldError e) {
            return false;
        }
    }

    private boolean isShulkerBox(InventoryView inv) {
        try {
            return inv.getType() == InventoryType.SHULKER_BOX;
        }
        catch (NoSuchFieldError e) {
            return false;
        }
    }

    public boolean hasSilentlyOpenedChest(Player p) {
        return this.playerStateInfoMap.containsKey(p);
    }

    @Override
    public void onEnable() {
        ProtocolLibrary.getProtocolManager().addPacketListener((PacketListener)new PacketAdapter((Plugin)this.plugin, ListenerPriority.LOW, new PacketType[]{PacketType.Play.Server.PLAYER_INFO, PacketType.Play.Server.GAME_STATE_CHANGE, PacketType.Play.Server.ABILITIES, PacketType.Play.Server.ENTITY_METADATA}){

            public void onPacketSending(PacketEvent event) {
                block17: {
                    try {
                        int entityID;
                        if (event.getPacketType() == PacketType.Play.Server.PLAYER_INFO) {
                            event.setPacket(event.getPacket().shallowClone());
                            ArrayList<PlayerInfoData> infoDataList = new ArrayList<PlayerInfoData>((Collection)event.getPacket().getPlayerInfoDataLists().read(0));
                            Player receiver = event.getPlayer();
                            for (PlayerInfoData infoData : ImmutableList.copyOf(infoDataList)) {
                                int latency;
                                if (SilentOpenChest.this.plugin.getVisibilityChanger().getHider().isHidden(infoData.getProfile().getUUID(), receiver) || !SilentOpenChest.this.plugin.getVanishStateMgr().isVanished(infoData.getProfile().getUUID())) continue;
                                Player vanishedTabPlayer = Bukkit.getPlayer((UUID)infoData.getProfile().getUUID());
                                if (infoData.getGameMode() != EnumWrappers.NativeGameMode.SPECTATOR || !SilentOpenChest.this.hasSilentlyOpenedChest(vanishedTabPlayer) || event.getPacket().getPlayerInfoAction().read(0) != EnumWrappers.PlayerInfoAction.UPDATE_GAME_MODE) continue;
                                try {
                                    latency = infoData.getLatency();
                                }
                                catch (NoSuchMethodError e) {
                                    latency = 21;
                                }
                                PlayerInfoData newData = new PlayerInfoData(infoData.getProfile(), latency, EnumWrappers.NativeGameMode.SURVIVAL, infoData.getDisplayName());
                                infoDataList.remove(infoData);
                                infoDataList.add(newData);
                            }
                            event.getPacket().getPlayerInfoDataLists().write(0, infoDataList);
                            break block17;
                        }
                        if (event.getPacketType() == PacketType.Play.Server.GAME_STATE_CHANGE) {
                            if (SilentOpenChest.this.plugin.getVanishStateMgr().isVanished(event.getPlayer().getUniqueId())) {
                                if ((Integer)event.getPacket().getIntegers().read(0) != 3) {
                                    return;
                                }
                                if (!SilentOpenChest.this.hasSilentlyOpenedChest(event.getPlayer())) {
                                    return;
                                }
                                event.setCancelled(true);
                            }
                        } else if (event.getPacketType() == PacketType.Play.Server.ABILITIES) {
                            if (SilentOpenChest.this.plugin.getVanishStateMgr().isVanished(event.getPlayer().getUniqueId())) {
                                if (!SilentOpenChest.this.hasSilentlyOpenedChest(event.getPlayer())) {
                                    return;
                                }
                                event.setCancelled(true);
                            }
                        } else if (event.getPacketType() == PacketType.Play.Server.ENTITY_METADATA && (entityID = ((Integer)event.getPacket().getIntegers().read(0)).intValue()) == event.getPlayer().getEntityId() && SilentOpenChest.this.plugin.getVanishStateMgr().isVanished(event.getPlayer().getUniqueId())) {
                            if (!SilentOpenChest.this.hasSilentlyOpenedChest(event.getPlayer())) {
                                return;
                            }
                            event.setCancelled(true);
                        }
                    }
                    catch (Exception e) {
                        if (e.getMessage() != null && e.getMessage().endsWith("is not supported for temporary players.")) break block17;
                        SilentOpenChest.this.plugin.logException(e);
                    }
                }
            }
        });
    }

    private static class StateInfo {
        private final boolean canFly;
        private final boolean isFlying;
        private final GameMode gameMode;

        static StateInfo extract(Player p) {
            return new StateInfo(p.getAllowFlight(), p.isFlying(), p.getGameMode());
        }

        public StateInfo(boolean canFly, boolean isFlying, GameMode gameMode) {
            this.canFly = canFly;
            this.isFlying = isFlying;
            this.gameMode = gameMode;
        }

        public boolean isCanFly() {
            return this.canFly;
        }

        public boolean isFlying() {
            return this.isFlying;
        }

        public GameMode getGameMode() {
            return this.gameMode;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof StateInfo)) {
                return false;
            }
            StateInfo other = (StateInfo)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.isCanFly() != other.isCanFly()) {
                return false;
            }
            if (this.isFlying() != other.isFlying()) {
                return false;
            }
            GameMode this$gameMode = this.getGameMode();
            GameMode other$gameMode = other.getGameMode();
            return !(this$gameMode == null ? other$gameMode != null : !this$gameMode.equals(other$gameMode));
        }

        protected boolean canEqual(Object other) {
            return other instanceof StateInfo;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isCanFly() ? 79 : 97);
            result = result * 59 + (this.isFlying() ? 79 : 97);
            GameMode $gameMode = this.getGameMode();
            result = result * 59 + ($gameMode == null ? 43 : $gameMode.hashCode());
            return result;
        }

        public String toString() {
            return "SilentOpenChest.StateInfo(canFly=" + this.isCanFly() + ", isFlying=" + this.isFlying() + ", gameMode=" + this.getGameMode() + ")";
        }
    }
}

