/*
 * Decompiled with CFR 0.152.
 */
package de.myzelyam.supervanish.features;

import de.myzelyam.supervanish.SuperVanish;
import de.myzelyam.supervanish.features.Broadcast;
import de.myzelyam.supervanish.features.Feature;
import de.myzelyam.supervanish.features.NightVision;
import de.myzelyam.supervanish.features.SilentOpenChest;
import de.myzelyam.supervanish.features.VanishIndication;
import de.myzelyam.supervanish.utils.Requirement;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.bukkit.Bukkit;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;

public class FeatureMgr {
    private static Requirement<FeatureInfo> protocolLibInstalled = new Requirement<FeatureInfo>(){

        @Override
        public boolean fulfilledBy(FeatureInfo featureInfo) {
            return Bukkit.getPluginManager().isPluginEnabled("ProtocolLib");
        }
    };
    private static Requirement<FeatureInfo> oneDotEightOrHigher = new Requirement<FeatureInfo>(){

        @Override
        public boolean fulfilledBy(FeatureInfo featureInfo) {
            return featureInfo.getPlugin().getVersionUtil().isOneDotXOrHigher(8);
        }
    };
    private final Map<String, FeatureInfo> registeredFeatures = new HashMap<String, FeatureInfo>();
    private final Set<Feature> activeFeatures = new HashSet<Feature>();
    private final SuperVanish plugin;

    public FeatureMgr(SuperVanish plugin) {
        this.plugin = plugin;
        this.registeredFeatures.put("SilentOpenChest", new FeatureInfo(SilentOpenChest.class, plugin, Arrays.asList(protocolLibInstalled, oneDotEightOrHigher)));
        this.registeredFeatures.put("NightVision", new FeatureInfo(NightVision.class, plugin, Arrays.asList(protocolLibInstalled, oneDotEightOrHigher)));
        this.registeredFeatures.put("VanishIndication", new FeatureInfo(VanishIndication.class, plugin, Arrays.asList(protocolLibInstalled, oneDotEightOrHigher)));
        this.registeredFeatures.put("Broadcast", new FeatureInfo(Broadcast.class, plugin));
    }

    public void enableFeatures() {
        block2: for (String id : this.registeredFeatures.keySet()) {
            Feature feature;
            FeatureInfo featureInfo = this.registeredFeatures.get(id);
            for (Requirement<FeatureInfo> requirement : featureInfo.getRequirements()) {
                if (requirement.fulfilledBy(featureInfo)) continue;
                continue block2;
            }
            try {
                feature = featureInfo.getFeatureClass().getConstructor(SuperVanish.class).newInstance(this.plugin);
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                this.plugin.logException(e);
                continue;
            }
            if (!feature.isActive()) continue;
            this.activeFeatures.add(feature);
            Bukkit.getPluginManager().registerEvents((Listener)feature, (Plugin)this.plugin);
            feature.onEnable();
        }
    }

    public void disableFeatures() {
        for (Feature feature : this.activeFeatures) {
            feature.onDisable();
            HandlerList.unregisterAll((Listener)feature);
        }
        this.activeFeatures.clear();
    }

    public <T extends Feature> T getFeature(Class<T> featureClass) {
        for (Feature feature : this.activeFeatures) {
            if (!feature.getClass().equals(featureClass)) continue;
            return (T)feature;
        }
        return null;
    }

    public Set<Feature> getActiveFeatures() {
        return this.activeFeatures;
    }

    private static class FeatureInfo {
        private final Class<? extends Feature> featureClass;
        private final Collection<Requirement<FeatureInfo>> requirements;
        private final SuperVanish plugin;

        FeatureInfo(Class<? extends Feature> featureClass, SuperVanish plugin, Collection<Requirement<FeatureInfo>> requirements) {
            this.featureClass = featureClass;
            this.requirements = requirements;
            this.plugin = plugin;
        }

        FeatureInfo(Class<? extends Feature> featureClass, SuperVanish plugin) {
            this(featureClass, plugin, Collections.emptySet());
        }

        public Class<? extends Feature> getFeatureClass() {
            return this.featureClass;
        }

        public Collection<Requirement<FeatureInfo>> getRequirements() {
            return this.requirements;
        }

        public SuperVanish getPlugin() {
            return this.plugin;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof FeatureInfo)) {
                return false;
            }
            FeatureInfo other = (FeatureInfo)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Class<? extends Feature> this$featureClass = this.getFeatureClass();
            Class<? extends Feature> other$featureClass = other.getFeatureClass();
            if (this$featureClass == null ? other$featureClass != null : !this$featureClass.equals(other$featureClass)) {
                return false;
            }
            Collection<Requirement<FeatureInfo>> this$requirements = this.getRequirements();
            Collection<Requirement<FeatureInfo>> other$requirements = other.getRequirements();
            if (this$requirements == null ? other$requirements != null : !((Object)this$requirements).equals(other$requirements)) {
                return false;
            }
            SuperVanish this$plugin = this.getPlugin();
            SuperVanish other$plugin = other.getPlugin();
            return !(this$plugin == null ? other$plugin != null : !this$plugin.equals(other$plugin));
        }

        protected boolean canEqual(Object other) {
            return other instanceof FeatureInfo;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Class<? extends Feature> $featureClass = this.getFeatureClass();
            result = result * 59 + ($featureClass == null ? 43 : $featureClass.hashCode());
            Collection<Requirement<FeatureInfo>> $requirements = this.getRequirements();
            result = result * 59 + ($requirements == null ? 43 : ((Object)$requirements).hashCode());
            SuperVanish $plugin = this.getPlugin();
            result = result * 59 + ($plugin == null ? 43 : $plugin.hashCode());
            return result;
        }

        public String toString() {
            return "FeatureMgr.FeatureInfo(featureClass=" + this.getFeatureClass() + ", requirements=" + this.getRequirements() + ", plugin=" + this.getPlugin() + ")";
        }
    }
}

