/*
 * Decompiled with CFR 0.152.
 */
package de.myzelyam.supervanish.features;

import de.myzelyam.api.vanish.PlayerShowEvent;
import de.myzelyam.api.vanish.PostPlayerHideEvent;
import de.myzelyam.supervanish.SuperVanish;
import de.myzelyam.supervanish.features.Feature;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;

public class Broadcast
extends Feature {
    public Broadcast(SuperVanish plugin) {
        super(plugin);
    }

    public static void announceSilentJoin(Player vanished, SuperVanish plugin) {
        if (plugin.getSettings().getBoolean("MessageOptions.AnnounceRealJoinQuitToAdmins", true)) {
            for (Player onlinePlayer : Bukkit.getOnlinePlayers()) {
                if (vanished == onlinePlayer || !plugin.canSee(onlinePlayer, vanished)) continue;
                plugin.sendMessage((CommandSender)onlinePlayer, "SilentJoinMessageForAdmins", vanished, onlinePlayer);
            }
        }
    }

    public static void announceSilentQuit(Player p, SuperVanish plugin) {
        if (plugin.getSettings().getBoolean("MessageOptions.AnnounceRealJoinQuitToAdmins", true)) {
            for (Player onlinePlayer : Bukkit.getOnlinePlayers()) {
                if (p == onlinePlayer || !plugin.canSee(onlinePlayer, p)) continue;
                plugin.sendMessage((CommandSender)onlinePlayer, "SilentQuitMessageForAdmins", p, onlinePlayer);
            }
        }
    }

    @Override
    public boolean isActive() {
        return this.plugin.getSettings().getBoolean("MessageOptions.FakeJoinQuitMessages.BroadcastFakeQuitOnVanish") || this.plugin.getSettings().getBoolean("MessageOptions.FakeJoinQuitMessages.BroadcastFakeQuitOnReappear");
    }

    @EventHandler
    public void onVanish(PostPlayerHideEvent e) {
        Player p = e.getPlayer();
        if (this.plugin.getSettings().getBoolean("MessageOptions.FakeJoinQuitMessages.BroadcastFakeQuitOnVanish") && !e.isSilent()) {
            for (Player onlinePlayer : Bukkit.getOnlinePlayers()) {
                if (!this.plugin.canSee(onlinePlayer, p)) {
                    if (this.plugin.getSettings().getBoolean("MessageOptions.FakeJoinQuitMessages.SendMessageOnlyToAdmins")) continue;
                    this.plugin.sendMessage((CommandSender)onlinePlayer, "VanishMessage", p, onlinePlayer);
                    continue;
                }
                if (this.plugin.getSettings().getBoolean("MessageOptions.FakeJoinQuitMessages.SendMessageOnlyToUsers")) continue;
                if (!this.plugin.getSettings().getBoolean("MessageOptions.FakeJoinQuitMessages.AnnounceVanishReappearToAdmins")) {
                    this.plugin.sendMessage((CommandSender)onlinePlayer, "VanishMessage", p, onlinePlayer);
                    continue;
                }
                if (onlinePlayer == p && !this.plugin.getSettings().getBoolean("MessageOptions.FakeJoinQuitMessages.SendMessageOnlyToAdmins")) {
                    this.plugin.sendMessage((CommandSender)onlinePlayer, "VanishMessage", p, onlinePlayer);
                    continue;
                }
                if (onlinePlayer == p) continue;
                this.plugin.sendMessage((CommandSender)onlinePlayer, "VanishMessageWithPermission", p, onlinePlayer);
            }
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onReappear(PlayerShowEvent e) {
        Player p = e.getPlayer();
        if (this.plugin.getSettings().getBoolean("MessageOptions.FakeJoinQuitMessages.BroadcastFakeJoinOnReappear") && !e.isSilent()) {
            for (Player onlinePlayer : Bukkit.getOnlinePlayers()) {
                if (!this.plugin.canSee(onlinePlayer, p)) {
                    if (this.plugin.getSettings().getBoolean("MessageOptions.FakeJoinQuitMessages.SendMessageOnlyToAdmins")) continue;
                    this.plugin.sendMessage((CommandSender)onlinePlayer, "ReappearMessage", p, onlinePlayer);
                    continue;
                }
                if (this.plugin.getSettings().getBoolean("MessageOptions.FakeJoinQuitMessages.SendMessageOnlyToUsers")) continue;
                if (!this.plugin.getSettings().getBoolean("MessageOptions.FakeJoinQuitMessages.AnnounceVanishReappearToAdmins")) {
                    this.plugin.sendMessage((CommandSender)onlinePlayer, "ReappearMessageWithPermission", p, onlinePlayer);
                    continue;
                }
                if (onlinePlayer == p && !this.plugin.getSettings().getBoolean("MessageOptions.FakeJoinQuitMessages.SendMessageOnlyToAdmins")) {
                    this.plugin.sendMessage((CommandSender)onlinePlayer, "ReappearMessage", p, onlinePlayer);
                    continue;
                }
                if (onlinePlayer == p) continue;
                this.plugin.sendMessage((CommandSender)onlinePlayer, "ReappearMessageWithPermission", p, onlinePlayer);
            }
        }
    }
}

