/*
 * Decompiled with CFR 0.152.
 */
package de.myzelyam.supervanish.commands.subcommands;

import de.myzelyam.supervanish.SuperVanish;
import de.myzelyam.supervanish.commands.CommandAction;
import de.myzelyam.supervanish.commands.SubCommand;
import java.io.File;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class RecreateFiles
extends SubCommand {
    public RecreateFiles(SuperVanish plugin) {
        super(plugin);
    }

    @Override
    public void execute(Command cmd, CommandSender p, String[] args, String label) {
        if (this.canDo(p, CommandAction.RECREATE_FILES, true)) {
            String changes;
            String updates;
            if (this.plugin.getConfigMgr().isSettingsUpdateRequired() && this.plugin.getConfigMgr().isMessagesUpdateRequired()) {
                updates = "the config and the messages file";
                changes = "all settings and messages";
            } else if (this.plugin.getConfigMgr().isSettingsUpdateRequired()) {
                updates = "the config";
                changes = "all settings";
            } else {
                updates = "the messages file";
                changes = "all messages";
            }
            if (args.length != 2) {
                if (!this.plugin.getConfigMgr().isSettingsUpdateRequired() && !this.plugin.getConfigMgr().isMessagesUpdateRequired()) {
                    this.plugin.sendMessage(p, "NoConfigUpdateAvailable", p);
                    return;
                }
                this.plugin.sendMessage(p, this.plugin.getMessage("UpdateWarning").replace("%changes%", changes).replace("%updates%", updates), p);
                return;
            }
            if (args[1].equalsIgnoreCase("confirm") || args[1].equalsIgnoreCase("force")) {
                if (!(this.plugin.getConfigMgr().isSettingsUpdateRequired() || this.plugin.getConfigMgr().isMessagesUpdateRequired() || args[1].equalsIgnoreCase("force"))) {
                    this.plugin.sendMessage(p, "NoConfigUpdateAvailable", p);
                    return;
                }
                if (args[1].equalsIgnoreCase("force")) {
                    updates = "the config and the messages file";
                    changes = "all settings and messages";
                }
                boolean success = false;
                if (this.plugin.getConfigMgr().isSettingsUpdateRequired() || args[1].equalsIgnoreCase("force")) {
                    File file = new File(this.plugin.getDataFolder().getPath() + File.separator + "config.yml");
                    success = file.delete();
                    this.plugin.getConfigMgr().getSettingsFile().save();
                    this.plugin.getConfigMgr().getSettingsFile().reload();
                    this.plugin.getConfigMgr().setSettings(this.plugin.getConfigMgr().getSettingsFile().getConfig());
                }
                if (this.plugin.getConfigMgr().isMessagesUpdateRequired() || args[1].equalsIgnoreCase("force")) {
                    File file2 = new File(this.plugin.getDataFolder().getPath() + File.separator + "messages.yml");
                    success &= file2.delete();
                    this.plugin.getConfigMgr().getMessagesFile().save();
                    this.plugin.getConfigMgr().getMessagesFile().reload();
                    this.plugin.getConfigMgr().setMessages(this.plugin.getConfigMgr().getMessagesFile().getConfig());
                }
                if (!success) {
                    p.sendMessage(ChatColor.RED + "Cannot update config, failed to delete file. Are the file permissions valid?");
                    return;
                }
                this.plugin.sendMessage(p, this.plugin.getMessage("RecreatedConfig").replace("%changes%", changes).replace("%updates%", updates), p);
                this.plugin.getConfigMgr().checkFilesForLeftOvers();
            } else if (args[1].equalsIgnoreCase("dismiss")) {
                String currentVersion = this.plugin.getDescription().getVersion();
                boolean isDismissed = this.plugin.getPlayerData().getBoolean("PlayerData." + (p instanceof Player ? ((Player)p).getUniqueId().toString() : "CONSOLE") + ".dismissed." + currentVersion.replace(".", "_"), false);
                this.plugin.getPlayerData().set("PlayerData." + (p instanceof Player ? ((Player)p).getUniqueId().toString() : "CONSOLE") + ".dismissed." + currentVersion.replace(".", "_"), (Object)(!isDismissed ? 1 : 0));
                this.plugin.getConfigMgr().getPlayerDataFile().save();
                if (!isDismissed) {
                    this.plugin.sendMessage(p, "DismissedRecreationWarning", p);
                } else {
                    this.plugin.sendMessage(p, "UndismissedRecreationWarning", p);
                }
            }
        }
    }
}

