/*
 * Decompiled with CFR 0.152.
 */
package de.myzelyam.supervanish;

import de.myzelyam.supervanish.SuperVanish;
import de.myzelyam.supervanish.VanishPlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;

public class LayeredPermissionChecker {
    private final SuperVanish plugin;
    private final FileConfiguration settings;

    public LayeredPermissionChecker(SuperVanish plugin) {
        this.plugin = plugin;
        this.settings = plugin.getSettings();
    }

    public boolean hasPermissionToVanish(CommandSender sender) {
        if (this.settings.getBoolean("IndicationFeatures.LayeredPermissions.LayeredSeeAndUsePermissions", false)) {
            if (sender.hasPermission("sv.use")) {
                return true;
            }
            int permissionLevel = sender instanceof Player ? this.plugin.getVanishPlayer((Player)sender).getUsePermissionLevel() : this.getLayeredPermissionLevel(sender, "use");
            return permissionLevel > 0 && sender.hasPermission("sv.use.level" + permissionLevel);
        }
        return sender.hasPermission("sv.use");
    }

    public boolean hasPermissionToSee(Player viewer, Player viewed) {
        if (viewer == null) {
            throw new IllegalArgumentException("viewer cannot be null");
        }
        if (viewer == viewed) {
            return true;
        }
        if (this.settings.getBoolean("IndicationFeatures.LayeredPermissions.LayeredSeeAndUsePermissions", false)) {
            VanishPlayer vanishViewer = this.plugin.getVanishPlayer(viewer);
            VanishPlayer vanishViewed = this.plugin.getVanishPlayer(viewed);
            int viewerLevel = vanishViewer.getSeePermissionLevel();
            if (viewerLevel == 0) {
                return false;
            }
            int viewedLevel = Math.max(1, vanishViewed.getUsePermissionLevel());
            return viewerLevel >= viewedLevel;
        }
        boolean enableSeePermission = this.settings.getBoolean("IndicationFeatures.LayeredPermissions.EnableSeePermission", true);
        return enableSeePermission && viewer.hasPermission("sv.see");
    }

    public int getLayeredPermissionLevel(CommandSender sender, String permission) {
        boolean enableSeePermission = this.settings.getBoolean("IndicationFeatures.LayeredPermissions.EnableSeePermission", true);
        if (!enableSeePermission && permission.equalsIgnoreCase("see")) {
            return 0;
        }
        int maxLevel = this.settings.getInt("IndicationFeatures.LayeredPermissions.MaxLevel", 100);
        int level = sender.hasPermission("sv." + permission) ? 1 : 0;
        for (int i = 1; i <= maxLevel; ++i) {
            if (!sender.hasPermission("sv." + permission + ".level" + i)) continue;
            level = i;
        }
        return level;
    }
}

