/*
 * Decompiled with CFR 0.152.
 */
package de.myzelyam.api.vanish;

import de.myzelyam.supervanish.SuperVanish;
import de.myzelyam.supervanish.utils.Validation;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;

public class VanishAPI {
    private static SuperVanish PLUGIN;

    public static List<UUID> getInvisiblePlayers() {
        return new ArrayList<UUID>(PLUGIN.getVanishStateMgr().getOnlineVanishedPlayers());
    }

    public static List<UUID> getAllInvisiblePlayers() {
        return new ArrayList<UUID>(PLUGIN.getVanishStateMgr().getVanishedPlayers());
    }

    public static boolean isInvisible(Player p) {
        Validation.checkNotNull("Player cannot be null!", p);
        return PLUGIN.getVanishStateMgr().isVanished(p.getUniqueId());
    }

    public static boolean isInvisibleOffline(UUID uuid) {
        Validation.checkNotNull("UUID cannot be null!", uuid);
        return PLUGIN.getVanishStateMgr().isVanished(uuid);
    }

    public static void hidePlayer(Player p) {
        Validation.checkNotNull("Player cannot be null!", p);
        PLUGIN.getVisibilityChanger().hidePlayer(p);
    }

    public static void showPlayer(Player p) {
        Validation.checkNotNull("Player cannot be null!", p);
        PLUGIN.getVisibilityChanger().showPlayer(p);
    }

    public static boolean canSee(Player viewer, Player viewed) {
        return PLUGIN.canSee(viewer, viewed);
    }

    public static FileConfiguration getConfiguration() {
        return PLUGIN.getSettings();
    }

    public static FileConfiguration getMessages() {
        return PLUGIN.getMessages();
    }

    public static FileConfiguration getPlayerData() {
        return PLUGIN.getPlayerData();
    }

    public static void reloadConfig() {
        PLUGIN.reload();
    }

    public static SuperVanish getPlugin() {
        return PLUGIN;
    }

    public static void setPlugin(SuperVanish plugin) {
        PLUGIN = plugin;
    }
}

