/*
 * Decompiled with CFR 0.152.
 */
package com.onarandombox.MultiversePortals.utils;

import com.onarandombox.MultiverseCore.api.MultiverseWorld;
import com.onarandombox.MultiversePortals.MVPortal;
import com.onarandombox.MultiversePortals.MultiversePortals;
import com.onarandombox.MultiversePortals.PortalLocation;
import com.onarandombox.MultiversePortals.utils.MultiverseRegion;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.permissions.Permission;
import org.bukkit.util.Vector;

public class PortalManager {
    private MultiversePortals plugin;
    private Map<String, MVPortal> portals;
    private Map<MultiverseWorld, Map<Integer, Collection<MVPortal>>> worldChunkPortals;
    private static final Collection<MVPortal> emptyPortalSet = new ArrayList<MVPortal>();

    public PortalManager(MultiversePortals plugin) {
        this.plugin = plugin;
        this.portals = new HashMap<String, MVPortal>();
        this.worldChunkPortals = new HashMap<MultiverseWorld, Map<Integer, Collection<MVPortal>>>();
    }

    public MVPortal getPortal(Player sender, Location l) {
        if (!this.plugin.getCore().getMVWorldManager().isMVWorld(l.getWorld().getName())) {
            return null;
        }
        MultiverseWorld world = this.plugin.getCore().getMVWorldManager().getMVWorld(l.getWorld().getName());
        for (MVPortal portal : this.getNearbyPortals(world, l)) {
            PortalLocation portalLoc;
            if (MultiversePortals.EnforcePortalAccess && !portal.playerCanEnterPortal(sender) || !(portalLoc = portal.getLocation()).isValidLocation() || !portalLoc.getRegion().containsVector(l)) continue;
            return portal;
        }
        return null;
    }

    @Deprecated
    public MVPortal isPortal(Player sender, Location l) {
        return this.getPortal(sender, l);
    }

    public boolean isPortal(Location l) {
        return this.getPortal(l) != null;
    }

    public MVPortal getPortal(Location l) {
        MultiverseWorld world = this.plugin.getCore().getMVWorldManager().getMVWorld(l.getWorld().getName());
        for (MVPortal portal : this.getNearbyPortals(world, l)) {
            MultiverseRegion r = portal.getLocation().getRegion();
            if (r == null || !r.containsVector(l)) continue;
            return portal;
        }
        return null;
    }

    public boolean addPortal(MVPortal portal) {
        if (!this.portals.containsKey(portal.getName())) {
            MultiverseWorld world = this.plugin.getCore().getMVWorldManager().getMVWorld(portal.getWorld());
            this.addUniquePortal(world, portal.getName(), portal);
            return true;
        }
        return false;
    }

    public boolean addPortal(MultiverseWorld world, String name, String owner, PortalLocation location) {
        if (!this.portals.containsKey(name)) {
            this.addUniquePortal(world, name, new MVPortal(this.plugin, name, owner, location));
            return true;
        }
        return false;
    }

    private void addUniquePortal(MultiverseWorld world, String name, MVPortal portal) {
        this.portals.put(name, portal);
        this.addToWorldChunkPortals(world, portal);
    }

    public MVPortal removePortal(String portalName, boolean removeFromConfigs) {
        return this.removePortal(portalName, removeFromConfigs, false);
    }

    private MVPortal removePortal(String portalName, boolean removeFromConfigs, boolean delayRecalculation) {
        if (!this.isPortal(portalName)) {
            return null;
        }
        if (removeFromConfigs) {
            FileConfiguration config = this.plugin.getPortalsConfig();
            config.set("portals." + portalName, null);
            this.plugin.savePortalsConfig();
        }
        MVPortal removed = this.portals.remove(portalName);
        MultiverseWorld world = this.plugin.getCore().getMVWorldManager().getMVWorld(removed.getWorld());
        this.removeFromWorldChunkPortals(world, removed);
        removed.removePermission();
        Permission portalAccess = this.plugin.getServer().getPluginManager().getPermission("multiverse.portal.access.*");
        Permission exemptAccess = this.plugin.getServer().getPluginManager().getPermission("multiverse.portal.exempt.*");
        Permission portalFill = this.plugin.getServer().getPluginManager().getPermission("multiverse.portal.fill.*");
        if (exemptAccess != null) {
            exemptAccess.getChildren().remove(removed.getExempt().getName());
        }
        if (portalAccess != null) {
            portalAccess.getChildren().remove(removed.getPermission().getName());
        }
        if (portalFill != null) {
            portalFill.getChildren().remove(removed.getFillPermission().getName());
        }
        if (!delayRecalculation) {
            this.recalculatePermissions();
        }
        if (MultiversePortals.ClearOnRemove) {
            MultiverseRegion region = removed.getLocation().getRegion();
            this.replaceInRegion(removed.getWorld(), region, Material.NETHER_PORTAL, Material.AIR);
        }
        this.plugin.getServer().getPluginManager().removePermission(removed.getPermission());
        this.plugin.getServer().getPluginManager().removePermission(removed.getExempt());
        this.plugin.getServer().getPluginManager().removePermission(removed.getFillPermission());
        return removed;
    }

    private void recalculatePermissions() {
        String[] permissionsNames;
        for (String permissionName : permissionsNames = new String[]{"multiverse.portal.access.*", "multiverse.portal.exempt.*", "multiverse.portal.fill.*"}) {
            Permission permission = this.plugin.getServer().getPluginManager().getPermission(permissionName);
            this.plugin.getServer().getPluginManager().recalculatePermissionDefaults(permission);
        }
    }

    public List<MVPortal> getAllPortals() {
        return new ArrayList<MVPortal>(this.portals.values());
    }

    public List<MVPortal> getPortals(CommandSender sender) {
        if (!(sender instanceof Player)) {
            return this.getAllPortals();
        }
        List<MVPortal> all = this.getAllPortals();
        ArrayList<MVPortal> validItems = new ArrayList();
        if (MultiversePortals.EnforcePortalAccess) {
            for (MVPortal p : all) {
                if (!p.playerCanEnterPortal((Player)sender)) continue;
                validItems.add(p);
            }
        } else {
            validItems = new ArrayList<MVPortal>(all);
        }
        return validItems;
    }

    private List<MVPortal> getPortals(MultiverseWorld world) {
        List<MVPortal> all = this.getAllPortals();
        ArrayList<MVPortal> validItems = new ArrayList<MVPortal>();
        for (MVPortal p : all) {
            MultiverseWorld portalworld = p.getLocation().getMVWorld();
            if (portalworld == null || !portalworld.equals(world)) continue;
            validItems.add(p);
        }
        return validItems;
    }

    public List<MVPortal> getPortals(CommandSender sender, MultiverseWorld world) {
        if (!(sender instanceof Player)) {
            return this.getPortals(world);
        }
        List<MVPortal> all = this.getAllPortals();
        ArrayList<MVPortal> validItems = new ArrayList();
        if (MultiversePortals.EnforcePortalAccess) {
            for (MVPortal p : all) {
                if (!p.getLocation().isValidLocation() || !p.getLocation().getMVWorld().equals(world) || !p.playerCanEnterPortal((Player)sender)) continue;
                validItems.add(p);
            }
        } else {
            validItems = new ArrayList<MVPortal>(all);
        }
        return validItems;
    }

    public MVPortal getPortal(String portalName) {
        return this.portals.get(portalName);
    }

    public MVPortal getPortal(String portalName, CommandSender sender) {
        if (!this.plugin.getCore().getMVPerms().hasPermission(sender, "multiverse.portal.access." + portalName, true)) {
            return null;
        }
        return this.getPortal(portalName);
    }

    public boolean isPortal(String portalName) {
        return this.portals.containsKey(portalName);
    }

    public void removeAll(boolean removeFromConfigs) {
        ArrayList<String> iterList = new ArrayList<String>(this.portals.keySet());
        for (String s : iterList) {
            this.removePortal(s, removeFromConfigs, true);
        }
        this.recalculatePermissions();
    }

    private void replaceInRegion(World world, MultiverseRegion removedRegion, Material oldMaterial, Material newMaterial) {
        Vector min = removedRegion.getMinimumPoint();
        Vector max = removedRegion.getMaximumPoint();
        int minX = min.getBlockX();
        int minY = min.getBlockY();
        int minZ = min.getBlockZ();
        int maxX = max.getBlockX();
        int maxY = max.getBlockY();
        int maxZ = max.getBlockZ();
        for (int x = minX; x <= maxX; ++x) {
            for (int y = minY; y <= maxY; ++y) {
                for (int z = minZ; z <= maxZ; ++z) {
                    Block b = world.getBlockAt(x, y, z);
                    if (b.getType() != oldMaterial) continue;
                    b.setType(newMaterial, false);
                }
            }
        }
    }

    private int blockToChunk(int b) {
        if (b < 0) {
            b -= 16;
        }
        return b / 16;
    }

    private int hashChunk(int cx, int cz) {
        return cx << 16 | cz & 0xFFFF;
    }

    private void addToWorldChunkPortals(MultiverseWorld world, MVPortal portal) {
        Map<Integer, Collection<MVPortal>> chunksToPortals = this.worldChunkPortals.get(world);
        if (chunksToPortals == null) {
            chunksToPortals = new HashMap<Integer, Collection<MVPortal>>();
            this.worldChunkPortals.put(world, chunksToPortals);
        }
        PortalLocation location = portal.getLocation();
        Vector min = location.getMinimum();
        Vector max = location.getMaximum();
        int c1x = this.blockToChunk(min.getBlockX());
        int c1z = this.blockToChunk(min.getBlockZ());
        int c2x = this.blockToChunk(max.getBlockX());
        int c2z = this.blockToChunk(max.getBlockZ());
        for (int cx = c1x; cx <= c2x; ++cx) {
            for (int cz = c1z; cz <= c2z; ++cz) {
                Integer hashCode = this.hashChunk(cx, cz);
                Collection<MVPortal> portals = chunksToPortals.get(hashCode);
                if (portals == null) {
                    portals = new ArrayList<MVPortal>();
                    chunksToPortals.put(hashCode, portals);
                }
                portals.add(portal);
            }
        }
    }

    private void removeFromWorldChunkPortals(MultiverseWorld world, MVPortal portal) {
        Map<Integer, Collection<MVPortal>> chunksToPortals = this.worldChunkPortals.get(world);
        if (chunksToPortals == null) {
            return;
        }
        PortalLocation location = portal.getLocation();
        Vector min = location.getMinimum();
        Vector max = location.getMaximum();
        int c1x = this.blockToChunk(min.getBlockX());
        int c1z = this.blockToChunk(min.getBlockZ());
        int c2x = this.blockToChunk(max.getBlockX());
        int c2z = this.blockToChunk(max.getBlockZ());
        for (int cx = c1x; cx <= c2x; ++cx) {
            for (int cz = c1z; cz <= c2z; ++cz) {
                Integer hashCode = this.hashChunk(cx, cz);
                chunksToPortals.get(hashCode).remove(portal);
            }
        }
    }

    private Collection<MVPortal> getNearbyPortals(MultiverseWorld world, Location location) {
        Collection<MVPortal> nearbyPortals = null;
        Map<Integer, Collection<MVPortal>> chunkMap = this.worldChunkPortals.get(world);
        if (chunkMap != null) {
            int cx = this.blockToChunk(location.getBlockX());
            int cz = this.blockToChunk(location.getBlockZ());
            Integer hash = this.hashChunk(cx, cz);
            nearbyPortals = chunkMap.get(hash);
        }
        return nearbyPortals != null ? nearbyPortals : emptyPortalSet;
    }
}

