/*
 * Decompiled with CFR 0.152.
 */
package com.onarandombox.MultiversePortals.utils;

import com.onarandombox.MultiverseCore.api.MultiverseWorld;
import com.sk89q.worldedit.math.BlockVector3;
import org.bukkit.Location;
import org.bukkit.util.Vector;

public class MultiverseRegion {
    private Vector min;
    private Vector max;
    private MultiverseWorld world;

    public MultiverseRegion(Object pos1, Object pos2, MultiverseWorld w) {
        if (pos1 instanceof BlockVector3 && pos2 instanceof BlockVector3) {
            BlockVector3 weV1 = (BlockVector3)pos1;
            BlockVector3 weV2 = (BlockVector3)pos2;
            Vector tmp1 = new Vector(weV1.getX(), weV1.getY(), weV1.getZ());
            Vector tmp2 = new Vector(weV2.getX(), weV2.getY(), weV2.getZ());
            this.min = Vector.getMinimum((Vector)tmp1, (Vector)tmp2);
            this.max = Vector.getMaximum((Vector)tmp1, (Vector)tmp2);
            this.world = w;
        }
    }

    public MultiverseRegion(Location loc1, Location loc2, MultiverseWorld w) {
        this(loc1.toVector(), loc2.toVector(), w);
    }

    public MultiverseRegion(Vector pos1, Vector pos2, MultiverseWorld w) {
        this.min = Vector.getMinimum((Vector)pos1, (Vector)pos2);
        this.max = Vector.getMaximum((Vector)pos1, (Vector)pos2);
        this.world = w;
    }

    public Vector getMinimumPoint() {
        return this.min;
    }

    public Vector getMaximumPoint() {
        return this.max;
    }

    public MultiverseWorld getWorld() {
        return this.world;
    }

    public int getWidth() {
        return Math.abs(this.max.getBlockX() + 1 - this.min.getBlockX());
    }

    public int getHeight() {
        return Math.abs(this.max.getBlockY() + 1 - this.min.getBlockY());
    }

    public int getDepth() {
        return Math.abs(this.max.getBlockZ() + 1 - this.min.getBlockZ());
    }

    public int getArea() {
        return this.getWidth() * this.getHeight() * this.getDepth();
    }

    public boolean containsVector(Location l) {
        if (!this.world.getCBWorld().equals(l.getWorld())) {
            return false;
        }
        if (l.getBlockX() < this.min.getBlockX() || l.getBlockX() > this.max.getBlockX()) {
            return false;
        }
        if (l.getBlockZ() < this.min.getBlockZ() || l.getBlockZ() > this.max.getBlockZ()) {
            return false;
        }
        return l.getBlockY() >= this.min.getBlockY() && l.getBlockY() <= this.max.getBlockY();
    }
}

