/*
 * Decompiled with CFR 0.152.
 */
package com.onarandombox.MultiversePortals;

import com.onarandombox.MultiverseCore.api.MultiverseWorld;
import com.onarandombox.MultiversePortals.MVPortal;
import com.onarandombox.MultiversePortals.MultiversePortals;
import com.onarandombox.MultiversePortals.WorldEditConnection;
import com.onarandombox.MultiversePortals.enums.MoveType;
import com.onarandombox.MultiversePortals.utils.MultiverseRegion;
import com.onarandombox.MultiversePortals.utils.PortalManager;
import java.util.Date;
import java.util.logging.Level;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.util.Vector;

public class PortalPlayerSession {
    private MultiversePortals plugin;
    private String playerName;
    private MVPortal portalSelection = null;
    private MVPortal standingIn = null;
    private boolean debugMode = false;
    private boolean staleLocation;
    private boolean hasMovedOutOfPortal = true;
    private Location loc;
    private Vector rightClick;
    private Vector leftClick;
    private MultiverseWorld rightClickWorld;
    private MultiverseWorld leftClickWorld;
    private Date lastTeleportTime;

    public PortalPlayerSession(MultiversePortals plugin, Player p) {
        this.plugin = plugin;
        this.playerName = p.getName();
        this.setLocation(p.getLocation());
        this.lastTeleportTime = new Date(new Date().getTime() - this.plugin.getCooldownTime());
    }

    public boolean selectPortal(MVPortal portal) {
        this.portalSelection = portal;
        return true;
    }

    public MVPortal getSelectedPortal() {
        return this.portalSelection;
    }

    private Player getPlayerFromName() {
        return this.plugin.getServer().getPlayer(this.playerName);
    }

    public void setDebugMode(boolean debugMode) {
        this.debugMode = debugMode;
        if (this.debugMode) {
            this.getPlayerFromName().sendMessage("Portal debug mode " + ChatColor.GREEN + "ENABLED");
            this.getPlayerFromName().sendMessage("Use " + ChatColor.DARK_AQUA + "/mvp debug" + ChatColor.WHITE + " to disable.");
        } else {
            this.getPlayerFromName().sendMessage("Portal debug mode " + ChatColor.RED + "DISABLED");
        }
    }

    public boolean isDebugModeOn() {
        return this.debugMode;
    }

    public void setStaleLocation(boolean active) {
        this.staleLocation = active;
    }

    public boolean isStaleLocation() {
        return this.staleLocation;
    }

    private void setLocation(Location loc) {
        this.loc = loc;
        this.setStandinginLocation();
    }

    private void setStandinginLocation() {
        if (this.standingIn == null && this.plugin.getPortalManager().isPortal(this.loc)) {
            this.standingIn = this.plugin.getPortalManager().getPortal(this.loc);
        } else if (!this.plugin.getPortalManager().isPortal(this.loc)) {
            this.hasMovedOutOfPortal = true;
            this.standingIn = null;
        } else {
            this.hasMovedOutOfPortal = false;
        }
    }

    public boolean doTeleportPlayer(MoveType eventType) {
        if (eventType == MoveType.PLAYER_MOVE && this.getPlayerFromName().isInsideVehicle()) {
            return false;
        }
        return this.hasMovedOutOfPortal && this.standingIn != null;
    }

    public Location getLocation() {
        return this.loc;
    }

    public void setStaleLocation(Location loc, MoveType moveType) {
        if (this.getPlayerFromName() == null) {
            return;
        }
        if (this.getPlayerFromName().isInsideVehicle() && moveType != MoveType.VEHICLE_MOVE) {
            return;
        }
        if (this.getLocation().getBlockX() == loc.getBlockX() && this.getLocation().getBlockY() == loc.getBlockY() && this.getLocation().getBlockZ() == loc.getBlockZ()) {
            this.setStaleLocation(true);
        } else {
            this.setLocation(loc);
            this.setStaleLocation(false);
        }
    }

    public boolean setLeftClickSelection(Vector v, MultiverseWorld world) {
        if (!this.plugin.isWandEnabled()) {
            return false;
        }
        this.leftClick = v;
        this.leftClickWorld = world;
        String message = ChatColor.AQUA + "First position set to: (" + v.getBlockX() + ", " + v.getBlockY() + ", " + v.getBlockZ() + ")";
        if (this.leftClickWorld == this.rightClickWorld && this.rightClick != null) {
            MultiverseRegion tempReg = new MultiverseRegion(this.leftClick, this.rightClick, this.leftClickWorld);
            message = message + ChatColor.GOLD + " (" + tempReg.getArea() + " blocks)";
        }
        this.getPlayerFromName().sendMessage(message);
        return true;
    }

    public boolean setRightClickSelection(Vector v, MultiverseWorld world) {
        if (!this.plugin.isWandEnabled()) {
            return false;
        }
        this.rightClick = v;
        this.rightClickWorld = world;
        String message = ChatColor.AQUA + "Second position set to: (" + v.getBlockX() + ", " + v.getBlockY() + ", " + v.getBlockZ() + ")";
        if (this.leftClickWorld == this.rightClickWorld && this.leftClick != null) {
            MultiverseRegion tempReg = new MultiverseRegion(this.leftClick, this.rightClick, this.leftClickWorld);
            message = message + ChatColor.GOLD + " (" + tempReg.getArea() + " blocks)";
        }
        this.getPlayerFromName().sendMessage(message);
        return true;
    }

    public MultiverseRegion getSelectedRegion() {
        Player player = this.getPlayerFromName();
        WorldEditConnection worldEdit = this.plugin.getWorldEditConnection();
        if (worldEdit != null && worldEdit.isConnected()) {
            if (worldEdit.isSelectionAvailable(player)) {
                Location minPoint = worldEdit.getSelectionMinPoint(player);
                Location maxPoint = worldEdit.getSelectionMaxPoint(player);
                if (minPoint != null && maxPoint != null && minPoint.getWorld().equals(maxPoint.getWorld())) {
                    return new MultiverseRegion(minPoint, maxPoint, this.plugin.getCore().getMVWorldManager().getMVWorld(minPoint.getWorld().getName()));
                }
                player.sendMessage("You haven't finished your selection.");
                return null;
            }
            player.sendMessage("You must have a WorldEdit selection to do this.");
            return null;
        }
        if (this.leftClick == null) {
            player.sendMessage("You need to LEFT click on a block with your wand!");
            return null;
        }
        if (this.rightClick == null) {
            player.sendMessage("You need to RIGHT click on a block with your wand!");
            return null;
        }
        if (!this.leftClickWorld.equals(this.rightClickWorld)) {
            player.sendMessage("You need to select both coords in the same world!");
            player.sendMessage("Left Click Position was in:" + this.leftClickWorld.getColoredWorldString());
            player.sendMessage("Right Click Position was in:" + this.rightClickWorld.getColoredWorldString());
            return null;
        }
        return new MultiverseRegion(this.leftClick, this.rightClick, this.leftClickWorld);
    }

    public MVPortal getStandingInPortal() {
        return this.standingIn;
    }

    public MVPortal getUncachedStandingInPortal() {
        this.standingIn = this.plugin.getPortalManager().getPortal(this.loc);
        return this.standingIn;
    }

    public void playerDidTeleport(Location location) {
        PortalManager pm = this.plugin.getPortalManager();
        if (pm.getPortal(location) != null) {
            this.hasMovedOutOfPortal = false;
            return;
        }
        this.hasMovedOutOfPortal = true;
    }

    public boolean hasMovedOutOfPortal() {
        return this.hasMovedOutOfPortal;
    }

    public boolean showDebugInfo() {
        if (!this.isDebugModeOn()) {
            return false;
        }
        if (this.standingIn == null) {
            return false;
        }
        PortalPlayerSession.showStaticInfo((CommandSender)this.getPlayerFromName(), this.standingIn, "You are currently standing in ");
        this.showPortalPriceInfo(this.standingIn);
        return true;
    }

    public boolean showDebugInfo(MVPortal portal) {
        if (portal.playerCanEnterPortal(this.getPlayerFromName())) {
            PortalPlayerSession.showStaticInfo((CommandSender)this.getPlayerFromName(), portal, "Portal Info ");
            this.showPortalPriceInfo(portal);
        } else {
            this.plugin.log(Level.INFO, "Player " + this.playerName + " walked through" + portal.getName() + " with debug on.");
        }
        return true;
    }

    private void showPortalPriceInfo(MVPortal portal) {
        this.getPlayerFromName().sendMessage("More details for you: " + ChatColor.GREEN + portal.getDestination());
        if (portal.getPrice() > 0.0) {
            this.getPlayerFromName().sendMessage("Price: " + ChatColor.GREEN + this.plugin.getCore().getEconomist().formatPrice(portal.getPrice(), portal.getCurrency()));
        } else if (portal.getPrice() < 0.0) {
            this.getPlayerFromName().sendMessage("Prize: " + ChatColor.GREEN + this.plugin.getCore().getEconomist().formatPrice(-portal.getPrice(), portal.getCurrency()));
        } else {
            this.getPlayerFromName().sendMessage("Price: " + ChatColor.GREEN + "FREE!");
        }
    }

    public static void showStaticInfo(CommandSender sender, MVPortal portal, String message) {
        sender.sendMessage(message + ChatColor.DARK_AQUA + portal.getName());
        sender.sendMessage("It's coords are: " + ChatColor.GOLD + portal.getLocation().toString());
        if (portal.getDestination() == null) {
            sender.sendMessage("This portal has " + ChatColor.RED + "NO DESTINATION SET.");
        } else {
            sender.sendMessage("It will take you to a location of type: " + ChatColor.AQUA + portal.getDestination().getType());
            sender.sendMessage("The destination's name is: " + ChatColor.GREEN + portal.getDestination().getName());
        }
    }

    public void setTeleportTime(Date date) {
        this.lastTeleportTime = date;
    }

    public boolean allowTeleportViaCooldown(Date date) {
        return date.after(new Date(this.lastTeleportTime.getTime() + this.plugin.getCooldownTime()));
    }

    public String getFriendlyRemainingTimeMessage() {
        String remaining = "There is a portal " + ChatColor.AQUA + "cooldown" + ChatColor.WHITE + " in effect. Please try again in " + ChatColor.GOLD + Integer.toString((int)this.getRemainingCooldown() / 1000) + "s.";
        int time = (int)this.getRemainingCooldown() / 1000;
        remaining = ++time <= 0 ? remaining + "< 1s" + ChatColor.WHITE + "." : remaining + time + "s" + ChatColor.WHITE + ".";
        return remaining;
    }

    public long getRemainingCooldown() {
        long remainingcooldown = this.plugin.getCooldownTime() - (new Date().getTime() - this.lastTeleportTime.getTime());
        if (remainingcooldown < 0L) {
            remainingcooldown = 0L;
        }
        return remainingcooldown;
    }
}

