/*
 * Decompiled with CFR 0.152.
 */
package com.onarandombox.MultiversePortals;

import com.onarandombox.MultiverseCore.MultiverseCore;
import com.onarandombox.MultiverseCore.api.MVPlugin;
import com.onarandombox.MultiverseCore.commands.HelpCommand;
import com.onarandombox.MultiverseCore.utils.DebugLog;
import com.onarandombox.MultiverseCore.utils.MaterialConverter;
import com.onarandombox.MultiversePortals.MVPortal;
import com.onarandombox.MultiversePortals.PortalPlayerSession;
import com.onarandombox.MultiversePortals.WorldEditConnection;
import com.onarandombox.MultiversePortals.commands.ConfigCommand;
import com.onarandombox.MultiversePortals.commands.CreateCommand;
import com.onarandombox.MultiversePortals.commands.DebugCommand;
import com.onarandombox.MultiversePortals.commands.InfoCommand;
import com.onarandombox.MultiversePortals.commands.ListCommand;
import com.onarandombox.MultiversePortals.commands.ModifyCommand;
import com.onarandombox.MultiversePortals.commands.RemoveCommand;
import com.onarandombox.MultiversePortals.commands.SelectCommand;
import com.onarandombox.MultiversePortals.commands.WandCommand;
import com.onarandombox.MultiversePortals.destination.PortalDestination;
import com.onarandombox.MultiversePortals.destination.RandomPortalDestination;
import com.onarandombox.MultiversePortals.enums.PortalConfigProperty;
import com.onarandombox.MultiversePortals.listeners.MVPBlockListener;
import com.onarandombox.MultiversePortals.listeners.MVPCoreListener;
import com.onarandombox.MultiversePortals.listeners.MVPPlayerListener;
import com.onarandombox.MultiversePortals.listeners.MVPPlayerMoveListener;
import com.onarandombox.MultiversePortals.listeners.MVPPluginListener;
import com.onarandombox.MultiversePortals.listeners.MVPVehicleListener;
import com.onarandombox.MultiversePortals.listeners.PlayerListenerHelper;
import com.onarandombox.MultiversePortals.utils.MVPLogging;
import com.onarandombox.MultiversePortals.utils.PortalManager;
import com.onarandombox.commandhandler.CommandHandler;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.logging.Level;
import java.util.stream.Collectors;
import org.bukkit.Material;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.Configuration;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.server.PluginDisableEvent;
import org.bukkit.event.server.PluginEnableEvent;
import org.bukkit.permissions.Permission;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;
import org.bukkit.plugin.java.JavaPlugin;

public class MultiversePortals
extends JavaPlugin
implements MVPlugin {
    protected static DebugLog debugLog;
    private MultiverseCore core;
    private FileConfiguration MVPPortalConfig;
    private FileConfiguration MVPConfig;
    private CommandHandler commandHandler;
    private WorldEditConnection worldEditConnection;
    private PortalManager portalManager;
    private Map<String, PortalPlayerSession> portalSessions;
    private static final Material DEFAULT_WAND;
    private long portalCooldown = 0L;
    private static final int requiresProtocol = 24;
    public static boolean UseOnMove;
    public static boolean EnforcePortalAccess;
    public static boolean WandEnabled;
    public static boolean ClearOnRemove;
    public static boolean TeleportVehicles;
    public static List<Material> FrameMaterials;

    public void onLoad() {
        this.getDataFolder().mkdirs();
    }

    public void onEnable() {
        MVPLogging.init((Plugin)this);
        this.core = (MultiverseCore)this.getServer().getPluginManager().getPlugin("Multiverse-Core");
        if (this.core == null) {
            MVPLogging.info("Multiverse-Core not found, will keep looking.", new Object[0]);
            this.getServer().getPluginManager().disablePlugin((Plugin)this);
            return;
        }
        if (this.core.getProtocolVersion() < 24) {
            MVPLogging.severe("Your Multiverse-Core is OUT OF DATE", new Object[0]);
            MVPLogging.severe("This version of Multiverse Portals requires Protocol Level: 24", new Object[0]);
            MVPLogging.severe("Your of Core Protocol Level is: " + this.core.getProtocolVersion(), new Object[0]);
            MVPLogging.severe("Grab an updated copy at: ", new Object[0]);
            MVPLogging.severe("http://ci.onarandombox.com/view/Multiverse/job/Multiverse-Core/", new Object[0]);
            this.getServer().getPluginManager().disablePlugin((Plugin)this);
            return;
        }
        MVPLogging.setDebugLevel(this.core.getMVConfig().getGlobalDebug());
        this.core.incrementPluginCount();
        this.registerCommands();
        this.createDefaultPerms();
        this.portalManager = new PortalManager(this);
        this.portalSessions = new HashMap<String, PortalPlayerSession>();
        this.getCore().getDestFactory().registerDestinationType(PortalDestination.class, "p");
        this.getCore().getDestFactory().registerDestinationType(RandomPortalDestination.class, "rp");
        this.loadPortals();
        this.loadConfig();
        this.registerEvents();
        this.getServer().getPluginManager().registerEvents((Listener)new WorldEditPluginListener(), (Plugin)this);
        MVPLogging.log(true, Level.INFO, " Enabled - By %s", this.getAuthors());
    }

    private void registerEvents() {
        MVPPluginListener pluginListener = new MVPPluginListener(this);
        PlayerListenerHelper playerListenerHelper = new PlayerListenerHelper(this);
        MVPPlayerListener playerListener = new MVPPlayerListener(this, playerListenerHelper);
        MVPBlockListener blockListener = new MVPBlockListener(this);
        MVPVehicleListener vehicleListener = new MVPVehicleListener(this);
        MVPCoreListener coreListener = new MVPCoreListener(this);
        PluginManager pm = this.getServer().getPluginManager();
        pm.registerEvents((Listener)pluginListener, (Plugin)this);
        pm.registerEvents((Listener)playerListener, (Plugin)this);
        pm.registerEvents((Listener)blockListener, (Plugin)this);
        if (TeleportVehicles) {
            pm.registerEvents((Listener)vehicleListener, (Plugin)this);
        }
        if (UseOnMove) {
            pm.registerEvents((Listener)new MVPPlayerMoveListener(this, playerListenerHelper), (Plugin)this);
        }
        pm.registerEvents((Listener)coreListener, (Plugin)this);
    }

    private void createDefaultPerms() {
        Permission perm;
        if (this.getServer().getPluginManager().getPermission("multiverse.portal.*") == null) {
            perm = new Permission("multiverse.portal.*");
            this.getServer().getPluginManager().addPermission(perm);
        }
        if (this.getServer().getPluginManager().getPermission("multiverse.portal.access.*") == null) {
            perm = new Permission("multiverse.portal.access.*");
            this.getServer().getPluginManager().addPermission(perm);
        }
        if (this.getServer().getPluginManager().getPermission("multiverse.portal.fill.*") == null) {
            perm = new Permission("multiverse.portal.fill.*");
            this.getServer().getPluginManager().addPermission(perm);
        }
        if (this.getServer().getPluginManager().getPermission("multiverse.portal.exempt.*") == null) {
            perm = new Permission("multiverse.portal.exempt.*");
            this.getServer().getPluginManager().addPermission(perm);
        }
        Permission allPortals = this.getServer().getPluginManager().getPermission("multiverse.portal.*");
        allPortals.getChildren().put("multiverse.portal.access.*", true);
        allPortals.getChildren().put("multiverse.portal.exempt.*", true);
        allPortals.getChildren().put("multiverse.portal.fill.*", true);
        this.getServer().getPluginManager().recalculatePermissionDefaults(allPortals);
        Permission all = this.getServer().getPluginManager().getPermission("multiverse.*");
        all.getChildren().put("multiverse.portal.*", true);
        this.getServer().getPluginManager().recalculatePermissionDefaults(all);
    }

    public PortalPlayerSession getPortalSession(Player p) {
        if (this.portalSessions.containsKey(p.getName())) {
            return this.portalSessions.get(p.getName());
        }
        PortalPlayerSession session = new PortalPlayerSession(this, p);
        this.portalSessions.put(p.getName(), session);
        return session;
    }

    private void loadPortals() {
        Set keys;
        this.MVPPortalConfig = YamlConfiguration.loadConfiguration((File)new File(this.getDataFolder(), "portals.yml"));
        if (!this.MVPPortalConfig.isConfigurationSection("portals")) {
            this.MVPPortalConfig.createSection("portals");
        }
        if ((keys = this.MVPPortalConfig.getConfigurationSection("portals").getKeys(false)) != null) {
            for (String pname : keys) {
                MVPortal portal = MVPortal.loadMVPortalFromConfig(this, pname);
                if (portal.getLocation().isValidLocation()) {
                    this.portalManager.addPortal(portal);
                    continue;
                }
                MultiversePortals.staticLog(Level.WARNING, String.format("Portal '%s' not loaded due to invalid location!", portal.getName()));
            }
            MultiversePortals.staticLog(Level.INFO, keys.size() + " - Portals(s) loaded");
        }
        for (MVPortal portal : this.portalManager.getAllPortals()) {
            String dest = this.MVPPortalConfig.getString("portals." + portal.getName() + ".destination", "");
            if (dest.equals("")) continue;
            portal.setDestination(dest);
        }
        this.savePortalsConfig();
    }

    public void loadConfig() {
        this.MVPConfig = YamlConfiguration.loadConfiguration((File)new File(this.getDataFolder(), "config.yml"));
        InputStream resourceURL = ((Object)((Object)this)).getClass().getResourceAsStream("/defaults/config.yml");
        YamlConfiguration portalsDefaults = null;
        try {
            portalsDefaults = YamlConfiguration.loadConfiguration((Reader)new BufferedReader(new InputStreamReader(resourceURL, "UTF-8")));
            this.MVPConfig.setDefaults((Configuration)portalsDefaults);
        }
        catch (UnsupportedEncodingException e) {
            MVPLogging.severe("Couldn't load default config with UTF-8 encoding. Details follow:", new Object[0]);
            e.printStackTrace();
            MVPLogging.severe("Default configs NOT loaded.", new Object[0]);
        }
        this.MVPConfig.options().copyDefaults(true);
        this.saveMainConfig();
        this.MVPConfig = YamlConfiguration.loadConfiguration((File)new File(this.getDataFolder(), "config.yml"));
        UseOnMove = this.MVPConfig.getBoolean("useonmove", true);
        EnforcePortalAccess = this.MVPConfig.getBoolean("enforceportalaccess", true);
        this.portalCooldown = this.MVPConfig.getInt("portalcooldown", 1000);
        ClearOnRemove = this.MVPConfig.getBoolean("clearonremove", false);
        TeleportVehicles = this.MVPConfig.getBoolean("teleportvehicles", true);
        FrameMaterials = this.migrateFrameMaterials((ConfigurationSection)this.MVPConfig);
        if (this.MVPConfig.get("useportalaccess") != null) {
            this.MVPConfig.set("enforceportalaccess", (Object)this.MVPConfig.getBoolean("useportalaccess", true));
            this.log(Level.INFO, "Migrating useportalaccess -> enforceportalaccess...");
        }
        if (this.MVPConfig.get("mvportals_default_to_nether") != null) {
            this.MVPConfig.set("portalsdefaulttonether", (Object)this.MVPConfig.getBoolean("mvportals_default_to_nether", false));
            this.log(Level.INFO, "Migrating mvportals_default_to_nether -> portalsdefaulttonether...");
        }
        if (this.MVPConfig.get("use_onmove") != null) {
            this.MVPConfig.set("useonmove", (Object)this.MVPConfig.getBoolean("use_onmove", false));
            this.log(Level.INFO, "Migrating use_onmove -> useonmove...");
        }
        if (this.MVPConfig.get("portal_cooldown") != null) {
            this.MVPConfig.set("portalcooldown", (Object)this.MVPConfig.getInt("portal_cooldown", 1000));
            this.log(Level.INFO, "Migrating portal_cooldown -> portalcooldown...");
        }
        this.MVPConfig.set("mvportals_default_to_nether", null);
        this.MVPConfig.set("useportalaccess", null);
        this.MVPConfig.set("use_onmove", null);
        this.MVPConfig.set("portal_cooldown", null);
        if (portalsDefaults != null) {
            this.MVPConfig.set("version", portalsDefaults.get("version"));
        }
        this.saveMainConfig();
    }

    private List<Material> migrateFrameMaterials(ConfigurationSection config) {
        return config.getList("framematerials", Collections.emptyList()).stream().map(Object::toString).map(MaterialConverter::convertTypeString).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public boolean saveMainConfig() {
        try {
            this.MVPConfig.save(new File(this.getDataFolder(), "config.yml"));
            return true;
        }
        catch (IOException e) {
            this.log(Level.SEVERE, "Failed to save Portals config.yml.");
            return false;
        }
    }

    public boolean savePortalsConfig() {
        try {
            this.MVPPortalConfig.save(new File(this.getDataFolder(), "portals.yml"));
            return true;
        }
        catch (IOException e) {
            this.log(Level.SEVERE, "Failed to save Portals portals.yml.");
            return false;
        }
    }

    public void onDisable() {
    }

    private void registerCommands() {
        this.commandHandler = this.core.getCommandHandler();
        this.commandHandler.registerCommand((com.onarandombox.commandhandler.Command)new InfoCommand(this));
        this.commandHandler.registerCommand((com.onarandombox.commandhandler.Command)new ListCommand(this));
        this.commandHandler.registerCommand((com.onarandombox.commandhandler.Command)new CreateCommand(this));
        this.commandHandler.registerCommand((com.onarandombox.commandhandler.Command)new DebugCommand(this));
        this.commandHandler.registerCommand((com.onarandombox.commandhandler.Command)new RemoveCommand(this));
        this.commandHandler.registerCommand((com.onarandombox.commandhandler.Command)new ModifyCommand(this));
        this.commandHandler.registerCommand((com.onarandombox.commandhandler.Command)new SelectCommand(this));
        this.commandHandler.registerCommand((com.onarandombox.commandhandler.Command)new WandCommand(this));
        this.commandHandler.registerCommand((com.onarandombox.commandhandler.Command)new ConfigCommand(this));
        for (com.onarandombox.commandhandler.Command c : this.commandHandler.getAllCommands()) {
            if (!(c instanceof HelpCommand)) continue;
            c.addKey("mvp");
        }
    }

    public boolean onCommand(CommandSender sender, Command command, String commandLabel, String[] args) {
        if (!this.isEnabled()) {
            sender.sendMessage("This plugin is Disabled!");
            return true;
        }
        ArrayList<String> allArgs = new ArrayList<String>(Arrays.asList(args));
        allArgs.add(0, command.getName());
        return this.commandHandler.locateAndRunCommand(sender, allArgs);
    }

    private String getAuthors() {
        String authors = "";
        for (int i = 0; i < this.getDescription().getAuthors().size(); ++i) {
            authors = i == this.getDescription().getAuthors().size() - 1 ? authors + " and " + (String)this.getDescription().getAuthors().get(i) : authors + ", " + (String)this.getDescription().getAuthors().get(i);
        }
        return authors.substring(2);
    }

    public WorldEditConnection getWorldEditConnection() {
        return this.worldEditConnection;
    }

    public MultiverseCore getCore() {
        return this.core;
    }

    public PortalManager getPortalManager() {
        return this.portalManager;
    }

    public FileConfiguration getPortalsConfig() {
        return this.MVPPortalConfig;
    }

    public void setCore(MultiverseCore multiverseCore) {
        this.core = multiverseCore;
    }

    public int getProtocolVersion() {
        return 1;
    }

    public FileConfiguration getMainConfig() {
        return this.MVPConfig;
    }

    public void reloadConfigs() {
        this.portalManager.removeAll(false);
        this.loadPortals();
        this.loadConfig();
    }

    @Deprecated
    public static void staticLog(Level level, String msg) {
        MVPLogging.log(level, msg, new Object[0]);
    }

    @Deprecated
    public static void staticDebugLog(Level level, String msg) {
        MVPLogging.log(level, msg, new Object[0]);
    }

    public void log(Level level, String msg) {
        MVPLogging.log(level, msg, new Object[0]);
    }

    public String dumpVersionInfo(String buffer) {
        buffer = buffer + this.logAndAddToPasteBinBuffer("Multiverse-Portals Version: " + this.getDescription().getVersion());
        buffer = buffer + this.logAndAddToPasteBinBuffer("Bukkit Version: " + this.getServer().getVersion());
        buffer = buffer + this.logAndAddToPasteBinBuffer("Loaded Portals: " + this.getPortalManager().getAllPortals().size());
        buffer = buffer + this.logAndAddToPasteBinBuffer("Dumping Portal Values: (version " + this.getMainConfig().getString("version", "NOT SET") + ")");
        for (PortalConfigProperty property : PortalConfigProperty.values()) {
            String propStr = property.toString();
            if ("version".equals(propStr)) continue;
            buffer = buffer + this.logAndAddToPasteBinBuffer(propStr + ": " + this.getMainConfig().getString(propStr, "NOT SET"));
        }
        buffer = buffer + this.logAndAddToPasteBinBuffer("Special Code: FRN001");
        return buffer;
    }

    public String getVersionInfo() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("[Multiverse-Portals] Multiverse-Portals Version: ").append(this.getDescription().getVersion()).append('\n');
        buffer.append("[Multiverse-Portals] Loaded Portals: ").append(this.getPortalManager().getAllPortals().size()).append('\n');
        buffer.append("[Multiverse-Portals] Dumping Portal Values: (version ").append(this.getMainConfig().getDouble("version", -1.0)).append(')').append('\n');
        buffer.append("[Multiverse-Portals]  wand: ").append(this.getMainConfig().get("wand", (Object)"NOT SET")).append('\n');
        buffer.append("[Multiverse-Portals]  useonmove: ").append(this.getMainConfig().get("useonmove", (Object)"NOT SET")).append('\n');
        buffer.append("[Multiverse-Portals]  enforceportalaccess: ").append(this.getMainConfig().get("enforceportalaccess", (Object)"NOT SET")).append('\n');
        buffer.append("[Multiverse-Portals]  portalsdefaulttonether: ").append(this.getMainConfig().get("portalsdefaulttonether", (Object)"NOT SET")).append('\n');
        buffer.append("[Multiverse-Portals]  portalcooldown: ").append(this.getMainConfig().get("portalcooldown", (Object)"NOT SET")).append('\n');
        buffer.append("[Multiverse-Portals]  clearonremove: ").append(this.getMainConfig().get("clearonremove", (Object)"NOT SET")).append('\n');
        buffer.append("[Multiverse-Portals] Special Code: FRN001").append('\n');
        return buffer.toString();
    }

    private String logAndAddToPasteBinBuffer(String string) {
        this.log(Level.INFO, string);
        return "[Multiverse-Portals] " + string + "\n";
    }

    public long getCooldownTime() {
        return this.portalCooldown;
    }

    public boolean isWandEnabled() {
        return WandEnabled;
    }

    public void setWandEnabled(boolean enabled) {
        WandEnabled = enabled;
    }

    public Material getWandMaterial() {
        Material m = MaterialConverter.convertConfigType((ConfigurationSection)this.getMainConfig(), (String)"wand");
        if (m == null) {
            m = DEFAULT_WAND;
        }
        return m;
    }

    static {
        DEFAULT_WAND = Material.WOODEN_AXE;
        UseOnMove = true;
        EnforcePortalAccess = true;
        WandEnabled = true;
        ClearOnRemove = false;
        TeleportVehicles = true;
        FrameMaterials = null;
    }

    private class WorldEditPluginListener
    implements Listener {
        private WorldEditPluginListener() {
            if (MultiversePortals.this.getServer().getPluginManager().getPlugin("WorldEdit") != null) {
                this.connectWorldEdit();
            }
        }

        private boolean isPluginWorldEdit(Plugin plugin) {
            if (plugin == null) {
                throw new RuntimeException("plugin must not be null.");
            }
            return plugin.getName().equals("WorldEdit");
        }

        private void connectWorldEdit() {
            MultiversePortals.this.worldEditConnection = new WorldEditConnection((Plugin)MultiversePortals.this);
            MultiversePortals.this.worldEditConnection.connect();
        }

        @EventHandler
        private void pluginEnabled(PluginEnableEvent event) {
            if (this.isPluginWorldEdit(event.getPlugin())) {
                this.connectWorldEdit();
            }
        }

        @EventHandler
        private void pluginDisableEvent(PluginDisableEvent event) {
            if (this.isPluginWorldEdit(event.getPlugin())) {
                MultiversePortals.this.worldEditConnection.disconnect();
                MultiversePortals.this.worldEditConnection = null;
            }
        }
    }
}

