/*
 * Decompiled with CFR 0.152.
 */
package com.onarandombox.MultiversePortals;

import com.onarandombox.MultiverseCore.api.MVDestination;
import com.onarandombox.MultiverseCore.api.MVWorldManager;
import com.onarandombox.MultiverseCore.api.MultiverseWorld;
import com.onarandombox.MultiverseCore.destination.ExactDestination;
import com.onarandombox.MultiverseCore.destination.InvalidDestination;
import com.onarandombox.MultiverseCore.utils.MaterialConverter;
import com.onarandombox.MultiversePortals.MultiversePortals;
import com.onarandombox.MultiversePortals.PortalLocation;
import com.onarandombox.MultiversePortals.utils.MultiverseRegion;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Stack;
import java.util.logging.Level;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.permissions.Permission;
import org.bukkit.permissions.PermissionDefault;
import org.bukkit.util.Vector;

public class MVPortal {
    private String name;
    private PortalLocation location;
    private MVDestination destination;
    private MultiversePortals plugin;
    private String owner;
    private String portalConfigString;
    private Permission permission;
    private Permission fillPermission;
    private Permission exempt;
    private Material currency = null;
    private double price = 0.0;
    private MVWorldManager worldManager;
    private boolean safeTeleporter;
    private boolean teleportNonPlayers;
    private FileConfiguration config;
    private boolean allowSave;
    private String handlerScript;
    private static final Collection<Material> INTERIOR_MATERIALS = Arrays.asList(Material.NETHER_PORTAL, Material.GRASS, Material.VINE, Material.SNOW, Material.AIR, Material.WATER, Material.LAVA);

    public static boolean isPortalInterior(Material material) {
        return INTERIOR_MATERIALS.contains(material);
    }

    public MVPortal(MultiversePortals instance, String name) {
        this.init(instance, name, true);
    }

    private MVPortal(MultiversePortals instance, String name, boolean allowSave) {
        this.init(instance, name, allowSave);
    }

    private void init(MultiversePortals instance, String name, boolean allowSave) {
        this.allowSave = false;
        this.plugin = instance;
        this.config = this.plugin.getPortalsConfig();
        this.name = name;
        this.portalConfigString = "portals." + this.name;
        this.setCurrency(MaterialConverter.convertConfigType((ConfigurationSection)this.config, (String)(this.portalConfigString + ".entryfee.currency")));
        this.setPrice(this.config.getDouble(this.portalConfigString + ".entryfee.amount", 0.0));
        this.setUseSafeTeleporter(this.config.getBoolean(this.portalConfigString + ".safeteleport", true));
        this.setTeleportNonPlayers(this.config.getBoolean(this.portalConfigString + ".teleportnonplayers", false));
        this.setHandlerScript(this.config.getString(this.portalConfigString + ".handlerscript", ""));
        this.permission = this.plugin.getServer().getPluginManager().getPermission("multiverse.portal.access." + this.name);
        if (this.permission == null) {
            this.permission = new Permission("multiverse.portal.access." + this.name, "Allows access to the " + this.name + " portal", PermissionDefault.OP);
            this.plugin.getServer().getPluginManager().addPermission(this.permission);
        }
        this.fillPermission = this.plugin.getServer().getPluginManager().getPermission("multiverse.portal.fill." + this.name);
        if (this.fillPermission == null) {
            this.fillPermission = new Permission("multiverse.portal.fill." + this.name, "Allows filling the " + this.name + " portal", PermissionDefault.OP);
            this.plugin.getServer().getPluginManager().addPermission(this.fillPermission);
        }
        this.exempt = this.plugin.getServer().getPluginManager().getPermission("multiverse.portal.exempt." + this.name);
        if (this.exempt == null) {
            this.exempt = new Permission("multiverse.portal.exempt." + this.name, "A player who has this permission will not pay to use this portal " + this.name + " portal", PermissionDefault.FALSE);
            this.plugin.getServer().getPluginManager().addPermission(this.exempt);
        }
        this.addToUpperLists();
        this.worldManager = this.plugin.getCore().getMVWorldManager();
        if (allowSave) {
            this.allowSave = true;
            this.saveConfig();
        }
    }

    private void allowSave() {
        this.allowSave = true;
    }

    private void setTeleportNonPlayers(boolean b) {
        this.teleportNonPlayers = b;
        this.config.set(this.portalConfigString + ".teleportnonplayers", (Object)this.teleportNonPlayers);
        this.saveConfig();
    }

    public boolean getTeleportNonPlayers() {
        return this.teleportNonPlayers;
    }

    private void setUseSafeTeleporter(boolean teleport) {
        this.safeTeleporter = teleport;
        this.config.set(this.portalConfigString + ".safeteleport", (Object)teleport);
        this.saveConfig();
    }

    public boolean useSafeTeleporter() {
        return this.safeTeleporter;
    }

    private void addToUpperLists() {
        Permission all = this.plugin.getServer().getPluginManager().getPermission("multiverse.*");
        Permission allPortals = this.plugin.getServer().getPluginManager().getPermission("multiverse.portal.*");
        Permission allPortalAccess = this.plugin.getServer().getPluginManager().getPermission("multiverse.portal.access.*");
        Permission allPortalExempt = this.plugin.getServer().getPluginManager().getPermission("multiverse.portal.exempt.*");
        Permission allPortalFill = this.plugin.getServer().getPluginManager().getPermission("multiverse.portal.fill.*");
        if (allPortalAccess == null) {
            allPortalAccess = new Permission("multiverse.portal.access.*");
            this.plugin.getServer().getPluginManager().addPermission(allPortalAccess);
        }
        if (allPortalExempt == null) {
            allPortalExempt = new Permission("multiverse.portal.exempt.*");
            this.plugin.getServer().getPluginManager().addPermission(allPortalExempt);
        }
        if (allPortalFill == null) {
            allPortalFill = new Permission("multiverse.portal.fill.*");
            this.plugin.getServer().getPluginManager().addPermission(allPortalFill);
        }
        if (allPortals == null) {
            allPortals = new Permission("multiverse.portal.*");
            this.plugin.getServer().getPluginManager().addPermission(allPortals);
        }
        if (all == null) {
            all = new Permission("multiverse.*");
            this.plugin.getServer().getPluginManager().addPermission(all);
        }
        all.getChildren().put("multiverse.portal.*", true);
        allPortals.getChildren().put("multiverse.portal.access.*", true);
        allPortals.getChildren().put("multiverse.portal.exempt.*", true);
        allPortals.getChildren().put("multiverse.portal.fill.*", true);
        allPortalAccess.getChildren().put(this.permission.getName(), true);
        allPortalExempt.getChildren().put(this.exempt.getName(), true);
        allPortalFill.getChildren().put(this.fillPermission.getName(), true);
        this.plugin.getServer().getPluginManager().recalculatePermissionDefaults(all);
        for (Player player : this.plugin.getServer().getOnlinePlayers()) {
            player.recalculatePermissions();
        }
    }

    public static MVPortal loadMVPortalFromConfig(MultiversePortals instance, String name) {
        boolean allowSave = false;
        MVPortal portal = new MVPortal(instance, name, allowSave);
        String portalLocString = portal.config.getString(portal.portalConfigString + ".location", "");
        String worldString = portal.config.getString(portal.portalConfigString + ".world", "");
        portal.setPortalLocation(portalLocString, worldString);
        portal.setOwner(portal.config.getString(portal.portalConfigString + ".owner", ""));
        portal.setCurrency(MaterialConverter.convertConfigType((ConfigurationSection)portal.config, (String)(portal.portalConfigString + ".entryfee.currency")));
        portal.setPrice(portal.config.getDouble(portal.portalConfigString + ".entryfee.amount", 0.0));
        portal.allowSave();
        return portal;
    }

    public Material getCurrency() {
        return this.currency;
    }

    public double getPrice() {
        return this.price;
    }

    private boolean setCurrency(Material currency) {
        this.currency = currency;
        this.config.set(this.portalConfigString + ".entryfee.currency", (Object)currency);
        this.saveConfig();
        return true;
    }

    private boolean setPrice(double price) {
        this.price = price;
        this.config.set(this.portalConfigString + ".entryfee.amount", (Object)price);
        this.saveConfig();
        return true;
    }

    private void saveConfig() {
        if (this.allowSave) {
            this.plugin.savePortalsConfig();
        }
    }

    public MVPortal(MultiverseWorld world, MultiversePortals instance, String name, String owner, String location) {
        this(instance, name);
        this.setOwner(owner);
        this.setPortalLocation(location, world);
    }

    public MVPortal(MultiversePortals instance, String name, String owner, PortalLocation location) {
        this(instance, name);
        this.setOwner(owner);
        this.setPortalLocation(location);
    }

    public boolean setPortalLocation(String locationString, String worldString) {
        MultiverseWorld world = null;
        if (this.worldManager.isMVWorld(worldString)) {
            world = this.worldManager.getMVWorld(worldString);
        }
        return this.setPortalLocation(locationString, world);
    }

    public boolean setPortalLocation(String locationString, MultiverseWorld world) {
        return this.setPortalLocation(PortalLocation.parseLocation(locationString, world, this.name));
    }

    public boolean setPortalLocation(PortalLocation location) {
        this.location = location;
        if (!this.location.isValidLocation()) {
            this.plugin.log(Level.WARNING, "Portal " + this.name + " has an invalid LOCATION!");
            return false;
        }
        this.config.set(this.portalConfigString + ".location", (Object)this.location.toString());
        MultiverseWorld world = this.location.getMVWorld();
        if (world == null) {
            this.plugin.log(Level.WARNING, "Portal " + this.name + " has an invalid WORLD");
            return false;
        }
        this.config.set(this.portalConfigString + ".world", (Object)world.getName());
        this.saveConfig();
        return true;
    }

    private boolean setOwner(String owner) {
        this.owner = owner;
        this.config.set(this.portalConfigString + ".owner", (Object)this.owner);
        this.saveConfig();
        return true;
    }

    public boolean setDestination(String destinationString) {
        this.destination = this.plugin.getCore().getDestFactory().getDestination(destinationString);
        if (this.destination instanceof InvalidDestination) {
            this.plugin.getCore().log(Level.WARNING, "Portal " + this.name + " has an invalid DESTINATION!");
            return false;
        }
        this.config.set(this.portalConfigString + ".destination", (Object)this.destination.toString());
        this.saveConfig();
        return !(this.destination instanceof InvalidDestination);
    }

    public boolean setExactDestination(Location location) {
        this.destination = new ExactDestination();
        ((ExactDestination)this.destination).setDestination(location);
        if (!this.destination.isValid()) {
            this.destination = new InvalidDestination();
            this.plugin.getCore().log(Level.WARNING, "Portal " + this.name + " has an invalid DESTINATION!");
            return false;
        }
        this.config.set(this.portalConfigString + ".destination", (Object)this.destination.toString());
        this.saveConfig();
        return true;
    }

    public String getName() {
        return this.name;
    }

    public PortalLocation getLocation() {
        return this.location;
    }

    public boolean playerCanEnterPortal(Player player) {
        return this.plugin.getCore().getMVPerms().hasPermission((CommandSender)player, this.permission.getName(), true);
    }

    public boolean playerCanFillPortal(Player player) {
        return this.plugin.getCore().getMVPerms().hasPermission((CommandSender)player, this.fillPermission.getName(), true);
    }

    public MVDestination getDestination() {
        return this.destination;
    }

    public boolean setProperty(String property, String value) {
        if (property.equalsIgnoreCase("dest") || property.equalsIgnoreCase("destination")) {
            return this.setDestination(value);
        }
        if (property.equalsIgnoreCase("curr") || property.equalsIgnoreCase("currency")) {
            return this.setCurrency(Material.matchMaterial((String)value));
        }
        if (property.equalsIgnoreCase("price")) {
            try {
                return this.setPrice(Double.parseDouble(value));
            }
            catch (NumberFormatException e) {
                return false;
            }
        }
        if (property.equalsIgnoreCase("owner")) {
            return this.setOwner(value);
        }
        if (property.equalsIgnoreCase("safe")) {
            try {
                this.setUseSafeTeleporter(Boolean.parseBoolean(value));
                return true;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (property.equalsIgnoreCase("telenonplayers")) {
            try {
                this.setTeleportNonPlayers(Boolean.parseBoolean(value));
                return true;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (property.equalsIgnoreCase("handlerscript")) {
            this.setHandlerScript(value);
            return true;
        }
        return false;
    }

    public World getWorld() {
        MultiverseWorld mvWorld = this.location.getMVWorld();
        if (mvWorld == null) {
            return null;
        }
        return mvWorld.getCBWorld();
    }

    public String getHandlerScript() {
        return this.handlerScript;
    }

    public void setHandlerScript(String handlerScript) {
        this.handlerScript = handlerScript;
        this.config.set(this.portalConfigString + ".handlerscript", (Object)this.handlerScript);
        this.saveConfig();
    }

    public Permission getPermission() {
        return this.permission;
    }

    public Permission getFillPermission() {
        return this.fillPermission;
    }

    public void removePermission() {
        this.removeFromUpperLists(this.permission);
        this.plugin.getServer().getPluginManager().removePermission(this.permission);
    }

    private void removeFromUpperLists(Permission permission) {
        Permission all = this.plugin.getServer().getPluginManager().getPermission("multiverse.*");
        Permission allPortals = this.plugin.getServer().getPluginManager().getPermission("multiverse.portal.*");
        Permission allPortalAccess = this.plugin.getServer().getPluginManager().getPermission("multiverse.portal.access.*");
        Permission allPortalExempt = this.plugin.getServer().getPluginManager().getPermission("multiverse.portal.exempt.*");
        Permission allPortalFill = this.plugin.getServer().getPluginManager().getPermission("multiverse.portal.fill.*");
        if (all != null) {
            all.getChildren().remove(this.permission.getName());
            this.plugin.getServer().getPluginManager().recalculatePermissionDefaults(all);
        }
        if (allPortals != null) {
            allPortals.getChildren().remove(this.permission.getName());
            this.plugin.getServer().getPluginManager().recalculatePermissionDefaults(allPortals);
        }
        if (allPortalAccess != null) {
            allPortalAccess.getChildren().remove(this.permission.getName());
            this.plugin.getServer().getPluginManager().recalculatePermissionDefaults(allPortalAccess);
        }
        if (allPortalExempt != null) {
            allPortalExempt.getChildren().remove(this.exempt.getName());
            this.plugin.getServer().getPluginManager().recalculatePermissionDefaults(allPortalExempt);
        }
        if (allPortalFill != null) {
            allPortalFill.getChildren().remove(this.fillPermission.getName());
            this.plugin.getServer().getPluginManager().recalculatePermissionDefaults(allPortalFill);
        }
    }

    public boolean isFrameValid(Location l) {
        boolean useZ;
        List<Material> validMaterials = MultiversePortals.FrameMaterials;
        if (validMaterials == null || validMaterials.isEmpty()) {
            return true;
        }
        MultiversePortals.staticLog(Level.FINER, String.format("checking portal frame at %d,%d,%d", l.getBlockX(), l.getBlockY(), l.getBlockZ()));
        boolean frameValid = false;
        MultiverseRegion r = this.getLocation().getRegion();
        boolean useX = r.getWidth() != 1;
        boolean useY = r.getHeight() != 1;
        boolean bl = useZ = r.getDepth() != 1;
        if (!frameValid && !useX) {
            frameValid = this.isFrameValid(l, this.expandedRegion(r, 0, 1, 1));
        }
        if (!frameValid && !useY) {
            frameValid = this.isFrameValid(l, this.expandedRegion(r, 1, 0, 1));
        }
        if (!frameValid && !useZ) {
            frameValid = this.isFrameValid(l, this.expandedRegion(r, 1, 1, 0));
        }
        return frameValid;
    }

    private boolean isFrameValid(Location location, MultiverseRegion searchRegion) {
        int useZ;
        int useX = searchRegion.getWidth() == 1 ? 0 : 1;
        int useY = searchRegion.getHeight() == 1 ? 0 : 1;
        int n = useZ = searchRegion.getDepth() == 1 ? 0 : 1;
        if (useX + useY + useZ != 2) {
            return false;
        }
        Level debugLevel = Level.FINER;
        MultiversePortals.staticLog(debugLevel, String.format("checking portal around %d,%d,%d", location.getBlockX(), location.getBlockY(), location.getBlockZ()));
        Material commonMaterial = null;
        World world = location.getWorld();
        HashSet<Location> visited = new HashSet<Location>();
        Stack<Location> frontier = new Stack<Location>();
        frontier.push(location);
        while (!frontier.isEmpty()) {
            Location toCheck = (Location)frontier.pop();
            visited.add(toCheck);
            MultiversePortals.staticLog(debugLevel, String.format("          ... block at %d,%d,%d", toCheck.getBlockX(), toCheck.getBlockY(), toCheck.getBlockZ()));
            if (MVPortal.isPortalInterior(toCheck.getBlock().getType())) {
                for (int d1 = -1; d1 <= 1; ++d1) {
                    for (int d2 = -1; d2 <= 1; ++d2) {
                        int newZ;
                        int newY;
                        if (!(d1 == 0 ^ d2 == 0)) continue;
                        int dx = useX * d1;
                        int dy = useY * (useX == 0 ? d1 : d2);
                        int dz = useZ * d2;
                        int newX = toCheck.getBlockX() + dx;
                        Location toVisit = new Location(world, (double)newX, (double)(newY = toCheck.getBlockY() + dy), (double)(newZ = toCheck.getBlockZ() + dz));
                        if (!searchRegion.containsVector(toVisit)) {
                            return false;
                        }
                        if (visited.contains(toVisit)) continue;
                        frontier.add(toVisit);
                    }
                }
                continue;
            }
            Material material = toCheck.getBlock().getType();
            if (commonMaterial == null) {
                commonMaterial = material;
                continue;
            }
            if (commonMaterial == material) continue;
            MultiversePortals.staticLog(debugLevel, "frame has multiple materials");
            return false;
        }
        MultiversePortals.staticLog(debugLevel, String.format("frame has common material %s", commonMaterial));
        return MultiversePortals.FrameMaterials.contains(commonMaterial);
    }

    @Deprecated
    public boolean isExempt(Player player) {
        return false;
    }

    public Permission getExempt() {
        return this.exempt;
    }

    private MultiverseRegion expandedRegion(MultiverseRegion r, int x, int y, int z) {
        Vector min = new Vector().copy(r.getMinimumPoint());
        Vector max = new Vector().copy(r.getMaximumPoint());
        min.add(new Vector(-x, -y, -z));
        max.add(new Vector(x, y, z));
        return new MultiverseRegion(min, max, r.getWorld());
    }
}

